/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.Equivalence;
import com.koloboke.collect.FloatCollection;
import com.koloboke.collect.FloatCursor;
import com.koloboke.collect.FloatIterator;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractFloatValueView;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.CommonFloatFloatMapOps;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.InternalFloatCollectionOps;
import com.koloboke.collect.impl.InternalFloatFloatMapOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.UnsafeConstants;
import com.koloboke.collect.impl.hash.MutableQHashParallelKVFloatFloatMapSO;
import com.koloboke.collect.impl.hash.ParallelKVFloatFloatQHash;
import com.koloboke.collect.impl.hash.QHash;
import com.koloboke.collect.map.FloatFloatCursor;
import com.koloboke.collect.set.FloatSet;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.FloatBinaryOperator;
import com.koloboke.function.FloatConsumer;
import com.koloboke.function.FloatFloatConsumer;
import com.koloboke.function.FloatFloatPredicate;
import com.koloboke.function.FloatFloatToFloatFunction;
import com.koloboke.function.FloatPredicate;
import com.koloboke.function.FloatUnaryOperator;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class MutableQHashParallelKVFloatFloatMapGO
extends MutableQHashParallelKVFloatFloatMapSO {
    final void copy(ParallelKVFloatFloatQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    final void move(ParallelKVFloatFloatQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public float defaultValue() {
        return 0.0f;
    }

    public boolean containsEntry(float key, float value) {
        int k = Float.floatToIntBits(key);
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix((int)k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == k) {
            return (int)(entry >>> 32) == Float.floatToIntBits(value);
        }
        if (cur == 0x7FFFFFFE) {
            return false;
        }
        int bIndex = index;
        int fIndex = index;
        int step = 1;
        while (true) {
            if ((bIndex -= step) < 0) {
                bIndex += capacity;
            }
            if ((cur = (int)(entry = tab[bIndex])) == k) {
                return (int)(entry >>> 32) == Float.floatToIntBits(value);
            }
            if (cur == 0x7FFFFFFE) {
                return false;
            }
            int t = (fIndex += step) - capacity;
            if (t >= 0) {
                fIndex = t;
            }
            if ((cur = (int)(entry = tab[fIndex])) == k) {
                return (int)(entry >>> 32) == Float.floatToIntBits(value);
            }
            if (cur == 0x7FFFFFFE) {
                return false;
            }
            step += 2;
        }
    }

    public boolean containsEntry(int key, int value) {
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix((int)key) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == key) {
            return (int)(entry >>> 32) == value;
        }
        if (cur == 0x7FFFFFFE) {
            return false;
        }
        int bIndex = index;
        int fIndex = index;
        int step = 1;
        while (true) {
            if ((bIndex -= step) < 0) {
                bIndex += capacity;
            }
            if ((cur = (int)(entry = tab[bIndex])) == key) {
                return (int)(entry >>> 32) == value;
            }
            if (cur == 0x7FFFFFFE) {
                return false;
            }
            int t = (fIndex += step) - capacity;
            if (t >= 0) {
                fIndex = t;
            }
            if ((cur = (int)(entry = tab[fIndex])) == key) {
                return (int)(entry >>> 32) == value;
            }
            if (cur == 0x7FFFFFFE) {
                return false;
            }
            step += 2;
        }
    }

    public Float get(Object key) {
        int k = Float.floatToIntBits(((Float)key).floatValue());
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix((int)k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == k) {
            return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
        }
        if (cur == 0x7FFFFFFE) {
            return null;
        }
        int bIndex = index;
        int fIndex = index;
        int step = 1;
        while (true) {
            if ((bIndex -= step) < 0) {
                bIndex += capacity;
            }
            if ((cur = (int)(entry = tab[bIndex])) == k) {
                return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (cur == 0x7FFFFFFE) {
                return null;
            }
            int t = (fIndex += step) - capacity;
            if (t >= 0) {
                fIndex = t;
            }
            if ((cur = (int)(entry = tab[fIndex])) == k) {
                return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (cur == 0x7FFFFFFE) {
                return null;
            }
            step += 2;
        }
    }

    public float get(float key) {
        int k = Float.floatToIntBits(key);
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix((int)k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == k) {
            return Float.intBitsToFloat((int)(entry >>> 32));
        }
        if (cur == 0x7FFFFFFE) {
            return this.defaultValue();
        }
        int bIndex = index;
        int fIndex = index;
        int step = 1;
        while (true) {
            if ((bIndex -= step) < 0) {
                bIndex += capacity;
            }
            if ((cur = (int)(entry = tab[bIndex])) == k) {
                return Float.intBitsToFloat((int)(entry >>> 32));
            }
            if (cur == 0x7FFFFFFE) {
                return this.defaultValue();
            }
            int t = (fIndex += step) - capacity;
            if (t >= 0) {
                fIndex = t;
            }
            if ((cur = (int)(entry = tab[fIndex])) == k) {
                return Float.intBitsToFloat((int)(entry >>> 32));
            }
            if (cur == 0x7FFFFFFE) {
                return this.defaultValue();
            }
            step += 2;
        }
    }

    public Float getOrDefault(Object key, Float defaultValue) {
        int k = Float.floatToIntBits(((Float)key).floatValue());
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix((int)k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == k) {
            return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
        }
        if (cur == 0x7FFFFFFE) {
            return defaultValue;
        }
        int bIndex = index;
        int fIndex = index;
        int step = 1;
        while (true) {
            if ((bIndex -= step) < 0) {
                bIndex += capacity;
            }
            if ((cur = (int)(entry = tab[bIndex])) == k) {
                return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (cur == 0x7FFFFFFE) {
                return defaultValue;
            }
            int t = (fIndex += step) - capacity;
            if (t >= 0) {
                fIndex = t;
            }
            if ((cur = (int)(entry = tab[fIndex])) == k) {
                return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (cur == 0x7FFFFFFE) {
                return defaultValue;
            }
            step += 2;
        }
    }

    public float getOrDefault(float key, float defaultValue) {
        int k = Float.floatToIntBits(key);
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix((int)k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == k) {
            return Float.intBitsToFloat((int)(entry >>> 32));
        }
        if (cur == 0x7FFFFFFE) {
            return defaultValue;
        }
        int bIndex = index;
        int fIndex = index;
        int step = 1;
        while (true) {
            if ((bIndex -= step) < 0) {
                bIndex += capacity;
            }
            if ((cur = (int)(entry = tab[bIndex])) == k) {
                return Float.intBitsToFloat((int)(entry >>> 32));
            }
            if (cur == 0x7FFFFFFE) {
                return defaultValue;
            }
            int t = (fIndex += step) - capacity;
            if (t >= 0) {
                fIndex = t;
            }
            if ((cur = (int)(entry = tab[fIndex])) == k) {
                return Float.intBitsToFloat((int)(entry >>> 32));
            }
            if (cur == 0x7FFFFFFE) {
                return defaultValue;
            }
            step += 2;
        }
    }

    public void forEach(BiConsumer<? super Float, ? super Float> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE) continue;
            action.accept(Float.valueOf(Float.intBitsToFloat(key)), Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32))));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(FloatFloatConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE) continue;
            action.accept(Float.intBitsToFloat(key), Float.intBitsToFloat((int)(entry >>> 32)));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(FloatFloatPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE || predicate.test(Float.intBitsToFloat(key), Float.intBitsToFloat((int)(entry >>> 32)))) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public FloatFloatCursor cursor() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedMapCursor(mc);
        }
        return new NoRemovedMapCursor(mc);
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonFloatFloatMapOps.containsAllEntries((InternalFloatFloatMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalFloatFloatMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE || m.containsEntry(key, (int)(entry >>> 32))) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalFloatFloatMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE) continue;
            m.justPut(key, (int)(entry >>> 32));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<Float, Float>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public FloatCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE) continue;
            hashCode += key ^ (int)(entry >>> 32);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE) continue;
            sb.append(' ');
            sb.append(Float.intBitsToFloat(key));
            sb.append('=');
            sb.append(Float.intBitsToFloat((int)(entry >>> 32)));
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        long[] tab = this.table;
        this.initForRehash(newCapacity);
        ++mc;
        long[] newTab = this.table;
        int capacity = newTab.length;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE) continue;
            int index = QHash.ParallelKVFloatKeyMixing.mix((int)key) % capacity;
            if (U.getInt(newTab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)index << 3)) != 0x7FFFFFFE) {
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if (U.getInt(newTab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)bIndex << 3)) == 0x7FFFFFFE) {
                        index = bIndex;
                        break;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if (U.getInt(newTab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)fIndex << 3)) == 0x7FFFFFFE) {
                        index = fIndex;
                        break;
                    }
                    step += 2;
                }
            }
            newTab[index] = entry;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public Float put(Float key, Float value) {
        long entry;
        int index;
        long[] tab;
        block23: {
            int k = Float.floatToIntBits(key.floatValue());
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVFloatKeyMixing.mix((int)k) % capacity;
            entry = tab[index];
            int cur = (int)entry;
            if (cur == 0x7FFFFFFE) {
                this.incrementModCount();
                tab[index] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value.floatValue()) << 32;
                this.postFreeSlotInsertHook();
                return null;
            }
            if (cur != k) {
                int firstRemoved;
                if (cur <= 0x7FFFFFFE) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (int)(entry = tab[bIndex])) == 0x7FFFFFFE) {
                                this.incrementModCount();
                                tab[bIndex] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value.floatValue()) << 32;
                                this.postFreeSlotInsertHook();
                                return null;
                            }
                            if (cur == k) {
                                index = bIndex;
                                break block23;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (int)(entry = tab[fIndex])) == 0x7FFFFFFE) {
                                this.incrementModCount();
                                tab[fIndex] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value.floatValue()) << 32;
                                this.postFreeSlotInsertHook();
                                return null;
                            }
                            if (cur == k) {
                                index = fIndex;
                                break block23;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (int)(entry = tab[bIndex])) == 0x7FFFFFFE) {
                        if (firstRemoved < 0) {
                            this.incrementModCount();
                            tab[bIndex] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value.floatValue()) << 32;
                            this.postFreeSlotInsertHook();
                            return null;
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value.floatValue()) << 32;
                        this.postRemovedSlotInsertHook();
                        return null;
                    }
                    if (cur == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur > 0x7FFFFFFE && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (int)(entry = tab[fIndex])) == 0x7FFFFFFE) {
                        if (firstRemoved < 0) {
                            this.incrementModCount();
                            tab[fIndex] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value.floatValue()) << 32;
                            this.postFreeSlotInsertHook();
                            return null;
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value.floatValue()) << 32;
                        this.postRemovedSlotInsertHook();
                        return null;
                    }
                    if (cur == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur > 0x7FFFFFFE && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
            }
        }
        float prevValue = Float.intBitsToFloat((int)(entry >>> 32));
        U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), Float.floatToIntBits(value.floatValue()));
        return Float.valueOf(prevValue);
    }

    public float put(float key, float value) {
        long entry;
        int index;
        long[] tab;
        block23: {
            int k = Float.floatToIntBits(key);
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVFloatKeyMixing.mix((int)k) % capacity;
            entry = tab[index];
            int cur = (int)entry;
            if (cur == 0x7FFFFFFE) {
                this.incrementModCount();
                tab[index] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                this.postFreeSlotInsertHook();
                return this.defaultValue();
            }
            if (cur != k) {
                int firstRemoved;
                if (cur <= 0x7FFFFFFE) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (int)(entry = tab[bIndex])) == 0x7FFFFFFE) {
                                this.incrementModCount();
                                tab[bIndex] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                                this.postFreeSlotInsertHook();
                                return this.defaultValue();
                            }
                            if (cur == k) {
                                index = bIndex;
                                break block23;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (int)(entry = tab[fIndex])) == 0x7FFFFFFE) {
                                this.incrementModCount();
                                tab[fIndex] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                                this.postFreeSlotInsertHook();
                                return this.defaultValue();
                            }
                            if (cur == k) {
                                index = fIndex;
                                break block23;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (int)(entry = tab[bIndex])) == 0x7FFFFFFE) {
                        if (firstRemoved < 0) {
                            this.incrementModCount();
                            tab[bIndex] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                            this.postFreeSlotInsertHook();
                            return this.defaultValue();
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                        this.postRemovedSlotInsertHook();
                        return this.defaultValue();
                    }
                    if (cur == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur > 0x7FFFFFFE && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (int)(entry = tab[fIndex])) == 0x7FFFFFFE) {
                        if (firstRemoved < 0) {
                            this.incrementModCount();
                            tab[fIndex] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                            this.postFreeSlotInsertHook();
                            return this.defaultValue();
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                        this.postRemovedSlotInsertHook();
                        return this.defaultValue();
                    }
                    if (cur == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur > 0x7FFFFFFE && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
            }
        }
        float prevValue = Float.intBitsToFloat((int)(entry >>> 32));
        U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), Float.floatToIntBits(value));
        return prevValue;
    }

    public Float putIfAbsent(Float key, Float value) {
        int firstRemoved;
        int k = Float.floatToIntBits(key.floatValue());
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix((int)k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == 0x7FFFFFFE) {
            this.incrementModCount();
            tab[index] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value.floatValue()) << 32;
            this.postFreeSlotInsertHook();
            return null;
        }
        if (cur == k) {
            return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
        }
        if (cur <= 0x7FFFFFFE) {
            if (this.noRemoved()) {
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (int)(entry = tab[bIndex])) == 0x7FFFFFFE) {
                        this.incrementModCount();
                        tab[bIndex] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value.floatValue()) << 32;
                        this.postFreeSlotInsertHook();
                        return null;
                    }
                    if (cur == k) {
                        return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (int)(entry = tab[fIndex])) == 0x7FFFFFFE) {
                        this.incrementModCount();
                        tab[fIndex] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value.floatValue()) << 32;
                        this.postFreeSlotInsertHook();
                        return null;
                    }
                    if (cur == k) {
                        return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
                    }
                    step += 2;
                }
            }
            firstRemoved = -1;
        } else {
            firstRemoved = index;
        }
        int bIndex = index;
        int fIndex = index;
        int step = 1;
        while (true) {
            int t;
            if ((bIndex -= step) < 0) {
                bIndex += capacity;
            }
            if ((cur = (int)(entry = tab[bIndex])) == 0x7FFFFFFE) {
                if (firstRemoved < 0) {
                    this.incrementModCount();
                    tab[bIndex] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value.floatValue()) << 32;
                    this.postFreeSlotInsertHook();
                    return null;
                }
                this.incrementModCount();
                tab[firstRemoved] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value.floatValue()) << 32;
                this.postRemovedSlotInsertHook();
                return null;
            }
            if (cur == k) {
                return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (cur > 0x7FFFFFFE && firstRemoved < 0) {
                firstRemoved = bIndex;
            }
            if ((t = (fIndex += step) - capacity) >= 0) {
                fIndex = t;
            }
            if ((cur = (int)(entry = tab[fIndex])) == 0x7FFFFFFE) {
                if (firstRemoved < 0) {
                    this.incrementModCount();
                    tab[fIndex] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value.floatValue()) << 32;
                    this.postFreeSlotInsertHook();
                    return null;
                }
                this.incrementModCount();
                tab[firstRemoved] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value.floatValue()) << 32;
                this.postRemovedSlotInsertHook();
                return null;
            }
            if (cur == k) {
                return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (cur > 0x7FFFFFFE && firstRemoved < 0) {
                firstRemoved = fIndex;
            }
            step += 2;
        }
    }

    public float putIfAbsent(float key, float value) {
        int firstRemoved;
        int k = Float.floatToIntBits(key);
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix((int)k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == 0x7FFFFFFE) {
            this.incrementModCount();
            tab[index] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
            this.postFreeSlotInsertHook();
            return this.defaultValue();
        }
        if (cur == k) {
            return Float.intBitsToFloat((int)(entry >>> 32));
        }
        if (cur <= 0x7FFFFFFE) {
            if (this.noRemoved()) {
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (int)(entry = tab[bIndex])) == 0x7FFFFFFE) {
                        this.incrementModCount();
                        tab[bIndex] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                        this.postFreeSlotInsertHook();
                        return this.defaultValue();
                    }
                    if (cur == k) {
                        return Float.intBitsToFloat((int)(entry >>> 32));
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (int)(entry = tab[fIndex])) == 0x7FFFFFFE) {
                        this.incrementModCount();
                        tab[fIndex] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                        this.postFreeSlotInsertHook();
                        return this.defaultValue();
                    }
                    if (cur == k) {
                        return Float.intBitsToFloat((int)(entry >>> 32));
                    }
                    step += 2;
                }
            }
            firstRemoved = -1;
        } else {
            firstRemoved = index;
        }
        int bIndex = index;
        int fIndex = index;
        int step = 1;
        while (true) {
            int t;
            if ((bIndex -= step) < 0) {
                bIndex += capacity;
            }
            if ((cur = (int)(entry = tab[bIndex])) == 0x7FFFFFFE) {
                if (firstRemoved < 0) {
                    this.incrementModCount();
                    tab[bIndex] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                    this.postFreeSlotInsertHook();
                    return this.defaultValue();
                }
                this.incrementModCount();
                tab[firstRemoved] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                this.postRemovedSlotInsertHook();
                return this.defaultValue();
            }
            if (cur == k) {
                return Float.intBitsToFloat((int)(entry >>> 32));
            }
            if (cur > 0x7FFFFFFE && firstRemoved < 0) {
                firstRemoved = bIndex;
            }
            if ((t = (fIndex += step) - capacity) >= 0) {
                fIndex = t;
            }
            if ((cur = (int)(entry = tab[fIndex])) == 0x7FFFFFFE) {
                if (firstRemoved < 0) {
                    this.incrementModCount();
                    tab[fIndex] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                    this.postFreeSlotInsertHook();
                    return this.defaultValue();
                }
                this.incrementModCount();
                tab[firstRemoved] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                this.postRemovedSlotInsertHook();
                return this.defaultValue();
            }
            if (cur == k) {
                return Float.intBitsToFloat((int)(entry >>> 32));
            }
            if (cur > 0x7FFFFFFE && firstRemoved < 0) {
                firstRemoved = fIndex;
            }
            step += 2;
        }
    }

    public void justPut(float key, float value) {
        int k = Float.floatToIntBits(key);
        int index = this.insert(k, Float.floatToIntBits(value));
        if (index < 0) {
            return;
        }
        U.putInt(this.table, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), Float.floatToIntBits(value));
    }

    public void justPut(int key, int value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        U.putInt(this.table, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), value);
    }

    public Float compute(Float key, BiFunction<? super Float, ? super Float, ? extends Float> remappingFunction) {
        Float newValue;
        long entry;
        int index;
        long[] tab;
        int k;
        block25: {
            k = Float.floatToIntBits(key.floatValue());
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVFloatKeyMixing.mix((int)k) % capacity;
            entry = tab[index];
            int cur = (int)entry;
            if (cur != k) {
                Float newValue2;
                block26: {
                    if (cur != 0x7FFFFFFE) {
                        Float newValue3;
                        int firstRemoved;
                        if (cur <= 0x7FFFFFFE) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = (int)(entry = tab[bIndex])) == k) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    if (cur == 0x7FFFFFFE) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = (int)(entry = tab[fIndex])) == k) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    if (cur == 0x7FFFFFFE) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (int)(entry = tab[bIndex])) == k) {
                                index = bIndex;
                                break block25;
                            }
                            if (cur == 0x7FFFFFFE) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block26;
                            }
                            if (cur > 0x7FFFFFFE && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (int)(entry = tab[fIndex])) == k) {
                                index = fIndex;
                                break block25;
                            }
                            if (cur == 0x7FFFFFFE) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block26;
                            }
                            if (cur > 0x7FFFFFFE && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        if ((newValue3 = remappingFunction.apply(Float.valueOf(Float.intBitsToFloat(k)), null)) != null) {
                            this.incrementModCount();
                            tab[firstRemoved] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(newValue3.floatValue()) << 32;
                            this.postRemovedSlotInsertHook();
                            return newValue3;
                        }
                        return null;
                    }
                }
                if ((newValue2 = remappingFunction.apply(Float.valueOf(Float.intBitsToFloat(k)), null)) != null) {
                    this.incrementModCount();
                    tab[index] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(newValue2.floatValue()) << 32;
                    this.postFreeSlotInsertHook();
                    return newValue2;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply(Float.valueOf(Float.intBitsToFloat(k)), Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32))))) != null) {
            U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), Float.floatToIntBits(newValue.floatValue()));
            return newValue;
        }
        this.incrementModCount();
        U.putInt(tab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)index << 3), Integer.MAX_VALUE);
        this.postRemoveHook();
        return null;
    }

    public float compute(float key, FloatFloatToFloatFunction remappingFunction) {
        long entry;
        int index;
        long[] tab;
        int k;
        block22: {
            k = Float.floatToIntBits(key);
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVFloatKeyMixing.mix((int)k) % capacity;
            entry = tab[index];
            int cur = (int)entry;
            if (cur != k) {
                block23: {
                    if (cur != 0x7FFFFFFE) {
                        int firstRemoved;
                        if (cur <= 0x7FFFFFFE) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = (int)(entry = tab[bIndex])) == k) {
                                        index = bIndex;
                                        break block22;
                                    }
                                    if (cur == 0x7FFFFFFE) {
                                        index = bIndex;
                                        break block23;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = (int)(entry = tab[fIndex])) == k) {
                                        index = fIndex;
                                        break block22;
                                    }
                                    if (cur == 0x7FFFFFFE) {
                                        index = fIndex;
                                        break block23;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (int)(entry = tab[bIndex])) == k) {
                                index = bIndex;
                                break block22;
                            }
                            if (cur == 0x7FFFFFFE) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block23;
                            }
                            if (cur > 0x7FFFFFFE && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (int)(entry = tab[fIndex])) == k) {
                                index = fIndex;
                                break block22;
                            }
                            if (cur == 0x7FFFFFFE) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block23;
                            }
                            if (cur > 0x7FFFFFFE && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        float newValue = remappingFunction.applyAsFloat(Float.intBitsToFloat(k), this.defaultValue());
                        this.incrementModCount();
                        tab[firstRemoved] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(newValue) << 32;
                        this.postRemovedSlotInsertHook();
                        return newValue;
                    }
                }
                float newValue = remappingFunction.applyAsFloat(Float.intBitsToFloat(k), this.defaultValue());
                this.incrementModCount();
                tab[index] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(newValue) << 32;
                this.postFreeSlotInsertHook();
                return newValue;
            }
        }
        float newValue = remappingFunction.applyAsFloat(Float.intBitsToFloat(k), Float.intBitsToFloat((int)(entry >>> 32)));
        U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), Float.floatToIntBits(newValue));
        return newValue;
    }

    public Float computeIfAbsent(Float key, Function<? super Float, ? extends Float> mappingFunction) {
        Float value;
        int k;
        block24: {
            k = Float.floatToIntBits(key.floatValue());
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVFloatKeyMixing.mix((int)k) % capacity;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur == k) {
                return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (cur != 0x7FFFFFFE) {
                Float value2;
                int firstRemoved;
                if (cur <= 0x7FFFFFFE) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (int)(entry = tab[bIndex])) == k) {
                                return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
                            }
                            if (cur == 0x7FFFFFFE) {
                                index = bIndex;
                                break block24;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (int)(entry = tab[fIndex])) == k) {
                                return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
                            }
                            if (cur == 0x7FFFFFFE) {
                                index = fIndex;
                                break block24;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (int)(entry = tab[bIndex])) == k) {
                        return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
                    }
                    if (cur == 0x7FFFFFFE) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block24;
                    }
                    if (cur > 0x7FFFFFFE && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (int)(entry = tab[fIndex])) == k) {
                        return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
                    }
                    if (cur == 0x7FFFFFFE) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block24;
                    }
                    if (cur > 0x7FFFFFFE && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                if ((value2 = mappingFunction.apply(Float.valueOf(Float.intBitsToFloat(k)))) != null) {
                    this.incrementModCount();
                    tab[firstRemoved] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value2.floatValue()) << 32;
                    this.postRemovedSlotInsertHook();
                    return value2;
                }
                return null;
            }
        }
        if ((value = mappingFunction.apply(Float.valueOf(Float.intBitsToFloat(k)))) != null) {
            this.incrementModCount();
            tab[index] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value.floatValue()) << 32;
            this.postFreeSlotInsertHook();
            return value;
        }
        return null;
    }

    public float computeIfAbsent(float key, FloatUnaryOperator mappingFunction) {
        int k;
        block22: {
            k = Float.floatToIntBits(key);
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVFloatKeyMixing.mix((int)k) % capacity;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur == k) {
                return Float.intBitsToFloat((int)(entry >>> 32));
            }
            if (cur != 0x7FFFFFFE) {
                int firstRemoved;
                if (cur <= 0x7FFFFFFE) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (int)(entry = tab[bIndex])) == k) {
                                return Float.intBitsToFloat((int)(entry >>> 32));
                            }
                            if (cur == 0x7FFFFFFE) {
                                index = bIndex;
                                break block22;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (int)(entry = tab[fIndex])) == k) {
                                return Float.intBitsToFloat((int)(entry >>> 32));
                            }
                            if (cur == 0x7FFFFFFE) {
                                index = fIndex;
                                break block22;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (int)(entry = tab[bIndex])) == k) {
                        return Float.intBitsToFloat((int)(entry >>> 32));
                    }
                    if (cur == 0x7FFFFFFE) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block22;
                    }
                    if (cur > 0x7FFFFFFE && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (int)(entry = tab[fIndex])) == k) {
                        return Float.intBitsToFloat((int)(entry >>> 32));
                    }
                    if (cur == 0x7FFFFFFE) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block22;
                    }
                    if (cur > 0x7FFFFFFE && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                float value = mappingFunction.applyAsFloat(Float.intBitsToFloat(k));
                this.incrementModCount();
                tab[firstRemoved] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                this.postRemovedSlotInsertHook();
                return value;
            }
        }
        float value = mappingFunction.applyAsFloat(Float.intBitsToFloat(k));
        this.incrementModCount();
        tab[index] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
        this.postFreeSlotInsertHook();
        return value;
    }

    public Float computeIfPresent(Float key, BiFunction<? super Float, ? super Float, ? extends Float> remappingFunction) {
        Float newValue;
        int k = Float.floatToIntBits(key.floatValue());
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix((int)k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur != k) {
            if (cur == 0x7FFFFFFE) {
                return null;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == k) {
                    index = bIndex;
                    break;
                }
                if (cur == 0x7FFFFFFE) {
                    return null;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == k) {
                    index = fIndex;
                    break;
                }
                if (cur == 0x7FFFFFFE) {
                    return null;
                }
                step += 2;
            }
        }
        if ((newValue = remappingFunction.apply(Float.valueOf(Float.intBitsToFloat(k)), Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32))))) != null) {
            U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), Float.floatToIntBits(newValue.floatValue()));
            return newValue;
        }
        this.incrementModCount();
        U.putInt(tab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)index << 3), Integer.MAX_VALUE);
        this.postRemoveHook();
        return null;
    }

    public float computeIfPresent(float key, FloatFloatToFloatFunction remappingFunction) {
        int k = Float.floatToIntBits(key);
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix((int)k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur != k) {
            if (cur == 0x7FFFFFFE) {
                return this.defaultValue();
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == k) {
                    index = bIndex;
                    break;
                }
                if (cur == 0x7FFFFFFE) {
                    return this.defaultValue();
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == k) {
                    index = fIndex;
                    break;
                }
                if (cur == 0x7FFFFFFE) {
                    return this.defaultValue();
                }
                step += 2;
            }
        }
        float newValue = remappingFunction.applyAsFloat(Float.intBitsToFloat(k), Float.intBitsToFloat((int)(entry >>> 32)));
        U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), Float.floatToIntBits(newValue));
        return newValue;
    }

    public Float merge(Float key, Float value, BiFunction<? super Float, ? super Float, ? extends Float> remappingFunction) {
        Float newValue;
        long entry;
        int index;
        long[] tab;
        block24: {
            int k = Float.floatToIntBits(key.floatValue());
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVFloatKeyMixing.mix((int)k) % capacity;
            entry = tab[index];
            int cur = (int)entry;
            if (cur != k) {
                block25: {
                    if (cur != 0x7FFFFFFE) {
                        int firstRemoved;
                        if (cur <= 0x7FFFFFFE) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = (int)(entry = tab[bIndex])) == k) {
                                        index = bIndex;
                                        break block24;
                                    }
                                    if (cur == 0x7FFFFFFE) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = (int)(entry = tab[fIndex])) == k) {
                                        index = fIndex;
                                        break block24;
                                    }
                                    if (cur == 0x7FFFFFFE) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (int)(entry = tab[bIndex])) == k) {
                                index = bIndex;
                                break block24;
                            }
                            if (cur == 0x7FFFFFFE) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block25;
                            }
                            if (cur > 0x7FFFFFFE && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (int)(entry = tab[fIndex])) == k) {
                                index = fIndex;
                                break block24;
                            }
                            if (cur == 0x7FFFFFFE) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block25;
                            }
                            if (cur > 0x7FFFFFFE && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value.floatValue()) << 32;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                tab[index] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value.floatValue()) << 32;
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply(Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32))), value)) != null) {
            U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), Float.floatToIntBits(newValue.floatValue()));
            return newValue;
        }
        this.incrementModCount();
        U.putInt(tab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)index << 3), Integer.MAX_VALUE);
        this.postRemoveHook();
        return null;
    }

    public float merge(float key, float value, FloatBinaryOperator remappingFunction) {
        long entry;
        int index;
        long[] tab;
        block22: {
            int k = Float.floatToIntBits(key);
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVFloatKeyMixing.mix((int)k) % capacity;
            entry = tab[index];
            int cur = (int)entry;
            if (cur != k) {
                block23: {
                    if (cur != 0x7FFFFFFE) {
                        int firstRemoved;
                        if (cur <= 0x7FFFFFFE) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = (int)(entry = tab[bIndex])) == k) {
                                        index = bIndex;
                                        break block22;
                                    }
                                    if (cur == 0x7FFFFFFE) {
                                        index = bIndex;
                                        break block23;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = (int)(entry = tab[fIndex])) == k) {
                                        index = fIndex;
                                        break block22;
                                    }
                                    if (cur == 0x7FFFFFFE) {
                                        index = fIndex;
                                        break block23;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (int)(entry = tab[bIndex])) == k) {
                                index = bIndex;
                                break block22;
                            }
                            if (cur == 0x7FFFFFFE) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block23;
                            }
                            if (cur > 0x7FFFFFFE && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (int)(entry = tab[fIndex])) == k) {
                                index = fIndex;
                                break block22;
                            }
                            if (cur == 0x7FFFFFFE) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block23;
                            }
                            if (cur > 0x7FFFFFFE && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                tab[index] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        float newValue = remappingFunction.applyAsFloat(Float.intBitsToFloat((int)(entry >>> 32)), value);
        U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), Float.floatToIntBits(newValue));
        return newValue;
    }

    public float addValue(float key, float value) {
        long entry;
        int index;
        long[] tab;
        block21: {
            int k = Float.floatToIntBits(key);
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVFloatKeyMixing.mix((int)k) % capacity;
            entry = tab[index];
            int cur = (int)entry;
            if (cur != k) {
                block22: {
                    if (cur != 0x7FFFFFFE) {
                        int firstRemoved;
                        if (cur <= 0x7FFFFFFE) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = (int)(entry = tab[bIndex])) == k) {
                                        index = bIndex;
                                        break block21;
                                    }
                                    if (cur == 0x7FFFFFFE) {
                                        index = bIndex;
                                        break block22;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = (int)(entry = tab[fIndex])) == k) {
                                        index = fIndex;
                                        break block21;
                                    }
                                    if (cur == 0x7FFFFFFE) {
                                        index = fIndex;
                                        break block22;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (int)(entry = tab[bIndex])) == k) {
                                index = bIndex;
                                break block21;
                            }
                            if (cur == 0x7FFFFFFE) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block22;
                            }
                            if (cur > 0x7FFFFFFE && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (int)(entry = tab[fIndex])) == k) {
                                index = fIndex;
                                break block21;
                            }
                            if (cur == 0x7FFFFFFE) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block22;
                            }
                            if (cur > 0x7FFFFFFE && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        float newValue = this.defaultValue() + value;
                        this.incrementModCount();
                        tab[firstRemoved] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(newValue) << 32;
                        this.postRemovedSlotInsertHook();
                        return newValue;
                    }
                }
                float newValue = this.defaultValue() + value;
                this.incrementModCount();
                tab[index] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(newValue) << 32;
                this.postFreeSlotInsertHook();
                return newValue;
            }
        }
        float newValue = Float.intBitsToFloat((int)(entry >>> 32)) + value;
        U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), Float.floatToIntBits(newValue));
        return newValue;
    }

    public float addValue(float key, float addition, float initialValue) {
        long entry;
        int index;
        long[] tab;
        block21: {
            int k = Float.floatToIntBits(key);
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVFloatKeyMixing.mix((int)k) % capacity;
            entry = tab[index];
            int cur = (int)entry;
            if (cur != k) {
                block22: {
                    if (cur != 0x7FFFFFFE) {
                        int firstRemoved;
                        if (cur <= 0x7FFFFFFE) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = (int)(entry = tab[bIndex])) == k) {
                                        index = bIndex;
                                        break block21;
                                    }
                                    if (cur == 0x7FFFFFFE) {
                                        index = bIndex;
                                        break block22;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = (int)(entry = tab[fIndex])) == k) {
                                        index = fIndex;
                                        break block21;
                                    }
                                    if (cur == 0x7FFFFFFE) {
                                        index = fIndex;
                                        break block22;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (int)(entry = tab[bIndex])) == k) {
                                index = bIndex;
                                break block21;
                            }
                            if (cur == 0x7FFFFFFE) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block22;
                            }
                            if (cur > 0x7FFFFFFE && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (int)(entry = tab[fIndex])) == k) {
                                index = fIndex;
                                break block21;
                            }
                            if (cur == 0x7FFFFFFE) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block22;
                            }
                            if (cur > 0x7FFFFFFE && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        float newValue = initialValue + addition;
                        this.incrementModCount();
                        tab[firstRemoved] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(newValue) << 32;
                        this.postRemovedSlotInsertHook();
                        return newValue;
                    }
                }
                float newValue = initialValue + addition;
                this.incrementModCount();
                tab[index] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(newValue) << 32;
                this.postFreeSlotInsertHook();
                return newValue;
            }
        }
        float newValue = Float.intBitsToFloat((int)(entry >>> 32)) + addition;
        U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), Float.floatToIntBits(newValue));
        return newValue;
    }

    public void putAll(@Nonnull Map<? extends Float, ? extends Float> m) {
        CommonFloatFloatMapOps.putAll((InternalFloatFloatMapOps)this, m);
    }

    public Float replace(Float key, Float value) {
        int k = Float.floatToIntBits(key.floatValue());
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix((int)k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur != k) {
            if (cur == 0x7FFFFFFE) {
                return null;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == k) {
                    index = bIndex;
                    break;
                }
                if (cur == 0x7FFFFFFE) {
                    return null;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == k) {
                    index = fIndex;
                    break;
                }
                if (cur == 0x7FFFFFFE) {
                    return null;
                }
                step += 2;
            }
        }
        float oldValue = Float.intBitsToFloat((int)(entry >>> 32));
        U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), Float.floatToIntBits(value.floatValue()));
        return Float.valueOf(oldValue);
    }

    public float replace(float key, float value) {
        int k = Float.floatToIntBits(key);
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix((int)k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur != k) {
            if (cur == 0x7FFFFFFE) {
                return this.defaultValue();
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == k) {
                    index = bIndex;
                    break;
                }
                if (cur == 0x7FFFFFFE) {
                    return this.defaultValue();
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == k) {
                    index = fIndex;
                    break;
                }
                if (cur == 0x7FFFFFFE) {
                    return this.defaultValue();
                }
                step += 2;
            }
        }
        float oldValue = Float.intBitsToFloat((int)(entry >>> 32));
        U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), Float.floatToIntBits(value));
        return oldValue;
    }

    public boolean replace(Float key, Float oldValue, Float newValue) {
        return this.replace(key.floatValue(), oldValue.floatValue(), newValue.floatValue());
    }

    public boolean replace(float key, float oldValue, float newValue) {
        int k = Float.floatToIntBits(key);
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix((int)k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur != k) {
            if (cur == 0x7FFFFFFE) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == k) {
                    index = bIndex;
                    break;
                }
                if (cur == 0x7FFFFFFE) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == k) {
                    index = fIndex;
                    break;
                }
                if (cur == 0x7FFFFFFE) {
                    return false;
                }
                step += 2;
            }
        }
        if ((int)(entry >>> 32) == Float.floatToIntBits(oldValue)) {
            U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), Float.floatToIntBits(newValue));
            return true;
        }
        return false;
    }

    public void replaceAll(BiFunction<? super Float, ? super Float, ? extends Float> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE) continue;
            U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)i << 3), Float.floatToIntBits(function.apply(Float.valueOf(Float.intBitsToFloat(key)), Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)))).floatValue()));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(FloatFloatToFloatFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE) continue;
            U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)i << 3), Float.floatToIntBits(function.applyAsFloat(Float.intBitsToFloat(key), Float.intBitsToFloat((int)(entry >>> 32)))));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        this.doClear();
    }

    private void doClear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    void removeAt(int index) {
        this.incrementModCount();
        super.removeAt(index);
        this.postRemoveHook();
    }

    public Float remove(Object key) {
        int k = Float.floatToIntBits(((Float)key).floatValue());
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix((int)k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur != k) {
            if (cur == 0x7FFFFFFE) {
                return null;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == k) {
                    index = bIndex;
                    break;
                }
                if (cur == 0x7FFFFFFE) {
                    return null;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == k) {
                    index = fIndex;
                    break;
                }
                if (cur == 0x7FFFFFFE) {
                    return null;
                }
                step += 2;
            }
        }
        float val = Float.intBitsToFloat((int)(entry >>> 32));
        this.incrementModCount();
        U.putInt(tab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)index << 3), Integer.MAX_VALUE);
        this.postRemoveHook();
        return Float.valueOf(val);
    }

    @Override
    public boolean justRemove(float key) {
        int k = Float.floatToIntBits(key);
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix((int)k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur != k) {
            if (cur == 0x7FFFFFFE) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == k) {
                    index = bIndex;
                    break;
                }
                if (cur == 0x7FFFFFFE) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == k) {
                    index = fIndex;
                    break;
                }
                if (cur == 0x7FFFFFFE) {
                    return false;
                }
                step += 2;
            }
        }
        this.incrementModCount();
        U.putInt(tab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)index << 3), Integer.MAX_VALUE);
        this.postRemoveHook();
        return true;
    }

    @Override
    public boolean justRemove(int key) {
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix((int)key) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur != key) {
            if (cur == 0x7FFFFFFE) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == key) {
                    index = bIndex;
                    break;
                }
                if (cur == 0x7FFFFFFE) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == key) {
                    index = fIndex;
                    break;
                }
                if (cur == 0x7FFFFFFE) {
                    return false;
                }
                step += 2;
            }
        }
        this.incrementModCount();
        U.putInt(tab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)index << 3), Integer.MAX_VALUE);
        this.postRemoveHook();
        return true;
    }

    public float remove(float key) {
        int k = Float.floatToIntBits(key);
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix((int)k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur != k) {
            if (cur == 0x7FFFFFFE) {
                return this.defaultValue();
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == k) {
                    index = bIndex;
                    break;
                }
                if (cur == 0x7FFFFFFE) {
                    return this.defaultValue();
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == k) {
                    index = fIndex;
                    break;
                }
                if (cur == 0x7FFFFFFE) {
                    return this.defaultValue();
                }
                step += 2;
            }
        }
        float val = Float.intBitsToFloat((int)(entry >>> 32));
        this.incrementModCount();
        U.putInt(tab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)index << 3), Integer.MAX_VALUE);
        this.postRemoveHook();
        return val;
    }

    public boolean remove(Object key, Object value) {
        return this.remove(((Float)key).floatValue(), ((Float)value).floatValue());
    }

    public boolean remove(float key, float value) {
        int k = Float.floatToIntBits(key);
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix((int)k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur != k) {
            if (cur == 0x7FFFFFFE) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == k) {
                    index = bIndex;
                    break;
                }
                if (cur == 0x7FFFFFFE) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == k) {
                    index = fIndex;
                    break;
                }
                if (cur == 0x7FFFFFFE) {
                    return false;
                }
                step += 2;
            }
        }
        if ((int)(entry >>> 32) == Float.floatToIntBits(value)) {
            this.incrementModCount();
            U.putInt(tab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)index << 3), Integer.MAX_VALUE);
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public boolean removeIf(FloatFloatPredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE || !filter.test(Float.intBitsToFloat(key), Float.intBitsToFloat((int)(entry >>> 32)))) continue;
            this.incrementModCount();
            ++mc;
            U.putInt(tab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)i << 3), Integer.MAX_VALUE);
            this.postRemoveHook();
            changed = true;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    class SomeRemovedMapCursor
    implements FloatFloatCursor {
        final long[] tab;
        int expectedModCount;
        int index;
        int curKey;
        int curValue;

        SomeRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = 0x7FFFFFFE;
        }

        public void forEachForward(FloatFloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                action.accept(Float.intBitsToFloat(key), Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (index != this.index || mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFE;
        }

        public float key() {
            int curKey = this.curKey;
            if (curKey != 0x7FFFFFFE) {
                return Float.intBitsToFloat(curKey);
            }
            throw new IllegalStateException();
        }

        public float value() {
            if (this.curKey != 0x7FFFFFFE) {
                return Float.intBitsToFloat(this.curValue);
            }
            throw new IllegalStateException();
        }

        public void setValue(float value) {
            if (this.curKey != 0x7FFFFFFE) {
                if (this.expectedModCount != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_VALUE_OFFSET + ((long)this.index << 3), Float.floatToIntBits(value));
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                long[] tab = this.tab;
                for (int i = this.index - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key >= 0x7FFFFFFE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (int)(entry >>> 32);
                    return true;
                }
                this.curKey = 0x7FFFFFFE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != 0x7FFFFFFE) {
                if (this.expectedModCount++ != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = 0x7FFFFFFE;
            MutableQHashParallelKVFloatFloatMapGO.this.incrementModCount();
            UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)this.index << 3), Integer.MAX_VALUE);
            MutableQHashParallelKVFloatFloatMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedMapCursor
    implements FloatFloatCursor {
        final long[] tab;
        int expectedModCount;
        int index;
        int curKey;
        int curValue;

        NoRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = 0x7FFFFFFE;
        }

        public void forEachForward(FloatFloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                action.accept(Float.intBitsToFloat(key), Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (index != this.index || mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFE;
        }

        public float key() {
            int curKey = this.curKey;
            if (curKey != 0x7FFFFFFE) {
                return Float.intBitsToFloat(curKey);
            }
            throw new IllegalStateException();
        }

        public float value() {
            if (this.curKey != 0x7FFFFFFE) {
                return Float.intBitsToFloat(this.curValue);
            }
            throw new IllegalStateException();
        }

        public void setValue(float value) {
            if (this.curKey != 0x7FFFFFFE) {
                if (this.expectedModCount != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_VALUE_OFFSET + ((long)this.index << 3), Float.floatToIntBits(value));
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                long[] tab = this.tab;
                for (int i = this.index - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key >= 0x7FFFFFFE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (int)(entry >>> 32);
                    return true;
                }
                this.curKey = 0x7FFFFFFE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != 0x7FFFFFFE) {
                if (this.expectedModCount++ != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = 0x7FFFFFFE;
            MutableQHashParallelKVFloatFloatMapGO.this.incrementModCount();
            UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)this.index << 3), Integer.MAX_VALUE);
            MutableQHashParallelKVFloatFloatMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueCursor
    implements FloatCursor {
        final long[] tab;
        int expectedModCount;
        int index;
        int curKey;
        int curValue;

        SomeRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = 0x7FFFFFFE;
        }

        public void forEachForward(FloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                action.accept(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (index != this.index || mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFE;
        }

        public float elem() {
            if (this.curKey != 0x7FFFFFFE) {
                return Float.intBitsToFloat(this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                long[] tab = this.tab;
                for (int i = this.index - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key >= 0x7FFFFFFE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (int)(entry >>> 32);
                    return true;
                }
                this.curKey = 0x7FFFFFFE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != 0x7FFFFFFE) {
                if (this.expectedModCount++ != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = 0x7FFFFFFE;
            MutableQHashParallelKVFloatFloatMapGO.this.incrementModCount();
            UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)this.index << 3), Integer.MAX_VALUE);
            MutableQHashParallelKVFloatFloatMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueIterator
    implements FloatIterator {
        final long[] tab;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        float next;

        SomeRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            long[] tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            int nextI = tab.length;
            while (--nextI >= 0) {
                long entry = tab[nextI];
                if ((int)entry >= 0x7FFFFFFE) continue;
                this.next = Float.intBitsToFloat((int)(entry >>> 32));
                break;
            }
            this.nextIndex = nextI;
        }

        public float nextFloat() {
            if (this.expectedModCount == MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    long[] tab = this.tab;
                    float prev = this.next;
                    while (--nextI >= 0) {
                        long entry = tab[nextI];
                        if ((int)entry >= 0x7FFFFFFE) continue;
                        this.next = Float.intBitsToFloat((int)(entry >>> 32));
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void forEachRemaining(Consumer<? super Float> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                action.accept(Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32))));
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(FloatConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                action.accept(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Float next() {
            return Float.valueOf(this.nextFloat());
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashParallelKVFloatFloatMapGO.this.incrementModCount();
            UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)index << 3), Integer.MAX_VALUE);
            MutableQHashParallelKVFloatFloatMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueCursor
    implements FloatCursor {
        final long[] tab;
        int expectedModCount;
        int index;
        int curKey;
        int curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = 0x7FFFFFFE;
        }

        public void forEachForward(FloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                action.accept(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (index != this.index || mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFE;
        }

        public float elem() {
            if (this.curKey != 0x7FFFFFFE) {
                return Float.intBitsToFloat(this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                long[] tab = this.tab;
                for (int i = this.index - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key >= 0x7FFFFFFE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (int)(entry >>> 32);
                    return true;
                }
                this.curKey = 0x7FFFFFFE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != 0x7FFFFFFE) {
                if (this.expectedModCount++ != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = 0x7FFFFFFE;
            MutableQHashParallelKVFloatFloatMapGO.this.incrementModCount();
            UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)this.index << 3), Integer.MAX_VALUE);
            MutableQHashParallelKVFloatFloatMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueIterator
    implements FloatIterator {
        final long[] tab;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        float next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            long[] tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            int nextI = tab.length;
            while (--nextI >= 0) {
                long entry = tab[nextI];
                if ((int)entry >= 0x7FFFFFFE) continue;
                this.next = Float.intBitsToFloat((int)(entry >>> 32));
                break;
            }
            this.nextIndex = nextI;
        }

        public float nextFloat() {
            if (this.expectedModCount == MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    long[] tab = this.tab;
                    float prev = this.next;
                    while (--nextI >= 0) {
                        long entry = tab[nextI];
                        if ((int)entry >= 0x7FFFFFFE) continue;
                        this.next = Float.intBitsToFloat((int)(entry >>> 32));
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void forEachRemaining(Consumer<? super Float> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                action.accept(Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32))));
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(FloatConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                action.accept(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Float next() {
            return Float.valueOf(this.nextFloat());
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashParallelKVFloatFloatMapGO.this.incrementModCount();
            UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)index << 3), Integer.MAX_VALUE);
            MutableQHashParallelKVFloatFloatMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryCursor
    implements ObjCursor<Map.Entry<Float, Float>> {
        final long[] tab;
        int expectedModCount;
        int index;
        int curKey;
        int curValue;

        SomeRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = 0x7FFFFFFE;
        }

        public void forEachForward(Consumer<? super Map.Entry<Float, Float>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                action.accept((Map.Entry<Float, Float>)((Object)new MutableEntry(mc, i, key, (int)(entry >>> 32))));
            }
            if (index != this.index || mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFE;
        }

        public Map.Entry<Float, Float> elem() {
            int curKey = this.curKey;
            if (curKey != 0x7FFFFFFE) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                long[] tab = this.tab;
                for (int i = this.index - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key >= 0x7FFFFFFE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (int)(entry >>> 32);
                    return true;
                }
                this.curKey = 0x7FFFFFFE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != 0x7FFFFFFE) {
                if (this.expectedModCount++ != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = 0x7FFFFFFE;
            MutableQHashParallelKVFloatFloatMapGO.this.incrementModCount();
            UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)this.index << 3), Integer.MAX_VALUE);
            MutableQHashParallelKVFloatFloatMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryIterator
    implements ObjIterator<Map.Entry<Float, Float>> {
        final long[] tab;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        SomeRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            long[] tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            int nextI = tab.length;
            while (--nextI >= 0) {
                long entry = tab[nextI];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                this.next = new MutableEntry(mc, nextI, key, (int)(entry >>> 32));
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Float, Float>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                action.accept((Map.Entry<Float, Float>)((Object)new MutableEntry(mc, i, key, (int)(entry >>> 32))));
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Float, Float> next() {
            int mc = this.expectedModCount;
            if (mc == MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    long[] tab = this.tab;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        long entry = tab[nextI];
                        int key = (int)entry;
                        if (key >= 0x7FFFFFFE) continue;
                        this.next = new MutableEntry(mc, nextI, key, (int)(entry >>> 32));
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashParallelKVFloatFloatMapGO.this.incrementModCount();
            UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)index << 3), Integer.MAX_VALUE);
            MutableQHashParallelKVFloatFloatMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Float, Float>> {
        final long[] tab;
        int expectedModCount;
        int index;
        int curKey;
        int curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = 0x7FFFFFFE;
        }

        public void forEachForward(Consumer<? super Map.Entry<Float, Float>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                action.accept((Map.Entry<Float, Float>)((Object)new MutableEntry(mc, i, key, (int)(entry >>> 32))));
            }
            if (index != this.index || mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFE;
        }

        public Map.Entry<Float, Float> elem() {
            int curKey = this.curKey;
            if (curKey != 0x7FFFFFFE) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                long[] tab = this.tab;
                for (int i = this.index - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key >= 0x7FFFFFFE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (int)(entry >>> 32);
                    return true;
                }
                this.curKey = 0x7FFFFFFE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != 0x7FFFFFFE) {
                if (this.expectedModCount++ != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = 0x7FFFFFFE;
            MutableQHashParallelKVFloatFloatMapGO.this.incrementModCount();
            UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)this.index << 3), Integer.MAX_VALUE);
            MutableQHashParallelKVFloatFloatMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Float, Float>> {
        final long[] tab;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            long[] tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            int nextI = tab.length;
            while (--nextI >= 0) {
                long entry = tab[nextI];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                this.next = new MutableEntry(mc, nextI, key, (int)(entry >>> 32));
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Float, Float>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                action.accept((Map.Entry<Float, Float>)((Object)new MutableEntry(mc, i, key, (int)(entry >>> 32))));
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Float, Float> next() {
            int mc = this.expectedModCount;
            if (mc == MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    long[] tab = this.tab;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        long entry = tab[nextI];
                        int key = (int)entry;
                        if (key >= 0x7FFFFFFE) continue;
                        this.next = new MutableEntry(mc, nextI, key, (int)(entry >>> 32));
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashParallelKVFloatFloatMapGO.this.incrementModCount();
            UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)index << 3), Integer.MAX_VALUE);
            MutableQHashParallelKVFloatFloatMapGO.this.postRemoveHook();
        }
    }

    class ValueView
    extends AbstractFloatValueView {
        ValueView() {
        }

        public int size() {
            return MutableQHashParallelKVFloatFloatMapGO.this.size();
        }

        public boolean shrink() {
            return MutableQHashParallelKVFloatFloatMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return MutableQHashParallelKVFloatFloatMapGO.this.containsValue(o);
        }

        public boolean contains(float v) {
            return MutableQHashParallelKVFloatFloatMapGO.this.containsValue(v);
        }

        public boolean contains(int bits) {
            return MutableQHashParallelKVFloatFloatMapGO.this.containsValue(bits);
        }

        public void forEach(Consumer<? super Float> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashParallelKVFloatFloatMapGO.this.modCount();
            long[] tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                action.accept(Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32))));
            }
            if (mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(FloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashParallelKVFloatFloatMapGO.this.modCount();
            long[] tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                action.accept(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(FloatPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashParallelKVFloatFloatMapGO.this.modCount();
            long[] tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE || predicate.test(Float.intBitsToFloat((int)(entry >>> 32)))) continue;
                terminated = true;
                break;
            }
            if (mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        public boolean allContainingIn(FloatCollection c) {
            if (c instanceof InternalFloatCollectionOps) {
                return this.allContainingIn((InternalFloatCollectionOps)c);
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableQHashParallelKVFloatFloatMapGO.this.modCount();
            long[] tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE || c.contains(Float.intBitsToFloat((int)(entry >>> 32)))) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        private boolean allContainingIn(InternalFloatCollectionOps c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableQHashParallelKVFloatFloatMapGO.this.modCount();
            long[] tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE || c.contains((int)(entry >>> 32))) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(FloatCollection c) {
            if (c instanceof InternalFloatCollectionOps) {
                return this.reverseAddAllTo((InternalFloatCollectionOps)c);
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVFloatFloatMapGO.this.modCount();
            long[] tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                changed |= c.add(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean reverseAddAllTo(InternalFloatCollectionOps c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVFloatFloatMapGO.this.modCount();
            long[] tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                changed |= c.add((int)(entry >>> 32));
            }
            if (mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(FloatSet s) {
            if (s instanceof InternalFloatCollectionOps) {
                return this.reverseRemoveAllFrom((InternalFloatCollectionOps)s);
            }
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVFloatFloatMapGO.this.modCount();
            long[] tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                changed |= s.removeFloat(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean reverseRemoveAllFrom(InternalFloatCollectionOps s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVFloatFloatMapGO.this.modCount();
            long[] tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                changed |= s.removeFloat((int)(entry >>> 32));
            }
            if (mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public FloatIterator iterator() {
            int mc = MutableQHashParallelKVFloatFloatMapGO.this.modCount();
            if (!MutableQHashParallelKVFloatFloatMapGO.this.noRemoved()) {
                return new SomeRemovedValueIterator(mc);
            }
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public FloatCursor cursor() {
            int mc = MutableQHashParallelKVFloatFloatMapGO.this.modCount();
            if (!MutableQHashParallelKVFloatFloatMapGO.this.noRemoved()) {
                return new SomeRemovedValueCursor(mc);
            }
            return new NoRemovedValueCursor(mc);
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVFloatFloatMapGO.this.modCount();
            long[] tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                result[resultIndex++] = Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVFloatFloatMapGO.this.modCount();
            long[] tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                a[resultIndex++] = Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public float[] toFloatArray() {
            int size = this.size();
            float[] result = new float[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVFloatFloatMapGO.this.modCount();
            long[] tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                result[resultIndex++] = Float.intBitsToFloat((int)(entry >>> 32));
            }
            if (mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public float[] toArray(float[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new float[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0.0f;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVFloatFloatMapGO.this.modCount();
            long[] tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                a[resultIndex++] = Float.intBitsToFloat((int)(entry >>> 32));
            }
            if (mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0.0f;
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashParallelKVFloatFloatMapGO.this.modCount();
            long[] tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                sb.append(' ').append(Float.intBitsToFloat((int)(entry >>> 32))).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return this.removeFloat(((Float)o).floatValue());
        }

        public boolean removeFloat(float v) {
            return MutableQHashParallelKVFloatFloatMapGO.this.removeValue(v);
        }

        public boolean removeFloat(int bits) {
            return MutableQHashParallelKVFloatFloatMapGO.this.removeValue(bits);
        }

        public void clear() {
            MutableQHashParallelKVFloatFloatMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super Float> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVFloatFloatMapGO.this.modCount();
            long[] tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE || !filter.test(Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32))))) continue;
                MutableQHashParallelKVFloatFloatMapGO.this.incrementModCount();
                ++mc;
                UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)i << 3), Integer.MAX_VALUE);
                MutableQHashParallelKVFloatFloatMapGO.this.postRemoveHook();
                changed = true;
            }
            if (mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeIf(FloatPredicate filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVFloatFloatMapGO.this.modCount();
            long[] tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE || !filter.test(Float.intBitsToFloat((int)(entry >>> 32)))) continue;
                MutableQHashParallelKVFloatFloatMapGO.this.incrementModCount();
                ++mc;
                UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)i << 3), Integer.MAX_VALUE);
                MutableQHashParallelKVFloatFloatMapGO.this.postRemoveHook();
                changed = true;
            }
            if (mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof FloatCollection) {
                return this.removeAll((FloatCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVFloatFloatMapGO.this.modCount();
            long[] tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE || !c.contains(Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32))))) continue;
                MutableQHashParallelKVFloatFloatMapGO.this.incrementModCount();
                ++mc;
                UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)i << 3), Integer.MAX_VALUE);
                MutableQHashParallelKVFloatFloatMapGO.this.postRemoveHook();
                changed = true;
            }
            if (mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(FloatCollection c) {
            if (c instanceof InternalFloatCollectionOps) {
                return this.removeAll((InternalFloatCollectionOps)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVFloatFloatMapGO.this.modCount();
            long[] tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE || !c.contains(Float.intBitsToFloat((int)(entry >>> 32)))) continue;
                MutableQHashParallelKVFloatFloatMapGO.this.incrementModCount();
                ++mc;
                UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)i << 3), Integer.MAX_VALUE);
                MutableQHashParallelKVFloatFloatMapGO.this.postRemoveHook();
                changed = true;
            }
            if (mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(InternalFloatCollectionOps c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVFloatFloatMapGO.this.modCount();
            long[] tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE || !c.contains((int)(entry >>> 32))) continue;
                MutableQHashParallelKVFloatFloatMapGO.this.incrementModCount();
                ++mc;
                UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)i << 3), Integer.MAX_VALUE);
                MutableQHashParallelKVFloatFloatMapGO.this.postRemoveHook();
                changed = true;
            }
            if (mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            if (c instanceof FloatCollection) {
                return this.retainAll((FloatCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVFloatFloatMapGO.this.modCount();
            long[] tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE || c.contains(Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32))))) continue;
                MutableQHashParallelKVFloatFloatMapGO.this.incrementModCount();
                ++mc;
                UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)i << 3), Integer.MAX_VALUE);
                MutableQHashParallelKVFloatFloatMapGO.this.postRemoveHook();
                changed = true;
            }
            if (mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(FloatCollection c) {
            if (c instanceof InternalFloatCollectionOps) {
                return this.retainAll((InternalFloatCollectionOps)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVFloatFloatMapGO.this.modCount();
            long[] tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE || c.contains(Float.intBitsToFloat((int)(entry >>> 32)))) continue;
                MutableQHashParallelKVFloatFloatMapGO.this.incrementModCount();
                ++mc;
                UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)i << 3), Integer.MAX_VALUE);
                MutableQHashParallelKVFloatFloatMapGO.this.postRemoveHook();
                changed = true;
            }
            if (mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(InternalFloatCollectionOps c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVFloatFloatMapGO.this.modCount();
            long[] tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE || c.contains((int)(entry >>> 32))) continue;
                MutableQHashParallelKVFloatFloatMapGO.this.incrementModCount();
                ++mc;
                UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)i << 3), Integer.MAX_VALUE);
                MutableQHashParallelKVFloatFloatMapGO.this.postRemoveHook();
                changed = true;
            }
            if (mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }
    }

    class ReusableEntry
    extends FloatFloatEntry {
        private int key;
        private int value;

        ReusableEntry() {
        }

        ReusableEntry with(int key, int value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    class MutableEntry
    extends FloatFloatEntry {
        final int modCount;
        private final int index;
        final int key;
        private int value;

        MutableEntry(int modCount, int index, int key, int value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }

        public Float setValue(Float newValue) {
            int unwrappedNewValue;
            if (this.modCount != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            float oldValue = Float.intBitsToFloat(this.value);
            this.value = unwrappedNewValue = Float.floatToIntBits(newValue.floatValue());
            this.updateValueInTable(unwrappedNewValue);
            return Float.valueOf(oldValue);
        }

        void updateValueInTable(int newValue) {
            UnsafeConstants.U.putInt(MutableQHashParallelKVFloatFloatMapGO.this.table, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_VALUE_OFFSET + ((long)this.index << 3), newValue);
        }
    }

    abstract class FloatFloatEntry
    extends AbstractEntry<Float, Float> {
        FloatFloatEntry() {
        }

        abstract int key();

        public final Float getKey() {
            return Float.valueOf(Float.intBitsToFloat(this.key()));
        }

        abstract int value();

        public final Float getValue() {
            return Float.valueOf(Float.intBitsToFloat(this.value()));
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                int k2 = Float.floatToIntBits(((Float)e2.getKey()).floatValue());
                int v2 = Float.floatToIntBits(((Float)e2.getValue()).floatValue());
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return Primitives.hashCode((int)this.key()) ^ Primitives.hashCode((int)this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Float, Float>>
    implements HashObjSet<Map.Entry<Float, Float>>,
    InternalObjCollectionOps<Map.Entry<Float, Float>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Float, Float>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return MutableQHashParallelKVFloatFloatMapGO.this.hashConfig();
        }

        public int size() {
            return MutableQHashParallelKVFloatFloatMapGO.this.size;
        }

        public double currentLoad() {
            return MutableQHashParallelKVFloatFloatMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return MutableQHashParallelKVFloatFloatMapGO.this.containsEntry(((Float)e.getKey()).floatValue(), ((Float)e.getValue()).floatValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVFloatFloatMapGO.this.modCount();
            long[] tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, (int)(entry >>> 32));
            }
            if (mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVFloatFloatMapGO.this.modCount();
            long[] tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, (int)(entry >>> 32));
            }
            if (mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<Float, Float>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashParallelKVFloatFloatMapGO.this.modCount();
            long[] tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                action.accept((Map.Entry<Float, Float>)((Object)new MutableEntry(mc, i, key, (int)(entry >>> 32))));
            }
            if (mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Float, Float>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashParallelKVFloatFloatMapGO.this.modCount();
            long[] tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE || predicate.test((Map.Entry<Float, Float>)((Object)new MutableEntry(mc, i, key, (int)(entry >>> 32))))) continue;
                terminated = true;
                break;
            }
            if (mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<Float, Float>> iterator() {
            int mc = MutableQHashParallelKVFloatFloatMapGO.this.modCount();
            if (!MutableQHashParallelKVFloatFloatMapGO.this.noRemoved()) {
                return new SomeRemovedEntryIterator(mc);
            }
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Float, Float>> cursor() {
            int mc = MutableQHashParallelKVFloatFloatMapGO.this.modCount();
            if (!MutableQHashParallelKVFloatFloatMapGO.this.noRemoved()) {
                return new SomeRemovedEntryCursor(mc);
            }
            return new NoRemovedEntryCursor(mc);
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashParallelKVFloatFloatMapGO.this.modCount();
            long[] tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE || c.contains((Object)e.with(key, (int)(entry >>> 32)))) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashParallelKVFloatFloatMapGO.this.modCount();
            long[] tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                changed |= s.remove((Object)e.with(key, (int)(entry >>> 32)));
            }
            if (mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Float, Float>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVFloatFloatMapGO.this.modCount();
            long[] tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, (int)(entry >>> 32)));
            }
            if (mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public int hashCode() {
            return MutableQHashParallelKVFloatFloatMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashParallelKVFloatFloatMapGO.this.modCount();
            long[] tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                sb.append(' ');
                sb.append(Float.intBitsToFloat(key));
                sb.append('=');
                sb.append(Float.intBitsToFloat((int)(entry >>> 32)));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return MutableQHashParallelKVFloatFloatMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                float key = ((Float)e.getKey()).floatValue();
                float value = ((Float)e.getValue()).floatValue();
                return MutableQHashParallelKVFloatFloatMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Float, Float>> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVFloatFloatMapGO.this.modCount();
            long[] tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE || !filter.test((Map.Entry<Float, Float>)((Object)new MutableEntry(mc, i, key, (int)(entry >>> 32))))) continue;
                MutableQHashParallelKVFloatFloatMapGO.this.incrementModCount();
                ++mc;
                UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)i << 3), Integer.MAX_VALUE);
                MutableQHashParallelKVFloatFloatMapGO.this.postRemoveHook();
                changed = true;
            }
            if (mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashParallelKVFloatFloatMapGO.this.modCount();
            long[] tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE || !c.contains((Object)e.with(key, (int)(entry >>> 32)))) continue;
                MutableQHashParallelKVFloatFloatMapGO.this.incrementModCount();
                ++mc;
                UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)i << 3), Integer.MAX_VALUE);
                MutableQHashParallelKVFloatFloatMapGO.this.postRemoveHook();
                changed = true;
            }
            if (mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashParallelKVFloatFloatMapGO.this.modCount();
            long[] tab = MutableQHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE || c.contains((Object)e.with(key, (int)(entry >>> 32)))) continue;
                MutableQHashParallelKVFloatFloatMapGO.this.incrementModCount();
                ++mc;
                UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)i << 3), Integer.MAX_VALUE);
                MutableQHashParallelKVFloatFloatMapGO.this.postRemoveHook();
                changed = true;
            }
            if (mc != MutableQHashParallelKVFloatFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public void clear() {
            MutableQHashParallelKVFloatFloatMapGO.this.doClear();
        }
    }
}

