/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.DoubleCollection;
import com.koloboke.collect.DoubleCursor;
import com.koloboke.collect.DoubleIterator;
import com.koloboke.collect.Equivalence;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractDoubleValueView;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.CommonIntDoubleMapOps;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.InternalDoubleCollectionOps;
import com.koloboke.collect.impl.InternalIntDoubleMapOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.hash.MutableQHashSeparateKVIntDoubleMapSO;
import com.koloboke.collect.impl.hash.QHash;
import com.koloboke.collect.impl.hash.SeparateKVIntDoubleQHash;
import com.koloboke.collect.map.IntDoubleCursor;
import com.koloboke.collect.set.DoubleSet;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.IntDoubleConsumer;
import com.koloboke.function.IntDoublePredicate;
import com.koloboke.function.IntDoubleToDoubleFunction;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoublePredicate;
import java.util.function.Function;
import java.util.function.IntToDoubleFunction;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class MutableQHashSeparateKVIntDoubleMapGO
extends MutableQHashSeparateKVIntDoubleMapSO {
    @Override
    final void copy(SeparateKVIntDoubleQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVIntDoubleQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public double defaultValue() {
        return 0.0;
    }

    public boolean containsEntry(int key, double value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == Double.doubleToLongBits(value);
        }
        return false;
    }

    public boolean containsEntry(int key, long value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    public Double get(Object key) {
        int index = this.index((Integer)key);
        if (index >= 0) {
            return Double.longBitsToDouble(this.values[index]);
        }
        return null;
    }

    public double get(int key) {
        int index = this.index(key);
        if (index >= 0) {
            return Double.longBitsToDouble(this.values[index]);
        }
        return this.defaultValue();
    }

    public Double getOrDefault(Object key, Double defaultValue) {
        int index = this.index((Integer)key);
        if (index >= 0) {
            return Double.longBitsToDouble(this.values[index]);
        }
        return defaultValue;
    }

    public double getOrDefault(int key, double defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return Double.longBitsToDouble(this.values[index]);
        }
        return defaultValue;
    }

    public void forEach(BiConsumer<? super Integer, ? super Double> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        int[] keys = this.set;
        long[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                action.accept((Integer)key, (Double)Double.longBitsToDouble(vals[i]));
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed) continue;
                action.accept((Integer)key, (Double)Double.longBitsToDouble(vals[i]));
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(IntDoubleConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        int[] keys = this.set;
        long[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                action.accept(key, Double.longBitsToDouble(vals[i]));
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(key, Double.longBitsToDouble(vals[i]));
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(IntDoublePredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        int[] keys = this.set;
        long[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || predicate.test(key, Double.longBitsToDouble(vals[i]))) continue;
                terminated = true;
                break;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed || predicate.test(key, Double.longBitsToDouble(vals[i]))) continue;
                terminated = true;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public IntDoubleCursor cursor() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedMapCursor(mc);
        }
        return new NoRemovedMapCursor(mc);
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonIntDoubleMapOps.containsAllEntries((InternalIntDoubleMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalIntDoubleMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        int[] keys = this.set;
        long[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || m.containsEntry(key, vals[i])) continue;
                containsAll = false;
                break;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed || m.containsEntry(key, vals[i])) continue;
                containsAll = false;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalIntDoubleMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        int[] keys = this.set;
        long[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                m.justPut(key, vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed) continue;
                m.justPut(key, vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<Integer, Double>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public DoubleCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        int[] keys = this.set;
        long[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                long val = vals[i];
                hashCode += key ^ (int)(val ^ val >>> 32);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed) continue;
                long val = vals[i];
                hashCode += key ^ (int)(val ^ val >>> 32);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        int[] keys = this.set;
        long[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(Double.longBitsToDouble(vals[i]));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(Double.longBitsToDouble(vals[i]));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        int[] keys = this.set;
        long[] vals = this.values;
        this.initForRehash(newCapacity);
        ++mc;
        int[] newKeys = this.set;
        int capacity = newKeys.length;
        long[] newVals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                int index = QHash.SeparateKVIntKeyMixing.mix((int)key) % capacity;
                if (newKeys[index] != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if (newKeys[bIndex] == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if (newKeys[fIndex] == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newKeys[index] = key;
                newVals[index] = vals[i];
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed) continue;
                int index = QHash.SeparateKVIntKeyMixing.mix((int)key) % capacity;
                if (newKeys[index] != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if (newKeys[bIndex] == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if (newKeys[fIndex] == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newKeys[index] = key;
                newVals[index] = vals[i];
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public Double put(Integer key, Double value) {
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return null;
        }
        long[] vals = this.values;
        double prevValue = Double.longBitsToDouble(vals[index]);
        vals[index] = Double.doubleToLongBits(value);
        return prevValue;
    }

    public double put(int key, double value) {
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return this.defaultValue();
        }
        long[] vals = this.values;
        double prevValue = Double.longBitsToDouble(vals[index]);
        vals[index] = Double.doubleToLongBits(value);
        return prevValue;
    }

    public Double putIfAbsent(Integer key, Double value) {
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return null;
        }
        return Double.longBitsToDouble(this.values[index]);
    }

    public double putIfAbsent(int key, double value) {
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return this.defaultValue();
        }
        return Double.longBitsToDouble(this.values[index]);
    }

    public void justPut(int key, double value) {
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return;
        }
        this.values[index] = Double.doubleToLongBits(value);
    }

    public void justPut(int key, long value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    public Double compute(Integer key, BiFunction<? super Integer, ? super Double, ? extends Double> remappingFunction) {
        Double newValue;
        int index;
        long[] vals;
        int removed;
        int k;
        block28: {
            k = key;
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            removed = this.removedValue;
            int free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            int[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVIntKeyMixing.mix((int)k) % capacity;
            int cur = keys[index];
            if (cur != k) {
                Double newValue2;
                block29: {
                    if (cur != free) {
                        Double newValue3;
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == k) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == k) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        if ((newValue3 = remappingFunction.apply((Integer)k, null)) != null) {
                            this.incrementModCount();
                            keys[firstRemoved] = k;
                            vals[firstRemoved] = Double.doubleToLongBits(newValue3);
                            this.postRemovedSlotInsertHook();
                            return newValue3;
                        }
                        return null;
                    }
                }
                if ((newValue2 = remappingFunction.apply((Integer)k, null)) != null) {
                    this.incrementModCount();
                    keys[index] = k;
                    vals[index] = Double.doubleToLongBits(newValue2);
                    this.postFreeSlotInsertHook();
                    return newValue2;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply((Integer)k, (Double)Double.longBitsToDouble(vals[index]))) != null) {
            vals[index] = Double.doubleToLongBits(newValue);
            return newValue;
        }
        this.incrementModCount();
        keys[index] = removed;
        this.postRemoveHook();
        return null;
    }

    public double compute(int key, IntDoubleToDoubleFunction remappingFunction) {
        int index;
        long[] vals;
        block25: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            int removed = this.removedValue;
            int free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            int[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVIntKeyMixing.mix((int)key) % capacity;
            int cur = keys[index];
            if (cur != key) {
                block26: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        double newValue = remappingFunction.applyAsDouble(key, this.defaultValue());
                        this.incrementModCount();
                        keys[firstRemoved] = key;
                        vals[firstRemoved] = Double.doubleToLongBits(newValue);
                        this.postRemovedSlotInsertHook();
                        return newValue;
                    }
                }
                double newValue = remappingFunction.applyAsDouble(key, this.defaultValue());
                this.incrementModCount();
                keys[index] = key;
                vals[index] = Double.doubleToLongBits(newValue);
                this.postFreeSlotInsertHook();
                return newValue;
            }
        }
        double newValue = remappingFunction.applyAsDouble(key, Double.longBitsToDouble(vals[index]));
        vals[index] = Double.doubleToLongBits(newValue);
        return newValue;
    }

    public Double computeIfAbsent(Integer key, Function<? super Integer, ? extends Double> mappingFunction) {
        Double value;
        int k;
        block27: {
            k = key;
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            int removed = this.removedValue;
            int free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            int[] keys = this.set;
            long[] vals = this.values;
            int capacity = keys.length;
            int index = QHash.SeparateKVIntKeyMixing.mix((int)k) % capacity;
            int cur = keys[index];
            if (cur == k) {
                return Double.longBitsToDouble(vals[index]);
            }
            if (cur != free) {
                Double value2;
                int firstRemoved;
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                return Double.longBitsToDouble(vals[bIndex]);
                            }
                            if (cur == free) {
                                index = bIndex;
                                break block27;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                return Double.longBitsToDouble(vals[fIndex]);
                            }
                            if (cur == free) {
                                index = fIndex;
                                break block27;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == k) {
                        return Double.longBitsToDouble(vals[bIndex]);
                    }
                    if (cur == free) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block27;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == k) {
                        return Double.longBitsToDouble(vals[fIndex]);
                    }
                    if (cur == free) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block27;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                if ((value2 = mappingFunction.apply((Integer)k)) != null) {
                    this.incrementModCount();
                    keys[firstRemoved] = k;
                    vals[firstRemoved] = Double.doubleToLongBits(value2);
                    this.postRemovedSlotInsertHook();
                    return value2;
                }
                return null;
            }
        }
        if ((value = mappingFunction.apply((Integer)k)) != null) {
            this.incrementModCount();
            keys[index] = k;
            vals[index] = Double.doubleToLongBits(value);
            this.postFreeSlotInsertHook();
            return value;
        }
        return null;
    }

    public double computeIfAbsent(int key, IntToDoubleFunction mappingFunction) {
        block25: {
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            int removed = this.removedValue;
            int free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            int[] keys = this.set;
            long[] vals = this.values;
            int capacity = keys.length;
            int index = QHash.SeparateKVIntKeyMixing.mix((int)key) % capacity;
            int cur = keys[index];
            if (cur == key) {
                return Double.longBitsToDouble(vals[index]);
            }
            if (cur != free) {
                int firstRemoved;
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                return Double.longBitsToDouble(vals[bIndex]);
                            }
                            if (cur == free) {
                                index = bIndex;
                                break block25;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                return Double.longBitsToDouble(vals[fIndex]);
                            }
                            if (cur == free) {
                                index = fIndex;
                                break block25;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == key) {
                        return Double.longBitsToDouble(vals[bIndex]);
                    }
                    if (cur == free) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block25;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == key) {
                        return Double.longBitsToDouble(vals[fIndex]);
                    }
                    if (cur == free) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block25;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                double value = mappingFunction.applyAsDouble(key);
                this.incrementModCount();
                keys[firstRemoved] = key;
                vals[firstRemoved] = Double.doubleToLongBits(value);
                this.postRemovedSlotInsertHook();
                return value;
            }
        }
        double value = mappingFunction.applyAsDouble(key);
        this.incrementModCount();
        keys[index] = key;
        vals[index] = Double.doubleToLongBits(value);
        this.postFreeSlotInsertHook();
        return value;
    }

    public Double computeIfPresent(Integer key, BiFunction<? super Integer, ? super Double, ? extends Double> remappingFunction) {
        int k = key;
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            long[] vals = this.values;
            Double newValue = remappingFunction.apply((Integer)k, (Double)Double.longBitsToDouble(vals[index]));
            if (newValue != null) {
                vals[index] = Double.doubleToLongBits(newValue);
                return newValue;
            }
            this.incrementModCount();
            this.set[index] = this.removedValue;
            this.postRemoveHook();
            return null;
        }
        return null;
    }

    public double computeIfPresent(int key, IntDoubleToDoubleFunction remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            long[] vals = this.values;
            double newValue = remappingFunction.applyAsDouble(key, Double.longBitsToDouble(vals[index]));
            vals[index] = Double.doubleToLongBits(newValue);
            return newValue;
        }
        return this.defaultValue();
    }

    public Double merge(Integer key, Double value, BiFunction<? super Double, ? super Double, ? extends Double> remappingFunction) {
        Double newValue;
        int index;
        long[] vals;
        int removed;
        block27: {
            int k = key;
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            removed = this.removedValue;
            int free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            int[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVIntKeyMixing.mix((int)k) % capacity;
            int cur = keys[index];
            if (cur != k) {
                block28: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == k) {
                                        index = bIndex;
                                        break block27;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == k) {
                                        index = fIndex;
                                        break block27;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break block27;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block28;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break block27;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block28;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        keys[firstRemoved] = k;
                        vals[firstRemoved] = Double.doubleToLongBits(value);
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                keys[index] = k;
                vals[index] = Double.doubleToLongBits(value);
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply((Double)Double.longBitsToDouble(vals[index]), value)) != null) {
            vals[index] = Double.doubleToLongBits(newValue);
            return newValue;
        }
        this.incrementModCount();
        keys[index] = removed;
        this.postRemoveHook();
        return null;
    }

    public double merge(int key, double value, DoubleBinaryOperator remappingFunction) {
        int index;
        long[] vals;
        block25: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            int removed = this.removedValue;
            int free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            int[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVIntKeyMixing.mix((int)key) % capacity;
            int cur = keys[index];
            if (cur != key) {
                block26: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        keys[firstRemoved] = key;
                        vals[firstRemoved] = Double.doubleToLongBits(value);
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                keys[index] = key;
                vals[index] = Double.doubleToLongBits(value);
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        double newValue = remappingFunction.applyAsDouble(Double.longBitsToDouble(vals[index]), value);
        vals[index] = Double.doubleToLongBits(newValue);
        return newValue;
    }

    public double addValue(int key, double value) {
        int index;
        long[] vals;
        block24: {
            int removed = this.removedValue;
            int free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            int[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVIntKeyMixing.mix((int)key) % capacity;
            int cur = keys[index];
            if (cur != key) {
                block25: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block24;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block24;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break block24;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block25;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break block24;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block25;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        double newValue = this.defaultValue() + value;
                        this.incrementModCount();
                        keys[firstRemoved] = key;
                        vals[firstRemoved] = Double.doubleToLongBits(newValue);
                        this.postRemovedSlotInsertHook();
                        return newValue;
                    }
                }
                double newValue = this.defaultValue() + value;
                this.incrementModCount();
                keys[index] = key;
                vals[index] = Double.doubleToLongBits(newValue);
                this.postFreeSlotInsertHook();
                return newValue;
            }
        }
        double newValue = Double.longBitsToDouble(vals[index]) + value;
        vals[index] = Double.doubleToLongBits(newValue);
        return newValue;
    }

    public double addValue(int key, double addition, double initialValue) {
        int index;
        long[] vals;
        block24: {
            int removed = this.removedValue;
            int free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            int[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVIntKeyMixing.mix((int)key) % capacity;
            int cur = keys[index];
            if (cur != key) {
                block25: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block24;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block24;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break block24;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block25;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break block24;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block25;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        double newValue = initialValue + addition;
                        this.incrementModCount();
                        keys[firstRemoved] = key;
                        vals[firstRemoved] = Double.doubleToLongBits(newValue);
                        this.postRemovedSlotInsertHook();
                        return newValue;
                    }
                }
                double newValue = initialValue + addition;
                this.incrementModCount();
                keys[index] = key;
                vals[index] = Double.doubleToLongBits(newValue);
                this.postFreeSlotInsertHook();
                return newValue;
            }
        }
        double newValue = Double.longBitsToDouble(vals[index]) + addition;
        vals[index] = Double.doubleToLongBits(newValue);
        return newValue;
    }

    public void putAll(@Nonnull Map<? extends Integer, ? extends Double> m) {
        CommonIntDoubleMapOps.putAll((InternalIntDoubleMapOps)this, m);
    }

    public Double replace(Integer key, Double value) {
        int index = this.index(key);
        if (index >= 0) {
            long[] vals = this.values;
            double oldValue = Double.longBitsToDouble(vals[index]);
            vals[index] = Double.doubleToLongBits(value);
            return oldValue;
        }
        return null;
    }

    public double replace(int key, double value) {
        int index = this.index(key);
        if (index >= 0) {
            long[] vals = this.values;
            double oldValue = Double.longBitsToDouble(vals[index]);
            vals[index] = Double.doubleToLongBits(value);
            return oldValue;
        }
        return this.defaultValue();
    }

    public boolean replace(Integer key, Double oldValue, Double newValue) {
        return this.replace((int)key, (double)oldValue, (double)newValue);
    }

    public boolean replace(int key, double oldValue, double newValue) {
        int index = this.index(key);
        if (index >= 0) {
            long[] vals = this.values;
            if (vals[index] == Double.doubleToLongBits(oldValue)) {
                vals[index] = Double.doubleToLongBits(newValue);
                return true;
            }
            return false;
        }
        return false;
    }

    public void replaceAll(BiFunction<? super Integer, ? super Double, ? extends Double> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        int[] keys = this.set;
        long[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                vals[i] = Double.doubleToLongBits(function.apply((Integer)key, (Double)Double.longBitsToDouble(vals[i])));
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed) continue;
                vals[i] = Double.doubleToLongBits(function.apply((Integer)key, (Double)Double.longBitsToDouble(vals[i])));
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(IntDoubleToDoubleFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        int[] keys = this.set;
        long[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                vals[i] = Double.doubleToLongBits(function.applyAsDouble(key, Double.longBitsToDouble(vals[i])));
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed) continue;
                vals[i] = Double.doubleToLongBits(function.applyAsDouble(key, Double.longBitsToDouble(vals[i])));
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        this.doClear();
    }

    private void doClear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    void removeAt(int index) {
        this.incrementModCount();
        super.removeAt(index);
        this.postRemoveHook();
    }

    public Double remove(Object key) {
        int removed;
        int free;
        int k = (Integer)key;
        if (k != (free = this.freeValue) && k != (removed = this.removedValue)) {
            int[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVIntKeyMixing.mix((int)k) % capacity;
            int cur = keys[index];
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    step += 2;
                }
            }
            double val = Double.longBitsToDouble(this.values[index]);
            this.incrementModCount();
            keys[index] = removed;
            this.postRemoveHook();
            return val;
        }
        return null;
    }

    @Override
    public boolean justRemove(int key) {
        int removed;
        int free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            int[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVIntKeyMixing.mix((int)key) % capacity;
            int cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    step += 2;
                }
            }
            this.incrementModCount();
            keys[index] = removed;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public double remove(int key) {
        int removed;
        int free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            int[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVIntKeyMixing.mix((int)key) % capacity;
            int cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    step += 2;
                }
            }
            double val = Double.longBitsToDouble(this.values[index]);
            this.incrementModCount();
            keys[index] = removed;
            this.postRemoveHook();
            return val;
        }
        return this.defaultValue();
    }

    public boolean remove(Object key, Object value) {
        return this.remove((Integer)key, (Double)value);
    }

    public boolean remove(int key, double value) {
        int removed;
        int free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            int[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVIntKeyMixing.mix((int)key) % capacity;
            int cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    step += 2;
                }
            }
            if (this.values[index] == Double.doubleToLongBits(value)) {
                this.incrementModCount();
                keys[index] = removed;
                this.postRemoveHook();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean removeIf(IntDoublePredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        int[] keys = this.set;
        long[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || !filter.test(key, Double.longBitsToDouble(vals[i]))) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed || !filter.test(key, Double.longBitsToDouble(vals[i]))) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    class SomeRemovedMapCursor
    implements IntDoubleCursor {
        final int[] keys;
        final long[] vals;
        final int free;
        final int removed;
        int expectedModCount;
        int index;
        int curKey;
        long curValue;

        SomeRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            int free = this.free = MutableQHashSeparateKVIntDoubleMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVIntDoubleMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(IntDoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            long[] vals = this.vals;
            int free = this.free;
            int removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(key, Double.longBitsToDouble(vals[i]));
            }
            if (index != this.index || mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public int key() {
            int curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public double value() {
            if (this.curKey != this.free) {
                return Double.longBitsToDouble(this.curValue);
            }
            throw new IllegalStateException();
        }

        public void setValue(double value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = Double.doubleToLongBits(value);
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                int[] keys = this.keys;
                int free = this.free;
                int removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVIntDoubleMapGO.this.incrementModCount();
            this.keys[this.index] = this.removed;
            MutableQHashSeparateKVIntDoubleMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedMapCursor
    implements IntDoubleCursor {
        final int[] keys;
        final long[] vals;
        final int free;
        final int removed;
        int expectedModCount;
        int index;
        int curKey;
        long curValue;

        NoRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            int free = this.free = MutableQHashSeparateKVIntDoubleMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVIntDoubleMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(IntDoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            long[] vals = this.vals;
            int free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                action.accept(key, Double.longBitsToDouble(vals[i]));
            }
            if (index != this.index || mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public int key() {
            int curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public double value() {
            if (this.curKey != this.free) {
                return Double.longBitsToDouble(this.curValue);
            }
            throw new IllegalStateException();
        }

        public void setValue(double value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = Double.doubleToLongBits(value);
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                int[] keys = this.keys;
                int free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVIntDoubleMapGO.this.incrementModCount();
            this.keys[this.index] = this.removed;
            MutableQHashSeparateKVIntDoubleMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueCursor
    implements DoubleCursor {
        final int[] keys;
        final long[] vals;
        final int free;
        final int removed;
        int expectedModCount;
        int index;
        int curKey;
        long curValue;

        SomeRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            int free = this.free = MutableQHashSeparateKVIntDoubleMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVIntDoubleMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(DoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            long[] vals = this.vals;
            int free = this.free;
            int removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(Double.longBitsToDouble(vals[i]));
            }
            if (index != this.index || mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public double elem() {
            if (this.curKey != this.free) {
                return Double.longBitsToDouble(this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                int[] keys = this.keys;
                int free = this.free;
                int removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVIntDoubleMapGO.this.incrementModCount();
            this.keys[this.index] = this.removed;
            MutableQHashSeparateKVIntDoubleMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueIterator
    implements DoubleIterator {
        final int[] keys;
        final long[] vals;
        final int free;
        final int removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        double next;

        SomeRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            int[] keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            this.vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            long[] vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            int free = this.free = MutableQHashSeparateKVIntDoubleMapGO.this.freeValue;
            int removed = this.removed = MutableQHashSeparateKVIntDoubleMapGO.this.removedValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                int key = keys[nextI];
                if (key == free || key == removed) continue;
                this.next = Double.longBitsToDouble(vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public double nextDouble() {
            if (this.expectedModCount == MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    int[] keys = this.keys;
                    int free = this.free;
                    int removed = this.removed;
                    double prev = this.next;
                    while (--nextI >= 0) {
                        int key = keys[nextI];
                        if (key == free || key == removed) continue;
                        this.next = Double.longBitsToDouble(this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void forEachRemaining(Consumer<? super Double> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            long[] vals = this.vals;
            int free = this.free;
            int removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed) continue;
                action.accept((Double)Double.longBitsToDouble(vals[i]));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(DoubleConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            long[] vals = this.vals;
            int free = this.free;
            int removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(Double.longBitsToDouble(vals[i]));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Double next() {
            return this.nextDouble();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVIntDoubleMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            MutableQHashSeparateKVIntDoubleMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueCursor
    implements DoubleCursor {
        final int[] keys;
        final long[] vals;
        final int free;
        final int removed;
        int expectedModCount;
        int index;
        int curKey;
        long curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            int free = this.free = MutableQHashSeparateKVIntDoubleMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVIntDoubleMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(DoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            long[] vals = this.vals;
            int free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(Double.longBitsToDouble(vals[i]));
            }
            if (index != this.index || mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public double elem() {
            if (this.curKey != this.free) {
                return Double.longBitsToDouble(this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                int[] keys = this.keys;
                int free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVIntDoubleMapGO.this.incrementModCount();
            this.keys[this.index] = this.removed;
            MutableQHashSeparateKVIntDoubleMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueIterator
    implements DoubleIterator {
        final int[] keys;
        final long[] vals;
        final int free;
        final int removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        double next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            int[] keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            this.vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            long[] vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            int free = this.free = MutableQHashSeparateKVIntDoubleMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVIntDoubleMapGO.this.removedValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == free) continue;
                this.next = Double.longBitsToDouble(vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public double nextDouble() {
            if (this.expectedModCount == MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    int[] keys = this.keys;
                    int free = this.free;
                    double prev = this.next;
                    while (--nextI >= 0) {
                        if (keys[nextI] == free) continue;
                        this.next = Double.longBitsToDouble(this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void forEachRemaining(Consumer<? super Double> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            long[] vals = this.vals;
            int free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept((Double)Double.longBitsToDouble(vals[i]));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(DoubleConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            long[] vals = this.vals;
            int free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(Double.longBitsToDouble(vals[i]));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Double next() {
            return this.nextDouble();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVIntDoubleMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            MutableQHashSeparateKVIntDoubleMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryCursor
    implements ObjCursor<Map.Entry<Integer, Double>> {
        final int[] keys;
        final long[] vals;
        final int free;
        final int removed;
        int expectedModCount;
        int index;
        int curKey;
        long curValue;

        SomeRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            int free = this.free = MutableQHashSeparateKVIntDoubleMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVIntDoubleMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(Consumer<? super Map.Entry<Integer, Double>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            long[] vals = this.vals;
            int free = this.free;
            int removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed) continue;
                action.accept((Map.Entry<Integer, Double>)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (index != this.index || mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Integer, Double> elem() {
            int curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                int[] keys = this.keys;
                int free = this.free;
                int removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVIntDoubleMapGO.this.incrementModCount();
            this.keys[this.index] = this.removed;
            MutableQHashSeparateKVIntDoubleMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryIterator
    implements ObjIterator<Map.Entry<Integer, Double>> {
        final int[] keys;
        final long[] vals;
        final int free;
        final int removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        SomeRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            int[] keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            this.vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            long[] vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            int free = this.free = MutableQHashSeparateKVIntDoubleMapGO.this.freeValue;
            int removed = this.removed = MutableQHashSeparateKVIntDoubleMapGO.this.removedValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                int key = keys[nextI];
                if (key == free || key == removed) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Integer, Double>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            long[] vals = this.vals;
            int free = this.free;
            int removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed) continue;
                action.accept((Map.Entry<Integer, Double>)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Integer, Double> next() {
            int mc = this.expectedModCount;
            if (mc == MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    int[] keys = this.keys;
                    int free = this.free;
                    int removed = this.removed;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        int key = keys[nextI];
                        if (key == free || key == removed) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVIntDoubleMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            MutableQHashSeparateKVIntDoubleMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Integer, Double>> {
        final int[] keys;
        final long[] vals;
        final int free;
        final int removed;
        int expectedModCount;
        int index;
        int curKey;
        long curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            int free = this.free = MutableQHashSeparateKVIntDoubleMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVIntDoubleMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(Consumer<? super Map.Entry<Integer, Double>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            long[] vals = this.vals;
            int free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry<Integer, Double>)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (index != this.index || mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Integer, Double> elem() {
            int curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                int[] keys = this.keys;
                int free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVIntDoubleMapGO.this.incrementModCount();
            this.keys[this.index] = this.removed;
            MutableQHashSeparateKVIntDoubleMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Integer, Double>> {
        final int[] keys;
        final long[] vals;
        final int free;
        final int removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            int[] keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            this.vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            long[] vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            int free = this.free = MutableQHashSeparateKVIntDoubleMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVIntDoubleMapGO.this.removedValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                int key = keys[nextI];
                if (key == free) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Integer, Double>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            long[] vals = this.vals;
            int free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry<Integer, Double>)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Integer, Double> next() {
            int mc = this.expectedModCount;
            if (mc == MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    int[] keys = this.keys;
                    int free = this.free;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        int key = keys[nextI];
                        if (key == free) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVIntDoubleMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            MutableQHashSeparateKVIntDoubleMapGO.this.postRemoveHook();
        }
    }

    class ValueView
    extends AbstractDoubleValueView {
        ValueView() {
        }

        public int size() {
            return MutableQHashSeparateKVIntDoubleMapGO.this.size();
        }

        public boolean shrink() {
            return MutableQHashSeparateKVIntDoubleMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return MutableQHashSeparateKVIntDoubleMapGO.this.containsValue(o);
        }

        public boolean contains(double v) {
            return MutableQHashSeparateKVIntDoubleMapGO.this.containsValue(v);
        }

        public boolean contains(long bits) {
            return MutableQHashSeparateKVIntDoubleMapGO.this.containsValue(bits);
        }

        public void forEach(Consumer<? super Double> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVIntDoubleMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntDoubleMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntDoubleMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            if (MutableQHashSeparateKVIntDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    action.accept((Double)Double.longBitsToDouble(vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    action.accept((Double)Double.longBitsToDouble(vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(DoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVIntDoubleMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntDoubleMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntDoubleMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            if (MutableQHashSeparateKVIntDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    action.accept(Double.longBitsToDouble(vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    action.accept(Double.longBitsToDouble(vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(DoublePredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashSeparateKVIntDoubleMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntDoubleMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntDoubleMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            if (MutableQHashSeparateKVIntDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || predicate.test(Double.longBitsToDouble(vals[i]))) continue;
                    terminated = true;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed || predicate.test(Double.longBitsToDouble(vals[i]))) continue;
                    terminated = true;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        public boolean allContainingIn(DoubleCollection c) {
            if (c instanceof InternalDoubleCollectionOps) {
                return this.allContainingIn((InternalDoubleCollectionOps)c);
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableQHashSeparateKVIntDoubleMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntDoubleMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntDoubleMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            if (MutableQHashSeparateKVIntDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || c.contains(Double.longBitsToDouble(vals[i]))) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed || c.contains(Double.longBitsToDouble(vals[i]))) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        private boolean allContainingIn(InternalDoubleCollectionOps c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableQHashSeparateKVIntDoubleMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntDoubleMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntDoubleMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            if (MutableQHashSeparateKVIntDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || c.contains(vals[i])) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed || c.contains(vals[i])) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(DoubleCollection c) {
            if (c instanceof InternalDoubleCollectionOps) {
                return this.reverseAddAllTo((InternalDoubleCollectionOps)c);
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVIntDoubleMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntDoubleMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntDoubleMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            if (MutableQHashSeparateKVIntDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    changed |= c.add(Double.longBitsToDouble(vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    changed |= c.add(Double.longBitsToDouble(vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean reverseAddAllTo(InternalDoubleCollectionOps c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVIntDoubleMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntDoubleMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntDoubleMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            if (MutableQHashSeparateKVIntDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    changed |= c.add(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    changed |= c.add(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(DoubleSet s) {
            if (s instanceof InternalDoubleCollectionOps) {
                return this.reverseRemoveAllFrom((InternalDoubleCollectionOps)s);
            }
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVIntDoubleMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntDoubleMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntDoubleMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            if (MutableQHashSeparateKVIntDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    changed |= s.removeDouble(Double.longBitsToDouble(vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    changed |= s.removeDouble(Double.longBitsToDouble(vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean reverseRemoveAllFrom(InternalDoubleCollectionOps s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVIntDoubleMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntDoubleMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntDoubleMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            if (MutableQHashSeparateKVIntDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    changed |= s.removeDouble(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    changed |= s.removeDouble(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public DoubleIterator iterator() {
            int mc = MutableQHashSeparateKVIntDoubleMapGO.this.modCount();
            if (!MutableQHashSeparateKVIntDoubleMapGO.this.noRemoved()) {
                return new SomeRemovedValueIterator(mc);
            }
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public DoubleCursor cursor() {
            int mc = MutableQHashSeparateKVIntDoubleMapGO.this.modCount();
            if (!MutableQHashSeparateKVIntDoubleMapGO.this.noRemoved()) {
                return new SomeRemovedValueCursor(mc);
            }
            return new NoRemovedValueCursor(mc);
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVIntDoubleMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntDoubleMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntDoubleMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            if (MutableQHashSeparateKVIntDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    result[resultIndex++] = Double.longBitsToDouble(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = Double.longBitsToDouble(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVIntDoubleMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntDoubleMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntDoubleMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            if (MutableQHashSeparateKVIntDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    a[resultIndex++] = Double.longBitsToDouble(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = Double.longBitsToDouble(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public double[] toDoubleArray() {
            int size = this.size();
            double[] result = new double[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVIntDoubleMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntDoubleMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntDoubleMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            if (MutableQHashSeparateKVIntDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    result[resultIndex++] = Double.longBitsToDouble(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = Double.longBitsToDouble(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public double[] toArray(double[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new double[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0.0;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVIntDoubleMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntDoubleMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntDoubleMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            if (MutableQHashSeparateKVIntDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    a[resultIndex++] = Double.longBitsToDouble(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = Double.longBitsToDouble(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0.0;
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashSeparateKVIntDoubleMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntDoubleMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntDoubleMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            if (MutableQHashSeparateKVIntDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    sb.append(' ').append(Double.longBitsToDouble(vals[i])).append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    sb.append(' ').append(Double.longBitsToDouble(vals[i])).append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            }
            if (mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return this.removeDouble((Double)o);
        }

        public boolean removeDouble(double v) {
            return MutableQHashSeparateKVIntDoubleMapGO.this.removeValue(v);
        }

        public boolean removeDouble(long bits) {
            return MutableQHashSeparateKVIntDoubleMapGO.this.removeValue(bits);
        }

        public void clear() {
            MutableQHashSeparateKVIntDoubleMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super Double> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVIntDoubleMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntDoubleMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntDoubleMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            if (MutableQHashSeparateKVIntDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || !filter.test((Double)Double.longBitsToDouble(vals[i]))) continue;
                    MutableQHashSeparateKVIntDoubleMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVIntDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed || !filter.test((Double)Double.longBitsToDouble(vals[i]))) continue;
                    MutableQHashSeparateKVIntDoubleMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVIntDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeIf(DoublePredicate filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVIntDoubleMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntDoubleMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntDoubleMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            if (MutableQHashSeparateKVIntDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || !filter.test(Double.longBitsToDouble(vals[i]))) continue;
                    MutableQHashSeparateKVIntDoubleMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVIntDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed || !filter.test(Double.longBitsToDouble(vals[i]))) continue;
                    MutableQHashSeparateKVIntDoubleMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVIntDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof DoubleCollection) {
                return this.removeAll((DoubleCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVIntDoubleMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntDoubleMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntDoubleMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            if (MutableQHashSeparateKVIntDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || !c.contains(Double.longBitsToDouble(vals[i]))) continue;
                    MutableQHashSeparateKVIntDoubleMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVIntDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed || !c.contains(Double.longBitsToDouble(vals[i]))) continue;
                    MutableQHashSeparateKVIntDoubleMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVIntDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(DoubleCollection c) {
            if (c instanceof InternalDoubleCollectionOps) {
                return this.removeAll((InternalDoubleCollectionOps)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVIntDoubleMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntDoubleMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntDoubleMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            if (MutableQHashSeparateKVIntDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || !c.contains(Double.longBitsToDouble(vals[i]))) continue;
                    MutableQHashSeparateKVIntDoubleMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVIntDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed || !c.contains(Double.longBitsToDouble(vals[i]))) continue;
                    MutableQHashSeparateKVIntDoubleMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVIntDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(InternalDoubleCollectionOps c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVIntDoubleMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntDoubleMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntDoubleMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            if (MutableQHashSeparateKVIntDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || !c.contains(vals[i])) continue;
                    MutableQHashSeparateKVIntDoubleMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVIntDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed || !c.contains(vals[i])) continue;
                    MutableQHashSeparateKVIntDoubleMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVIntDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            if (c instanceof DoubleCollection) {
                return this.retainAll((DoubleCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVIntDoubleMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntDoubleMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntDoubleMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            if (MutableQHashSeparateKVIntDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || c.contains(Double.longBitsToDouble(vals[i]))) continue;
                    MutableQHashSeparateKVIntDoubleMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVIntDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed || c.contains(Double.longBitsToDouble(vals[i]))) continue;
                    MutableQHashSeparateKVIntDoubleMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVIntDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(DoubleCollection c) {
            if (c instanceof InternalDoubleCollectionOps) {
                return this.retainAll((InternalDoubleCollectionOps)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVIntDoubleMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntDoubleMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntDoubleMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            if (MutableQHashSeparateKVIntDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || c.contains(Double.longBitsToDouble(vals[i]))) continue;
                    MutableQHashSeparateKVIntDoubleMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVIntDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed || c.contains(Double.longBitsToDouble(vals[i]))) continue;
                    MutableQHashSeparateKVIntDoubleMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVIntDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(InternalDoubleCollectionOps c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVIntDoubleMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntDoubleMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntDoubleMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            if (MutableQHashSeparateKVIntDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || c.contains(vals[i])) continue;
                    MutableQHashSeparateKVIntDoubleMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVIntDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed || c.contains(vals[i])) continue;
                    MutableQHashSeparateKVIntDoubleMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVIntDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }
    }

    class ReusableEntry
    extends IntDoubleEntry {
        private int key;
        private long value;

        ReusableEntry() {
        }

        ReusableEntry with(int key, long value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }
    }

    class MutableEntry
    extends IntDoubleEntry {
        final int modCount;
        private final int index;
        final int key;
        private long value;

        MutableEntry(int modCount, int index, int key, long value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }

        public Double setValue(Double newValue) {
            long unwrappedNewValue;
            if (this.modCount != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            double oldValue = Double.longBitsToDouble(this.value);
            this.value = unwrappedNewValue = Double.doubleToLongBits(newValue);
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(long newValue) {
            MutableQHashSeparateKVIntDoubleMapGO.this.values[this.index] = newValue;
        }
    }

    abstract class IntDoubleEntry
    extends AbstractEntry<Integer, Double> {
        IntDoubleEntry() {
        }

        abstract int key();

        public final Integer getKey() {
            return this.key();
        }

        abstract long value();

        public final Double getValue() {
            return Double.longBitsToDouble(this.value());
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                int k2 = (Integer)e2.getKey();
                long v2 = Double.doubleToLongBits((Double)e2.getValue());
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return Primitives.hashCode((int)this.key()) ^ Primitives.hashCode((long)this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Integer, Double>>
    implements HashObjSet<Map.Entry<Integer, Double>>,
    InternalObjCollectionOps<Map.Entry<Integer, Double>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Integer, Double>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return MutableQHashSeparateKVIntDoubleMapGO.this.hashConfig();
        }

        public int size() {
            return MutableQHashSeparateKVIntDoubleMapGO.this.size;
        }

        public double currentLoad() {
            return MutableQHashSeparateKVIntDoubleMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return MutableQHashSeparateKVIntDoubleMapGO.this.containsEntry((int)((Integer)e.getKey()), (Double)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVIntDoubleMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntDoubleMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntDoubleMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            if (MutableQHashSeparateKVIntDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free) continue;
                    result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVIntDoubleMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntDoubleMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntDoubleMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            if (MutableQHashSeparateKVIntDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free) continue;
                    a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<Integer, Double>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVIntDoubleMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntDoubleMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntDoubleMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            if (MutableQHashSeparateKVIntDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free) continue;
                    action.accept((Map.Entry<Integer, Double>)((Object)new MutableEntry(mc, i, key, vals[i])));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    action.accept((Map.Entry<Integer, Double>)((Object)new MutableEntry(mc, i, key, vals[i])));
                }
            }
            if (mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Integer, Double>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashSeparateKVIntDoubleMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntDoubleMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntDoubleMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            if (MutableQHashSeparateKVIntDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || predicate.test((Map.Entry<Integer, Double>)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                    terminated = true;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed || predicate.test((Map.Entry<Integer, Double>)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                    terminated = true;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<Integer, Double>> iterator() {
            int mc = MutableQHashSeparateKVIntDoubleMapGO.this.modCount();
            if (!MutableQHashSeparateKVIntDoubleMapGO.this.noRemoved()) {
                return new SomeRemovedEntryIterator(mc);
            }
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Integer, Double>> cursor() {
            int mc = MutableQHashSeparateKVIntDoubleMapGO.this.modCount();
            if (!MutableQHashSeparateKVIntDoubleMapGO.this.noRemoved()) {
                return new SomeRemovedEntryCursor(mc);
            }
            return new NoRemovedEntryCursor(mc);
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVIntDoubleMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntDoubleMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntDoubleMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            if (MutableQHashSeparateKVIntDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed || c.contains((Object)e.with(key, vals[i]))) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVIntDoubleMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntDoubleMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntDoubleMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            if (MutableQHashSeparateKVIntDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free) continue;
                    changed |= s.remove((Object)e.with(key, vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    changed |= s.remove((Object)e.with(key, vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Integer, Double>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVIntDoubleMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntDoubleMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntDoubleMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            if (MutableQHashSeparateKVIntDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free) continue;
                    changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public int hashCode() {
            return MutableQHashSeparateKVIntDoubleMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashSeparateKVIntDoubleMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntDoubleMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntDoubleMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            if (MutableQHashSeparateKVIntDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free) continue;
                    sb.append(' ');
                    sb.append(key);
                    sb.append('=');
                    sb.append(Double.longBitsToDouble(vals[i]));
                    sb.append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    sb.append(' ');
                    sb.append(key);
                    sb.append('=');
                    sb.append(Double.longBitsToDouble(vals[i]));
                    sb.append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            }
            if (mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return MutableQHashSeparateKVIntDoubleMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                int key = (Integer)e.getKey();
                double value = (Double)e.getValue();
                return MutableQHashSeparateKVIntDoubleMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Integer, Double>> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVIntDoubleMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntDoubleMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntDoubleMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            if (MutableQHashSeparateKVIntDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || !filter.test((Map.Entry<Integer, Double>)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                    MutableQHashSeparateKVIntDoubleMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVIntDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed || !filter.test((Map.Entry<Integer, Double>)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                    MutableQHashSeparateKVIntDoubleMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVIntDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVIntDoubleMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntDoubleMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntDoubleMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            if (MutableQHashSeparateKVIntDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || !c.contains((Object)e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVIntDoubleMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVIntDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed || !c.contains((Object)e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVIntDoubleMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVIntDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVIntDoubleMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntDoubleMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntDoubleMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVIntDoubleMapGO.this.values;
            if (MutableQHashSeparateKVIntDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVIntDoubleMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVIntDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed || c.contains((Object)e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVIntDoubleMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVIntDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVIntDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public void clear() {
            MutableQHashSeparateKVIntDoubleMapGO.this.doClear();
        }
    }
}

