/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.ByteCollection;
import com.koloboke.collect.ByteCursor;
import com.koloboke.collect.ByteIterator;
import com.koloboke.collect.Equivalence;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractByteValueView;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.CommonByteByteMapOps;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.InternalByteByteMapOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.UnsafeConstants;
import com.koloboke.collect.impl.hash.LHash;
import com.koloboke.collect.impl.hash.ParallelKVByteByteLHash;
import com.koloboke.collect.impl.hash.UpdatableLHashParallelKVByteByteMapSO;
import com.koloboke.collect.map.ByteByteCursor;
import com.koloboke.collect.set.ByteSet;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.ByteBinaryOperator;
import com.koloboke.function.ByteByteConsumer;
import com.koloboke.function.ByteBytePredicate;
import com.koloboke.function.ByteByteToByteFunction;
import com.koloboke.function.ByteConsumer;
import com.koloboke.function.BytePredicate;
import com.koloboke.function.ByteUnaryOperator;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class UpdatableLHashParallelKVByteByteMapGO
extends UpdatableLHashParallelKVByteByteMapSO {
    final void copy(ParallelKVByteByteLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    final void move(ParallelKVByteByteLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public byte defaultValue() {
        return 0;
    }

    public boolean containsEntry(byte key, byte value) {
        byte free = this.freeValue;
        if (key != free) {
            char[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVByteKeyMixing.mix((byte)key) & capacityMask;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur == key) {
                return (byte)(entry >>> 8) == value;
            }
            if (cur == free) {
                return false;
            }
            do {
                if ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return (byte)(entry >>> 8) == value;
            } while (cur != free);
            return false;
        }
        return false;
    }

    public Byte get(Object key) {
        byte free;
        byte k = (Byte)key;
        if (k != (free = this.freeValue)) {
            char[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVByteKeyMixing.mix((byte)k) & capacityMask;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur == k) {
                return (byte)(entry >>> 8);
            }
            if (cur == free) {
                return null;
            }
            do {
                if ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
                return (byte)(entry >>> 8);
            } while (cur != free);
            return null;
        }
        return null;
    }

    public byte get(byte key) {
        byte free = this.freeValue;
        if (key != free) {
            char[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVByteKeyMixing.mix((byte)key) & capacityMask;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur == key) {
                return (byte)(entry >>> 8);
            }
            if (cur == free) {
                return this.defaultValue();
            }
            do {
                if ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return (byte)(entry >>> 8);
            } while (cur != free);
            return this.defaultValue();
        }
        return this.defaultValue();
    }

    public Byte getOrDefault(Object key, Byte defaultValue) {
        byte free;
        byte k = (Byte)key;
        if (k != (free = this.freeValue)) {
            char[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVByteKeyMixing.mix((byte)k) & capacityMask;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur == k) {
                return (byte)(entry >>> 8);
            }
            if (cur == free) {
                return defaultValue;
            }
            do {
                if ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
                return (byte)(entry >>> 8);
            } while (cur != free);
            return defaultValue;
        }
        return defaultValue;
    }

    public byte getOrDefault(byte key, byte defaultValue) {
        byte free = this.freeValue;
        if (key != free) {
            char[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVByteKeyMixing.mix((byte)key) & capacityMask;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur == key) {
                return (byte)(entry >>> 8);
            }
            if (cur == free) {
                return defaultValue;
            }
            do {
                if ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return (byte)(entry >>> 8);
            } while (cur != free);
            return defaultValue;
        }
        return defaultValue;
    }

    public void forEach(BiConsumer<? super Byte, ? super Byte> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        byte free = this.freeValue;
        char[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            char entry = tab[i];
            byte key = (byte)entry;
            if (key == free) continue;
            action.accept((Byte)key, (Byte)((byte)(entry >>> 8)));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(ByteByteConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        byte free = this.freeValue;
        char[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            char entry = tab[i];
            byte key = (byte)entry;
            if (key == free) continue;
            action.accept(key, (byte)(entry >>> 8));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(ByteBytePredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        char[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            char entry = tab[i];
            byte key = (byte)entry;
            if (key == free || predicate.test(key, (byte)(entry >>> 8))) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public ByteByteCursor cursor() {
        int mc = this.modCount();
        return new NoRemovedMapCursor(mc);
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonByteByteMapOps.containsAllEntries((InternalByteByteMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalByteByteMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        byte free = this.freeValue;
        char[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            char entry = tab[i];
            byte key = (byte)entry;
            if (key == free || m.containsEntry(key, (byte)(entry >>> 8))) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalByteByteMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        byte free = this.freeValue;
        char[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            char entry = tab[i];
            byte key = (byte)entry;
            if (key == free) continue;
            m.justPut(key, (byte)(entry >>> 8));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<Byte, Byte>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public ByteCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        byte free = this.freeValue;
        char[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            char entry = tab[i];
            byte key = (byte)entry;
            if (key == free) continue;
            hashCode += key ^ (byte)(entry >>> 8);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        byte free = this.freeValue;
        char[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            char entry = tab[i];
            byte key = (byte)entry;
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append((byte)(entry >>> 8));
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        byte free = this.freeValue;
        char[] tab = this.table;
        this.initForRehash(newCapacity);
        ++mc;
        char[] newTab = this.table;
        int capacityMask = newTab.length - 1;
        for (int i = tab.length - 1; i >= 0; --i) {
            char entry = tab[i];
            byte key = (byte)entry;
            if (key == free) continue;
            int index = LHash.ParallelKVByteKeyMixing.mix((byte)key) & capacityMask;
            if (U.getByte(newTab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)index << 1)) != free) {
                while (U.getByte(newTab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)(index = index - 1 & capacityMask) << 1)) != free) {
                }
            }
            newTab[index] = entry;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public Byte put(Byte key, Byte value) {
        byte free;
        byte k = key;
        if (k == (free = this.freeValue)) {
            free = this.changeFree();
        }
        char[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVByteKeyMixing.mix((byte)k) & capacityMask;
        char entry = tab[index];
        byte cur = (byte)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = (char)(k & 0xFF | value << 8);
            this.postInsertHook();
            return null;
        }
        if (cur != k) {
            do {
                if ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != free) continue;
                this.incrementModCount();
                tab[index] = (char)(k & 0xFF | value << 8);
                this.postInsertHook();
                return null;
            } while (cur != k);
        }
        byte prevValue = (byte)(entry >>> 8);
        U.putByte(tab, CHAR_BASE + BYTE_VALUE_OFFSET + ((long)index << 1), value);
        return prevValue;
    }

    public byte put(byte key, byte value) {
        byte free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        char[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVByteKeyMixing.mix((byte)key) & capacityMask;
        char entry = tab[index];
        byte cur = (byte)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = (char)(key & 0xFF | value << 8);
            this.postInsertHook();
            return this.defaultValue();
        }
        if (cur != key) {
            do {
                if ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != free) continue;
                this.incrementModCount();
                tab[index] = (char)(key & 0xFF | value << 8);
                this.postInsertHook();
                return this.defaultValue();
            } while (cur != key);
        }
        byte prevValue = (byte)(entry >>> 8);
        U.putByte(tab, CHAR_BASE + BYTE_VALUE_OFFSET + ((long)index << 1), value);
        return prevValue;
    }

    public Byte putIfAbsent(Byte key, Byte value) {
        byte free;
        byte k = key;
        if (k == (free = this.freeValue)) {
            free = this.changeFree();
        }
        char[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVByteKeyMixing.mix((byte)k) & capacityMask;
        char entry = tab[index];
        byte cur = (byte)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = (char)(k & 0xFF | value << 8);
            this.postInsertHook();
            return null;
        }
        if (cur == k) {
            return (byte)(entry >>> 8);
        }
        do {
            if ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != free) continue;
            this.incrementModCount();
            tab[index] = (char)(k & 0xFF | value << 8);
            this.postInsertHook();
            return null;
        } while (cur != k);
        return (byte)(entry >>> 8);
    }

    public byte putIfAbsent(byte key, byte value) {
        byte free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        char[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVByteKeyMixing.mix((byte)key) & capacityMask;
        char entry = tab[index];
        byte cur = (byte)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = (char)(key & 0xFF | value << 8);
            this.postInsertHook();
            return this.defaultValue();
        }
        if (cur == key) {
            return (byte)(entry >>> 8);
        }
        do {
            if ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != free) continue;
            this.incrementModCount();
            tab[index] = (char)(key & 0xFF | value << 8);
            this.postInsertHook();
            return this.defaultValue();
        } while (cur != key);
        return (byte)(entry >>> 8);
    }

    public void justPut(byte key, byte value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        U.putByte(this.table, CHAR_BASE + BYTE_VALUE_OFFSET + ((long)index << 1), value);
    }

    /*
     * Unable to fully structure code
     */
    public Byte compute(Byte key, BiFunction<? super Byte, ? super Byte, ? extends Byte> remappingFunction) {
        block5: {
            k = key;
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVByteKeyMixing.mix((byte)k) & capacityMask;
            entry = tab[index];
            cur = (byte)entry;
            if (cur == k) break block5;
            if (cur == free) ** GOTO lbl16
            while ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != k) {
                if (cur != free) continue;
lbl16:
                // 2 sources

                if ((newValue = remappingFunction.apply((Byte)k, null)) != null) {
                    this.incrementModCount();
                    tab[index] = (char)(k & 255 | newValue << 8);
                    this.postInsertHook();
                    return newValue;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply((Byte)k, (Byte)((byte)(entry >>> 8)))) != null) {
            UpdatableLHashParallelKVByteByteMapGO.U.putByte(tab, UpdatableLHashParallelKVByteByteMapGO.CHAR_BASE + UpdatableLHashParallelKVByteByteMapGO.BYTE_VALUE_OFFSET + ((long)index << 1), newValue);
            return newValue;
        }
        throw new UnsupportedOperationException("Compute operation of updatable map doesn't support removals");
    }

    /*
     * Unable to fully structure code
     */
    public byte compute(byte key, ByteByteToByteFunction remappingFunction) {
        block3: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVByteKeyMixing.mix((byte)key) & capacityMask;
            entry = tab[index];
            cur = (byte)entry;
            if (cur == key) break block3;
            if (cur == free) ** GOTO lbl15
            while ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != key) {
                if (cur != free) continue;
lbl15:
                // 2 sources

                newValue = remappingFunction.applyAsByte(key, this.defaultValue());
                this.incrementModCount();
                tab[index] = (char)(key & 255 | newValue << 8);
                this.postInsertHook();
                return newValue;
            }
        }
        newValue = remappingFunction.applyAsByte(key, (byte)(entry >>> 8));
        UpdatableLHashParallelKVByteByteMapGO.U.putByte(tab, UpdatableLHashParallelKVByteByteMapGO.CHAR_BASE + UpdatableLHashParallelKVByteByteMapGO.BYTE_VALUE_OFFSET + ((long)index << 1), newValue);
        return newValue;
    }

    public Byte computeIfAbsent(Byte key, Function<? super Byte, ? extends Byte> mappingFunction) {
        Byte value;
        byte k = key;
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        byte free = this.freeValue;
        if (k == free) {
            free = this.changeFree();
        }
        char[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVByteKeyMixing.mix((byte)k) & capacityMask;
        char entry = tab[index];
        byte cur = (byte)entry;
        if (cur == k) {
            return (byte)(entry >>> 8);
        }
        if (cur != free) {
            do {
                if ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
                return (byte)(entry >>> 8);
            } while (cur != free);
        }
        if ((value = mappingFunction.apply((Byte)k)) != null) {
            this.incrementModCount();
            tab[index] = (char)(k & 0xFF | value << 8);
            this.postInsertHook();
            return value;
        }
        return null;
    }

    public byte computeIfAbsent(byte key, ByteUnaryOperator mappingFunction) {
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        byte free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        char[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVByteKeyMixing.mix((byte)key) & capacityMask;
        char entry = tab[index];
        byte cur = (byte)entry;
        if (cur == key) {
            return (byte)(entry >>> 8);
        }
        if (cur != free) {
            do {
                if ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return (byte)(entry >>> 8);
            } while (cur != free);
        }
        byte value = mappingFunction.applyAsByte(key);
        this.incrementModCount();
        tab[index] = (char)(key & 0xFF | value << 8);
        this.postInsertHook();
        return value;
    }

    public Byte computeIfPresent(Byte key, BiFunction<? super Byte, ? super Byte, ? extends Byte> remappingFunction) {
        byte k = key;
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        byte free = this.freeValue;
        if (k != free) {
            Byte newValue;
            char[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVByteKeyMixing.mix((byte)k) & capacityMask;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                while ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != k) {
                    if (cur != free) continue;
                    return null;
                }
            }
            if ((newValue = remappingFunction.apply((Byte)k, (Byte)((byte)(entry >>> 8)))) != null) {
                U.putByte(tab, CHAR_BASE + BYTE_VALUE_OFFSET + ((long)index << 1), newValue);
                return newValue;
            }
            throw new UnsupportedOperationException("ComputeIfPresent operation of updatable map doesn't support removals");
        }
        return null;
    }

    public byte computeIfPresent(byte key, ByteByteToByteFunction remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        byte free = this.freeValue;
        if (key != free) {
            char[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVByteKeyMixing.mix((byte)key) & capacityMask;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                while ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != key) {
                    if (cur != free) continue;
                    return this.defaultValue();
                }
            }
            byte newValue = remappingFunction.applyAsByte(key, (byte)(entry >>> 8));
            U.putByte(tab, CHAR_BASE + BYTE_VALUE_OFFSET + ((long)index << 1), newValue);
            return newValue;
        }
        return this.defaultValue();
    }

    /*
     * Unable to fully structure code
     */
    public Byte merge(Byte key, Byte value, BiFunction<? super Byte, ? super Byte, ? extends Byte> remappingFunction) {
        block5: {
            k = key;
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVByteKeyMixing.mix((byte)k) & capacityMask;
            entry = tab[index];
            cur = (byte)entry;
            if (cur == k) break block5;
            if (cur == free) ** GOTO lbl18
            while ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != k) {
                if (cur != free) continue;
lbl18:
                // 2 sources

                this.incrementModCount();
                tab[index] = (char)(k & 255 | value << 8);
                this.postInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply((Byte)((byte)(entry >>> 8)), value)) != null) {
            UpdatableLHashParallelKVByteByteMapGO.U.putByte(tab, UpdatableLHashParallelKVByteByteMapGO.CHAR_BASE + UpdatableLHashParallelKVByteByteMapGO.BYTE_VALUE_OFFSET + ((long)index << 1), newValue);
            return newValue;
        }
        throw new UnsupportedOperationException("Merge operation of updatable map doesn't support removals");
    }

    /*
     * Unable to fully structure code
     */
    public byte merge(byte key, byte value, ByteBinaryOperator remappingFunction) {
        block3: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVByteKeyMixing.mix((byte)key) & capacityMask;
            entry = tab[index];
            cur = (byte)entry;
            if (cur == key) break block3;
            if (cur == free) ** GOTO lbl15
            while ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != key) {
                if (cur != free) continue;
lbl15:
                // 2 sources

                this.incrementModCount();
                tab[index] = (char)(key & 255 | value << 8);
                this.postInsertHook();
                return value;
            }
        }
        newValue = remappingFunction.applyAsByte((byte)(entry >>> 8), value);
        UpdatableLHashParallelKVByteByteMapGO.U.putByte(tab, UpdatableLHashParallelKVByteByteMapGO.CHAR_BASE + UpdatableLHashParallelKVByteByteMapGO.BYTE_VALUE_OFFSET + ((long)index << 1), newValue);
        return newValue;
    }

    /*
     * Unable to fully structure code
     */
    public byte addValue(byte key, byte value) {
        block2: {
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVByteKeyMixing.mix((byte)key) & capacityMask;
            entry = tab[index];
            cur = (byte)entry;
            if (cur == key) break block2;
            if (cur == free) ** GOTO lbl13
            while ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != key) {
                if (cur != free) continue;
lbl13:
                // 2 sources

                newValue = (byte)(this.defaultValue() + value);
                this.incrementModCount();
                tab[index] = (char)(key & 255 | newValue << 8);
                this.postInsertHook();
                return newValue;
            }
        }
        newValue = (byte)((byte)(entry >>> 8) + value);
        UpdatableLHashParallelKVByteByteMapGO.U.putByte(tab, UpdatableLHashParallelKVByteByteMapGO.CHAR_BASE + UpdatableLHashParallelKVByteByteMapGO.BYTE_VALUE_OFFSET + ((long)index << 1), newValue);
        return newValue;
    }

    /*
     * Unable to fully structure code
     */
    public byte addValue(byte key, byte addition, byte initialValue) {
        block2: {
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVByteKeyMixing.mix((byte)key) & capacityMask;
            entry = tab[index];
            cur = (byte)entry;
            if (cur == key) break block2;
            if (cur == free) ** GOTO lbl13
            while ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != key) {
                if (cur != free) continue;
lbl13:
                // 2 sources

                newValue = (byte)(initialValue + addition);
                this.incrementModCount();
                tab[index] = (char)(key & 255 | newValue << 8);
                this.postInsertHook();
                return newValue;
            }
        }
        newValue = (byte)((byte)(entry >>> 8) + addition);
        UpdatableLHashParallelKVByteByteMapGO.U.putByte(tab, UpdatableLHashParallelKVByteByteMapGO.CHAR_BASE + UpdatableLHashParallelKVByteByteMapGO.BYTE_VALUE_OFFSET + ((long)index << 1), newValue);
        return newValue;
    }

    public void putAll(@Nonnull Map<? extends Byte, ? extends Byte> m) {
        CommonByteByteMapOps.putAll((InternalByteByteMapOps)this, m);
    }

    public Byte replace(Byte key, Byte value) {
        byte free;
        byte k = key;
        if (k != (free = this.freeValue)) {
            char[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVByteKeyMixing.mix((byte)k) & capacityMask;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                while ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != k) {
                    if (cur != free) continue;
                    return null;
                }
            }
            byte oldValue = (byte)(entry >>> 8);
            U.putByte(tab, CHAR_BASE + BYTE_VALUE_OFFSET + ((long)index << 1), value);
            return oldValue;
        }
        return null;
    }

    public byte replace(byte key, byte value) {
        byte free = this.freeValue;
        if (key != free) {
            char[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVByteKeyMixing.mix((byte)key) & capacityMask;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                while ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != key) {
                    if (cur != free) continue;
                    return this.defaultValue();
                }
            }
            byte oldValue = (byte)(entry >>> 8);
            U.putByte(tab, CHAR_BASE + BYTE_VALUE_OFFSET + ((long)index << 1), value);
            return oldValue;
        }
        return this.defaultValue();
    }

    public boolean replace(Byte key, Byte oldValue, Byte newValue) {
        return this.replace((byte)key, (byte)oldValue, (byte)newValue);
    }

    public boolean replace(byte key, byte oldValue, byte newValue) {
        byte free = this.freeValue;
        if (key != free) {
            char[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVByteKeyMixing.mix((byte)key) & capacityMask;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                while ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != key) {
                    if (cur != free) continue;
                    return false;
                }
            }
            if ((byte)(entry >>> 8) == oldValue) {
                U.putByte(tab, CHAR_BASE + BYTE_VALUE_OFFSET + ((long)index << 1), newValue);
                return true;
            }
            return false;
        }
        return false;
    }

    public void replaceAll(BiFunction<? super Byte, ? super Byte, ? extends Byte> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        byte free = this.freeValue;
        char[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            char entry = tab[i];
            byte key = (byte)entry;
            if (key == free) continue;
            U.putByte(tab, CHAR_BASE + BYTE_VALUE_OFFSET + ((long)i << 1), function.apply((Byte)key, (Byte)((byte)(entry >>> 8))));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(ByteByteToByteFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        byte free = this.freeValue;
        char[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            char entry = tab[i];
            byte key = (byte)entry;
            if (key == free) continue;
            U.putByte(tab, CHAR_BASE + BYTE_VALUE_OFFSET + ((long)i << 1), function.applyAsByte(key, (byte)(entry >>> 8)));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        this.doClear();
    }

    private void doClear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public Byte remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(byte key) {
        throw new UnsupportedOperationException();
    }

    public byte remove(byte key) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object key, Object value) {
        return this.remove((Byte)key, (Byte)value);
    }

    public boolean remove(byte key, byte value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(ByteBytePredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements ByteByteCursor {
        final char[] tab;
        final byte free;
        int expectedModCount;
        int index;
        byte curKey;
        byte curValue;

        NoRemovedMapCursor(int mc) {
            byte free;
            this.expectedModCount = mc;
            this.tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue);
        }

        public void forEachForward(ByteByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] tab = this.tab;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                action.accept(key, (byte)(entry >>> 8));
            }
            if (index != this.index || mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public byte key() {
            byte curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public byte value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(byte value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            UnsafeConstants.U.putByte(this.tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_VALUE_OFFSET + ((long)this.index << 1), value);
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                char[] tab = this.tab;
                byte free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (byte)(entry >>> 8);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements ByteCursor {
        final char[] tab;
        final byte free;
        int expectedModCount;
        int index;
        byte curKey;
        byte curValue;

        NoRemovedValueCursor(int mc) {
            byte free;
            this.expectedModCount = mc;
            this.tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue);
        }

        public void forEachForward(ByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] tab = this.tab;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                action.accept((byte)(entry >>> 8));
            }
            if (index != this.index || mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public byte elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                char[] tab = this.tab;
                byte free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (byte)(entry >>> 8);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements ByteIterator {
        final char[] tab;
        final byte free;
        int expectedModCount;
        int nextIndex;
        byte next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            char[] tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            byte free = this.free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                char entry = tab[nextI];
                if ((byte)entry == free) continue;
                this.next = (byte)(entry >>> 8);
                break;
            }
            this.nextIndex = nextI;
        }

        public byte nextByte() {
            if (this.expectedModCount == UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    char[] tab = this.tab;
                    byte free = this.free;
                    byte prev = this.next;
                    while (--nextI >= 0) {
                        char entry = tab[nextI];
                        if ((byte)entry == free) continue;
                        this.next = (byte)(entry >>> 8);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void forEachRemaining(Consumer<? super Byte> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] tab = this.tab;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                action.accept((Byte)((byte)(entry >>> 8)));
            }
            if (nextI != this.nextIndex || mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(ByteConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] tab = this.tab;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                action.accept((byte)(entry >>> 8));
            }
            if (nextI != this.nextIndex || mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Byte next() {
            return this.nextByte();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Byte, Byte>> {
        final char[] tab;
        final byte free;
        int expectedModCount;
        int index;
        byte curKey;
        byte curValue;

        NoRemovedEntryCursor(int mc) {
            byte free;
            this.expectedModCount = mc;
            this.tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Byte, Byte>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] tab = this.tab;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                action.accept((Map.Entry<Byte, Byte>)((Object)new MutableEntry(mc, i, key, (byte)(entry >>> 8))));
            }
            if (index != this.index || mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Byte, Byte> elem() {
            byte curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                char[] tab = this.tab;
                byte free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (byte)(entry >>> 8);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Byte, Byte>> {
        final char[] tab;
        final byte free;
        int expectedModCount;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            char[] tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            byte free = this.free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                char entry = tab[nextI];
                byte key = (byte)entry;
                if (key == free) continue;
                this.next = new MutableEntry(mc, nextI, key, (byte)(entry >>> 8));
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Byte, Byte>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] tab = this.tab;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                action.accept((Map.Entry<Byte, Byte>)((Object)new MutableEntry(mc, i, key, (byte)(entry >>> 8))));
            }
            if (nextI != this.nextIndex || mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Byte, Byte> next() {
            int mc = this.expectedModCount;
            if (mc == UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    char[] tab = this.tab;
                    byte free = this.free;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        char entry = tab[nextI];
                        byte key = (byte)entry;
                        if (key == free) continue;
                        this.next = new MutableEntry(mc, nextI, key, (byte)(entry >>> 8));
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractByteValueView {
        ValueView() {
        }

        public int size() {
            return UpdatableLHashParallelKVByteByteMapGO.this.size();
        }

        public boolean shrink() {
            return UpdatableLHashParallelKVByteByteMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return UpdatableLHashParallelKVByteByteMapGO.this.containsValue(o);
        }

        public boolean contains(byte v) {
            return UpdatableLHashParallelKVByteByteMapGO.this.containsValue(v);
        }

        public void forEach(Consumer<? super Byte> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            byte free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                action.accept((Byte)((byte)(entry >>> 8)));
            }
            if (mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(ByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            byte free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                action.accept((byte)(entry >>> 8));
            }
            if (mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(BytePredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            byte free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free || predicate.test((byte)(entry >>> 8))) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        public boolean allContainingIn(ByteCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            byte free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free || c.contains((byte)(entry >>> 8))) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(ByteCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            byte free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                changed |= c.add((byte)(entry >>> 8));
            }
            if (mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(ByteSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            byte free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                changed |= s.removeByte((byte)(entry >>> 8));
            }
            if (mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public ByteIterator iterator() {
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public ByteCursor cursor() {
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            byte free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                result[resultIndex++] = (byte)(entry >>> 8);
            }
            if (mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            byte free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                a[resultIndex++] = (byte)(entry >>> 8);
            }
            if (mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public byte[] toByteArray() {
            int size = this.size();
            byte[] result = new byte[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            byte free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                result[resultIndex++] = (byte)(entry >>> 8);
            }
            if (mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public byte[] toArray(byte[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new byte[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            byte free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                a[resultIndex++] = (byte)(entry >>> 8);
            }
            if (mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0;
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            byte free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                sb.append(' ').append((byte)(entry >>> 8)).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return this.removeByte((Byte)o);
        }

        public boolean removeByte(byte v) {
            return UpdatableLHashParallelKVByteByteMapGO.this.removeValue(v);
        }

        public void clear() {
            UpdatableLHashParallelKVByteByteMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super Byte> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(BytePredicate filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends ByteByteEntry {
        private byte key;
        private byte value;

        ReusableEntry() {
        }

        ReusableEntry with(byte key, byte value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public byte key() {
            return this.key;
        }

        @Override
        public byte value() {
            return this.value;
        }
    }

    class MutableEntry
    extends ByteByteEntry {
        final int modCount;
        private final int index;
        final byte key;
        private byte value;

        MutableEntry(int modCount, int index, byte key, byte value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public byte key() {
            return this.key;
        }

        @Override
        public byte value() {
            return this.value;
        }

        public Byte setValue(Byte newValue) {
            byte unwrappedNewValue;
            if (this.modCount != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            byte oldValue = this.value;
            this.value = unwrappedNewValue = newValue.byteValue();
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(byte newValue) {
            UnsafeConstants.U.putByte(UpdatableLHashParallelKVByteByteMapGO.this.table, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_VALUE_OFFSET + ((long)this.index << 1), newValue);
        }
    }

    abstract class ByteByteEntry
    extends AbstractEntry<Byte, Byte> {
        ByteByteEntry() {
        }

        abstract byte key();

        public final Byte getKey() {
            return this.key();
        }

        abstract byte value();

        public final Byte getValue() {
            return this.value();
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                byte k2 = (Byte)e2.getKey();
                byte v2 = (Byte)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return Primitives.hashCode((byte)this.key()) ^ Primitives.hashCode((byte)this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Byte, Byte>>
    implements HashObjSet<Map.Entry<Byte, Byte>>,
    InternalObjCollectionOps<Map.Entry<Byte, Byte>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Byte, Byte>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return UpdatableLHashParallelKVByteByteMapGO.this.hashConfig();
        }

        public int size() {
            return UpdatableLHashParallelKVByteByteMapGO.this.size;
        }

        public double currentLoad() {
            return UpdatableLHashParallelKVByteByteMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return UpdatableLHashParallelKVByteByteMapGO.this.containsEntry((Byte)e.getKey(), (Byte)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            byte free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, (byte)(entry >>> 8));
            }
            if (mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            byte free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, (byte)(entry >>> 8));
            }
            if (mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<Byte, Byte>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            byte free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                action.accept((Map.Entry<Byte, Byte>)((Object)new MutableEntry(mc, i, key, (byte)(entry >>> 8))));
            }
            if (mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Byte, Byte>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            byte free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free || predicate.test((Map.Entry<Byte, Byte>)((Object)new MutableEntry(mc, i, key, (byte)(entry >>> 8))))) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<Byte, Byte>> iterator() {
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Byte, Byte>> cursor() {
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            byte free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free || c.contains((Object)e.with(key, (byte)(entry >>> 8)))) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            byte free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, (byte)(entry >>> 8)));
            }
            if (mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Byte, Byte>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            byte free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, (byte)(entry >>> 8)));
            }
            if (mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public int hashCode() {
            return UpdatableLHashParallelKVByteByteMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            byte free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append((byte)(entry >>> 8));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return UpdatableLHashParallelKVByteByteMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                byte key = (Byte)e.getKey();
                byte value = (Byte)e.getValue();
                return UpdatableLHashParallelKVByteByteMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Byte, Byte>> filter) {
            throw new UnsupportedOperationException();
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            UpdatableLHashParallelKVByteByteMapGO.this.doClear();
        }
    }
}

