/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.CommonSetOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.hash.QHash;
import com.koloboke.collect.impl.hash.SeparateKVObjQHash;
import com.koloboke.collect.impl.hash.UpdatableObjQHashSetSO;
import com.koloboke.collect.set.hash.HashObjSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Set;
import javax.annotation.Nonnull;

public class UpdatableQHashObjSetGO<E>
extends UpdatableObjQHashSetSO<E>
implements HashObjSet<E>,
InternalObjCollectionOps<E> {
    @Override
    final void copy(SeparateKVObjQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVObjQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public int hashCode() {
        return this.setHashCode();
    }

    @Override
    public String toString() {
        return this.setToString();
    }

    @Override
    public boolean equals(Object obj) {
        return CommonSetOps.equals((Set)((Object)this), (Object)obj);
    }

    public boolean containsAll(@Nonnull Collection<?> c) {
        return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
    }

    @Nonnull
    public ObjCursor<E> cursor() {
        return this.setCursor();
    }

    public boolean add(E key) {
        if (key != null) {
            Object[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVObjKeyMixing.mix((int)this.keyHashCode(key)) % capacity;
            Object cur = keys[index];
            if (cur != FREE) {
                if (cur == key || this.keyEquals(key, cur)) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == FREE) {
                        index = bIndex;
                        break;
                    }
                    if (cur == key || this.keyEquals(key, cur)) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == FREE) {
                        index = fIndex;
                        break;
                    }
                    if (cur == key || this.keyEquals(key, cur)) {
                        return false;
                    }
                    step += 2;
                }
            }
            this.incrementModCount();
            keys[index] = key;
            this.postInsertHook();
            return true;
        }
        return this.addNullKey();
    }

    private boolean addNullKey() {
        Object[] keys = this.set;
        int capacity = keys.length;
        int index = 0;
        Object cur = keys[0];
        if (cur != FREE) {
            if (cur == null) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == FREE) {
                    index = bIndex;
                    break;
                }
                if (cur == null) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == FREE) {
                    index = fIndex;
                    break;
                }
                if (cur == null) {
                    return false;
                }
                step += 2;
            }
        }
        this.incrementModCount();
        keys[index] = null;
        this.postInsertHook();
        return true;
    }

    public boolean addAll(@Nonnull Collection<? extends E> c) {
        return CommonObjCollectionOps.addAll((ObjCollection)this, c);
    }

    public boolean remove(Object key) {
        throw new UnsupportedOperationException();
    }

    private boolean removeNullKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    boolean justRemove(E key) {
        return this.remove(key);
    }

    public boolean removeAll(@Nonnull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(@Nonnull Collection<?> c) {
        return this.retainAll(this, c);
    }
}

