/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.impl.InternalByteObjMapOps;
import com.koloboke.collect.impl.hash.QHash;
import com.koloboke.collect.impl.hash.SeparateKVByteObjQHash;
import com.koloboke.collect.impl.hash.UpdatableQHashSeparateKVByteKeyMap;
import com.koloboke.collect.map.hash.HashByteObjMap;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class UpdatableQHashSeparateKVByteObjMapSO<V>
extends UpdatableQHashSeparateKVByteKeyMap
implements HashByteObjMap<V>,
InternalByteObjMapOps<V>,
SeparateKVByteObjQHash {
    V[] values;

    void copy(SeparateKVByteObjQHash hash) {
        super.copy(hash);
        this.values = (Object[])hash.valueArray().clone();
    }

    void move(SeparateKVByteObjQHash hash) {
        super.move(hash);
        this.values = hash.valueArray();
    }

    @Override
    @Nonnull
    public Object[] valueArray() {
        return this.values;
    }

    boolean nullableValueEquals(@Nullable V a, @Nullable V b) {
        return a == b || a != null && this.valueEquals(a, b);
    }

    boolean valueEquals(@Nonnull V a, @Nullable V b) {
        return a.equals(b);
    }

    int nullableValueHashCode(@Nullable V value) {
        return value != null ? this.valueHashCode(value) : 0;
    }

    int valueHashCode(@Nonnull V value) {
        return value.hashCode();
    }

    int valueIndex(@Nullable Object value) {
        if (value == null) {
            return this.nullValueIndex();
        }
        if (this.isEmpty()) {
            return -1;
        }
        Object val = value;
        int index = -1;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte[] keys = this.set;
        V[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            if (keys[i] == free || !this.valueEquals(val, vals[i])) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    private int nullValueIndex() {
        if (this.isEmpty()) {
            return -1;
        }
        int index = -1;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte[] keys = this.set;
        V[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            if (keys[i] == free || vals[i] != null) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    public boolean containsValue(Object value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(@Nullable Object value) {
        throw new UnsupportedOperationException();
    }

    int insert(byte key, V value) {
        byte free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        byte[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVByteKeyMixing.mix((byte)key) % capacity;
        byte cur = keys[index];
        if (cur != free) {
            if (cur == key) {
                return index;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == free) {
                    index = bIndex;
                    break;
                }
                if (cur == key) {
                    return bIndex;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == free) {
                    index = fIndex;
                    break;
                }
                if (cur == key) {
                    return fIndex;
                }
                step += 2;
            }
        }
        this.incrementModCount();
        keys[index] = key;
        this.values[index] = value;
        this.postInsertHook();
        return -1;
    }

    @Override
    void allocateArrays(int capacity) {
        super.allocateArrays(capacity);
        this.values = new Object[capacity];
    }

    @Override
    public void clear() {
        super.clear();
        Arrays.fill(this.values, null);
    }
}

