/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.impl.InternalFloatCharMapOps;
import com.koloboke.collect.impl.hash.QHash;
import com.koloboke.collect.impl.hash.SeparateKVFloatCharQHash;
import com.koloboke.collect.impl.hash.UpdatableQHashSeparateKVFloatKeyMap;
import com.koloboke.collect.map.hash.HashFloatCharMap;
import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;

public abstract class UpdatableQHashSeparateKVFloatCharMapSO
extends UpdatableQHashSeparateKVFloatKeyMap
implements HashFloatCharMap,
InternalFloatCharMapOps,
SeparateKVFloatCharQHash {
    char[] values;

    void copy(SeparateKVFloatCharQHash hash) {
        super.copy(hash);
        this.values = (char[])hash.valueArray().clone();
    }

    void move(SeparateKVFloatCharQHash hash) {
        super.move(hash);
        this.values = hash.valueArray();
    }

    @Override
    @Nonnull
    public char[] valueArray() {
        return this.values;
    }

    int valueIndex(char value) {
        if (this.isEmpty()) {
            return -1;
        }
        int index = -1;
        int mc = this.modCount();
        int[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            if (keys[i] >= 0x7FFFFFFE || value != vals[i]) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    public boolean containsValue(char value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(char value) {
        throw new UnsupportedOperationException();
    }

    public boolean containsValue(Object value) {
        return this.containsValue(((Character)value).charValue());
    }

    int insert(int key, char value) {
        int[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVFloatKeyMixing.mix((int)key) % capacity;
        int cur = keys[index];
        if (cur != 0x7FFFFFFE) {
            if (cur == key) {
                return index;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == 0x7FFFFFFE) {
                    index = bIndex;
                    break;
                }
                if (cur == key) {
                    return bIndex;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == 0x7FFFFFFE) {
                    index = fIndex;
                    break;
                }
                if (cur == key) {
                    return fIndex;
                }
                step += 2;
            }
        }
        this.incrementModCount();
        keys[index] = key;
        this.values[index] = value;
        this.postInsertHook();
        return -1;
    }

    @Override
    void allocateArrays(int capacity) {
        super.allocateArrays(capacity);
        this.values = new char[capacity];
    }
}

