/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.query;

import com.avaje.ebean.FutureList;
import com.avaje.ebean.Page;
import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.bean.BeanCollectionTouched;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.server.query.LimitOffsetPagingQuery;
import java.util.List;
import javax.persistence.PersistenceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LimitOffsetPage<T>
implements Page<T>,
BeanCollectionTouched {
    private final int pageIndex;
    private final LimitOffsetPagingQuery<T> owner;
    private FutureList<T> futureList;

    public LimitOffsetPage(int pageIndex, LimitOffsetPagingQuery<T> owner) {
        this.pageIndex = pageIndex;
        this.owner = owner;
    }

    public FutureList<T> getFutureList() {
        if (this.futureList == null) {
            SpiQuery<T> originalQuery = this.owner.getSpiQuery();
            SpiQuery<T> copy = originalQuery.copy();
            copy.setPersistenceContext(originalQuery.getPersistenceContext());
            int pageSize = this.owner.getPageSize();
            copy.setFirstRow(this.pageIndex * pageSize);
            copy.setMaxRows(pageSize);
            copy.setBeanCollectionTouched(this);
            this.futureList = this.owner.getServer().findFutureList(copy, null);
        }
        return this.futureList;
    }

    @Override
    public void notifyTouched(BeanCollection<?> c) {
        if (c.hasMoreRows()) {
            this.owner.fetchAheadIfRequired(this.pageIndex);
        }
    }

    @Override
    public List<T> getList() {
        try {
            return (List)this.getFutureList().get();
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    @Override
    public boolean hasNext() {
        return ((BeanCollection)((Object)this.getList())).hasMoreRows();
    }

    @Override
    public boolean hasPrev() {
        return this.pageIndex > 0;
    }

    @Override
    public Page<T> next() {
        return this.owner.getPage(this.pageIndex + 1);
    }

    @Override
    public Page<T> prev() {
        return this.owner.getPage(this.pageIndex - 1);
    }

    @Override
    public int getPageIndex() {
        return this.pageIndex;
    }

    @Override
    public int getTotalPageCount() {
        return this.owner.getTotalPageCount();
    }

    @Override
    public int getTotalRowCount() {
        return this.owner.getTotalRowCount();
    }

    @Override
    public String getDisplayXtoYofZ(String to, String of) {
        int first = this.pageIndex * this.owner.getPageSize() + 1;
        int last = first + this.getList().size() - 1;
        int total = this.getTotalRowCount();
        return first + to + last + of + total;
    }
}

