/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.configuration;

import com.mohistmc.MohistMC;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

public class MohistConfigUtil {
    public static File mohistyml = new File("mohist-config", "mohist.yml");

    public static String getString(String s, String key, String defaultreturn) {
        if (s.contains(key)) {
            String string = s.substring(s.indexOf(key));
            String s1 = string.substring(string.indexOf(": ") + 2);
            String[] ss = s1.split("\n");
            return ss[0].trim().replace("'", "").replace("\"", "");
        }
        return defaultreturn;
    }

    public static String getString(File f, String key, String defaultreturn) {
        try {
            StringBuilder s = new StringBuilder();
            try (BufferedReader br = new BufferedReader(new FileReader(f));){
                String l;
                while ((l = br.readLine()) != null) {
                    if (l.startsWith("#")) continue;
                    s.append(l).append("\n");
                }
            }
            return MohistConfigUtil.getString(s.toString(), key, defaultreturn);
        }
        catch (IOException e) {
            return defaultreturn;
        }
    }

    public static boolean getBoolean(File f, String key) {
        return Boolean.parseBoolean(MohistConfigUtil.getString(f, key, "true"));
    }

    public static boolean getBoolean(File f, String key, String b2) {
        return Boolean.parseBoolean(MohistConfigUtil.getString(f, key, b2));
    }

    public static void copyMohistConfig() {
        try {
            if (!mohistyml.exists()) {
                mohistyml.mkdirs();
                Files.copy(MohistMC.class.getClassLoader().getResourceAsStream("configurations/mohist.yml"), mohistyml.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (Exception e) {
            System.out.println("File copy exception!");
        }
    }

    public static boolean bMohist(String key) {
        return MohistConfigUtil.getBoolean(mohistyml, key + ":");
    }

    public static boolean bMohist(String key, String defaultReturn) {
        return MohistConfigUtil.getBoolean(mohistyml, key + ":", defaultReturn);
    }
}

