/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.pluginmanager;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.bukkit.Bukkit;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.UnknownDependencyException;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;

public class Control {
    public static PluginDescriptionFile getDescription(File file) throws InvalidDescriptionException, IOException {
        JarFile jar = new JarFile(file);
        ZipEntry zip = jar.getEntry("plugin.yml");
        if (zip == null) {
            jar.close();
            return null;
        }
        PluginDescriptionFile pdf = new PluginDescriptionFile(jar.getInputStream(zip));
        jar.close();
        return pdf;
    }

    public static File getFile(JavaPlugin plugin) {
        try {
            Field file = JavaPlugin.class.getDeclaredField("file");
            file.setAccessible(true);
            return (File)file.get(plugin);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void enablePlugin(Plugin plugin) {
        Bukkit.getPluginManager().enablePlugin(plugin);
    }

    public static void disablePlugin(Plugin plugin) {
        Bukkit.getPluginManager().disablePlugin(plugin);
    }

    public static Plugin loadPlugin(File plugin) {
        try {
            Plugin p = Bukkit.getPluginManager().loadPlugin(plugin);
            try {
                p.onLoad();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return p;
        }
        catch (InvalidPluginException e) {
            e.printStackTrace();
        }
        catch (InvalidDescriptionException e) {
            e.printStackTrace();
        }
        catch (UnknownDependencyException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static boolean unloadPlugin(Plugin plugin, Boolean reloaddependents) {
        Object e32;
        Map commands;
        SimpleCommandMap commandMap;
        Map names;
        List plugins;
        PluginManager pluginManager = Bukkit.getPluginManager();
        String pName = plugin.getName();
        ArrayList<Object> reload = new ArrayList<Object>();
        Control.disablePlugin(plugin);
        if (reloaddependents.booleanValue()) {
            for (Plugin p : pluginManager.getPlugins()) {
                List<String> softDepend;
                List<String> list = p.getDescription().getDepend();
                if (list != null) {
                    for (String s : list) {
                        if (!s.equals(pName) || reload.contains(p)) continue;
                        reload.add(p);
                        Control.unloadPlugin(p, false);
                    }
                }
                if ((softDepend = p.getDescription().getSoftDepend()) == null) continue;
                for (String s : softDepend) {
                    if (!s.equals(pName) || reload.contains(p)) continue;
                    reload.add(p);
                    Control.unloadPlugin(p, false);
                }
            }
        }
        for (Plugin plugin2 : reload) {
            Bukkit.getServer().broadcastMessage(plugin2.getName() + "\n");
        }
        try {
            Field pluginsField = pluginManager.getClass().getDeclaredField("plugins");
            Field field = pluginManager.getClass().getDeclaredField("lookupNames");
            Field commandMapField = pluginManager.getClass().getDeclaredField("commandMap");
            Field knownCommandsField = SimpleCommandMap.class.getDeclaredField("knownCommands");
            pluginsField.setAccessible(true);
            field.setAccessible(true);
            commandMapField.setAccessible(true);
            knownCommandsField.setAccessible(true);
            plugins = (List)pluginsField.get(pluginManager);
            names = (Map)field.get(pluginManager);
            commandMap = (SimpleCommandMap)commandMapField.get(pluginManager);
            commands = (Map)knownCommandsField.get(commandMap);
        }
        catch (NoSuchFieldException e2) {
            e2.printStackTrace();
            return false;
        }
        catch (IllegalAccessException e32) {
            e32.printStackTrace();
            return false;
        }
        if (commandMap != null) {
            e32 = commandMap;
            synchronized (e32) {
                Iterator iterator = commands.entrySet().iterator();
                while (iterator.hasNext()) {
                    PluginCommand c;
                    Map.Entry entry = iterator.next();
                    if (!(entry.getValue() instanceof PluginCommand) || (c = (PluginCommand)entry.getValue()).getPlugin() != plugin) continue;
                    c.unregister(commandMap);
                    iterator.remove();
                }
            }
        }
        e32 = pluginManager;
        synchronized (e32) {
            if (plugins != null && plugins.contains(plugin)) {
                plugins.remove(plugin);
            }
            if (names != null && names.containsKey(pName)) {
                names.remove(pName);
            }
        }
        JavaPluginLoader jpl = (JavaPluginLoader)plugin.getPluginLoader();
        Object var10_13 = null;
        try {
            Field field = jpl.getClass().getDeclaredField("loaders");
            field.setAccessible(true);
        }
        catch (Exception e4) {
            e4.printStackTrace();
        }
        try {
            void var10_15;
            CopyOnWriteArrayList loaderMap = (CopyOnWriteArrayList)var10_15.get(jpl);
            loaderMap.remove(plugin.getDescription().getName());
        }
        catch (Exception e5) {
            e5.printStackTrace();
        }
        ClassLoader cl = plugin.getClass().getClassLoader();
        try {
            ((URLClassLoader)cl).close();
        }
        catch (IOException e6) {
            e6.printStackTrace();
        }
        System.gc();
        if (reloaddependents.booleanValue()) {
            for (Plugin plugin3 : reload) {
                Control.enablePlugin(Control.loadPlugin(Control.getFile((JavaPlugin)plugin3)));
            }
        }
        return true;
    }
}

