/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.pluginmanager;

import com.mohistmc.pluginmanager.Control;
import com.mohistmc.util.i18n.i18n;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;

public class PluginManagers {
    public static boolean hasPermission(CommandSender sender) {
        if (sender != Bukkit.getServer().getConsoleSender()) {
            if (sender.isOp()) {
                return true;
            }
            sender.sendMessage(i18n.get("command.nopermission"));
            return false;
        }
        return true;
    }

    public static boolean loadPluginCommand(CommandSender sender, String label, String[] split) throws InvalidDescriptionException, IOException {
        Object[] d;
        PluginDescriptionFile desc;
        if (!PluginManagers.hasPermission(sender)) {
            return true;
        }
        if (split.length < 2) {
            Object[] f = new Object[]{label};
            sender.sendMessage(i18n.get("pluginscommand.load", f));
            return true;
        }
        String jarName = split[1] + (split[1].endsWith(".jar") ? "" : ".jar");
        File toLoad = new File("plugins" + File.separator + jarName);
        if (!toLoad.exists()) {
            jarName = split[1] + (split[1].endsWith(".jar") ? ".unloaded" : ".jar.unloaded");
            toLoad = new File("plugins" + File.separator + jarName);
            if (!toLoad.exists()) {
                Object[] f = new Object[]{split[1]};
                sender.sendMessage(i18n.get("pluginscommand.nofile", f));
                return true;
            }
            String fileName = jarName.substring(0, jarName.length() - ".unloaded".length());
            toLoad = new File("plugins" + File.separator + fileName);
            File unloaded = new File("plugins" + File.separator + jarName);
            unloaded.renameTo(toLoad);
        }
        if ((desc = Control.getDescription(toLoad)) == null) {
            Object[] f = new Object[]{split[1]};
            sender.sendMessage(i18n.get("pluginscommand.noyml", f));
            return true;
        }
        Plugin[] pl = Bukkit.getPluginManager().getPlugins();
        ArrayList<Plugin> plugins = new ArrayList<Plugin>(Arrays.asList(pl));
        for (Plugin p : plugins) {
            if (!desc.getName().equals(p.getName())) continue;
            Object[] f = new Object[]{desc.getName()};
            sender.sendMessage(i18n.get("pluginscommand.alreadyloaded", f));
            return true;
        }
        Plugin p = null;
        p = Control.loadPlugin(toLoad);
        if (p != null) {
            Control.enablePlugin(p);
            d = new Object[]{p.getDescription().getName(), p.getDescription().getVersion()};
            sender.sendMessage(i18n.get("pluginscommand.loaded", d));
        } else {
            d = new Object[]{split[1]};
            sender.sendMessage(i18n.get("pluginscommand.notload", d));
        }
        return true;
    }

    public static boolean unloadPluginCommand(CommandSender sender, String label, String[] split) {
        if (!PluginManagers.hasPermission(sender)) {
            return true;
        }
        if (split.length < 2) {
            Object[] f = new Object[]{label};
            sender.sendMessage(i18n.get("pluginscommand.unload", f));
            return true;
        }
        Plugin p = Bukkit.getServer().getPluginManager().getPlugin(split[1]);
        if (p == null) {
            Object[] f = new Object[]{split[1]};
            sender.sendMessage(i18n.get("pluginscommand.noplugin", f));
        } else if (Control.unloadPlugin(p, true)) {
            Object[] d = new Object[]{p.getDescription().getName(), p.getDescription().getVersion()};
            sender.sendMessage(i18n.get("pluginscommand.unloaded", d));
        } else {
            Object[] d = new Object[]{split[1]};
            sender.sendMessage(i18n.get("pluginscommand.notunload", d));
        }
        return true;
    }

    public static boolean reloadPluginCommand(CommandSender sender, String label, String[] split) {
        if (!PluginManagers.hasPermission(sender)) {
            return true;
        }
        if (split.length < 2) {
            Object[] f = new Object[]{label};
            sender.sendMessage(i18n.get("pluginscommand.reload", f));
            return true;
        }
        Plugin p = Bukkit.getServer().getPluginManager().getPlugin(split[1]);
        if (p == null) {
            Object[] f = new Object[]{split[1]};
            sender.sendMessage(i18n.get("pluginscommand.noplugin", f));
        } else {
            Object[] f;
            File file = Control.getFile((JavaPlugin)p);
            if (file == null) {
                Object[] f2 = new Object[]{p.getName()};
                sender.sendMessage(i18n.get("pluginscommand.nojar", f2));
                return true;
            }
            File name = new File("plugins" + File.separator + file.getName());
            JavaPlugin loaded = null;
            if (!Control.unloadPlugin(p, false)) {
                f = new Object[]{split[1]};
                sender.sendMessage(i18n.get("pluginscommand.unloaderror", f));
            } else {
                loaded = (JavaPlugin)Control.loadPlugin(name);
                if (loaded == null) {
                    f = new Object[]{split[1]};
                    sender.sendMessage(i18n.get("pluginscommand.nojar", f));
                }
            }
            Control.enablePlugin(loaded);
            Object[] d = new Object[]{split[1], loaded.getDescription().getVersion()};
            sender.sendMessage(i18n.get("pluginscommand.reloaded", d));
        }
        return true;
    }
}

