/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.util;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraftforge.common.util.FakePlayer;

public class FakePlayerFactory {
    private static GameProfile MINECRAFT = new GameProfile(UUID.fromString("41C82C87-7AfB-4024-BA57-13D2C99CAE77"), "[Minecraft]");
    public static Map<GameProfile, FakePlayer> fakePlayers = Maps.newHashMap();
    private static FakePlayer MINECRAFT_PLAYER = null;

    public static FakePlayer getMinecraft(mt world) {
        if (MINECRAFT_PLAYER == null) {
            MINECRAFT_PLAYER = FakePlayerFactory.get(world, MINECRAFT);
        }
        return MINECRAFT_PLAYER;
    }

    public static FakePlayer get(mt world, GameProfile username) {
        if (username == null || username.getName() == null) {
            return null;
        }
        for (Map.Entry<GameProfile, FakePlayer> mapEntry : fakePlayers.entrySet()) {
            GameProfile gameprofile = mapEntry.getKey();
            if (!gameprofile.getName().equals(username.getName())) continue;
            return mapEntry.getValue();
        }
        FakePlayer fakePlayer = new FakePlayer(world, username);
        if (username.getId() == null) {
            username = new GameProfile(UUID.randomUUID(), username.getName());
        }
        fakePlayers.put(username, fakePlayer);
        return fakePlayers.get(username);
    }

    public static void unloadWorld(mt world) {
        Iterator<Map.Entry<GameProfile, FakePlayer>> itr = fakePlayers.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<GameProfile, FakePlayer> entry = itr.next();
            if (entry.getValue().o != world) continue;
            itr.remove();
        }
    }
}

