/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.world;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.eventhandler.Cancelable;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.util.BlockSnapshot;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_7_R4.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_7_R4.event.CraftEventFactory;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.block.BlockPlaceEvent;

public class BlockEvent
extends Event {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("forge.debugBlockEvent", "false"));
    public final int x;
    public final int y;
    public final int z;
    public final ahb world;
    public final aji block;
    public final int blockMetadata;

    public BlockEvent(int x, int y2, int z2, ahb world, aji block, int blockMetadata) {
        this.x = x;
        this.y = y2;
        this.z = z2;
        this.world = world;
        this.block = block;
        this.blockMetadata = blockMetadata;
    }

    @Cancelable
    public static class MultiPlaceEvent
    extends PlaceEvent {
        private final List<BlockSnapshot> blockSnapshots;

        public MultiPlaceEvent(List<BlockSnapshot> blockSnapshots, aji placedAgainst, yz player) {
            super(blockSnapshots.get(0), placedAgainst, player);
            this.blockSnapshots = ImmutableList.copyOf(blockSnapshots);
            ArrayList<BlockState> tStates = new ArrayList<BlockState>(blockSnapshots.size());
            for (BlockSnapshot sSnapshot : this.blockSnapshots) {
                tStates.add(new CraftBlockState(sSnapshot));
            }
            BlockMultiPlaceEvent tEvent = CraftEventFactory.callBlockMultiPlaceEvent(this.world, player, tStates, this.x, this.y, this.z);
            this.setCanceled(tEvent.isCancelled() || !tEvent.canBuild());
            if (DEBUG) {
                System.out.printf("Created MultiPlaceEvent - [PlacedAgainst: %s ][ItemInHand: %s ][Player: %s ]\n", placedAgainst, this.itemInHand, player);
            }
        }

        public List<BlockSnapshot> getReplacedBlockSnapshots() {
            return this.blockSnapshots;
        }
    }

    @Cancelable
    public static class PlaceEvent
    extends BlockEvent {
        public final yz player;
        public final add itemInHand;
        public final BlockSnapshot blockSnapshot;
        public final aji placedBlock;
        public final aji placedAgainst;

        public PlaceEvent(BlockSnapshot blockSnapshot, aji placedAgainst, yz player) {
            super(blockSnapshot.x, blockSnapshot.y, blockSnapshot.z, blockSnapshot.world, blockSnapshot.getCurrentBlock(), blockSnapshot.meta);
            CraftBlockState blockstate;
            BlockPlaceEvent bukkitEvent;
            this.player = player;
            this.itemInHand = player.bF();
            this.blockSnapshot = blockSnapshot;
            this.placedBlock = blockSnapshot.getCurrentBlock();
            this.placedAgainst = placedAgainst;
            if (!(this instanceof MultiPlaceEvent || !(bukkitEvent = CraftEventFactory.callBlockPlaceEvent(this.world, player, blockstate = new CraftBlockState(blockSnapshot), this.x, this.y, this.z)).isCancelled() && bukkitEvent.canBuild())) {
                this.setCanceled(true);
            }
            if (DEBUG) {
                System.out.printf("Created PlaceEvent - [PlacedBlock: %s ][PlacedAgainst: %s ][ItemStack: %s ][Player: %s ]\n", this.placedBlock, placedAgainst, player.bF(), player);
            }
        }
    }

    @Cancelable
    public static class BreakEvent
    extends BlockEvent {
        private final yz player;
        private int exp;

        public BreakEvent(int x, int y2, int z2, ahb world, aji block, int blockMetadata, yz player) {
            super(x, y2, z2, world, block, blockMetadata);
            this.player = player;
            BlockBreakEvent bukkitEvent = CraftEventFactory.callBlockBreakEvent(world, x, y2, z2, block, blockMetadata, (mw)player);
            if (bukkitEvent.isCancelled()) {
                this.setCanceled(true);
            } else {
                this.exp = bukkitEvent.getExpToDrop();
            }
        }

        public yz getPlayer() {
            return this.player;
        }

        public int getExpToDrop() {
            return this.isCanceled() ? 0 : this.exp;
        }

        public void setExpToDrop(int exp) {
            this.exp = exp;
        }
    }

    public static class HarvestDropsEvent
    extends BlockEvent {
        public final int fortuneLevel;
        public final ArrayList<add> drops;
        public final boolean isSilkTouching;
        public float dropChance;
        public final yz harvester;

        public HarvestDropsEvent(int x, int y2, int z2, ahb world, aji block, int blockMetadata, int fortuneLevel, float dropChance, ArrayList<add> drops, yz harvester, boolean isSilkTouching) {
            super(x, y2, z2, world, block, blockMetadata);
            this.fortuneLevel = fortuneLevel;
            this.dropChance = dropChance;
            this.drops = drops;
            this.isSilkTouching = isSilkTouching;
            this.harvester = harvester;
        }
    }
}

