/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.Validate;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.FormattedCommandAlias;
import org.bukkit.command.defaults.AchievementCommand;
import org.bukkit.command.defaults.BanCommand;
import org.bukkit.command.defaults.BanIpCommand;
import org.bukkit.command.defaults.BanListCommand;
import org.bukkit.command.defaults.ClearCommand;
import org.bukkit.command.defaults.DefaultGameModeCommand;
import org.bukkit.command.defaults.DeopCommand;
import org.bukkit.command.defaults.DifficultyCommand;
import org.bukkit.command.defaults.EffectCommand;
import org.bukkit.command.defaults.EnchantCommand;
import org.bukkit.command.defaults.ExpCommand;
import org.bukkit.command.defaults.GameModeCommand;
import org.bukkit.command.defaults.GameRuleCommand;
import org.bukkit.command.defaults.GiveCommand;
import org.bukkit.command.defaults.HelpCommand;
import org.bukkit.command.defaults.KickCommand;
import org.bukkit.command.defaults.KillCommand;
import org.bukkit.command.defaults.ListCommand;
import org.bukkit.command.defaults.MeCommand;
import org.bukkit.command.defaults.OpCommand;
import org.bukkit.command.defaults.PardonCommand;
import org.bukkit.command.defaults.PardonIpCommand;
import org.bukkit.command.defaults.PlaySoundCommand;
import org.bukkit.command.defaults.PluginsCommand;
import org.bukkit.command.defaults.ReloadCommand;
import org.bukkit.command.defaults.SaveCommand;
import org.bukkit.command.defaults.SaveOffCommand;
import org.bukkit.command.defaults.SaveOnCommand;
import org.bukkit.command.defaults.SayCommand;
import org.bukkit.command.defaults.ScoreboardCommand;
import org.bukkit.command.defaults.SeedCommand;
import org.bukkit.command.defaults.SetIdleTimeoutCommand;
import org.bukkit.command.defaults.SetWorldSpawnCommand;
import org.bukkit.command.defaults.SpawnpointCommand;
import org.bukkit.command.defaults.SpreadPlayersCommand;
import org.bukkit.command.defaults.StopCommand;
import org.bukkit.command.defaults.TeleportCommand;
import org.bukkit.command.defaults.TellCommand;
import org.bukkit.command.defaults.TestForCommand;
import org.bukkit.command.defaults.TimeCommand;
import org.bukkit.command.defaults.TimingsCommand;
import org.bukkit.command.defaults.ToggleDownfallCommand;
import org.bukkit.command.defaults.VanillaCommand;
import org.bukkit.command.defaults.VersionCommand;
import org.bukkit.command.defaults.WeatherCommand;
import org.bukkit.command.defaults.WhitelistCommand;
import org.bukkit.entity.Player;
import org.bukkit.util.Java15Compat;
import org.bukkit.util.StringUtil;

public class SimpleCommandMap
implements CommandMap {
    private static final Pattern PATTERN_ON_SPACE = Pattern.compile(" ", 16);
    protected final Map<String, Command> knownCommands = new HashMap<String, Command>();
    private final Server server;

    public SimpleCommandMap(Server server) {
        this.server = server;
        this.setDefaultCommands();
    }

    private void setDefaultCommands() {
        this.register("bukkit", new SaveCommand());
        this.register("bukkit", new SaveOnCommand());
        this.register("bukkit", new SaveOffCommand());
        this.register("bukkit", new StopCommand());
        this.register("bukkit", new VersionCommand("version"));
        this.register("bukkit", new ReloadCommand("reload"));
        this.register("bukkit", new PluginsCommand("plugins"));
        this.register("bukkit", new TimingsCommand("timings"));
    }

    public void setFallbackCommands() {
        this.register("bukkit", new ListCommand());
        this.register("bukkit", new OpCommand());
        this.register("bukkit", new DeopCommand());
        this.register("bukkit", new BanIpCommand());
        this.register("bukkit", new PardonIpCommand());
        this.register("bukkit", new BanCommand());
        this.register("bukkit", new PardonCommand());
        this.register("bukkit", new KickCommand());
        this.register("bukkit", new TeleportCommand());
        this.register("bukkit", new GiveCommand());
        this.register("bukkit", new TimeCommand());
        this.register("bukkit", new SayCommand());
        this.register("bukkit", new WhitelistCommand());
        this.register("bukkit", new TellCommand());
        this.register("bukkit", new MeCommand());
        this.register("bukkit", new KillCommand());
        this.register("bukkit", new GameModeCommand());
        this.register("bukkit", new HelpCommand());
        this.register("bukkit", new ExpCommand());
        this.register("bukkit", new ToggleDownfallCommand());
        this.register("bukkit", new BanListCommand());
        this.register("bukkit", new DefaultGameModeCommand());
        this.register("bukkit", new SeedCommand());
        this.register("bukkit", new DifficultyCommand());
        this.register("bukkit", new WeatherCommand());
        this.register("bukkit", new SpawnpointCommand());
        this.register("bukkit", new ClearCommand());
        this.register("bukkit", new GameRuleCommand());
        this.register("bukkit", new EnchantCommand());
        this.register("bukkit", new TestForCommand());
        this.register("bukkit", new EffectCommand());
        this.register("bukkit", new ScoreboardCommand());
        this.register("bukkit", new PlaySoundCommand());
        this.register("bukkit", new SpreadPlayersCommand());
        this.register("bukkit", new SetWorldSpawnCommand());
        this.register("bukkit", new SetIdleTimeoutCommand());
        this.register("bukkit", new AchievementCommand());
    }

    @Override
    public void registerAll(String fallbackPrefix, List<Command> commands) {
        if (commands != null) {
            for (Command c : commands) {
                this.register(fallbackPrefix, c);
            }
        }
    }

    @Override
    public boolean register(String fallbackPrefix, Command command) {
        return this.register(command.getName(), fallbackPrefix, command);
    }

    @Override
    public boolean register(String label, String fallbackPrefix, Command command) {
        label = label.toLowerCase().trim();
        fallbackPrefix = fallbackPrefix.toLowerCase().trim();
        boolean registered = this.register(label, command, false, fallbackPrefix);
        Iterator<String> iterator = command.getAliases().iterator();
        while (iterator.hasNext()) {
            if (this.register(iterator.next(), command, true, fallbackPrefix)) continue;
            iterator.remove();
        }
        if (!registered) {
            command.setLabel(fallbackPrefix + ":" + label);
        }
        command.register(this);
        return registered;
    }

    private synchronized boolean register(String label, Command command, boolean isAlias, String fallbackPrefix) {
        this.knownCommands.put(fallbackPrefix + ":" + label, command);
        if ((command instanceof VanillaCommand || isAlias) && this.knownCommands.containsKey(label)) {
            return false;
        }
        boolean registered = true;
        Command conflict = this.knownCommands.get(label);
        if (conflict != null && conflict.getLabel().equals(label)) {
            return false;
        }
        if (!isAlias) {
            command.setLabel(label);
        }
        this.knownCommands.put(label, command);
        return registered;
    }

    @Override
    public boolean dispatch(CommandSender sender, String commandLine) throws CommandException {
        String[] args = PATTERN_ON_SPACE.split(commandLine);
        if (args.length == 0) {
            return false;
        }
        String sentCommandLabel = args[0].toLowerCase();
        Command target = this.getCommand(sentCommandLabel);
        if (target == null) {
            return false;
        }
        try {
            target.timings.startTiming();
            target.execute(sender, sentCommandLabel, Java15Compat.Arrays_copyOfRange(args, 1, args.length));
            target.timings.stopTiming();
        }
        catch (CommandException ex) {
            target.timings.stopTiming();
            throw ex;
        }
        catch (Throwable ex) {
            target.timings.stopTiming();
            throw new CommandException("Unhandled exception executing '" + commandLine + "' in " + target, ex);
        }
        return true;
    }

    @Override
    public synchronized void clearCommands() {
        for (Map.Entry<String, Command> entry : this.knownCommands.entrySet()) {
            entry.getValue().unregister(this);
        }
        this.knownCommands.clear();
        this.setDefaultCommands();
    }

    @Override
    public Command getCommand(String name) {
        Command target = this.knownCommands.get(name.toLowerCase());
        return target;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String cmdLine) {
        Validate.notNull((Object)sender, (String)"Sender cannot be null");
        Validate.notNull((Object)cmdLine, (String)"Command line cannot null");
        int spaceIndex = cmdLine.indexOf(32);
        if (spaceIndex == -1) {
            ArrayList<String> completions = new ArrayList<String>();
            Map<String, Command> knownCommands = this.knownCommands;
            String prefix = sender instanceof Player ? "/" : "";
            for (Map.Entry<String, Command> commandEntry : knownCommands.entrySet()) {
                String name;
                Command command = commandEntry.getValue();
                if (!command.testPermissionSilent(sender) || !StringUtil.startsWithIgnoreCase(name = commandEntry.getKey(), cmdLine)) continue;
                completions.add(prefix + name);
            }
            Collections.sort(completions, String.CASE_INSENSITIVE_ORDER);
            return completions;
        }
        String commandName = cmdLine.substring(0, spaceIndex);
        Command target = this.getCommand(commandName);
        if (target == null) {
            return null;
        }
        if (!target.testPermissionSilent(sender)) {
            return null;
        }
        String argLine = cmdLine.substring(spaceIndex + 1, cmdLine.length());
        String[] args = PATTERN_ON_SPACE.split(argLine, -1);
        try {
            return target.tabComplete(sender, commandName, args);
        }
        catch (CommandException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new CommandException("Unhandled exception executing tab-completer for '" + cmdLine + "' in " + target, ex);
        }
    }

    public Collection<Command> getCommands() {
        return Collections.unmodifiableCollection(this.knownCommands.values());
    }

    public void registerServerAliases() {
        Map<String, String[]> values = this.server.getCommandAliases();
        for (String alias : values.keySet()) {
            if (alias.contains(":") || alias.contains(" ")) {
                this.server.getLogger().warning("Could not register alias " + alias + " because it contains illegal characters");
                continue;
            }
            String[] commandStrings = values.get(alias);
            ArrayList<String> targets = new ArrayList<String>();
            StringBuilder bad = new StringBuilder();
            for (String commandString : commandStrings) {
                String[] commandArgs = commandString.split(" ");
                Command command = this.getCommand(commandArgs[0]);
                if (command == null) {
                    if (bad.length() > 0) {
                        bad.append(", ");
                    }
                    bad.append(commandString);
                    continue;
                }
                targets.add(commandString);
            }
            if (bad.length() > 0) {
                this.server.getLogger().warning("Could not register alias " + alias + " because it contains commands that do not exist: " + bad);
                continue;
            }
            if (targets.size() > 0) {
                this.knownCommands.put(alias.toLowerCase(), new FormattedCommandAlias(alias.toLowerCase(), targets.toArray(new String[targets.size()])));
                continue;
            }
            this.knownCommands.remove(alias.toLowerCase());
        }
    }
}

