/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.command.defaults;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.VanillaCommand;
import org.bukkit.entity.Player;

public class PlaySoundCommand
extends VanillaCommand {
    public PlaySoundCommand() {
        super("playsound");
        this.description = "Plays a sound to a given player";
        this.usageMessage = "/playsound <sound> <player> [x] [y] [z] [volume] [pitch] [minimumVolume]";
        this.setPermission("bukkit.command.playsound");
    }

    @Override
    public boolean execute(CommandSender sender, String currentAlias, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
            return false;
        }
        String soundArg = args[0];
        String playerArg = args[1];
        Player player = Bukkit.getPlayerExact(playerArg);
        if (player == null) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Can't find player " + playerArg);
            return false;
        }
        Location location = player.getLocation();
        double x = Math.floor(location.getX());
        double y2 = Math.floor(location.getY() + 0.5);
        double z2 = Math.floor(location.getZ());
        double volume = 1.0;
        double pitch = 1.0;
        double minimumVolume = 0.0;
        switch (args.length) {
            default: {
                minimumVolume = PlaySoundCommand.getDouble(sender, args[7], 0.0, 1.0);
            }
            case 7: {
                pitch = PlaySoundCommand.getDouble(sender, args[6], 0.0, 2.0);
            }
            case 6: {
                volume = PlaySoundCommand.getDouble(sender, args[5], 0.0, 3.4028234663852886E38);
            }
            case 5: {
                z2 = PlaySoundCommand.getRelativeDouble(z2, sender, args[4]);
            }
            case 4: {
                y2 = PlaySoundCommand.getRelativeDouble(y2, sender, args[3]);
            }
            case 3: {
                x = PlaySoundCommand.getRelativeDouble(x, sender, args[2]);
            }
            case 2: 
        }
        double fixedVolume = volume > 1.0 ? volume * 16.0 : 16.0;
        Location soundLocation = new Location(player.getWorld(), x, y2, z2);
        if (location.distanceSquared(soundLocation) > fixedVolume * fixedVolume) {
            double deltaZ;
            double deltaY;
            if (minimumVolume <= 0.0) {
                sender.sendMessage((Object)((Object)ChatColor.RED) + playerArg + " is too far away to hear the sound");
                return false;
            }
            double deltaX = x - location.getX();
            double delta = Math.sqrt(deltaX * deltaX + (deltaY = y2 - location.getY()) * deltaY + (deltaZ = z2 - location.getZ()) * deltaZ) / 2.0;
            if (delta > 0.0) {
                location.add(deltaX / delta, deltaY / delta, deltaZ / delta);
            }
            player.playSound(location, soundArg, (float)minimumVolume, (float)pitch);
        } else {
            player.playSound(soundLocation, soundArg, (float)volume, (float)pitch);
        }
        sender.sendMessage(String.format("Played '%s' to %s", soundArg, playerArg));
        return true;
    }
}

