/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_7_R4.inventory;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_7_R4.inventory.CraftItemFactory;
import org.bukkit.craftbukkit.v1_7_R4.inventory.CraftMetaBook;
import org.bukkit.craftbukkit.v1_7_R4.inventory.CraftMetaCharge;
import org.bukkit.craftbukkit.v1_7_R4.inventory.CraftMetaEnchantedBook;
import org.bukkit.craftbukkit.v1_7_R4.inventory.CraftMetaFirework;
import org.bukkit.craftbukkit.v1_7_R4.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_7_R4.inventory.CraftMetaLeatherArmor;
import org.bukkit.craftbukkit.v1_7_R4.inventory.CraftMetaMap;
import org.bukkit.craftbukkit.v1_7_R4.inventory.CraftMetaPotion;
import org.bukkit.craftbukkit.v1_7_R4.inventory.CraftMetaSkull;
import org.bukkit.craftbukkit.v1_7_R4.util.CraftMagicNumbers;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@DelegateDeserialization(value=ItemStack.class)
public final class CraftItemStack
extends ItemStack {
    add handle;

    public static add asNMSCopy(ItemStack original) {
        if (original instanceof CraftItemStack) {
            CraftItemStack stack = (CraftItemStack)original;
            return stack.handle == null ? null : stack.handle.m();
        }
        if (original == null || original.getTypeId() <= 0) {
            return null;
        }
        adb item = CraftMagicNumbers.getItem(original.getType());
        if (item == null) {
            return null;
        }
        add stack = new add(item, original.getAmount(), (int)original.getDurability());
        if (original.hasItemMeta()) {
            CraftItemStack.setItemMeta(stack, original.getItemMeta());
        }
        return stack;
    }

    public static add copyNMSStack(add original, int amount) {
        add stack = original.m();
        stack.b = amount;
        return stack;
    }

    public static ItemStack asBukkitCopy(add original) {
        if (original == null) {
            return new ItemStack(Material.AIR);
        }
        return CraftItemStack.asCraftMirror(CraftItemStack.copyNMSStack(original, original.b));
    }

    public static CraftItemStack asCraftMirror(add original) {
        return new CraftItemStack(original);
    }

    public static CraftItemStack asCraftCopy(ItemStack original) {
        if (original instanceof CraftItemStack) {
            CraftItemStack stack = (CraftItemStack)original;
            return new CraftItemStack(stack.handle == null ? null : stack.handle.m());
        }
        return new CraftItemStack(original);
    }

    public static CraftItemStack asNewCraftStack(adb item) {
        return CraftItemStack.asNewCraftStack(item, 1);
    }

    public static CraftItemStack asNewCraftStack(adb item, int amount) {
        return new CraftItemStack(CraftMagicNumbers.getMaterial(item), amount, 0, null);
    }

    private CraftItemStack(add item) {
        this.handle = item;
    }

    private CraftItemStack(ItemStack item) {
        this(item.getTypeId(), item.getAmount(), item.getDurability(), item.hasItemMeta() ? item.getItemMeta() : null);
    }

    private CraftItemStack(Material type, int amount, short durability, ItemMeta itemMeta) {
        this.setType(type);
        this.setAmount(amount);
        this.setDurability(durability);
        this.setItemMeta(itemMeta);
    }

    private CraftItemStack(int typeId, int amount, short durability, ItemMeta itemMeta) {
        this(Material.getMaterial(typeId), amount, durability, itemMeta);
    }

    @Override
    public int getTypeId() {
        return this.handle != null ? CraftMagicNumbers.getId(this.handle.b()) : 0;
    }

    @Override
    public void setTypeId(int type) {
        if (this.getTypeId() == type) {
            return;
        }
        if (type == 0) {
            this.handle = null;
        } else if (CraftMagicNumbers.getItem(type) == null) {
            this.handle = null;
        } else if (this.handle == null) {
            this.handle = new add(CraftMagicNumbers.getItem(type), 1, 0);
        } else {
            this.handle.a(CraftMagicNumbers.getItem(type));
            if (this.hasItemMeta()) {
                CraftItemStack.setItemMeta(this.handle, CraftItemStack.getItemMeta(this.handle));
            }
        }
        this.setData(null);
    }

    @Override
    public int getAmount() {
        return this.handle != null ? this.handle.b : 0;
    }

    @Override
    public void setAmount(int amount) {
        if (this.handle == null) {
            return;
        }
        if (amount == 0) {
            this.handle = null;
        } else {
            this.handle.b = amount;
        }
    }

    @Override
    public void setDurability(short durability) {
        if (this.handle != null) {
            this.handle.b((int)durability);
        }
    }

    @Override
    public short getDurability() {
        if (this.handle != null) {
            return (short)this.handle.k();
        }
        return -1;
    }

    @Override
    public int getMaxStackSize() {
        return this.handle == null ? Material.AIR.getMaxStackSize() : this.handle.b().getItemStackLimit(this.handle);
    }

    @Override
    public void addUnsafeEnchantment(Enchantment ench, int level) {
        Validate.notNull((Object)ench, (String)"Cannot add null enchantment");
        if (!CraftItemStack.makeTag(this.handle)) {
            return;
        }
        dq list = CraftItemStack.getEnchantmentList(this.handle);
        if (list == null) {
            list = new dq();
            this.handle.d.a(CraftMetaItem.ENCHANTMENTS.NBT, (dy)list);
        }
        int size = list.c();
        for (int i = 0; i < size; ++i) {
            dh tag = list.b(i);
            short id = tag.e(CraftMetaItem.ENCHANTMENTS_ID.NBT);
            if (id != ench.getId()) continue;
            tag.a(CraftMetaItem.ENCHANTMENTS_LVL.NBT, (short)level);
            return;
        }
        dh tag = new dh();
        tag.a(CraftMetaItem.ENCHANTMENTS_ID.NBT, (short)ench.getId());
        tag.a(CraftMetaItem.ENCHANTMENTS_LVL.NBT, (short)level);
        list.a((dy)tag);
    }

    static boolean makeTag(add item) {
        if (item == null) {
            return false;
        }
        if (item.d == null) {
            item.d(new dh());
        }
        return true;
    }

    @Override
    public boolean containsEnchantment(Enchantment ench) {
        return this.getEnchantmentLevel(ench) > 0;
    }

    @Override
    public int getEnchantmentLevel(Enchantment ench) {
        Validate.notNull((Object)ench, (String)"Cannot find null enchantment");
        if (this.handle == null) {
            return 0;
        }
        return afv.a((int)ench.getId(), (add)this.handle);
    }

    @Override
    public int removeEnchantment(Enchantment ench) {
        int i;
        Validate.notNull((Object)ench, (String)"Cannot remove null enchantment");
        dq list = CraftItemStack.getEnchantmentList(this.handle);
        if (list == null) {
            return 0;
        }
        int index = Integer.MIN_VALUE;
        int level = Integer.MIN_VALUE;
        int size = list.c();
        for (i = 0; i < size; ++i) {
            dh enchantment = list.b(i);
            int id = 0xFFFF & enchantment.e(CraftMetaItem.ENCHANTMENTS_ID.NBT);
            if (id != ench.getId()) continue;
            index = i;
            level = 0xFFFF & enchantment.e(CraftMetaItem.ENCHANTMENTS_LVL.NBT);
            break;
        }
        if (index == Integer.MIN_VALUE) {
            return 0;
        }
        if (size == 1) {
            this.handle.d.o(CraftMetaItem.ENCHANTMENTS.NBT);
            if (this.handle.d.d()) {
                this.handle.d = null;
            }
            return level;
        }
        dq listCopy = new dq();
        for (i = 0; i < size; ++i) {
            if (i == index) continue;
            listCopy.a((dy)list.b(i));
        }
        this.handle.d.a(CraftMetaItem.ENCHANTMENTS.NBT, (dy)listCopy);
        return level;
    }

    @Override
    public Map<Enchantment, Integer> getEnchantments() {
        return CraftItemStack.getEnchantments(this.handle);
    }

    static Map<Enchantment, Integer> getEnchantments(add item) {
        dq list;
        dq dq2 = list = item != null && item.y() ? item.r() : null;
        if (list == null || list.c() == 0) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (int i = 0; i < list.c(); ++i) {
            int id = 0xFFFF & list.b(i).e(CraftMetaItem.ENCHANTMENTS_ID.NBT);
            int level = 0xFFFF & list.b(i).e(CraftMetaItem.ENCHANTMENTS_LVL.NBT);
            result.put((Object)Enchantment.getById(id), (Object)level);
        }
        return result.build();
    }

    static dq getEnchantmentList(add item) {
        return item != null && item.y() ? item.r() : null;
    }

    @Override
    public CraftItemStack clone() {
        CraftItemStack itemStack = (CraftItemStack)super.clone();
        if (this.handle != null) {
            itemStack.handle = this.handle.m();
        }
        return itemStack;
    }

    @Override
    public ItemMeta getItemMeta() {
        return CraftItemStack.getItemMeta(this.handle);
    }

    public static ItemMeta getItemMeta(add item) {
        if (!CraftItemStack.hasItemMeta(item)) {
            return CraftItemFactory.instance().getItemMeta(CraftItemStack.getType(item));
        }
        switch (CraftItemStack.getType(item)) {
            case WRITTEN_BOOK: 
            case BOOK_AND_QUILL: {
                return new CraftMetaBook(item.d);
            }
            case SKULL_ITEM: {
                return new CraftMetaSkull(item.d);
            }
            case LEATHER_HELMET: 
            case LEATHER_CHESTPLATE: 
            case LEATHER_LEGGINGS: 
            case LEATHER_BOOTS: {
                return new CraftMetaLeatherArmor(item.d);
            }
            case POTION: {
                return new CraftMetaPotion(item.d);
            }
            case MAP: {
                return new CraftMetaMap(item.d);
            }
            case FIREWORK: {
                return new CraftMetaFirework(item.d);
            }
            case FIREWORK_CHARGE: {
                return new CraftMetaCharge(item.d);
            }
            case ENCHANTED_BOOK: {
                return new CraftMetaEnchantedBook(item.d);
            }
        }
        return new CraftMetaItem(item.d);
    }

    static Material getType(add item) {
        Material material = Material.getMaterial(item == null ? 0 : CraftMagicNumbers.getId(item.b()));
        return material == null ? Material.AIR : material;
    }

    @Override
    public boolean setItemMeta(ItemMeta itemMeta) {
        return CraftItemStack.setItemMeta(this.handle, itemMeta);
    }

    public static boolean setItemMeta(add item, ItemMeta itemMeta) {
        if (item == null) {
            return false;
        }
        if (CraftItemFactory.instance().equals(itemMeta, null)) {
            item.d = null;
            return true;
        }
        if (!CraftItemFactory.instance().isApplicable(itemMeta, CraftItemStack.getType(item))) {
            return false;
        }
        if (item.d == null) {
            item.d = new dh();
        }
        ((CraftMetaItem)itemMeta).applyToItem(item.d);
        return true;
    }

    @Override
    public boolean isSimilar(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack == this) {
            return true;
        }
        if (!(stack instanceof CraftItemStack)) {
            return stack.getClass() == ItemStack.class && stack.isSimilar(this);
        }
        CraftItemStack that = (CraftItemStack)stack;
        if (this.handle == that.handle) {
            return true;
        }
        if (this.handle == null || that.handle == null) {
            return false;
        }
        if (that.getTypeId() != this.getTypeId() || this.getDurability() != that.getDurability()) {
            return false;
        }
        return this.hasItemMeta() ? that.hasItemMeta() && this.handle.d.equals((Object)that.handle.d) : !that.hasItemMeta();
    }

    @Override
    public boolean hasItemMeta() {
        return CraftItemStack.hasItemMeta(this.handle);
    }

    static boolean hasItemMeta(add item) {
        return item != null && item.d != null && !item.d.d();
    }
}

