/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_7_R4.inventory;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_7_R4.inventory.CraftMetaItem;
import org.bukkit.inventory.meta.FireworkMeta;

@DelegateDeserialization(value=CraftMetaItem.SerializableMeta.class)
class CraftMetaFirework
extends CraftMetaItem
implements FireworkMeta {
    static final CraftMetaItem.ItemMetaKey FIREWORKS = new CraftMetaItem.ItemMetaKey("Fireworks");
    static final CraftMetaItem.ItemMetaKey FLIGHT = new CraftMetaItem.ItemMetaKey("Flight", "power");
    static final CraftMetaItem.ItemMetaKey EXPLOSIONS = new CraftMetaItem.ItemMetaKey("Explosions", "firework-effects");
    static final CraftMetaItem.ItemMetaKey EXPLOSION_COLORS = new CraftMetaItem.ItemMetaKey("Colors");
    static final CraftMetaItem.ItemMetaKey EXPLOSION_TYPE = new CraftMetaItem.ItemMetaKey("Type");
    static final CraftMetaItem.ItemMetaKey EXPLOSION_TRAIL = new CraftMetaItem.ItemMetaKey("Trail");
    static final CraftMetaItem.ItemMetaKey EXPLOSION_FLICKER = new CraftMetaItem.ItemMetaKey("Flicker");
    static final CraftMetaItem.ItemMetaKey EXPLOSION_FADE = new CraftMetaItem.ItemMetaKey("FadeColors");
    private List<FireworkEffect> effects;
    private int power;

    CraftMetaFirework(CraftMetaItem meta) {
        super(meta);
        if (!(meta instanceof CraftMetaFirework)) {
            return;
        }
        CraftMetaFirework that = (CraftMetaFirework)meta;
        this.power = that.power;
        if (that.hasEffects()) {
            this.effects = new ArrayList<FireworkEffect>(that.effects);
        }
    }

    CraftMetaFirework(dh tag) {
        super(tag);
        if (!tag.c(CraftMetaFirework.FIREWORKS.NBT)) {
            return;
        }
        dh fireworks = tag.m(CraftMetaFirework.FIREWORKS.NBT);
        this.power = 0xFF & fireworks.d(CraftMetaFirework.FLIGHT.NBT);
        if (!fireworks.c(CraftMetaFirework.EXPLOSIONS.NBT)) {
            return;
        }
        dq fireworkEffects = fireworks.c(CraftMetaFirework.EXPLOSIONS.NBT, 10);
        this.effects = new ArrayList<FireworkEffect>(fireworkEffects.c());
        ArrayList<FireworkEffect> effects = this.effects;
        for (int i = 0; i < fireworkEffects.c(); ++i) {
            effects.add(CraftMetaFirework.getEffect(fireworkEffects.b(i)));
        }
    }

    static FireworkEffect getEffect(dh explosion) {
        FireworkEffect.Builder effect = FireworkEffect.builder().flicker(explosion.n(CraftMetaFirework.EXPLOSION_FLICKER.NBT)).trail(explosion.n(CraftMetaFirework.EXPLOSION_TRAIL.NBT)).with(CraftMetaFirework.getEffectType(0xFF & explosion.d(CraftMetaFirework.EXPLOSION_TYPE.NBT)));
        for (int color : explosion.l(CraftMetaFirework.EXPLOSION_COLORS.NBT)) {
            effect.withColor(Color.fromRGB(color));
        }
        for (int color : explosion.l(CraftMetaFirework.EXPLOSION_FADE.NBT)) {
            effect.withFade(Color.fromRGB(color));
        }
        return effect.build();
    }

    static dh getExplosion(FireworkEffect effect) {
        dh explosion = new dh();
        if (effect.hasFlicker()) {
            explosion.a(CraftMetaFirework.EXPLOSION_FLICKER.NBT, true);
        }
        if (effect.hasTrail()) {
            explosion.a(CraftMetaFirework.EXPLOSION_TRAIL.NBT, true);
        }
        CraftMetaFirework.addColors(explosion, EXPLOSION_COLORS, effect.getColors());
        CraftMetaFirework.addColors(explosion, EXPLOSION_FADE, effect.getFadeColors());
        explosion.a(CraftMetaFirework.EXPLOSION_TYPE.NBT, (byte)CraftMetaFirework.getNBT(effect.getType()));
        return explosion;
    }

    static int getNBT(FireworkEffect.Type type) {
        switch (type) {
            case BALL: {
                return 0;
            }
            case BALL_LARGE: {
                return 1;
            }
            case STAR: {
                return 2;
            }
            case CREEPER: {
                return 3;
            }
            case BURST: {
                return 4;
            }
        }
        throw new IllegalStateException(type.toString());
    }

    static FireworkEffect.Type getEffectType(int nbt) {
        switch (nbt) {
            case 0: {
                return FireworkEffect.Type.BALL;
            }
            case 1: {
                return FireworkEffect.Type.BALL_LARGE;
            }
            case 2: {
                return FireworkEffect.Type.STAR;
            }
            case 3: {
                return FireworkEffect.Type.CREEPER;
            }
            case 4: {
                return FireworkEffect.Type.BURST;
            }
        }
        throw new IllegalStateException(Integer.toString(nbt));
    }

    CraftMetaFirework(Map<String, Object> map) {
        super(map);
        Integer power = CraftMetaItem.SerializableMeta.getObject(Integer.class, map, CraftMetaFirework.FLIGHT.BUKKIT, true);
        if (power != null) {
            this.setPower(power);
        }
        Iterable effects = CraftMetaItem.SerializableMeta.getObject(Iterable.class, map, CraftMetaFirework.EXPLOSIONS.BUKKIT, true);
        this.safelyAddEffects(effects);
    }

    @Override
    public boolean hasEffects() {
        return this.effects != null && !this.effects.isEmpty();
    }

    void safelyAddEffects(Iterable<?> collection) {
        if (collection == null || collection instanceof Collection && ((Collection)collection).isEmpty()) {
            return;
        }
        List<FireworkEffect> effects = this.effects;
        if (effects == null) {
            effects = this.effects = new ArrayList<FireworkEffect>();
        }
        for (Object obj : collection) {
            if (obj instanceof FireworkEffect) {
                effects.add((FireworkEffect)obj);
                continue;
            }
            throw new IllegalArgumentException(obj + " in " + collection + " is not a FireworkEffect");
        }
    }

    @Override
    void applyToItem(dh itemTag) {
        super.applyToItem(itemTag);
        if (this.isFireworkEmpty()) {
            return;
        }
        dh fireworks = itemTag.m(CraftMetaFirework.FIREWORKS.NBT);
        itemTag.a(CraftMetaFirework.FIREWORKS.NBT, (dy)fireworks);
        if (this.hasEffects()) {
            dq effects = new dq();
            for (FireworkEffect effect : this.effects) {
                effects.a((dy)CraftMetaFirework.getExplosion(effect));
            }
            if (effects.c() > 0) {
                fireworks.a(CraftMetaFirework.EXPLOSIONS.NBT, (dy)effects);
            }
        }
        if (this.hasPower()) {
            fireworks.a(CraftMetaFirework.FLIGHT.NBT, (byte)this.power);
        }
    }

    static void addColors(dh compound, CraftMetaItem.ItemMetaKey key, List<Color> colors) {
        if (colors.isEmpty()) {
            return;
        }
        int[] colorArray = new int[colors.size()];
        int i = 0;
        for (Color color : colors) {
            colorArray[i++] = color.asRGB();
        }
        compound.a(key.NBT, colorArray);
    }

    @Override
    boolean applicableTo(Material type) {
        switch (type) {
            case FIREWORK: {
                return true;
            }
        }
        return false;
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isFireworkEmpty();
    }

    boolean isFireworkEmpty() {
        return !this.hasEffects() && !this.hasPower();
    }

    boolean hasPower() {
        return this.power != 0;
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaFirework) {
            CraftMetaFirework that = (CraftMetaFirework)meta;
            return (this.hasPower() ? that.hasPower() && this.power == that.power : !that.hasPower()) && (this.hasEffects() ? that.hasEffects() && this.effects.equals(that.effects) : !that.hasEffects());
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaFirework || this.isFireworkEmpty());
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.hasPower()) {
            hash = 61 * hash + this.power;
        }
        if (this.hasEffects()) {
            hash = 61 * hash + 13 * this.effects.hashCode();
        }
        return hash != original ? CraftMetaFirework.class.hashCode() ^ hash : hash;
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        if (this.hasEffects()) {
            builder.put((Object)CraftMetaFirework.EXPLOSIONS.BUKKIT, (Object)ImmutableList.copyOf(this.effects));
        }
        if (this.hasPower()) {
            builder.put((Object)CraftMetaFirework.FLIGHT.BUKKIT, (Object)this.power);
        }
        return builder;
    }

    @Override
    public CraftMetaFirework clone() {
        CraftMetaFirework meta = (CraftMetaFirework)super.clone();
        if (this.effects != null) {
            meta.effects = new ArrayList<FireworkEffect>(this.effects);
        }
        return meta;
    }

    @Override
    public void addEffect(FireworkEffect effect) {
        Validate.notNull((Object)effect, (String)"Effect cannot be null");
        if (this.effects == null) {
            this.effects = new ArrayList<FireworkEffect>();
        }
        this.effects.add(effect);
    }

    @Override
    public void addEffects(FireworkEffect ... effects) {
        Validate.notNull((Object)effects, (String)"Effects cannot be null");
        if (effects.length == 0) {
            return;
        }
        List<FireworkEffect> list = this.effects;
        if (list == null) {
            list = this.effects = new ArrayList<FireworkEffect>();
        }
        for (FireworkEffect effect : effects) {
            Validate.notNull((Object)effect, (String)"Effect cannot be null");
            list.add(effect);
        }
    }

    @Override
    public void addEffects(Iterable<FireworkEffect> effects) {
        Validate.notNull(effects, (String)"Effects cannot be null");
        this.safelyAddEffects(effects);
    }

    @Override
    public List<FireworkEffect> getEffects() {
        return this.effects == null ? ImmutableList.of() : ImmutableList.copyOf(this.effects);
    }

    @Override
    public int getEffectsSize() {
        return this.effects == null ? 0 : this.effects.size();
    }

    @Override
    public void removeEffect(int index) {
        if (this.effects == null) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: 0");
        }
        this.effects.remove(index);
    }

    @Override
    public void clearEffects() {
        this.effects = null;
    }

    @Override
    public int getPower() {
        return this.power;
    }

    @Override
    public void setPower(int power) {
        Validate.isTrue((power >= 0 ? 1 : 0) != 0, (String)"Power cannot be less than zero: ", (long)power);
        Validate.isTrue((power < 128 ? 1 : 0) != 0, (String)"Power cannot be more than 127: ", (long)power);
        this.power = power;
    }
}

