/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.cauldron.CauldronHooks;
import org.bukkit.Bukkit;
import org.spigotmc.RestartCommand;

public class WatchdogThread
extends Thread {
    private static WatchdogThread instance;
    private final long timeoutTime;
    private final long warningTime;
    private final boolean restart;
    private volatile long lastTick;
    private volatile boolean stopping;
    private volatile long lastWarning;

    private WatchdogThread(long timeoutTime, boolean restart) {
        super("Spigot Watchdog Thread");
        this.timeoutTime = timeoutTime;
        this.warningTime = Math.max(timeoutTime / 3L, 5000L);
        this.restart = restart;
    }

    public static void doStart(int timeoutTime, boolean restart) {
        if (instance == null) {
            instance = new WatchdogThread((long)timeoutTime * 1000L, restart);
            instance.start();
        }
    }

    public static void tick() {
        WatchdogThread.instance.lastTick = System.currentTimeMillis();
    }

    public static void doStop() {
        if (instance != null) {
            WatchdogThread.instance.stopping = true;
        }
    }

    @Override
    public void run() {
        while (!this.stopping) {
            double tps;
            Logger log;
            long currentTime = System.currentTimeMillis();
            if (this.lastTick != 0L && currentTime > this.lastTick + this.timeoutTime) {
                ThreadInfo[] threads;
                File file;
                log = Bukkit.getServer().getLogger();
                log.log(Level.SEVERE, "The server has stopped responding!");
                log.log(Level.SEVERE, "Please report this to https://github.com/CyberdyneCC/Thermos/issues");
                log.log(Level.SEVERE, "Be sure to include ALL relevant console errors and Minecraft crash reports");
                log.log(Level.SEVERE, "Cauldron version: " + Bukkit.getServer().getVersion());
                log.log(Level.SEVERE, "The server is going slow. Last server tick was " + (currentTime - this.lastTick) + "ms ago");
                tps = Math.min(20.0, (double)Math.round(MinecraftServer.currentTps * 10.0) / 10.0);
                log.log(Level.SEVERE, "Last Tick: " + this.lastTick + " Current Time: " + currentTime + " Warning: " + this.warningTime + " Timeout: " + this.timeoutTime);
                log.log(Level.SEVERE, "[TPS]: " + tps + " Server Tick #" + MinecraftServer.I().al());
                log.log(Level.SEVERE, "Last recorded TPS: " + tps);
                log.log(Level.SEVERE, "------------------------------");
                log.log(Level.SEVERE, "Loaded dimensions:");
                for (ThreadInfo[] world : MinecraftServer.I().worlds) {
                    log.log(Level.SEVERE, "  Dimension:" + world.t.i);
                    log.log(Level.SEVERE, "  Loaded Chunks: " + world.b.loadedChunkHashMap_KC.rawThermos().size() + " Active Chunks: " + world.F.size() + " Entities: " + world.e.size() + " Tile Entities: " + world.g.size());
                    log.log(Level.SEVERE, "  Entities Last Tick: " + world.entitiesTicked);
                    log.log(Level.SEVERE, "  Tiles Last Tick: " + world.tilesTicked);
                }
                log.log(Level.SEVERE, "------------------------------");
                MinecraftServer.I();
                if (MinecraftServer.cauldronConfig.dumpChunksOnDeadlock.getValue().booleanValue()) {
                    file = new File(new File(new File("."), "crash-reports"), "watchdog-chunks-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
                    log.log(Level.SEVERE, "------------------------------");
                    log.log(Level.SEVERE, "Writing watchdog detailed info to: " + file);
                    CauldronHooks.writeChunks(file, false);
                    log.log(Level.SEVERE, "Writing complete");
                    log.log(Level.SEVERE, "------------------------------");
                }
                MinecraftServer.I();
                if (MinecraftServer.cauldronConfig.dumpHeapOnDeadlock.getValue().booleanValue()) {
                    file = new File(new File(new File("."), "crash-reports"), "watchdog-heap-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.bin");
                    log.log(Level.SEVERE, "------------------------------");
                    log.log(Level.SEVERE, "Writing heap dump to: " + file);
                    CauldronHooks.dumpHeap(file, true);
                    log.log(Level.SEVERE, "Writing complete");
                    log.log(Level.SEVERE, "------------------------------");
                }
                log.log(Level.SEVERE, "------------------------------");
                log.log(Level.SEVERE, "Server thread dump (Look for plugins here before reporting to Cauldron!):");
                WatchdogThread.dumpThread(ManagementFactory.getThreadMXBean().getThreadInfo(MinecraftServer.I().primaryThread.getId(), Integer.MAX_VALUE), log);
                log.log(Level.SEVERE, "------------------------------");
                log.log(Level.SEVERE, "Entire Thread Dump:");
                for (ThreadInfo thread : threads = ManagementFactory.getThreadMXBean().dumpAllThreads(true, true)) {
                    WatchdogThread.dumpThread(thread, log);
                }
                log.log(Level.SEVERE, "------------------------------");
                if (!this.restart) break;
                RestartCommand.restart();
                break;
            }
            if (this.lastTick != 0L && System.currentTimeMillis() > this.lastTick + this.warningTime) {
                log = Bukkit.getServer().getLogger();
                this.lastWarning = System.currentTimeMillis();
                log.log(Level.WARNING, "The server is going slow. Last server tick was " + (System.currentTimeMillis() - this.lastTick) + "ms ago");
                tps = Math.min(20.0, (double)Math.round(MinecraftServer.currentTps * 10.0) / 10.0);
                log.log(Level.WARNING, "Last Tick: " + this.lastTick + " Current Time: " + currentTime + " Warning: " + this.warningTime + " Timeout: " + this.timeoutTime);
                log.log(Level.WARNING, "[TPS]: " + tps + " Server Tick #" + MinecraftServer.I().al());
                for (ThreadInfo[] world : MinecraftServer.I().worlds) {
                    log.log(Level.WARNING, "  Dimension:" + world.t.i);
                    log.log(Level.WARNING, "  Loaded Chunks: " + world.b.loadedChunkHashMap_KC.rawThermos().size() + " Active Chunks: " + world.F.size() + " Entities: " + world.e.size() + " Tile Entities: " + world.g.size());
                    log.log(Level.WARNING, "  Entities Last Tick: " + world.entitiesTicked);
                    log.log(Level.WARNING, "  Tiles Last Tick: " + world.tilesTicked);
                }
                MinecraftServer.I();
                if (MinecraftServer.cauldronConfig.dumpThreadsOnWarn.getValue().booleanValue()) {
                    log.log(Level.WARNING, "Server thread dump (Look for mods or plugins here before reporting to Cauldron!):");
                    WatchdogThread.dumpThread(ManagementFactory.getThreadMXBean().getThreadInfo(MinecraftServer.I().primaryThread.getId(), Integer.MAX_VALUE), log, Level.WARNING);
                }
            }
            try {
                WatchdogThread.sleep(10000L);
            }
            catch (InterruptedException ex) {
                this.interrupt();
            }
        }
    }

    private static void dumpThread(ThreadInfo thread, Logger log) {
        WatchdogThread.dumpThread(thread, log, Level.SEVERE);
    }

    private static void dumpThread(ThreadInfo thread, Logger log, Level level) {
        if (thread == null) {
            return;
        }
        if (thread.getThreadState() != Thread.State.WAITING) {
            log.log(level, "------------------------------");
            log.log(level, "Current Thread: " + thread.getThreadName());
            log.log(level, "\tPID: " + thread.getThreadId() + " | Suspended: " + thread.isSuspended() + " | Native: " + thread.isInNative() + " | State: " + (Object)((Object)thread.getThreadState()) + " | Blocked Time: " + thread.getBlockedTime() + " | Blocked Count: " + thread.getBlockedCount());
            if (thread.getLockedMonitors().length != 0) {
                log.log(level, "\tThread is waiting on monitor(s):");
                for (MonitorInfo monitor : thread.getLockedMonitors()) {
                    log.log(level, "\t\tLocked on:" + monitor.getLockedStackFrame());
                }
            }
            if (thread.getLockOwnerId() != -1L) {
                log.log(level, "\tLock Owner Id: " + thread.getLockOwnerId());
            }
            log.log(level, "\tStack:");
            StackTraceElement[] stack = thread.getStackTrace();
            for (int line = 0; line < stack.length; ++line) {
                log.log(level, "\t\t" + stack[line].toString());
            }
        }
    }
}

