/*
 * Decompiled with CFR 0.152.
 */
package thermos;

import cpw.mods.fml.common.FMLLog;
import org.apache.logging.log4j.Level;

public class TLog {
    private static final TLog DEFAULT_LOGGER = new TLog("Thermos");
    private final String mTag;

    public static TLog get() {
        return DEFAULT_LOGGER;
    }

    public static TLog get(String tag) {
        return new TLog("Thermos: " + tag);
    }

    public TLog(String tag) {
        this.mTag = tag;
    }

    public void log(Level level, Throwable throwable, String message, Object ... args) {
        Throwable t = null;
        if (throwable != null) {
            t = new Throwable();
            t.initCause(throwable);
            t.fillInStackTrace();
        }
        FMLLog.log(this.mTag, level, t, String.format(message, args), new Object[0]);
    }

    public void warning(String message, Object ... args) {
        this.log(Level.WARN, null, message, args);
    }

    public void warning(Throwable throwable, String message, Object ... args) {
        this.log(Level.WARN, throwable, message, args);
    }

    public void info(String message, Object ... args) {
        this.log(Level.INFO, null, message, args);
    }

    public void info(Throwable throwable, String message, Object ... args) {
        this.log(Level.INFO, throwable, message, args);
    }
}

