/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.imagine.fan;

import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ModClassLoader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.discovery.ModCandidate;
import cpw.mods.fml.common.event.FMLConstructionEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import pw.prok.imagine.fan.Fan;
import pw.prok.imagine.inject.Injector;

public class FanEventHandler {
    private final ModCandidate mCandidate;
    private final ModContainer mContainer;
    private final Object mMod;
    private final Fan mFan;

    public FanEventHandler(ModCandidate candidate, ModContainer container, Object mod, Fan fan) {
        this.mCandidate = candidate;
        this.mContainer = container;
        this.mMod = mod;
        this.mFan = fan;
    }

    @Subscribe
    public void constructMod(FMLConstructionEvent event) {
        try {
            ModClassLoader modClassLoader = event.getModClassLoader();
            modClassLoader.addFile(this.mContainer.getSource());
            modClassLoader.clearNegativeCacheFor(this.mCandidate.getClassList());
            NetworkRegistry.INSTANCE.register(this.mContainer, this.mContainer.getClass(), null, event.getASMHarvestedData());
            Injector.inject(this.mMod, Injector.Phase.Construct, FMLCommonHandler.instance().getSide());
        }
        catch (Throwable e) {
            throw new IllegalStateException("Cannot construct fan", e);
        }
    }

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        Injector.inject(this.mMod, Injector.Phase.PreInit, event);
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        Injector.inject(this.mMod, Injector.Phase.Init, event);
    }

    @Subscribe
    public void postInit(FMLPostInitializationEvent event) {
        Injector.inject(this.mMod, Injector.Phase.PostInit, event);
    }
}

