/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.imagine.fan;

import java.util.HashMap;
import java.util.Map;
import pw.prok.imagine.fan.Fan;
import pw.prok.imagine.fan.FanData;
import pw.prok.imagine.inject.Creator;

public class FanLoader {
    private static Map<Class<?>, FanHolder<?>> sFanMap = new HashMap();
    private static State sState = State.Unloaded;

    public static <T> void loadFan(Class<T> fanClass) {
        if (sState != State.Unloaded) {
            throw new IllegalStateException("Attempt to load fan after initializing!");
        }
        Fan fanData = fanClass.getAnnotation(Fan.class);
        if (fanData == null) {
            throw new IllegalArgumentException("Illegal fan! No fan data found");
        }
        FanHolder holder = new FanHolder();
        holder.fan = Creator.creator(fanClass).build();
        holder.fanData = new FanData(fanData);
        holder.state = State.Unloaded;
        sFanMap.put(fanClass, holder);
    }

    public static void migrate(State state) {
        switch (state) {
            case Unloaded: {
                throw new IllegalArgumentException("Could not migrate to unloaded state!");
            }
            case Found: {
                break;
            }
        }
        sState = state;
        for (FanHolder<?> holder : sFanMap.values()) {
            ((FanHolder)holder).state = state;
        }
    }

    public static <T> T getFan(Class<T> clazz) {
        FanHolder<?> holder = sFanMap.get(clazz);
        return (T)(holder != null ? ((FanHolder)holder).fan : null);
    }

    public static enum State {
        Unloaded,
        Found,
        Loaded,
        PreInitialized,
        Initialized,
        PostInitialized,
        Error;

    }

    private static class FanHolder<T> {
        private FanData fanData;
        private T fan;
        private State state;

        private FanHolder() {
        }
    }
}

