/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.imagine.fastdiscover;

import cpw.mods.fml.common.FMLLog;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.launchwrapper.LaunchClassLoader;
import pw.prok.imagine.fan.Fan;
import pw.prok.imagine.fastdiscover.DirCandidate;
import pw.prok.imagine.fastdiscover.DiscoverCandidate;
import pw.prok.imagine.fastdiscover.JarCandidate;
import pw.prok.imagine.fastdiscover.dd.DataScanner;
import pw.prok.imagine.fastdiscover.dd.DiscoverData;

public class FastDiscoverer
implements DataScanner.DataScannerCallback {
    public static final DiscoverData DISCOVER_DATA = new DiscoverData();
    public static final DataScanner DATA_SCANNER = new DataScanner(DISCOVER_DATA, new FastDiscoverer());
    private static final FileFilter JAR_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return FastDiscoverer.isFileValid(file);
        }
    };
    private static final FileFilter DIR_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return FastDiscoverer.isDirValid(file);
        }
    };
    private static boolean sNeedInjection;

    private static boolean isDirValid(File file) {
        if (!file.isDirectory()) {
            return false;
        }
        File metaInf = new File(file, "META-INF");
        return metaInf.exists() && metaInf.isDirectory();
    }

    private static boolean isFileValid(File file) {
        return file.isFile() && (file.getName().endsWith(".jar") || file.getName().endsWith(".zip"));
    }

    public static void discoverClassloader(LaunchClassLoader loader, DataScanner scanner) {
        LinkedList<DiscoverCandidate> candidates = new LinkedList<DiscoverCandidate>();
        for (URL url : loader.getSources()) {
            try {
                File file = new File(url.toURI());
                if (!file.exists()) continue;
                if (file.isDirectory() && FastDiscoverer.isDirValid(file)) {
                    candidates.add(new DirCandidate(file, false));
                    continue;
                }
                if (!file.isFile() || !FastDiscoverer.isFileValid(file)) continue;
                candidates.add(new JarCandidate(file, false));
            }
            catch (Exception exception) {}
        }
        FastDiscoverer.scan(loader, candidates, scanner);
    }

    public static void discover(LaunchClassLoader loader, File mcHome, String mcVersion, DataScanner scanner) {
        File versionModsDir;
        LinkedList<DiscoverCandidate> candidates = new LinkedList<DiscoverCandidate>();
        File modsDir = new File(mcHome, "mods");
        if (modsDir.exists() && modsDir.isDirectory()) {
            FastDiscoverer.scanDir(modsDir, candidates);
        }
        if ((versionModsDir = new File(modsDir, mcVersion)).exists() && versionModsDir.isDirectory()) {
            FastDiscoverer.scanDir(versionModsDir, candidates);
        }
        FastDiscoverer.scan(loader, candidates, scanner);
    }

    private static void scanDir(File dir, List<DiscoverCandidate> candidates) {
        File[] files = dir.listFiles(JAR_FILTER);
        if (files != null && files.length > 0) {
            for (File file : files) {
                candidates.add(new JarCandidate(file, true));
            }
        }
        if ((files = dir.listFiles(DIR_FILTER)) != null && files.length > 0) {
            for (File file : files) {
                candidates.add(new DirCandidate(file, true));
            }
        }
    }

    private static void scan(LaunchClassLoader loader, List<DiscoverCandidate> candidates, DataScanner scanner) {
        for (DiscoverCandidate candidate : candidates) {
            sNeedInjection = false;
            for (InputStream is : candidate) {
                scanner.scanClass(is);
            }
            if (!sNeedInjection) continue;
            FMLLog.info((String)("Found Fan in " + candidate + ", injecting into classloader..."), (Object[])new Object[0]);
            candidate.injectClassLoader(loader);
        }
    }

    @Override
    public void annotationResult(String className, Set<String> annotations) {
        sNeedInjection = annotations.contains(Fan.class.getName());
    }
}

