/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.imagine.fastdiscover.dd;

import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import pw.prok.imagine.fastdiscover.dd.DiscoverData;

public class DataScanner
extends ClassVisitor {
    private final DiscoverData mData;
    private String mClassName;
    private final Set<String> mAnnotations = new HashSet<String>();
    private final DataScannerCallback mCallback;

    public DataScanner(DiscoverData data, DataScannerCallback callback) {
        super(327680);
        this.mData = data;
        this.mCallback = callback;
    }

    public void scanClass(InputStream is) {
        try {
            ClassReader reader = new ClassReader(is);
            reader.accept((ClassVisitor)this, 7);
            is.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.mClassName = name.replace('/', '.');
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.mAnnotations.add(desc.substring(1, desc.length() - 1).replace('/', '.'));
        return super.visitAnnotation(desc, visible);
    }

    public void visitEnd() {
        if (this.mAnnotations.size() > 0) {
            this.mData.putAnnotations(this.mClassName, this.mAnnotations);
        }
        if (this.mCallback != null) {
            this.mCallback.annotationResult(this.mClassName, this.mAnnotations);
        }
        this.mClassName = null;
        this.mAnnotations.clear();
    }

    public static interface DataScannerCallback {
        public void annotationResult(String var1, Set<String> var2);
    }
}

