/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.imagine.inject;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import pw.prok.imagine.inject.Creator;
import pw.prok.imagine.inject.IConstructorBuilder;
import pw.prok.imagine.inject.IInjector;
import pw.prok.imagine.inject.RegisterInjector;
import pw.prok.imagine.util.Array;

public abstract class Injector<State extends InjectorState>
implements IInjector<State> {
    private static final InjectorState[] NULL_STATES = new InjectorState[0];
    private static Map<Phase, Set<IInjector<?>>> sInjectors = new EnumMap(Phase.class);
    private static Map<Phase, Map<Class<?>, InjectorState[]>> sState = new EnumMap(Phase.class);

    public static void registerInjector(Class<? extends IInjector<?>> clazz) {
        IInjector<?> injector = Creator.creator(clazz).build();
        Phase[] phases = clazz.getAnnotation(RegisterInjector.class).value();
        Injector.registerInjector(injector, phases);
    }

    public static void registerInjector(IInjector<?> injector, Phase ... phases) {
        for (Phase phase : phases) {
            Set<IInjector<?>> injectors = sInjectors.get((Object)phase);
            if (injectors == null) {
                injectors = new HashSet();
                sInjectors.put(phase, injectors);
            }
            injectors.add(injector);
            Map<Class<?>, InjectorState[]> states = sState.get((Object)phase);
            if (states == null) {
                states = new HashMap();
                sState.put(phase, states);
            }
            for (Map.Entry<Class<?>, InjectorState[]> entry : states.entrySet()) {
                Object state = injector.parseClass(entry.getKey());
                if (state == null) continue;
                entry.setValue(Array.mergeArrays(entry.getValue(), {state}));
            }
        }
    }

    public static <Type> InjectorState[] queryStates(Class<Type> clazz, Phase phase) {
        InjectorState[] states;
        Map<Class<?>, InjectorState[]> mapStates = sState.get((Object)phase);
        if (mapStates == null) {
            mapStates = new HashMap();
            sState.put(phase, mapStates);
        }
        if ((states = mapStates.get(clazz)) != null) {
            return states;
        }
        Set<IInjector<?>> injectors = sInjectors.get((Object)phase);
        if (injectors != null) {
            HashSet statesSet = new HashSet();
            for (IInjector<Type> iInjector : injectors) {
                Object state = iInjector.parseClass(clazz);
                if (state == null) continue;
                ((InjectorState)state).mInjector = iInjector;
                statesSet.add(state);
            }
            states = statesSet.toArray(new InjectorState[statesSet.size()]);
            mapStates.put(clazz, states);
        } else {
            states = NULL_STATES;
            mapStates.put(clazz, NULL_STATES);
        }
        return states == NULL_STATES ? null : states;
    }

    public static <Type> void inject(Type t, Phase phase, Object ... args) {
        if (t == null) {
            return;
        }
        Injector.injectInternal(t, phase, t.getClass(), args);
    }

    private static <Type> void injectInternal(Type t, Phase phase, Class<?> clazz, Object ... args) {
        InjectorState[] states;
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != Object.class) {
            Injector.injectInternal(t, phase, superclass, args);
        }
        if ((states = Injector.queryStates(t.getClass(), phase)) == null) {
            return;
        }
        for (InjectorState state : states) {
            IInjector injector = state.mInjector;
            if (injector.inject(state, t, args)) continue;
            throw new RuntimeException("Failed to inject into object " + t + " for class state " + clazz);
        }
    }

    @Override
    public <T> IConstructorBuilder<T, ?> create(Class<T> clazz) {
        return Creator.creator(clazz);
    }

    @Override
    public <T> IConstructorBuilder<T, ?> create(String className) {
        return Creator.creator(className);
    }

    public static class InjectorState {
        private IInjector mInjector;
    }

    public static enum Phase {
        Construct,
        PreInit,
        Init,
        PostInit;

    }
}

