/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.imagine.pool;

import java.util.BitSet;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import pw.prok.imagine.pool.Pool;
import pw.prok.imagine.pool.PoolFactory;

public class FixedPool<T>
implements Pool<T> {
    private final T[] mPool;
    private final PoolFactory<T> mFactory;
    private final BitSet mStateBits = new BitSet();
    private final int mMaxCount;
    private int mCount = 0;
    private int mLastPos = 0;
    private volatile Lock mLock = new ReentrantLock(true);

    public FixedPool(PoolFactory<T> factory, int count) {
        this(factory, count, count);
    }

    public FixedPool(PoolFactory<T> factory, int initialCount, int maxCount) {
        this.mFactory = factory;
        this.mMaxCount = maxCount;
        this.mPool = new Object[this.mMaxCount];
        this.mStateBits.clear(0, maxCount);
        this.grow(initialCount);
    }

    private void grow(int count) {
        if (count > this.mMaxCount) {
            count = this.mMaxCount;
        }
        for (int i = this.mCount; i < count; ++i) {
            T object = this.mFactory.create();
            assert (object != null);
            this.mPool[i] = object;
        }
        this.mCount = count;
    }

    @Override
    public T obtain() {
        this.mLock.lock();
        try {
            int i;
            for (i = this.mLastPos; i < this.mMaxCount; ++i) {
                if (this.mStateBits.get(i)) continue;
                this.mLastPos = i;
                this.mStateBits.set(this.mLastPos);
                T t = this.mPool[i];
                return t;
            }
            for (i = 0; i < this.mLastPos; ++i) {
                if (this.mStateBits.get(i)) continue;
                this.mLastPos = i;
                this.mStateBits.set(this.mLastPos);
                T t = this.mPool[i];
                return t;
            }
            if (this.mCount < this.mMaxCount) {
                int index = this.mCount;
                this.grow(this.mCount + 1);
                this.mStateBits.set(index);
                T t = this.mPool[index];
                return t;
            }
            throw new IllegalStateException("No available objects in pool!");
        }
        finally {
            this.mLock.unlock();
        }
    }

    @Override
    public void release(T object) {
        assert (object != null);
        this.mLock.lock();
        try {
            int i;
            for (i = this.mLastPos; i < this.mMaxCount; ++i) {
                if (this.mPool[i] != object) continue;
                this.mStateBits.clear(i);
                return;
            }
            for (i = this.mLastPos; i >= 0; --i) {
                if (this.mPool[i] != object) continue;
                this.mStateBits.clear(i);
                return;
            }
            throw new IllegalStateException("Object not assigned to this pool: " + object);
        }
        finally {
            this.mLock.unlock();
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < FixedPool.this.mMaxCount;
            }

            @Override
            public T next() {
                return FixedPool.this.mPool[this.index++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

