/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.affinity.impl;

public class VersionHelper {
    private static final String DELIM = ".";
    private final int major;
    private final int minor;
    private final int release;

    public VersionHelper(int major_, int minor_, int release_) {
        this.major = major_;
        this.minor = minor_;
        this.release = release_;
    }

    public VersionHelper(String ver) {
        if (ver != null && (ver = ver.trim()).length() > 0) {
            String[] parts = ver.split("\\.");
            this.major = parts.length > 0 ? Integer.parseInt(parts[0]) : 0;
            this.minor = parts.length > 1 ? Integer.parseInt(parts[1]) : 0;
            this.release = parts.length > 2 ? Integer.parseInt(parts[2]) : 0;
        } else {
            this.release = 0;
            this.minor = 0;
            this.major = 0;
        }
    }

    public String toString() {
        return this.major + DELIM + this.minor + DELIM + this.release;
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof VersionHelper) {
            VersionHelper ver = (VersionHelper)o;
            return this.major == ver.major && this.minor == ver.minor && this.release == ver.release;
        }
        return false;
    }

    public int hashCode() {
        return this.major << 16 | this.minor << 8 | this.release;
    }

    public boolean majorMinorEquals(VersionHelper ver) {
        return ver != null && this.major == ver.major && this.minor == ver.minor;
    }

    public boolean isSameOrNewer(VersionHelper ver) {
        return ver != null && this.major >= ver.major && this.minor >= ver.minor && this.release >= ver.release;
    }
}

