/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.Iterators;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Vec3i;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector4f;

public final class Direction
extends Enum<Direction>
implements StringRepresentable {
    public static final /* enum */ Direction DOWN = new Direction(0, 1, -1, "down", AxisDirection.NEGATIVE, Axis.Y, new Vec3i(0, -1, 0));
    public static final /* enum */ Direction UP = new Direction(1, 0, -1, "up", AxisDirection.POSITIVE, Axis.Y, new Vec3i(0, 1, 0));
    public static final /* enum */ Direction NORTH = new Direction(2, 3, 2, "north", AxisDirection.NEGATIVE, Axis.Z, new Vec3i(0, 0, -1));
    public static final /* enum */ Direction SOUTH = new Direction(3, 2, 0, "south", AxisDirection.POSITIVE, Axis.Z, new Vec3i(0, 0, 1));
    public static final /* enum */ Direction WEST = new Direction(4, 5, 1, "west", AxisDirection.NEGATIVE, Axis.X, new Vec3i(-1, 0, 0));
    public static final /* enum */ Direction EAST = new Direction(5, 4, 3, "east", AxisDirection.POSITIVE, Axis.X, new Vec3i(1, 0, 0));
    public static final StringRepresentable.EnumCodec<Direction> f_175356_;
    public static final Codec<Direction> f_194527_;
    private final int f_122339_;
    private final int f_122340_;
    private final int f_122341_;
    private final String f_122342_;
    private final Axis f_122343_;
    private final AxisDirection f_122344_;
    private final Vec3i f_122345_;
    private static final Direction[] f_122346_;
    private static final Direction[] f_122348_;
    private static final Direction[] f_122349_;
    private static final /* synthetic */ Direction[] $VALUES;

    public static Direction[] values() {
        return (Direction[])$VALUES.clone();
    }

    public static Direction valueOf(String p_122439_) {
        return Enum.valueOf(Direction.class, p_122439_);
    }

    private Direction(int p_122356_, int p_122357_, int p_122358_, String p_122359_, AxisDirection p_122360_, Axis p_122361_, Vec3i p_122362_) {
        this.f_122339_ = p_122356_;
        this.f_122341_ = p_122358_;
        this.f_122340_ = p_122357_;
        this.f_122342_ = p_122359_;
        this.f_122343_ = p_122361_;
        this.f_122344_ = p_122360_;
        this.f_122345_ = p_122362_;
    }

    public static Direction[] m_122382_(Entity p_122383_) {
        Direction direction2;
        float f = p_122383_.m_5686_(1.0f) * ((float)Math.PI / 180);
        float f1 = -p_122383_.m_5675_(1.0f) * ((float)Math.PI / 180);
        float f2 = Mth.m_14031_((float)f);
        float f3 = Mth.m_14089_((float)f);
        float f4 = Mth.m_14031_((float)f1);
        float f5 = Mth.m_14089_((float)f1);
        boolean flag = f4 > 0.0f;
        boolean flag1 = f2 < 0.0f;
        boolean flag2 = f5 > 0.0f;
        float f6 = flag ? f4 : -f4;
        float f7 = flag1 ? -f2 : f2;
        float f8 = flag2 ? f5 : -f5;
        float f9 = f6 * f3;
        float f10 = f8 * f3;
        Direction direction = flag ? EAST : WEST;
        Direction direction1 = flag1 ? UP : DOWN;
        Direction direction3 = direction2 = flag2 ? SOUTH : NORTH;
        if (f6 > f8) {
            if (f7 > f9) {
                return Direction.m_122398_(direction1, direction, direction2);
            }
            return f10 > f7 ? Direction.m_122398_(direction, direction2, direction1) : Direction.m_122398_(direction, direction1, direction2);
        }
        if (f7 > f10) {
            return Direction.m_122398_(direction1, direction2, direction);
        }
        return f9 > f7 ? Direction.m_122398_(direction2, direction, direction1) : Direction.m_122398_(direction2, direction1, direction);
    }

    private static Direction[] m_122398_(Direction p_122399_, Direction p_122400_, Direction p_122401_) {
        return new Direction[]{p_122399_, p_122400_, p_122401_, p_122401_.m_122424_(), p_122400_.m_122424_(), p_122399_.m_122424_()};
    }

    public static Direction m_252919_(Matrix4f p_254393_, Direction p_254252_) {
        Vec3i vec3i = p_254252_.m_122436_();
        Vector4f vector4f = p_254393_.transform(new Vector4f((float)vec3i.m_123341_(), (float)vec3i.m_123342_(), (float)vec3i.m_123343_(), 0.0f));
        return Direction.m_122372_(vector4f.x(), vector4f.y(), vector4f.z());
    }

    public static Collection<Direction> m_235667_(RandomSource p_235668_) {
        return Util.m_214681_(Direction.values(), p_235668_);
    }

    public static Stream<Direction> m_235666_() {
        return Stream.of(f_122346_);
    }

    public Quaternionf m_253075_() {
        return switch (this) {
            case DOWN -> new Quaternionf().rotationX((float)Math.PI);
            case UP -> new Quaternionf();
            case NORTH -> new Quaternionf().rotationXYZ(1.5707964f, 0.0f, (float)Math.PI);
            case SOUTH -> new Quaternionf().rotationX(1.5707964f);
            case WEST -> new Quaternionf().rotationXYZ(1.5707964f, 0.0f, 1.5707964f);
            case EAST -> new Quaternionf().rotationXYZ(1.5707964f, 0.0f, -1.5707964f);
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public int m_122411_() {
        return this.f_122339_;
    }

    public int m_122416_() {
        return this.f_122341_;
    }

    public AxisDirection m_122421_() {
        return this.f_122344_;
    }

    public static Direction m_175357_(Entity p_175358_, Axis p_175359_) {
        return switch (p_175359_) {
            case Axis.X -> EAST.m_122370_(p_175358_.m_5675_(1.0f)) ? EAST : WEST;
            case Axis.Z -> SOUTH.m_122370_(p_175358_.m_5675_(1.0f)) ? SOUTH : NORTH;
            case Axis.Y -> p_175358_.m_5686_(1.0f) < 0.0f ? UP : DOWN;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public Direction m_122424_() {
        return Direction.m_122376_(this.f_122340_);
    }

    public Direction m_175362_(Axis p_175363_) {
        return switch (p_175363_) {
            case Axis.X -> this != WEST && this != EAST ? this.m_175366_() : this;
            case Axis.Z -> this != NORTH && this != SOUTH ? this.m_175368_() : this;
            case Axis.Y -> this != UP && this != DOWN ? this.m_122427_() : this;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public Direction m_175364_(Axis p_175365_) {
        return switch (p_175365_) {
            case Axis.X -> this != WEST && this != EAST ? this.m_175367_() : this;
            case Axis.Z -> this != NORTH && this != SOUTH ? this.m_175369_() : this;
            case Axis.Y -> this != UP && this != DOWN ? this.m_122428_() : this;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public Direction m_122427_() {
        return switch (this) {
            case NORTH -> EAST;
            case SOUTH -> WEST;
            case WEST -> NORTH;
            case EAST -> SOUTH;
            default -> throw new IllegalStateException("Unable to get Y-rotated facing of " + this);
        };
    }

    private Direction m_175366_() {
        return switch (this) {
            case DOWN -> SOUTH;
            case UP -> NORTH;
            case NORTH -> DOWN;
            case SOUTH -> UP;
            default -> throw new IllegalStateException("Unable to get X-rotated facing of " + this);
        };
    }

    private Direction m_175367_() {
        return switch (this) {
            case DOWN -> NORTH;
            case UP -> SOUTH;
            case NORTH -> UP;
            case SOUTH -> DOWN;
            default -> throw new IllegalStateException("Unable to get X-rotated facing of " + this);
        };
    }

    private Direction m_175368_() {
        return switch (this) {
            case DOWN -> WEST;
            case UP -> EAST;
            default -> throw new IllegalStateException("Unable to get Z-rotated facing of " + this);
            case WEST -> UP;
            case EAST -> DOWN;
        };
    }

    private Direction m_175369_() {
        return switch (this) {
            case DOWN -> EAST;
            case UP -> WEST;
            default -> throw new IllegalStateException("Unable to get Z-rotated facing of " + this);
            case WEST -> DOWN;
            case EAST -> UP;
        };
    }

    public Direction m_122428_() {
        return switch (this) {
            case NORTH -> WEST;
            case SOUTH -> EAST;
            case WEST -> SOUTH;
            case EAST -> NORTH;
            default -> throw new IllegalStateException("Unable to get CCW facing of " + this);
        };
    }

    public int m_122429_() {
        return this.f_122345_.m_123341_();
    }

    public int m_122430_() {
        return this.f_122345_.m_123342_();
    }

    public int m_122431_() {
        return this.f_122345_.m_123343_();
    }

    public Vector3f m_253071_() {
        return new Vector3f((float)this.m_122429_(), (float)this.m_122430_(), (float)this.m_122431_());
    }

    public String m_122433_() {
        return this.f_122342_;
    }

    public Axis m_122434_() {
        return this.f_122343_;
    }

    @Nullable
    public static Direction m_122402_(@Nullable String p_122403_) {
        return (Direction)f_175356_.m_216455_(p_122403_);
    }

    public static Direction m_122376_(int p_122377_) {
        return f_122348_[Mth.m_14040_((int)(p_122377_ % f_122348_.length))];
    }

    public static Direction m_122407_(int p_122408_) {
        return f_122349_[Mth.m_14040_((int)(p_122408_ % f_122349_.length))];
    }

    @Nullable
    public static Direction m_122378_(int p_278323_, int p_278296_, int p_278347_) {
        if (p_278323_ == 0) {
            if (p_278296_ == 0) {
                if (p_278347_ > 0) {
                    return SOUTH;
                }
                if (p_278347_ < 0) {
                    return NORTH;
                }
            } else if (p_278347_ == 0) {
                if (p_278296_ > 0) {
                    return UP;
                }
                return DOWN;
            }
        } else if (p_278296_ == 0 && p_278347_ == 0) {
            if (p_278323_ > 0) {
                return EAST;
            }
            return WEST;
        }
        return null;
    }

    public static Direction m_122364_(double p_122365_) {
        return Direction.m_122407_(Mth.m_14107_((double)(p_122365_ / 90.0 + 0.5)) & 3);
    }

    public static Direction m_122387_(Axis p_122388_, AxisDirection p_122389_) {
        return switch (p_122388_) {
            case Axis.X -> p_122389_ == AxisDirection.POSITIVE ? EAST : WEST;
            case Axis.Z -> p_122389_ == AxisDirection.POSITIVE ? SOUTH : NORTH;
            case Axis.Y -> p_122389_ == AxisDirection.POSITIVE ? UP : DOWN;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public float m_122435_() {
        return (this.f_122341_ & 3) * 90;
    }

    public static Direction m_235672_(RandomSource p_235673_) {
        return Util.m_214670_(f_122346_, p_235673_);
    }

    public static Direction m_122366_(double p_122367_, double p_122368_, double p_122369_) {
        return Direction.m_122372_((float)p_122367_, (float)p_122368_, (float)p_122369_);
    }

    public static Direction m_122372_(float p_122373_, float p_122374_, float p_122375_) {
        Direction direction = NORTH;
        float f = Float.MIN_VALUE;
        for (Direction direction1 : f_122346_) {
            float f1 = p_122373_ * (float)direction1.f_122345_.m_123341_() + p_122374_ * (float)direction1.f_122345_.m_123342_() + p_122375_ * (float)direction1.f_122345_.m_123343_();
            if (!(f1 > f)) continue;
            f = f1;
            direction = direction1;
        }
        return direction;
    }

    public static Direction getNearestStable(float pX, float pY, float pZ) {
        Direction direction = NORTH;
        float f = Float.MIN_VALUE;
        for (Direction direction1 : f_122346_) {
            float f1 = pX * (float)direction1.f_122345_.m_123341_() + pY * (float)direction1.f_122345_.m_123342_() + pZ * (float)direction1.f_122345_.m_123343_();
            if (!(f1 > f + 1.0E-6f)) continue;
            f = f1;
            direction = direction1;
        }
        return direction;
    }

    public String toString() {
        return this.f_122342_;
    }

    public String m_7912_() {
        return this.f_122342_;
    }

    private static DataResult<Direction> m_194528_(Direction p_194529_) {
        return p_194529_.m_122434_().m_122478_() ? DataResult.success((Object)((Object)p_194529_)) : DataResult.error(() -> "Expected a vertical direction");
    }

    public static Direction m_122390_(AxisDirection p_122391_, Axis p_122392_) {
        for (Direction direction : f_122346_) {
            if (direction.m_122421_() != p_122391_ || direction.m_122434_() != p_122392_) continue;
            return direction;
        }
        throw new IllegalArgumentException("No such direction: " + p_122391_ + " " + p_122392_);
    }

    public Vec3i m_122436_() {
        return this.f_122345_;
    }

    public boolean m_122370_(float p_122371_) {
        float f = p_122371_ * ((float)Math.PI / 180);
        float f1 = -Mth.m_14031_((float)f);
        float f2 = Mth.m_14089_((float)f);
        return (float)this.f_122345_.m_123341_() * f1 + (float)this.f_122345_.m_123343_() * f2 > 0.0f;
    }

    private static /* synthetic */ Direction[] m_175370_() {
        return new Direction[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};
    }

    static {
        $VALUES = Direction.m_175370_();
        f_175356_ = StringRepresentable.m_216439_(Direction::values);
        f_194527_ = ExtraCodecs.m_264370_(f_175356_, Direction::m_194528_);
        f_122346_ = Direction.values();
        f_122348_ = (Direction[])Arrays.stream(f_122346_).sorted(Comparator.comparingInt(p_235687_ -> p_235687_.f_122339_)).toArray(Direction[]::new);
        f_122349_ = (Direction[])Arrays.stream(f_122346_).filter(p_235685_ -> p_235685_.m_122434_().m_122479_()).sorted(Comparator.comparingInt(p_235683_ -> p_235683_.f_122341_)).toArray(Direction[]::new);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class Axis
    extends Enum<Axis>
    implements StringRepresentable,
    Predicate<Direction> {
        public static final /* enum */ Axis X = new Axis("x"){

            @Override
            public int m_7863_(int p_122496_, int p_122497_, int p_122498_) {
                return p_122496_;
            }

            @Override
            public double m_6150_(double p_122492_, double p_122493_, double p_122494_) {
                return p_122492_;
            }
        };
        public static final /* enum */ Axis Y = new Axis("y"){

            @Override
            public int m_7863_(int p_122510_, int p_122511_, int p_122512_) {
                return p_122511_;
            }

            @Override
            public double m_6150_(double p_122506_, double p_122507_, double p_122508_) {
                return p_122507_;
            }
        };
        public static final /* enum */ Axis Z = new Axis("z"){

            @Override
            public int m_7863_(int p_122524_, int p_122525_, int p_122526_) {
                return p_122526_;
            }

            @Override
            public double m_6150_(double p_122520_, double p_122521_, double p_122522_) {
                return p_122522_;
            }
        };
        public static final Axis[] f_122448_;
        public static final StringRepresentable.EnumCodec<Axis> f_122447_;
        private final String f_122450_;
        private static final /* synthetic */ Axis[] $VALUES;

        public static Axis[] values() {
            return (Axis[])$VALUES.clone();
        }

        public static Axis valueOf(String p_122485_) {
            return Enum.valueOf(Axis.class, p_122485_);
        }

        private Axis(String p_122456_) {
            this.f_122450_ = p_122456_;
        }

        @Nullable
        public static Axis m_122473_(String p_122474_) {
            return (Axis)f_122447_.m_216455_(p_122474_);
        }

        public String m_122477_() {
            return this.f_122450_;
        }

        public boolean m_122478_() {
            return this == Y;
        }

        public boolean m_122479_() {
            return this == X || this == Z;
        }

        public String toString() {
            return this.f_122450_;
        }

        public static Axis m_235688_(RandomSource p_235689_) {
            return Util.m_214670_(f_122448_, p_235689_);
        }

        @Override
        public boolean test(@Nullable Direction p_122472_) {
            return p_122472_ != null && p_122472_.m_122434_() == this;
        }

        public Plane m_122480_() {
            return switch (this) {
                case X, Z -> Plane.HORIZONTAL;
                case Y -> Plane.VERTICAL;
                default -> throw new IncompatibleClassChangeError();
            };
        }

        public String m_7912_() {
            return this.f_122450_;
        }

        public abstract int m_7863_(int var1, int var2, int var3);

        public abstract double m_6150_(double var1, double var3, double var5);

        private static /* synthetic */ Axis[] m_175371_() {
            return new Axis[]{X, Y, Z};
        }

        static {
            $VALUES = Axis.m_175371_();
            f_122448_ = Axis.values();
            f_122447_ = StringRepresentable.m_216439_(Axis::values);
        }
    }

    public static final class AxisDirection
    extends Enum<AxisDirection> {
        public static final /* enum */ AxisDirection POSITIVE = new AxisDirection(1, "Towards positive");
        public static final /* enum */ AxisDirection NEGATIVE = new AxisDirection(-1, "Towards negative");
        private final int f_122531_;
        private final String f_122532_;
        private static final /* synthetic */ AxisDirection[] $VALUES;

        public static AxisDirection[] values() {
            return (AxisDirection[])$VALUES.clone();
        }

        public static AxisDirection valueOf(String p_122544_) {
            return Enum.valueOf(AxisDirection.class, p_122544_);
        }

        private AxisDirection(int p_122538_, String p_122539_) {
            this.f_122531_ = p_122538_;
            this.f_122532_ = p_122539_;
        }

        public int m_122540_() {
            return this.f_122531_;
        }

        public String m_175372_() {
            return this.f_122532_;
        }

        public String toString() {
            return this.f_122532_;
        }

        public AxisDirection m_122541_() {
            return this == POSITIVE ? NEGATIVE : POSITIVE;
        }

        private static /* synthetic */ AxisDirection[] m_175373_() {
            return new AxisDirection[]{POSITIVE, NEGATIVE};
        }

        static {
            $VALUES = AxisDirection.m_175373_();
        }
    }

    public static final class Plane
    extends Enum<Plane>
    implements Iterable<Direction>,
    Predicate<Direction> {
        public static final /* enum */ Plane HORIZONTAL = new Plane(new Direction[]{NORTH, EAST, SOUTH, WEST}, new Axis[]{Axis.X, Axis.Z});
        public static final /* enum */ Plane VERTICAL = new Plane(new Direction[]{UP, DOWN}, new Axis[]{Axis.Y});
        private final Direction[] f_122548_;
        private final Axis[] f_122549_;
        private static final /* synthetic */ Plane[] $VALUES;

        public static Plane[] values() {
            return (Plane[])$VALUES.clone();
        }

        public static Plane valueOf(String p_122568_) {
            return Enum.valueOf(Plane.class, p_122568_);
        }

        private Plane(Direction[] p_122555_, Axis[] p_122556_) {
            this.f_122548_ = p_122555_;
            this.f_122549_ = p_122556_;
        }

        public Direction m_235690_(RandomSource p_235691_) {
            return Util.m_214670_(this.f_122548_, p_235691_);
        }

        public Axis m_235692_(RandomSource p_235693_) {
            return Util.m_214670_(this.f_122549_, p_235693_);
        }

        @Override
        public boolean test(@Nullable Direction p_122559_) {
            return p_122559_ != null && p_122559_.m_122434_().m_122480_() == this;
        }

        @Override
        public Iterator<Direction> iterator() {
            return Iterators.forArray((Object[])this.f_122548_);
        }

        public Stream<Direction> m_122557_() {
            return Arrays.stream(this.f_122548_);
        }

        public List<Direction> m_235694_(RandomSource p_235695_) {
            return Util.m_214681_(this.f_122548_, p_235695_);
        }

        private static /* synthetic */ Plane[] m_175374_() {
            return new Plane[]{HORIZONTAL, VERTICAL};
        }

        static {
            $VALUES = Plane.m_175374_();
        }
    }
}

