/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.Reader;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagFile;
import net.minecraft.util.DependencySorter;
import org.slf4j.Logger;

public class TagLoader<T> {
    private static final Logger f_13445_ = LogUtils.getLogger();
    final Function<ResourceLocation, Optional<? extends T>> f_13448_;
    private final String f_13449_;

    public TagLoader(Function<ResourceLocation, Optional<? extends T>> p_144493_, String p_144494_) {
        this.f_13448_ = p_144493_;
        this.f_13449_ = p_144494_;
    }

    public Map<ResourceLocation, List<EntryWithSource>> m_144495_(ResourceManager p_144496_) {
        HashMap map = Maps.newHashMap();
        FileToIdConverter filetoidconverter = FileToIdConverter.m_246568_((String)this.f_13449_);
        for (Map.Entry entry : filetoidconverter.m_246760_(p_144496_).entrySet()) {
            ResourceLocation resourcelocation = (ResourceLocation)entry.getKey();
            ResourceLocation resourcelocation1 = filetoidconverter.m_245273_(resourcelocation);
            for (Resource resource : (List)entry.getValue()) {
                try {
                    BufferedReader reader = resource.m_215508_();
                    try {
                        JsonElement jsonelement = JsonParser.parseReader((Reader)reader);
                        List list = map.computeIfAbsent(resourcelocation1, p_215974_ -> new ArrayList());
                        TagFile tagfile = (TagFile)TagFile.f_215958_.parse(new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)jsonelement)).getOrThrow(false, arg_0 -> ((Logger)f_13445_).error(arg_0));
                        if (tagfile.f_215960_()) {
                            list.clear();
                        }
                        String s = resource.m_215506_();
                        tagfile.f_215959_().forEach(p_215997_ -> list.add(new EntryWithSource((TagEntry)p_215997_, s)));
                        tagfile.remove().forEach(e -> list.add(new EntryWithSource((TagEntry)e, s, true)));
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (Exception exception) {
                    f_13445_.error("Couldn't read tag list {} from {} in data pack {}", new Object[]{resourcelocation1, resourcelocation, resource.m_215506_(), exception});
                }
            }
        }
        return map;
    }

    private Either<Collection<EntryWithSource>, Collection<T>> m_215978_(TagEntry.Lookup<T> p_215979_, List<EntryWithSource> p_215980_) {
        LinkedHashSet builder = new LinkedHashSet();
        ArrayList<EntryWithSource> list = new ArrayList<EntryWithSource>();
        for (EntryWithSource tagloader$entrywithsource : p_215980_) {
            if (tagloader$entrywithsource.f_216042_().m_215927_(p_215979_, tagloader$entrywithsource.remove() ? builder::remove : builder::add) || tagloader$entrywithsource.remove()) continue;
            list.add(tagloader$entrywithsource);
        }
        return list.isEmpty() ? Either.right(List.copyOf(builder)) : Either.left(list);
    }

    public Map<ResourceLocation, Collection<T>> m_203898_(Map<ResourceLocation, List<EntryWithSource>> p_203899_) {
        final HashMap map = Maps.newHashMap();
        TagEntry.Lookup lookup = new TagEntry.Lookup<T>(){

            @Override
            @Nullable
            public T m_213619_(ResourceLocation p_216039_) {
                return TagLoader.this.f_13448_.apply(p_216039_).orElse(null);
            }

            @Override
            @Nullable
            public Collection<T> m_214048_(ResourceLocation p_216041_) {
                return (Collection)map.get(p_216041_);
            }
        };
        DependencySorter dependencysorter = new DependencySorter();
        p_203899_.forEach((p_284685_, p_284686_) -> dependencysorter.m_284176_(p_284685_, (DependencySorter.Entry)new SortingEntry((List<EntryWithSource>)p_284686_)));
        dependencysorter.m_284430_((p_284682_, p_284683_) -> this.m_215978_(lookup, p_284683_.f_283922_).ifLeft(p_215977_ -> f_13445_.error("Couldn't load tag {} as it is missing following references: {}", p_284682_, (Object)p_215977_.stream().map(Objects::toString).collect(Collectors.joining("\n\t", "\n\t", "")))).ifRight(p_216001_ -> map.put(p_284682_, p_216001_)));
        return map;
    }

    public Map<ResourceLocation, Collection<T>> m_203900_(ResourceManager p_203901_) {
        return this.m_203898_(this.m_144495_(p_203901_));
    }

    public record EntryWithSource(TagEntry f_216042_, String f_216043_, boolean remove) {
        public EntryWithSource(TagEntry f_216042_, String f_216043_) {
            this(f_216042_, f_216043_, false);
        }

        @Override
        public String toString() {
            return this.f_216042_ + " (from " + this.f_216043_ + ")";
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{EntryWithSource.class, "entry;source;remove", "f_216042_", "f_216043_", "remove"}, this);
        }

        @Override
        public final boolean equals(Object p_216050_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{EntryWithSource.class, "entry;source;remove", "f_216042_", "f_216043_", "remove"}, this, p_216050_);
        }
    }

    record SortingEntry(List<EntryWithSource> f_283922_) implements DependencySorter.Entry<ResourceLocation>
    {
        public void m_284213_(Consumer<ResourceLocation> p_285529_) {
            this.f_283922_.forEach(p_285236_ -> p_285236_.f_216042_.m_215938_(p_285529_));
        }

        public void m_284346_(Consumer<ResourceLocation> p_285469_) {
            this.f_283922_.forEach(p_284943_ -> p_284943_.f_216042_.m_215947_(p_285469_));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{SortingEntry.class, "entries", "f_283922_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SortingEntry.class, "entries", "f_283922_"}, this);
        }

        @Override
        public final boolean equals(Object p_285432_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SortingEntry.class, "entries", "f_283922_"}, this, p_285432_);
        }
    }
}

