/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.camel;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.serialization.Dynamic;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.RiderShieldingMount;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.camel.CamelAi;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class Camel
extends AbstractHorse
implements PlayerRideableJumping,
RiderShieldingMount,
Saddleable {
    public static final Ingredient f_243705_ = Ingredient.m_43929_(Items.f_41982_);
    public static final int f_244289_ = 55;
    public static final int f_263725_ = 30;
    private static final float f_243982_ = 0.1f;
    private static final float f_244195_ = 1.4285f;
    private static final float f_244101_ = 22.2222f;
    private static final int f_278128_ = 5;
    private static final int f_244084_ = 40;
    private static final int f_244435_ = 52;
    private static final int f_244638_ = 80;
    private static final float f_243730_ = 1.43f;
    public static final EntityDataAccessor<Boolean> f_244117_ = SynchedEntityData.m_135353_(Camel.class, EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Long> f_243883_ = SynchedEntityData.m_135353_(Camel.class, EntityDataSerializers.f_244073_);
    public final AnimationState f_243928_ = new AnimationState();
    public final AnimationState f_252486_ = new AnimationState();
    public final AnimationState f_244242_ = new AnimationState();
    public final AnimationState f_244047_ = new AnimationState();
    public final AnimationState f_244243_ = new AnimationState();
    private static final EntityDimensions f_244306_ = EntityDimensions.m_20395_((float)EntityType.f_243976_.m_20678_(), (float)(EntityType.f_243976_.m_20679_() - 1.43f));
    private int f_244455_ = 0;
    private int f_244476_ = 0;

    public Camel(EntityType<? extends Camel> p_248516_, Level p_249295_) {
        super((EntityType<? extends AbstractHorse>)p_248516_, p_249295_);
        this.m_274367_(1.5f);
        this.f_21342_ = new CamelMoveControl();
        GroundPathNavigation groundpathnavigation = (GroundPathNavigation)this.m_21573_();
        groundpathnavigation.m_7008_(true);
        groundpathnavigation.m_255224_(true);
    }

    @Override
    public void m_7380_(CompoundTag p_250330_) {
        super.m_7380_(p_250330_);
        p_250330_.m_128356_("LastPoseTick", this.f_19804_.m_135370_(f_243883_));
    }

    @Override
    public void m_7378_(CompoundTag p_250781_) {
        super.m_7378_(p_250781_);
        long i = p_250781_.m_128454_("LastPoseTick");
        if (i < 0L) {
            this.m_20124_(Pose.SITTING);
        }
        this.m_246174_(i);
    }

    public static AttributeSupplier.Builder m_247319_() {
        return Camel.m_30627_().m_22268_(Attributes.f_22276_, 32.0).m_22268_(Attributes.f_22279_, 0.09f).m_22268_(Attributes.f_22288_, 0.42f);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(f_244117_, false);
        this.f_19804_.m_135372_(f_243883_, 0L);
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor p_249190_, DifficultyInstance p_251264_, MobSpawnType p_250254_, @Nullable SpawnGroupData p_249259_, @Nullable CompoundTag p_251838_) {
        CamelAi.m_246286_((Camel)this, (RandomSource)p_249190_.m_213780_());
        this.m_264491_(p_249190_.m_6018_().m_46467_());
        return super.m_6518_(p_249190_, p_251264_, p_250254_, p_249259_, p_251838_);
    }

    protected Brain.Provider<Camel> m_5490_() {
        return CamelAi.m_246665_();
    }

    @Override
    protected void m_8099_() {
    }

    protected Brain<?> m_8075_(Dynamic<?> p_251586_) {
        return CamelAi.m_246748_((Brain)this.m_5490_().m_22073_(p_251586_));
    }

    public EntityDimensions m_6972_(Pose p_248973_) {
        return p_248973_ == Pose.SITTING ? f_244306_.m_20388_(this.m_6134_()) : super.m_6972_(p_248973_);
    }

    @Override
    protected float m_6431_(Pose p_248908_, EntityDimensions p_250490_) {
        return p_250490_.f_20378_ - 0.1f;
    }

    public double m_262813_() {
        return 0.5;
    }

    @Override
    protected void m_8024_() {
        this.m_9236_().m_46473_().m_6180_("camelBrain");
        Brain brain = this.m_6274_();
        brain.m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)((Object)this));
        this.m_9236_().m_46473_().m_7238_();
        this.m_9236_().m_46473_().m_6180_("camelActivityUpdate");
        CamelAi.m_246127_((Camel)this);
        this.m_9236_().m_46473_().m_7238_();
        super.m_8024_();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_245293_() && this.f_244455_ < 50 && (this.m_20096_() || this.m_20069_() || this.m_20159_())) {
            this.m_246841_(false);
        }
        if (this.f_244455_ > 0) {
            --this.f_244455_;
            if (this.f_244455_ == 0) {
                this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_244032_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        }
        if (this.m_9236_().m_5776_()) {
            this.m_245223_();
        }
        if (this.m_245824_()) {
            this.m_264142_((Entity)((Object)this), 30.0f);
        }
        if (this.m_264103_() && this.m_20069_()) {
            this.m_247328_();
        }
    }

    private void m_245223_() {
        if (this.f_244476_ <= 0) {
            this.f_244476_ = this.f_19796_.m_188503_(40) + 80;
            this.f_244047_.m_216977_(this.f_19797_);
        } else {
            --this.f_244476_;
        }
        if (this.m_267745_()) {
            this.f_244242_.m_216973_();
            this.f_244243_.m_216973_();
            if (this.m_267631_()) {
                this.f_243928_.m_216982_(this.f_19797_);
                this.f_252486_.m_216973_();
            } else {
                this.f_243928_.m_216973_();
                this.f_252486_.m_216982_(this.f_19797_);
            }
        } else {
            this.f_243928_.m_216973_();
            this.f_252486_.m_216973_();
            this.f_244243_.m_246184_(this.m_245293_(), this.f_19797_);
            this.f_244242_.m_246184_(this.m_245346_() && this.m_246237_() >= 0L, this.f_19797_);
        }
    }

    protected void m_267689_(float p_268362_) {
        float f = this.m_20089_() == Pose.STANDING && !this.f_244243_.m_216984_() ? Math.min(p_268362_ * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    public void m_7023_(Vec3 p_250068_) {
        if (this.m_245824_() && this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(0.0, 1.0, 0.0));
            p_250068_ = p_250068_.m_82542_(0.0, 1.0, 0.0);
        }
        super.m_7023_(p_250068_);
    }

    @Override
    protected void m_274498_(Player p_278319_, Vec3 p_278301_) {
        super.m_274498_(p_278319_, p_278301_);
        if (p_278319_.f_20902_ > 0.0f && this.m_264103_() && !this.m_245346_()) {
            this.m_246761_();
        }
    }

    public boolean m_245824_() {
        return this.m_264103_() || this.m_245346_();
    }

    @Override
    protected float m_245547_(Player p_278241_) {
        float f = p_278241_.m_20142_() && this.m_245614_() == 0 ? 0.1f : 0.0f;
        return (float)this.m_21133_(Attributes.f_22279_) + f;
    }

    @Override
    protected Vec2 m_274391_(LivingEntity p_275271_) {
        return this.m_245824_() ? new Vec2(this.m_146909_(), this.m_146908_()) : super.m_274391_(p_275271_);
    }

    @Override
    protected Vec3 m_274312_(Player p_278264_, Vec3 p_278298_) {
        return this.m_245824_() ? Vec3.f_82478_ : super.m_274312_(p_278264_, p_278298_);
    }

    @Override
    public boolean m_7132_() {
        return !this.m_245824_() && super.m_7132_();
    }

    @Override
    public void m_7888_(int p_249138_) {
        if (this.m_6254_() && this.f_244455_ <= 0 && this.m_20096_()) {
            super.m_7888_(p_249138_);
        }
    }

    public boolean m_264410_() {
        return true;
    }

    @Override
    protected void m_245980_(float p_251967_, Vec3 p_275627_) {
        double d0 = this.m_21133_(Attributes.f_22288_) * (double)this.m_20098_() + (double)this.m_285755_();
        this.m_246865_(this.m_20154_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)(22.2222f * p_251967_) * this.m_21133_(Attributes.f_22279_) * (double)this.m_6041_()).m_82520_(0.0, (double)(1.4285f * p_251967_) * d0, 0.0));
        this.f_244455_ = 55;
        this.m_246841_(true);
        this.f_19812_ = true;
    }

    public boolean m_245293_() {
        return this.f_19804_.m_135370_(f_244117_);
    }

    public void m_246841_(boolean p_251380_) {
        this.f_19804_.m_135381_(f_244117_, p_251380_);
    }

    public boolean m_245623_() {
        return this.m_6274_().m_21876_(MemoryModuleType.f_217768_, MemoryStatus.VALUE_PRESENT);
    }

    @Override
    public void m_7199_(int p_249968_) {
        this.m_5496_(SoundEvents.f_244538_, 1.0f, 1.0f);
        this.m_246841_(true);
    }

    @Override
    public void m_8012_() {
    }

    public int m_245614_() {
        return this.f_244455_;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_243764_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_243972_;
    }

    protected SoundEvent m_7975_(DamageSource p_250052_) {
        return SoundEvents.f_243775_;
    }

    @Override
    protected void m_7355_(BlockPos p_252056_, BlockState p_251457_) {
        if (p_251457_.getSoundType((LevelReader)((Object)this.m_9236_()), p_252056_, (Entity)((Object)this)) == SoundType.f_56746_) {
            this.m_5496_(SoundEvents.f_244016_, 1.0f, 1.0f);
        } else {
            this.m_5496_(SoundEvents.f_244506_, 1.0f, 1.0f);
        }
    }

    @Override
    public boolean m_6898_(ItemStack p_248671_) {
        return f_243705_.test(p_248671_);
    }

    @Override
    public InteractionResult m_6071_(Player p_249032_, InteractionHand p_251004_) {
        ItemStack itemstack = p_249032_.m_21120_(p_251004_);
        if (p_249032_.m_36341_() && !this.m_6162_()) {
            this.m_213583_(p_249032_);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        InteractionResult interactionresult = itemstack.m_41647_(p_249032_, (LivingEntity)((Object)this), p_251004_);
        if (interactionresult.m_19077_()) {
            return interactionresult;
        }
        if (this.m_6898_(itemstack)) {
            return this.m_30580_(p_249032_, itemstack);
        }
        if (this.m_20197_().size() < 2 && !this.m_6162_()) {
            this.m_6835_(p_249032_);
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
    }

    @Override
    protected void m_7880_(float p_251143_) {
        if (p_251143_ > 6.0f && this.m_264103_() && !this.m_245346_()) {
            this.m_246761_();
        }
    }

    @Override
    protected boolean m_5994_(Player p_249923_, ItemStack p_248995_) {
        SoundEvent soundevent;
        boolean flag2;
        boolean flag1;
        boolean flag;
        if (!this.m_6898_(p_248995_)) {
            return false;
        }
        boolean bl = flag = this.m_21223_() < this.m_21233_();
        if (flag) {
            this.m_5634_(2.0f);
        }
        boolean bl2 = flag1 = this.m_30614_() && this.m_146764_() == 0 && this.m_5957_();
        if (flag1) {
            this.m_27595_(p_249923_);
        }
        if (flag2 = this.m_6162_()) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0.0, 0.0, 0.0);
            if (!this.m_9236_().f_46443_) {
                this.m_146758_(10);
            }
        }
        if (!(flag || flag1 || flag2)) {
            return false;
        }
        if (!this.m_20067_() && (soundevent = this.m_7872_()) != null) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), soundevent, this.m_5720_(), 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
        }
        return true;
    }

    @Override
    protected boolean m_245259_() {
        return false;
    }

    @Override
    public boolean m_7848_(Animal p_251650_) {
        if (p_251650_ != this && p_251650_ instanceof Camel) {
            Camel camel = (Camel)p_251650_;
            if (this.m_30628_() && camel.m_30628_()) {
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public Camel m_142606_(ServerLevel p_251227_, AgeableMob p_251047_) {
        return EntityType.f_243976_.m_20615_(p_251227_);
    }

    @Override
    @Nullable
    protected SoundEvent m_7872_() {
        return SoundEvents.f_243713_;
    }

    protected void m_6475_(DamageSource p_250410_, float p_251451_) {
        this.m_247328_();
        super.m_6475_(p_250410_, p_251451_);
    }

    @Override
    protected void m_19956_(Entity p_289564_, Entity.MoveFunction p_289551_) {
        int i = this.m_20197_().indexOf((Object)p_289564_);
        if (i >= 0) {
            boolean flag = i == 0;
            float f = 0.5f;
            float f1 = (float)(this.m_213877_() ? (double)0.01f : this.m_246718_(flag, 0.0f) + p_289564_.m_6049_());
            if (this.m_20197_().size() > 1) {
                if (!flag) {
                    f = -0.7f;
                }
                if (p_289564_ instanceof Animal) {
                    f += 0.2f;
                }
            }
            Vec3 vec3 = new Vec3(0.0, 0.0, (double)f).m_82524_(-this.f_20883_ * ((float)Math.PI / 180));
            p_289551_.m_20372_(p_289564_, this.m_20185_() + vec3.f_82479_, this.m_20186_() + (double)f1, this.m_20189_() + vec3.f_82481_);
            this.m_246824_(p_289564_);
        }
    }

    private double m_246718_(boolean p_249228_, float p_251763_) {
        double d0 = this.m_6048_();
        float f = this.m_6134_() * 1.43f;
        float f1 = f - this.m_6134_() * 0.2f;
        float f2 = f - f1;
        boolean flag = this.m_245346_();
        boolean flag1 = this.m_264103_();
        if (flag) {
            float f3;
            int j;
            int i;
            int n = i = flag1 ? 40 : 52;
            if (flag1) {
                j = 28;
                f3 = p_249228_ ? 0.5f : 0.1f;
            } else {
                j = p_249228_ ? 24 : 32;
                f3 = p_249228_ ? 0.6f : 0.35f;
            }
            float f4 = Mth.m_14036_((float)((float)this.m_246237_() + p_251763_), (float)0.0f, (float)i);
            boolean flag2 = f4 < (float)j;
            float f5 = flag2 ? f4 / (float)j : (f4 - (float)j) / (float)(i - j);
            float f6 = f - f3 * f1;
            d0 += flag1 ? (double)Mth.m_14179_((float)f5, (float)(flag2 ? f : f6), (float)(flag2 ? f6 : f2)) : (double)Mth.m_14179_((float)f5, (float)(flag2 ? f2 - f : f2 - f6), (float)(flag2 ? f2 - f6 : 0.0f));
        }
        if (flag1 && !flag) {
            d0 += (double)f2;
        }
        return d0;
    }

    public Vec3 m_245894_(float p_251477_) {
        return new Vec3(0.0, this.m_246718_(true, p_251477_) - (double)(0.2f * this.m_6134_()), (double)(this.m_20205_() * 0.56f));
    }

    public double m_6048_() {
        return this.m_6972_((Pose)(this.m_264103_() ? Pose.SITTING : Pose.STANDING)).f_20378_ - (this.m_6162_() ? 0.35f : 0.6f);
    }

    public void m_7340_(Entity p_250747_) {
        if (this.m_6688_() != p_250747_) {
            this.m_246824_(p_250747_);
        }
    }

    private void m_246824_(Entity p_252070_) {
        p_252070_.m_5618_(this.m_146908_());
        float f = p_252070_.m_146908_();
        float f1 = Mth.m_14177_((float)(f - this.m_146908_()));
        float f2 = Mth.m_14036_((float)f1, (float)-160.0f, (float)160.0f);
        p_252070_.f_19859_ += f2 - f1;
        float f3 = f + f2 - f1;
        p_252070_.m_146922_(f3);
        p_252070_.m_5616_(f3);
    }

    private void m_264142_(Entity p_265624_, float p_265541_) {
        float f = p_265624_.m_6080_();
        float f1 = Mth.m_14177_((float)(this.f_20883_ - f));
        float f2 = Mth.m_14036_((float)Mth.m_14177_((float)(this.f_20883_ - f)), (float)(-p_265541_), (float)p_265541_);
        float f3 = f + f1 - f2;
        p_265624_.m_5616_(f3);
    }

    public int m_8085_() {
        return 30;
    }

    protected boolean m_7310_(Entity p_248594_) {
        return this.m_20197_().size() <= 2;
    }

    @Override
    @Nullable
    public LivingEntity m_6688_() {
        Entity entity;
        if (!this.m_20197_().isEmpty() && this.m_6254_() && (entity = (Entity)((Object)this.m_20197_().get(0))) instanceof LivingEntity) {
            return (LivingEntity)entity;
        }
        return null;
    }

    protected void m_8025_() {
        super.m_8025_();
        DebugPackets.m_133695_((LivingEntity)((Object)this));
    }

    public boolean m_264103_() {
        return this.f_19804_.m_135370_(f_243883_) < 0L;
    }

    public boolean m_267745_() {
        return this.m_246237_() < 0L != this.m_264103_();
    }

    public boolean m_245346_() {
        long i = this.m_246237_();
        return i < (long)(this.m_264103_() ? 40 : 52);
    }

    private boolean m_267631_() {
        return this.m_264103_() && this.m_246237_() < 40L && this.m_246237_() >= 0L;
    }

    public void m_245138_() {
        if (!this.m_264103_()) {
            this.m_5496_(SoundEvents.f_244086_, 1.0f, 1.0f);
            this.m_20124_(Pose.SITTING);
            this.m_246174_(-this.m_9236_().m_46467_());
        }
    }

    public void m_246761_() {
        if (this.m_264103_()) {
            this.m_5496_(SoundEvents.f_244044_, 1.0f, 1.0f);
            this.m_20124_(Pose.STANDING);
            this.m_246174_(this.m_9236_().m_46467_());
        }
    }

    public void m_247328_() {
        this.m_20124_(Pose.STANDING);
        this.m_264491_(this.m_9236_().m_46467_());
    }

    @VisibleForTesting
    public void m_246174_(long p_248642_) {
        this.f_19804_.m_135381_(f_243883_, p_248642_);
    }

    private void m_264491_(long p_265447_) {
        this.m_246174_(Math.max(0L, p_265447_ - 52L - 1L));
    }

    public long m_246237_() {
        return this.m_9236_().m_46467_() - Math.abs(this.f_19804_.m_135370_(f_243883_));
    }

    public SoundEvent m_246265_() {
        return SoundEvents.f_244204_;
    }

    public void m_7350_(EntityDataAccessor<?> p_252215_) {
        if (!this.f_19803_ && f_244117_.equals(p_252215_)) {
            this.f_244455_ = this.f_244455_ == 0 ? 55 : this.f_244455_;
        }
        super.m_7350_(p_252215_);
    }

    protected BodyRotationControl m_7560_() {
        return new CamelBodyRotationControl(this);
    }

    @Override
    public boolean m_30614_() {
        return true;
    }

    @Override
    public void m_213583_(Player p_248613_) {
        if (!this.m_9236_().f_46443_) {
            p_248613_.m_6658_(this, (Container)this.f_30520_);
        }
    }

    class CamelMoveControl
    extends MoveControl {
        public CamelMoveControl() {
            super((Mob)((Object)Camel.this));
        }

        @Override
        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !Camel.this.m_21523_() && Camel.this.m_264103_() && !Camel.this.m_245346_()) {
                Camel.this.m_246761_();
            }
            super.m_8126_();
        }
    }

    class CamelBodyRotationControl
    extends BodyRotationControl {
        public CamelBodyRotationControl(Camel p_248635_) {
            super((Mob)((Object)p_248635_));
        }

        public void m_8121_() {
            if (!Camel.this.m_245824_()) {
                super.m_8121_();
            }
        }
    }
}

