/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class ConcretePowderBlock
extends FallingBlock {
    private final BlockState f_52058_;

    public ConcretePowderBlock(Block p_52060_, BlockBehaviour.Properties p_52061_) {
        super(p_52061_);
        this.f_52058_ = p_52060_.m_49966_();
    }

    public void m_48792_(Level p_52068_, BlockPos p_52069_, BlockState p_52070_, BlockState p_52071_, FallingBlockEntity p_52072_) {
        if (ConcretePowderBlock.shouldSolidify((BlockGetter)((Object)p_52068_), p_52069_, p_52070_, p_52071_.m_60819_())) {
            p_52068_.m_7731_(p_52069_, this.f_52058_, 3);
        }
    }

    public BlockState m_5573_(BlockPlaceContext p_52063_) {
        BlockState blockstate;
        BlockPos blockpos;
        Level blockgetter = p_52063_.m_43725_();
        return ConcretePowderBlock.m_52080_((BlockGetter)((Object)blockgetter), blockpos = p_52063_.m_8083_(), blockstate = blockgetter.m_8055_(blockpos)) ? this.f_52058_ : super.m_5573_(p_52063_);
    }

    private static boolean shouldSolidify(BlockGetter pLevel, BlockPos pPos, BlockState pState, FluidState fluidState) {
        return pState.canBeHydrated(pLevel, pPos, fluidState, pPos) || ConcretePowderBlock.touchesLiquid(pLevel, pPos, pState);
    }

    private static boolean m_52080_(BlockGetter p_52081_, BlockPos p_52082_, BlockState p_52083_) {
        return ConcretePowderBlock.shouldSolidify(p_52081_, p_52082_, p_52083_, p_52081_.m_6425_(p_52082_));
    }

    private static boolean touchesLiquid(BlockGetter pLevel, BlockPos pPos, BlockState state) {
        boolean flag = false;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pPos.m_122032_();
        for (Direction direction : Direction.values()) {
            BlockState blockstate = pLevel.m_8055_((BlockPos)blockpos$mutableblockpos);
            if (direction == Direction.DOWN && !state.canBeHydrated(pLevel, pPos, blockstate.m_60819_(), (BlockPos)blockpos$mutableblockpos)) continue;
            blockpos$mutableblockpos.m_122159_((Vec3i)pPos, direction);
            blockstate = pLevel.m_8055_((BlockPos)blockpos$mutableblockpos);
            if (!state.canBeHydrated(pLevel, pPos, blockstate.m_60819_(), (BlockPos)blockpos$mutableblockpos) || blockstate.m_60783_(pLevel, pPos, direction.m_122424_())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private static boolean m_52088_(BlockState p_52089_) {
        return p_52089_.m_60819_().m_205070_(FluidTags.f_13131_);
    }

    public BlockState m_7417_(BlockState p_52074_, Direction p_52075_, BlockState p_52076_, LevelAccessor p_52077_, BlockPos p_52078_, BlockPos p_52079_) {
        return ConcretePowderBlock.touchesLiquid((BlockGetter)p_52077_, p_52078_, p_52074_) ? this.f_52058_ : super.m_7417_(p_52074_, p_52075_, p_52076_, p_52077_, p_52078_, p_52079_);
    }

    public int m_6248_(BlockState p_52085_, BlockGetter p_52086_, BlockPos p_52087_) {
        return p_52085_.m_284242_((BlockGetter)p_52086_, (BlockPos)p_52087_).f_283871_;
    }
}

