/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.Sets;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootDataResolver;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.loot.LootTableIdCondition;

public class LootContext {
    private final LootParams f_78914_;
    private final RandomSource f_78907_;
    private final LootDataResolver f_278421_;
    private final Set<VisitedEntry<?>> f_278466_ = Sets.newLinkedHashSet();
    private ResourceLocation queriedLootTableId;

    LootContext(LootParams p_287722_, RandomSource p_287702_, LootDataResolver p_287619_) {
        this.f_78914_ = p_287722_;
        this.f_78907_ = p_287702_;
        this.f_278421_ = p_287619_;
    }

    public boolean m_78936_(LootContextParam<?> p_78937_) {
        return this.f_78914_.m_287166_(p_78937_);
    }

    public <T> T m_165124_(LootContextParam<T> p_165125_) {
        return this.f_78914_.m_287156_(p_165125_);
    }

    public void m_78942_(ResourceLocation p_78943_, Consumer<ItemStack> p_78944_) {
        this.f_78914_.m_287256_(p_78943_, p_78944_);
    }

    @Nullable
    public <T> T m_78953_(LootContextParam<T> p_78954_) {
        return this.f_78914_.m_287267_(p_78954_);
    }

    public boolean m_278628_(VisitedEntry<?> p_279182_) {
        return this.f_278466_.contains(p_279182_);
    }

    public boolean m_278759_(VisitedEntry<?> p_279152_) {
        return this.f_278466_.add(p_279152_);
    }

    public void m_278639_(VisitedEntry<?> p_279198_) {
        this.f_278466_.remove(p_279198_);
    }

    public LootDataResolver m_278643_() {
        return this.f_278421_;
    }

    public RandomSource m_230907_() {
        return this.f_78907_;
    }

    public float m_78945_() {
        return this.f_78914_.m_287164_();
    }

    public ServerLevel m_78952_() {
        return this.f_78914_.m_287182_();
    }

    public static VisitedEntry<LootTable> m_278811_(LootTable p_279327_) {
        return new VisitedEntry<LootTable>(LootDataType.f_278413_, p_279327_);
    }

    public static VisitedEntry<LootItemCondition> m_278785_(LootItemCondition p_279250_) {
        return new VisitedEntry<LootItemCondition>(LootDataType.f_278407_, p_279250_);
    }

    public static VisitedEntry<LootItemFunction> m_278853_(LootItemFunction p_279163_) {
        return new VisitedEntry<LootItemFunction>(LootDataType.f_278496_, p_279163_);
    }

    public int getLootingModifier() {
        return ForgeHooks.getLootingLevel((Entity)((Entity)((Object)this.m_78953_(LootContextParams.f_81455_))), (Entity)((Entity)((Object)this.m_78953_(LootContextParams.f_81458_))), (DamageSource)((DamageSource)this.m_78953_(LootContextParams.f_81457_)));
    }

    private LootContext(LootParams pParams, RandomSource pRandom, LootDataResolver pLootDataResolver, ResourceLocation queriedLootTableId) {
        this(pParams, pRandom, pLootDataResolver);
        this.queriedLootTableId = queriedLootTableId;
    }

    public void setQueriedLootTableId(ResourceLocation queriedLootTableId) {
        if (this.queriedLootTableId == null && queriedLootTableId != null) {
            this.queriedLootTableId = queriedLootTableId;
        }
    }

    public ResourceLocation getQueriedLootTableId() {
        return this.queriedLootTableId == null ? LootTableIdCondition.UNKNOWN_LOOT_TABLE : this.queriedLootTableId;
    }

    public record VisitedEntry<T>(LootDataType<T> f_278478_, T f_278374_) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{VisitedEntry.class, "type;value", "f_278478_", "f_278374_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{VisitedEntry.class, "type;value", "f_278478_", "f_278374_"}, this);
        }

        @Override
        public final boolean equals(Object p_279464_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{VisitedEntry.class, "type;value", "f_278478_", "f_278374_"}, this, p_279464_);
        }
    }

    public static final class EntityTarget
    extends Enum<EntityTarget> {
        public static final /* enum */ EntityTarget THIS = new EntityTarget("this", (LootContextParam<? extends Entity>)LootContextParams.f_81455_);
        public static final /* enum */ EntityTarget KILLER = new EntityTarget("killer", (LootContextParam<? extends Entity>)LootContextParams.f_81458_);
        public static final /* enum */ EntityTarget DIRECT_KILLER = new EntityTarget("direct_killer", (LootContextParam<? extends Entity>)LootContextParams.f_81459_);
        public static final /* enum */ EntityTarget KILLER_PLAYER = new EntityTarget("killer_player", (LootContextParam<? extends Entity>)LootContextParams.f_81456_);
        final String f_78994_;
        private final LootContextParam<? extends Entity> f_78995_;
        private static final /* synthetic */ EntityTarget[] $VALUES;

        public static EntityTarget[] values() {
            return (EntityTarget[])$VALUES.clone();
        }

        public static EntityTarget valueOf(String p_79009_) {
            return Enum.valueOf(EntityTarget.class, p_79009_);
        }

        private EntityTarget(String p_79001_, LootContextParam<? extends Entity> p_79002_) {
            this.f_78994_ = p_79001_;
            this.f_78995_ = p_79002_;
        }

        public LootContextParam<? extends Entity> m_79003_() {
            return this.f_78995_;
        }

        public String getName() {
            return this.f_78994_;
        }

        public static EntityTarget m_79006_(String p_79007_) {
            for (EntityTarget lootcontext$entitytarget : EntityTarget.values()) {
                if (!lootcontext$entitytarget.f_78994_.equals(p_79007_)) continue;
                return lootcontext$entitytarget;
            }
            throw new IllegalArgumentException("Invalid entity target " + p_79007_);
        }

        private static /* synthetic */ EntityTarget[] m_165126_() {
            return new EntityTarget[]{THIS, KILLER, DIRECT_KILLER, KILLER_PLAYER};
        }

        static {
            $VALUES = EntityTarget.m_165126_();
        }

        public static class Serializer
        extends TypeAdapter<EntityTarget> {
            public void write(JsonWriter p_79015_, EntityTarget p_79016_) throws IOException {
                p_79015_.value(p_79016_.f_78994_);
            }

            public EntityTarget read(JsonReader p_79013_) throws IOException {
                return EntityTarget.m_79006_(p_79013_.nextString());
            }
        }
    }

    public static class Builder {
        private final LootParams f_78956_;
        @Nullable
        private RandomSource f_78958_;
        private ResourceLocation queriedLootTableId;

        public Builder(LootParams p_287628_) {
            this.f_78956_ = p_287628_;
        }

        public Builder(LootContext context) {
            this.f_78956_ = context.f_78914_;
            this.f_78958_ = context.f_78907_;
            this.queriedLootTableId = context.queriedLootTableId;
        }

        public Builder m_78965_(long p_78966_) {
            if (p_78966_ != 0L) {
                this.f_78958_ = RandomSource.m_216335_((long)p_78966_);
            }
            return this;
        }

        public Builder withQueriedLootTableId(ResourceLocation queriedLootTableId) {
            this.queriedLootTableId = queriedLootTableId;
            return this;
        }

        public ServerLevel m_78962_() {
            return this.f_78956_.m_287182_();
        }

        public LootContext m_287259_(@Nullable ResourceLocation p_287626_) {
            ServerLevel serverlevel = this.m_78962_();
            MinecraftServer minecraftserver = serverlevel.m_7654_();
            RandomSource randomsource = this.f_78958_ != null ? this.f_78958_ : (p_287626_ != null ? serverlevel.m_287143_(p_287626_) : serverlevel.m_213780_());
            return new LootContext(this.f_78956_, randomsource, minecraftserver.m_278653_(), this.queriedLootTableId);
        }
    }
}

