/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.vertex;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Vec3i;
import net.minecraft.util.FastColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.IVertexConsumerExtension;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.system.MemoryStack;

@OnlyIn(value=Dist.CLIENT)
public interface VertexConsumer
extends IVertexConsumerExtension {
    public VertexConsumer vertex(double var1, double var3, double var5);

    public VertexConsumer color(int var1, int var2, int var3, int var4);

    public VertexConsumer uv(float var1, float var2);

    public VertexConsumer overlayCoords(int var1, int var2);

    public VertexConsumer uv2(int var1, int var2);

    public VertexConsumer normal(float var1, float var2, float var3);

    public void endVertex();

    default public void vertex(float p_85955_, float p_85956_, float p_85957_, float p_85958_, float p_85959_, float p_85960_, float p_85961_, float p_85962_, float p_85963_, int p_85964_, int p_85965_, float p_85966_, float p_85967_, float p_85968_) {
        this.vertex(p_85955_, p_85956_, p_85957_);
        this.color(p_85958_, p_85959_, p_85960_, p_85961_);
        this.uv(p_85962_, p_85963_);
        this.overlayCoords(p_85964_);
        this.uv2(p_85965_);
        this.normal(p_85966_, p_85967_, p_85968_);
        this.endVertex();
    }

    public void defaultColor(int var1, int var2, int var3, int var4);

    public void unsetDefaultColor();

    default public VertexConsumer color(float p_85951_, float p_85952_, float p_85953_, float p_85954_) {
        return this.color((int)(p_85951_ * 255.0f), (int)(p_85952_ * 255.0f), (int)(p_85953_ * 255.0f), (int)(p_85954_ * 255.0f));
    }

    default public VertexConsumer color(int p_193480_) {
        return this.color(FastColor.ARGB32.red((int)p_193480_), FastColor.ARGB32.green((int)p_193480_), FastColor.ARGB32.blue((int)p_193480_), FastColor.ARGB32.alpha((int)p_193480_));
    }

    default public VertexConsumer uv2(int p_85970_) {
        return this.uv2(p_85970_ & 0xFFFF, p_85970_ >> 16 & 0xFFFF);
    }

    default public VertexConsumer overlayCoords(int p_86009_) {
        return this.overlayCoords(p_86009_ & 0xFFFF, p_86009_ >> 16 & 0xFFFF);
    }

    default public void putBulkData(PoseStack.Pose p_85996_, BakedQuad p_85997_, float p_85999_, float p_86000_, float p_86001_, float p_331520_, int p_86003_, int p_331548_) {
        this.putBulkData(p_85996_, p_85997_, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, p_85999_, p_86000_, p_86001_, p_331520_, new int[]{p_86003_, p_86003_, p_86003_, p_86003_}, p_331548_, false);
    }

    default public void putBulkData(PoseStack.Pose p_85988_, BakedQuad p_85989_, float[] p_331397_, float p_85990_, float p_85991_, float p_85992_, float p_331416_, int[] p_331378_, int p_85993_, boolean p_331268_) {
        float[] afloat = new float[]{p_331397_[0], p_331397_[1], p_331397_[2], p_331397_[3]};
        int[] aint = new int[]{p_331378_[0], p_331378_[1], p_331378_[2], p_331378_[3]};
        int[] aint1 = p_85989_.getVertices();
        Vec3i vec3i = p_85989_.getDirection().getNormal();
        Matrix4f matrix4f = p_85988_.pose();
        Vector3f vector3f = p_85988_.transformNormal(vec3i.getX(), vec3i.getY(), vec3i.getZ(), new Vector3f());
        int i = 8;
        int j = aint1.length / 8;
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            ByteBuffer bytebuffer = memorystack.malloc(DefaultVertexFormat.BLOCK.getVertexSize());
            IntBuffer intbuffer = bytebuffer.asIntBuffer();
            for (int k = 0; k < j; ++k) {
                float f5;
                float f4;
                float f3;
                intbuffer.clear();
                intbuffer.put(aint1, k * 8, 8);
                float f = bytebuffer.getFloat(0);
                float f1 = bytebuffer.getFloat(4);
                float f2 = bytebuffer.getFloat(8);
                if (p_331268_) {
                    float f6 = (float)(bytebuffer.get(12) & 0xFF) / 255.0f;
                    float f7 = (float)(bytebuffer.get(13) & 0xFF) / 255.0f;
                    float f8 = (float)(bytebuffer.get(14) & 0xFF) / 255.0f;
                    f3 = f6 * afloat[k] * p_85990_;
                    f4 = f7 * afloat[k] * p_85991_;
                    f5 = f8 * afloat[k] * p_85992_;
                } else {
                    f3 = afloat[k] * p_85990_;
                    f4 = afloat[k] * p_85991_;
                    f5 = afloat[k] * p_85992_;
                }
                int l = this.applyBakedLighting(p_331378_[k], bytebuffer);
                float f9 = bytebuffer.getFloat(16);
                float f10 = bytebuffer.getFloat(20);
                Vector4f vector4f = matrix4f.transform(new Vector4f(f, f1, f2, 1.0f));
                this.applyBakedNormals(vector3f, bytebuffer, p_85988_.normal());
                float vertexAlpha = p_331268_ ? p_331416_ * (float)(bytebuffer.get(15) & 0xFF) / 255.0f : p_331416_;
                this.vertex(vector4f.x(), vector4f.y(), vector4f.z(), f3, f4, f5, vertexAlpha, f9, f10, p_85993_, l, vector3f.x(), vector3f.y(), vector3f.z());
            }
        }
    }

    default public VertexConsumer vertex(PoseStack.Pose p_324031_, float p_323557_, float p_324535_, float p_324157_) {
        return this.vertex(p_324031_.pose(), p_323557_, p_324535_, p_324157_);
    }

    default public VertexConsumer vertex(Matrix4f p_254075_, float p_254519_, float p_253869_, float p_253980_) {
        Vector3f vector3f = p_254075_.transformPosition(p_254519_, p_253869_, p_253980_, new Vector3f());
        return this.vertex(vector3f.x(), vector3f.y(), vector3f.z());
    }

    default public VertexConsumer normal(PoseStack.Pose p_323641_, float p_254430_, float p_253877_, float p_254167_) {
        Vector3f vector3f = p_323641_.transformNormal(p_254430_, p_253877_, p_254167_, new Vector3f());
        return this.normal(vector3f.x(), vector3f.y(), vector3f.z());
    }
}

