/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.controls;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.screens.controls.KeyBindsScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.ArrayUtils;

@OnlyIn(value=Dist.CLIENT)
public class KeyBindsList
extends ContainerObjectSelectionList<Entry> {
    private static final int ITEM_HEIGHT = 20;
    final KeyBindsScreen keyBindsScreen;
    private int maxNameWidth;

    public KeyBindsList(KeyBindsScreen p_193861_, Minecraft p_193862_) {
        super(p_193862_, p_193861_.width, p_193861_.layout.getContentHeight(), p_193861_.layout.getHeaderHeight(), 20);
        this.keyBindsScreen = p_193861_;
        KeyMapping[] akeymapping = (KeyMapping[])ArrayUtils.clone((Object[])p_193862_.options.keyMappings);
        Arrays.sort(akeymapping);
        String s = null;
        for (KeyMapping keymapping : akeymapping) {
            MutableComponent component;
            int i;
            String s1 = keymapping.getCategory();
            if (!s1.equals(s)) {
                s = s1;
                this.addEntry((AbstractSelectionList.Entry)new CategoryEntry((Component)Component.translatable((String)s1)));
            }
            if ((i = p_193862_.font.width((FormattedText)(component = Component.translatable((String)keymapping.getName())))) > this.maxNameWidth) {
                this.maxNameWidth = i;
            }
            this.addEntry((AbstractSelectionList.Entry)new KeyEntry(keymapping, (Component)component));
        }
    }

    public void resetMappingAndUpdateButtons() {
        KeyMapping.resetMapping();
        this.refreshEntries();
    }

    public void refreshEntries() {
        this.children().forEach(Entry::refreshEntry);
    }

    public int getRowWidth() {
        return 340;
    }

    @OnlyIn(value=Dist.CLIENT)
    public class CategoryEntry
    extends Entry {
        final Component name;
        private final int width;

        public CategoryEntry(Component p_193886_) {
            this.name = p_193886_;
            this.width = ((KeyBindsList)KeyBindsList.this).minecraft.font.width((FormattedText)this.name);
        }

        public void render(GuiGraphics p_281285_, int p_281396_, int p_283616_, int p_281333_, int p_282287_, int p_283549_, int p_283684_, int p_283258_, boolean p_281563_, float p_283186_) {
            p_281285_.drawString(((KeyBindsList)KeyBindsList.this).minecraft.font, this.name, KeyBindsList.this.width / 2 - this.width / 2, p_283616_ + p_283549_ - 9 - 1, -1, false);
        }

        @Nullable
        public ComponentPath nextFocusPath(FocusNavigationEvent p_265391_) {
            return null;
        }

        public List<? extends GuiEventListener> children() {
            return Collections.emptyList();
        }

        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)new NarratableEntry(){

                public NarratableEntry.NarrationPriority narrationPriority() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void updateNarration(NarrationElementOutput p_193906_) {
                    p_193906_.add(NarratedElementType.TITLE, CategoryEntry.this.name);
                }
            });
        }

        @Override
        protected void refreshEntry() {
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class KeyEntry
    extends Entry {
        private static final Component RESET_BUTTON_TITLE = Component.translatable((String)"controls.reset");
        private static final int PADDING = 10;
        private final KeyMapping key;
        private final Component name;
        private final Button changeButton;
        private final Button resetButton;
        private boolean hasCollision = false;

        KeyEntry(KeyMapping p_193916_, Component p_193917_) {
            this.key = p_193916_;
            this.name = p_193917_;
            this.changeButton = Button.builder(p_193917_, p_269618_ -> {
                KeyBindsList.this.keyBindsScreen.selectedKey = p_193916_;
                KeyBindsList.this.resetMappingAndUpdateButtons();
            }).bounds(0, 0, 75, 20).createNarration(p_253311_ -> p_193916_.isUnbound() ? Component.translatable((String)"narrator.controls.unbound", (Object[])new Object[]{p_193917_}) : Component.translatable((String)"narrator.controls.bound", (Object[])new Object[]{p_193917_, p_253311_.get()})).build();
            this.resetButton = Button.builder(RESET_BUTTON_TITLE, p_329729_ -> {
                this.key.setToDefault();
                ((KeyBindsList)KeyBindsList.this).minecraft.options.setKey(p_193916_, p_193916_.getDefaultKey());
                KeyBindsList.this.resetMappingAndUpdateButtons();
            }).bounds(0, 0, 50, 20).createNarration(p_253313_ -> Component.translatable((String)"narrator.controls.reset", (Object[])new Object[]{p_193917_})).build();
            this.refreshEntry();
        }

        public void render(GuiGraphics p_281805_, int p_281298_, int p_282357_, int p_281373_, int p_283433_, int p_281932_, int p_282224_, int p_282053_, boolean p_282605_, float p_281432_) {
            int i = KeyBindsList.this.getScrollbarPosition() - this.resetButton.getWidth() - 10;
            int j = p_282357_ - 2;
            this.resetButton.setPosition(i, j);
            this.resetButton.render(p_281805_, p_282224_, p_282053_, p_281432_);
            int k = i - 5 - this.changeButton.getWidth();
            this.changeButton.setPosition(k, j);
            this.changeButton.render(p_281805_, p_282224_, p_282053_, p_281432_);
            p_281805_.drawScrollingString(((KeyBindsList)KeyBindsList.this).minecraft.font, this.name, p_281373_, k - 9, p_282357_ + p_281932_ / 2 - 4, -1);
            if (this.hasCollision) {
                int l = 3;
                int i1 = this.changeButton.getX() - 6;
                p_281805_.fill(i1, p_282357_ - 1, i1 + 3, p_282357_ + p_281932_, -65536);
            }
        }

        public List<? extends GuiEventListener> children() {
            return ImmutableList.of((Object)this.changeButton, (Object)this.resetButton);
        }

        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)this.changeButton, (Object)this.resetButton);
        }

        @Override
        protected void refreshEntry() {
            this.changeButton.setMessage(this.key.getTranslatedKeyMessage());
            this.resetButton.active = !this.key.isDefault();
            this.hasCollision = false;
            MutableComponent mutablecomponent = Component.empty();
            if (!this.key.isUnbound()) {
                for (KeyMapping keymapping : ((KeyBindsList)KeyBindsList.this).minecraft.options.keyMappings) {
                    if ((keymapping == this.key || !this.key.same(keymapping)) && !keymapping.hasKeyModifierConflict(this.key)) continue;
                    if (this.hasCollision) {
                        mutablecomponent.append(", ");
                    }
                    this.hasCollision = true;
                    mutablecomponent.append((Component)Component.translatable((String)keymapping.getName()));
                }
            }
            if (this.hasCollision) {
                this.changeButton.setMessage((Component)Component.literal((String)"[ ").append((Component)this.changeButton.getMessage().copy().withStyle(ChatFormatting.WHITE)).append(" ]").withStyle(ChatFormatting.RED));
                this.changeButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"controls.keybinds.duplicateKeybinds", (Object[])new Object[]{mutablecomponent})));
            } else {
                this.changeButton.setTooltip(null);
            }
            if (KeyBindsList.this.keyBindsScreen.selectedKey == this.key) {
                this.changeButton.setMessage((Component)Component.literal((String)"> ").append((Component)this.changeButton.getMessage().copy().withStyle(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.UNDERLINE})).append(" <").withStyle(ChatFormatting.YELLOW));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        abstract void refreshEntry();
    }
}

