/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.main;

import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.blaze3d.platform.DisplayData;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.logging.LogUtils;
import com.mojang.util.UndashedUuid;
import java.io.File;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import javax.annotation.Nullable;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.User;
import net.minecraft.client.main.GameConfig;
import net.minecraft.client.main.SilentInitException;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.client.telemetry.TelemetryProperty;
import net.minecraft.client.telemetry.events.GameLoadTimesEvent;
import net.minecraft.core.UUIDUtil;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.server.Bootstrap;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.NativeModuleLister;
import net.minecraft.util.profiling.jfr.Environment;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.loading.BackgroundWaiter;
import net.neoforged.fml.loading.FMLLoader;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class Main {
    static final Logger LOGGER = LogUtils.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DontObfuscate
    public static void main(String[] p_129642_) {
        Thread thread1;
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)Ticker.systemTicker());
        Stopwatch stopwatch1 = Stopwatch.createStarted((Ticker)Ticker.systemTicker());
        GameLoadTimesEvent.INSTANCE.beginStep(TelemetryProperty.LOAD_TIME_TOTAL_TIME_MS, stopwatch);
        GameLoadTimesEvent.INSTANCE.beginStep(TelemetryProperty.LOAD_TIME_PRE_WINDOW_MS, stopwatch1);
        SharedConstants.tryDetectVersion();
        SharedConstants.enableDataFixerOptimizations();
        OptionParser optionparser = new OptionParser();
        optionparser.allowsUnrecognizedOptions();
        optionparser.accepts("demo");
        optionparser.accepts("disableMultiplayer");
        optionparser.accepts("disableChat");
        optionparser.accepts("fullscreen");
        optionparser.accepts("checkGlErrors");
        OptionSpecBuilder optionspec = optionparser.accepts("jfrProfile");
        ArgumentAcceptingOptionSpec optionspec1 = optionparser.accepts("quickPlayPath").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec2 = optionparser.accepts("quickPlaySingleplayer").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec3 = optionparser.accepts("quickPlayMultiplayer").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec4 = optionparser.accepts("quickPlayRealms").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec5 = optionparser.accepts("gameDir").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("."), (Object[])new File[0]);
        ArgumentAcceptingOptionSpec optionspec6 = optionparser.accepts("assetsDir").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec optionspec7 = optionparser.accepts("resourcePackDir").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec optionspec8 = optionparser.accepts("proxyHost").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec9 = optionparser.accepts("proxyPort").withRequiredArg().defaultsTo((Object)"8080", (Object[])new String[0]).ofType(Integer.class);
        ArgumentAcceptingOptionSpec optionspec10 = optionparser.accepts("proxyUser").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec11 = optionparser.accepts("proxyPass").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec12 = optionparser.accepts("username").withRequiredArg().defaultsTo((Object)("Player" + Util.getMillis() % 1000L), (Object[])new String[0]);
        ArgumentAcceptingOptionSpec optionspec13 = optionparser.accepts("uuid").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec14 = optionparser.accepts("xuid").withOptionalArg().defaultsTo((Object)"", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec optionspec15 = optionparser.accepts("clientId").withOptionalArg().defaultsTo((Object)"", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec optionspec16 = optionparser.accepts("accessToken").withRequiredArg().required();
        ArgumentAcceptingOptionSpec optionspec17 = optionparser.accepts("version").withRequiredArg().required();
        ArgumentAcceptingOptionSpec optionspec18 = optionparser.accepts("width").withRequiredArg().ofType(Integer.class).defaultsTo((Object)854, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec optionspec19 = optionparser.accepts("height").withRequiredArg().ofType(Integer.class).defaultsTo((Object)480, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec optionspec20 = optionparser.accepts("fullscreenWidth").withRequiredArg().ofType(Integer.class);
        ArgumentAcceptingOptionSpec optionspec21 = optionparser.accepts("fullscreenHeight").withRequiredArg().ofType(Integer.class);
        ArgumentAcceptingOptionSpec optionspec22 = optionparser.accepts("userProperties").withRequiredArg().defaultsTo((Object)"{}", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec optionspec23 = optionparser.accepts("profileProperties").withRequiredArg().defaultsTo((Object)"{}", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec optionspec24 = optionparser.accepts("assetIndex").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec25 = optionparser.accepts("userType").withRequiredArg().defaultsTo((Object)User.Type.LEGACY.getName(), (Object[])new String[0]);
        ArgumentAcceptingOptionSpec optionspec26 = optionparser.accepts("versionType").withRequiredArg().defaultsTo((Object)"release", (Object[])new String[0]);
        NonOptionArgumentSpec optionspec27 = optionparser.nonOptions();
        OptionSet optionset = optionparser.parse(p_129642_);
        List list = optionset.valuesOf((OptionSpec)optionspec27);
        if (!list.isEmpty()) {
            LOGGER.info("Completely ignored arguments: {}", (Object)list);
        }
        String s = (String)Main.parseArgument(optionset, optionspec8);
        Proxy proxy = Proxy.NO_PROXY;
        if (s != null) {
            try {
                proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(s, (int)((Integer)Main.parseArgument(optionset, optionspec9))));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        final String s1 = (String)Main.parseArgument(optionset, optionspec10);
        final String s2 = (String)Main.parseArgument(optionset, optionspec11);
        if (!proxy.equals(Proxy.NO_PROXY) && Main.stringHasValue(s1) && Main.stringHasValue(s2)) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(s1, s2.toCharArray());
                }
            });
        }
        int i = (Integer)Main.parseArgument(optionset, optionspec18);
        int j = (Integer)Main.parseArgument(optionset, optionspec19);
        OptionalInt optionalint = Main.ofNullable((Integer)Main.parseArgument(optionset, optionspec20));
        OptionalInt optionalint1 = Main.ofNullable((Integer)Main.parseArgument(optionset, optionspec21));
        boolean flag = optionset.has("fullscreen");
        boolean flag1 = optionset.has("demo");
        boolean flag2 = optionset.has("disableMultiplayer");
        boolean flag3 = optionset.has("disableChat");
        String s3 = (String)Main.parseArgument(optionset, optionspec17);
        Gson gson = new GsonBuilder().registerTypeAdapter(PropertyMap.class, (Object)new PropertyMap.Serializer()).create();
        PropertyMap propertymap = (PropertyMap)GsonHelper.fromJson((Gson)gson, (String)((String)Main.parseArgument(optionset, optionspec22)), PropertyMap.class);
        PropertyMap propertymap1 = (PropertyMap)GsonHelper.fromJson((Gson)gson, (String)((String)Main.parseArgument(optionset, optionspec23)), PropertyMap.class);
        String s4 = (String)Main.parseArgument(optionset, optionspec26);
        File file1 = (File)Main.parseArgument(optionset, optionspec5);
        File file2 = optionset.has((OptionSpec)optionspec6) ? (File)Main.parseArgument(optionset, optionspec6) : new File(file1, "assets/");
        File file3 = optionset.has((OptionSpec)optionspec7) ? (File)Main.parseArgument(optionset, optionspec7) : new File(file1, "resourcepacks/");
        UUID uuid = optionset.has((OptionSpec)optionspec13) ? UndashedUuid.fromStringLenient((String)((String)optionspec13.value(optionset))) : UUIDUtil.createOfflinePlayerUUID((String)((String)optionspec12.value(optionset)));
        String s5 = optionset.has((OptionSpec)optionspec24) ? (String)optionspec24.value(optionset) : null;
        String s6 = (String)optionset.valueOf((OptionSpec)optionspec14);
        String s7 = (String)optionset.valueOf((OptionSpec)optionspec15);
        String s8 = (String)Main.parseArgument(optionset, optionspec1);
        String s9 = Main.unescapeJavaArgument((String)Main.parseArgument(optionset, optionspec2));
        String s10 = Main.unescapeJavaArgument((String)Main.parseArgument(optionset, optionspec3));
        String s11 = Main.unescapeJavaArgument((String)Main.parseArgument(optionset, optionspec4));
        if (optionset.has((OptionSpec)optionspec)) {
            JvmProfiler.INSTANCE.start(Environment.CLIENT);
        }
        CrashReport.preload();
        try {
            BackgroundWaiter.runAndTick(() -> Bootstrap.bootStrap(), (Runnable)FMLLoader.progressWindowTick);
            GameLoadTimesEvent.INSTANCE.setBootstrapTime(Bootstrap.bootstrapDuration.get());
            Bootstrap.validate();
        }
        catch (Throwable throwable2) {
            CrashReport crashreport = CrashReport.forThrowable(throwable2, "Bootstrap");
            CrashReportCategory crashreportcategory = crashreport.addCategory("Initialization");
            NativeModuleLister.addCrashSection((CrashReportCategory)crashreportcategory);
            Minecraft.fillReport(null, null, s3, null, crashreport);
            Minecraft.crash(null, file1, crashreport);
            return;
        }
        String s12 = (String)optionspec25.value(optionset);
        User.Type user$type = User.Type.byName(s12);
        if (user$type == null) {
            LOGGER.warn("Unrecognized user type: {}", (Object)s12);
        }
        User user = new User((String)optionspec12.value(optionset), uuid, (String)optionspec16.value(optionset), Main.emptyStringToEmptyOptional(s6), Main.emptyStringToEmptyOptional(s7), user$type);
        GameConfig gameconfig = new GameConfig(new GameConfig.UserData(user, propertymap, propertymap1, proxy), new DisplayData(i, j, optionalint, optionalint1, flag), new GameConfig.FolderData(file1, file3, file2, s5), new GameConfig.GameData(flag1, s3, s4, flag2, flag3), new GameConfig.QuickPlayData(s8, s9, s10, s11));
        Util.startTimerHackThread();
        Thread thread = new Thread("Client Shutdown Thread"){

            @Override
            public void run() {
                IntegratedServer integratedserver;
                Minecraft minecraft2 = Minecraft.getInstance();
                if (minecraft2 != null && (integratedserver = minecraft2.getSingleplayerServer()) != null) {
                    integratedserver.halt(true);
                }
            }
        };
        thread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(LOGGER));
        Runtime.getRuntime().addShutdownHook(thread);
        Minecraft minecraft = null;
        try {
            Thread.currentThread().setName("Render thread");
            RenderSystem.initRenderThread();
            RenderSystem.beginInitialization();
            minecraft = new Minecraft(gameconfig);
            RenderSystem.finishInitialization();
        }
        catch (SilentInitException silentinitexception) {
            Util.shutdownExecutors();
            LOGGER.warn("Failed to create window: ", (Throwable)silentinitexception);
            return;
        }
        catch (Throwable throwable1) {
            CrashReport crashreport1 = CrashReport.forThrowable(throwable1, "Initializing game");
            CrashReportCategory crashreportcategory1 = crashreport1.addCategory("Initialization");
            NativeModuleLister.addCrashSection((CrashReportCategory)crashreportcategory1);
            Minecraft.fillReport(minecraft, null, gameconfig.game.launchVersion, null, crashreport1);
            Minecraft.crash(minecraft, gameconfig.location.gameDirectory, crashreport1);
            return;
        }
        final Minecraft minecraft1 = minecraft;
        if (minecraft.renderOnThread()) {
            thread1 = new Thread("Game thread"){

                @Override
                public void run() {
                    try {
                        RenderSystem.initGameThread(true);
                        minecraft1.run();
                    }
                    catch (Throwable throwable3) {
                        LOGGER.error("Exception in client thread", throwable3);
                    }
                }
            };
            thread1.start();
            while (minecraft1.isRunning()) {
            }
        } else {
            thread1 = null;
            try {
                RenderSystem.initGameThread(false);
                minecraft1.run();
            }
            catch (Throwable throwable) {
                LOGGER.error("Unhandled game exception", throwable);
            }
        }
        BufferUploader.reset();
        try {
            minecraft1.stop();
            if (thread1 != null) {
                thread1.join();
            }
        }
        catch (InterruptedException interruptedexception) {
            LOGGER.error("Exception during client thread shutdown", (Throwable)interruptedexception);
        }
        finally {
            minecraft1.destroy();
        }
    }

    @Nullable
    private static String unescapeJavaArgument(@Nullable String p_301984_) {
        return p_301984_ == null ? null : StringEscapeUtils.unescapeJava((String)p_301984_);
    }

    private static Optional<String> emptyStringToEmptyOptional(String p_195487_) {
        return p_195487_.isEmpty() ? Optional.empty() : Optional.of(p_195487_);
    }

    private static OptionalInt ofNullable(@Nullable Integer p_129635_) {
        return p_129635_ != null ? OptionalInt.of(p_129635_) : OptionalInt.empty();
    }

    @Nullable
    private static <T> T parseArgument(OptionSet p_129639_, OptionSpec<T> p_129640_) {
        try {
            return (T)p_129639_.valueOf(p_129640_);
        }
        catch (Throwable throwable) {
            ArgumentAcceptingOptionSpec argumentacceptingoptionspec;
            List list;
            if (p_129640_ instanceof ArgumentAcceptingOptionSpec && !(list = (argumentacceptingoptionspec = (ArgumentAcceptingOptionSpec)p_129640_).defaultValues()).isEmpty()) {
                return (T)list.get(0);
            }
            throw throwable;
        }
    }

    private static boolean stringHasValue(@Nullable String p_129637_) {
        return p_129637_ != null && !p_129637_.isEmpty();
    }

    static {
        System.setProperty("java.awt.headless", "true");
    }
}

