/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.prediction.BlockStatePredictionHandler;
import net.minecraft.client.multiplayer.prediction.PredictiveAction;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundContainerButtonClickPacket;
import net.minecraft.network.protocol.game.ServerboundContainerClickPacket;
import net.minecraft.network.protocol.game.ServerboundContainerSlotStateChangedPacket;
import net.minecraft.network.protocol.game.ServerboundInteractPacket;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.network.protocol.game.ServerboundPickItemPacket;
import net.minecraft.network.protocol.game.ServerboundPlaceRecipePacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.network.protocol.game.ServerboundSetCarriedItemPacket;
import net.minecraft.network.protocol.game.ServerboundSetCreativeModeSlotPacket;
import net.minecraft.network.protocol.game.ServerboundUseItemOnPacket;
import net.minecraft.network.protocol.game.ServerboundUseItemPacket;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.StatsCounter;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class MultiPlayerGameMode {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Minecraft minecraft;
    private final ClientPacketListener connection;
    private BlockPos destroyBlockPos = new BlockPos(-1, -1, -1);
    private ItemStack destroyingItem = ItemStack.EMPTY;
    private float destroyProgress;
    private float destroyTicks;
    private int destroyDelay;
    private boolean isDestroying;
    private GameType localPlayerMode = GameType.DEFAULT_MODE;
    @Nullable
    private GameType previousLocalPlayerMode;
    private int carriedIndex;

    public MultiPlayerGameMode(Minecraft p_105203_, ClientPacketListener p_105204_) {
        this.minecraft = p_105203_;
        this.connection = p_105204_;
    }

    public void adjustPlayer(Player p_105222_) {
        this.localPlayerMode.updatePlayerAbilities(p_105222_.getAbilities());
    }

    public void setLocalMode(GameType p_171806_, @Nullable GameType p_171807_) {
        this.localPlayerMode = p_171806_;
        this.previousLocalPlayerMode = p_171807_;
        this.localPlayerMode.updatePlayerAbilities(this.minecraft.player.getAbilities());
    }

    public void setLocalMode(GameType p_105280_) {
        if (p_105280_ != this.localPlayerMode) {
            this.previousLocalPlayerMode = this.localPlayerMode;
        }
        this.localPlayerMode = p_105280_;
        this.localPlayerMode.updatePlayerAbilities(this.minecraft.player.getAbilities());
    }

    public boolean canHurtPlayer() {
        return this.localPlayerMode.isSurvival();
    }

    public boolean destroyBlock(BlockPos p_105268_) {
        if (this.minecraft.player.blockActionRestricted(this.minecraft.level, p_105268_, this.localPlayerMode)) {
            return false;
        }
        ClientLevel level = this.minecraft.level;
        BlockState blockstate = level.getBlockState(p_105268_);
        if (!this.minecraft.player.getMainHandItem().getItem().canAttackBlock(blockstate, level, p_105268_, this.minecraft.player)) {
            return false;
        }
        Block block = blockstate.getBlock();
        if (block instanceof GameMasterBlock && !this.minecraft.player.canUseGameMasterBlocks()) {
            return false;
        }
        if (blockstate.isAir()) {
            return false;
        }
        BlockState removedBlockState = block.playerWillDestroy(level, p_105268_, blockstate, this.minecraft.player);
        FluidState fluidstate = level.getFluidState(p_105268_);
        boolean flag = blockstate.onDestroyedByPlayer(level, p_105268_, this.minecraft.player, false, fluidstate);
        if (flag) {
            block.destroy(level, p_105268_, removedBlockState);
        }
        return flag;
    }

    public boolean startDestroyBlock(BlockPos p_105270_, Direction p_105271_) {
        if (this.minecraft.player.blockActionRestricted(this.minecraft.level, p_105270_, this.localPlayerMode)) {
            return false;
        }
        if (!this.minecraft.level.getWorldBorder().isWithinBounds(p_105270_)) {
            return false;
        }
        if (this.localPlayerMode.isCreative()) {
            BlockState blockstate = this.minecraft.level.getBlockState(p_105270_);
            this.minecraft.getTutorial().onDestroyBlock(this.minecraft.level, p_105270_, blockstate, 1.0f);
            this.startPrediction(this.minecraft.level, p_233757_ -> {
                if (!CommonHooks.onLeftClickBlock((Player)this.minecraft.player, (BlockPos)p_105270_, (Direction)p_105271_, (ServerboundPlayerActionPacket.Action)ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK).isCanceled()) {
                    this.destroyBlock(p_105270_);
                }
                return new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK, p_105270_, p_105271_, p_233757_);
            });
            this.destroyDelay = 5;
        } else if (!this.isDestroying || !this.sameDestroyTarget(p_105270_)) {
            if (this.isDestroying) {
                this.connection.send((Packet<?>)new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.ABORT_DESTROY_BLOCK, this.destroyBlockPos, p_105271_));
            }
            PlayerInteractEvent.LeftClickBlock event = CommonHooks.onLeftClickBlock((Player)this.minecraft.player, (BlockPos)p_105270_, (Direction)p_105271_, (ServerboundPlayerActionPacket.Action)ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK);
            BlockState blockstate1 = this.minecraft.level.getBlockState(p_105270_);
            this.minecraft.getTutorial().onDestroyBlock(this.minecraft.level, p_105270_, blockstate1, 0.0f);
            this.startPrediction(this.minecraft.level, p_233728_ -> {
                boolean flag;
                boolean bl = flag = !blockstate1.isAir();
                if (flag && this.destroyProgress == 0.0f && event.getUseBlock() != TriState.FALSE) {
                    blockstate1.attack(this.minecraft.level, p_105270_, this.minecraft.player);
                }
                ServerboundPlayerActionPacket packet = new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK, p_105270_, p_105271_, p_233728_);
                if (event.getUseItem().isFalse()) {
                    return packet;
                }
                if (flag && blockstate1.getDestroyProgress(this.minecraft.player, (BlockGetter)((Object)this.minecraft.player.level()), p_105270_) >= 1.0f) {
                    this.destroyBlock(p_105270_);
                } else {
                    this.isDestroying = true;
                    this.destroyBlockPos = p_105270_;
                    this.destroyingItem = this.minecraft.player.getMainHandItem();
                    this.destroyProgress = 0.0f;
                    this.destroyTicks = 0.0f;
                    this.minecraft.level.destroyBlockProgress(this.minecraft.player.getId(), this.destroyBlockPos, this.getDestroyStage());
                }
                return packet;
            });
        }
        return true;
    }

    public void stopDestroyBlock() {
        if (this.isDestroying) {
            BlockState blockstate = this.minecraft.level.getBlockState(this.destroyBlockPos);
            this.minecraft.getTutorial().onDestroyBlock(this.minecraft.level, this.destroyBlockPos, blockstate, -1.0f);
            this.connection.send((Packet<?>)new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.ABORT_DESTROY_BLOCK, this.destroyBlockPos, Direction.DOWN));
            this.isDestroying = false;
            this.destroyProgress = 0.0f;
            this.minecraft.level.destroyBlockProgress(this.minecraft.player.getId(), this.destroyBlockPos, -1);
            this.minecraft.player.resetAttackStrengthTicker();
        }
    }

    public boolean continueDestroyBlock(BlockPos p_105284_, Direction p_105285_) {
        this.ensureHasSentCarriedItem();
        if (this.destroyDelay > 0) {
            --this.destroyDelay;
            return true;
        }
        if (this.localPlayerMode.isCreative() && this.minecraft.level.getWorldBorder().isWithinBounds(p_105284_)) {
            this.destroyDelay = 5;
            BlockState blockstate1 = this.minecraft.level.getBlockState(p_105284_);
            this.minecraft.getTutorial().onDestroyBlock(this.minecraft.level, p_105284_, blockstate1, 1.0f);
            this.startPrediction(this.minecraft.level, p_233753_ -> {
                if (!CommonHooks.onLeftClickBlock((Player)this.minecraft.player, (BlockPos)p_105284_, (Direction)p_105285_, (ServerboundPlayerActionPacket.Action)ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK).isCanceled()) {
                    this.destroyBlock(p_105284_);
                }
                return new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK, p_105284_, p_105285_, p_233753_);
            });
            return true;
        }
        if (this.sameDestroyTarget(p_105284_)) {
            BlockState blockstate = this.minecraft.level.getBlockState(p_105284_);
            if (blockstate.isAir()) {
                this.isDestroying = false;
                return false;
            }
            this.destroyProgress += blockstate.getDestroyProgress(this.minecraft.player, (BlockGetter)((Object)this.minecraft.player.level()), p_105284_);
            if (this.destroyTicks % 4.0f == 0.0f) {
                SoundType soundtype = blockstate.getSoundType((LevelReader)((Object)this.minecraft.level), p_105284_, this.minecraft.player);
                this.minecraft.getSoundManager().play((SoundInstance)new SimpleSoundInstance(soundtype.getHitSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 8.0f, soundtype.getPitch() * 0.5f, SoundInstance.createUnseededRandom(), p_105284_));
            }
            this.destroyTicks += 1.0f;
            this.minecraft.getTutorial().onDestroyBlock(this.minecraft.level, p_105284_, blockstate, Mth.clamp((float)this.destroyProgress, (float)0.0f, (float)1.0f));
            if (CommonHooks.onClientMineHold((Player)this.minecraft.player, (BlockPos)p_105284_, (Direction)p_105285_).getUseItem().isFalse()) {
                return true;
            }
            if (this.destroyProgress >= 1.0f) {
                this.isDestroying = false;
                this.startPrediction(this.minecraft.level, p_233739_ -> {
                    this.destroyBlock(p_105284_);
                    return new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.STOP_DESTROY_BLOCK, p_105284_, p_105285_, p_233739_);
                });
                this.destroyProgress = 0.0f;
                this.destroyTicks = 0.0f;
                this.destroyDelay = 5;
            }
            this.minecraft.level.destroyBlockProgress(this.minecraft.player.getId(), this.destroyBlockPos, this.getDestroyStage());
            return true;
        }
        return this.startDestroyBlock(p_105284_, p_105285_);
    }

    private void startPrediction(ClientLevel p_233730_, PredictiveAction p_233731_) {
        try (BlockStatePredictionHandler blockstatepredictionhandler = p_233730_.getBlockStatePredictionHandler().startPredicting();){
            int i = blockstatepredictionhandler.currentSequence();
            Packet packet = p_233731_.predict(i);
            this.connection.send(packet);
        }
    }

    public void tick() {
        this.ensureHasSentCarriedItem();
        if (this.connection.getConnection().isConnected()) {
            this.connection.getConnection().tick();
        } else {
            this.connection.getConnection().handleDisconnection();
        }
    }

    private boolean sameDestroyTarget(BlockPos p_105282_) {
        ItemStack itemstack = this.minecraft.player.getMainHandItem();
        return p_105282_.equals((Object)this.destroyBlockPos) && !this.destroyingItem.shouldCauseBlockBreakReset(itemstack);
    }

    private void ensureHasSentCarriedItem() {
        int i = this.minecraft.player.getInventory().selected;
        if (i != this.carriedIndex) {
            this.carriedIndex = i;
            this.connection.send((Packet<?>)new ServerboundSetCarriedItemPacket(this.carriedIndex));
        }
    }

    public InteractionResult useItemOn(LocalPlayer p_233733_, InteractionHand p_233734_, BlockHitResult p_233735_) {
        this.ensureHasSentCarriedItem();
        if (!this.minecraft.level.getWorldBorder().isWithinBounds(p_233735_.getBlockPos())) {
            return InteractionResult.FAIL;
        }
        MutableObject mutableobject = new MutableObject();
        this.startPrediction(this.minecraft.level, p_233745_ -> {
            mutableobject.setValue((Object)this.performUseItemOn(p_233733_, p_233734_, p_233735_));
            return new ServerboundUseItemOnPacket(p_233734_, p_233735_, p_233745_);
        });
        return (InteractionResult)mutableobject.getValue();
    }

    private InteractionResult performUseItemOn(LocalPlayer p_233747_, InteractionHand p_233748_, BlockHitResult p_233749_) {
        boolean flag1;
        InteractionResult result;
        BlockPos blockpos = p_233749_.getBlockPos();
        ItemStack itemstack = p_233747_.getItemInHand(p_233748_);
        PlayerInteractEvent.RightClickBlock event = CommonHooks.onRightClickBlock((Player)p_233747_, (InteractionHand)p_233748_, (BlockPos)blockpos, (BlockHitResult)p_233749_);
        if (event.isCanceled()) {
            return event.getCancellationResult();
        }
        if (this.localPlayerMode == GameType.SPECTATOR) {
            return InteractionResult.SUCCESS;
        }
        UseOnContext useoncontext = new UseOnContext((Player)p_233747_, p_233748_, p_233749_);
        if (event.getUseItem() != TriState.FALSE && (result = itemstack.onItemUseFirst(useoncontext)) != InteractionResult.PASS) {
            return result;
        }
        boolean flag = !p_233747_.getMainHandItem().doesSneakBypassUse((LevelReader)((Object)p_233747_.level()), blockpos, p_233747_) || !p_233747_.getOffhandItem().doesSneakBypassUse((LevelReader)((Object)p_233747_.level()), blockpos, p_233747_);
        boolean bl = flag1 = p_233747_.isSecondaryUseActive() && flag;
        if (event.getUseBlock().isTrue() || event.getUseBlock().isDefault() && !flag1) {
            InteractionResult interactionresult;
            BlockState blockstate = this.minecraft.level.getBlockState(blockpos);
            if (!this.connection.isFeatureEnabled(blockstate.getBlock().requiredFeatures())) {
                return InteractionResult.FAIL;
            }
            ItemInteractionResult iteminteractionresult = blockstate.useItemOn(p_233747_.getItemInHand(p_233748_), this.minecraft.level, p_233747_, p_233748_, p_233749_);
            if (iteminteractionresult.consumesAction()) {
                return iteminteractionresult.result();
            }
            if (iteminteractionresult == ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION && p_233748_ == InteractionHand.MAIN_HAND && (interactionresult = blockstate.useWithoutItem(this.minecraft.level, p_233747_, p_233749_)).consumesAction()) {
                return interactionresult;
            }
        }
        if (event.getUseItem().isFalse()) {
            return InteractionResult.PASS;
        }
        if (event.getUseItem().isTrue() || !itemstack.isEmpty() && !p_233747_.getCooldowns().isOnCooldown(itemstack.getItem())) {
            InteractionResult interactionresult1;
            if (this.localPlayerMode.isCreative()) {
                int i = itemstack.getCount();
                interactionresult1 = itemstack.useOn(useoncontext);
                itemstack.setCount(i);
            } else {
                interactionresult1 = itemstack.useOn(useoncontext);
            }
            return interactionresult1;
        }
        return InteractionResult.PASS;
    }

    public InteractionResult useItem(Player p_233722_, InteractionHand p_233723_) {
        if (this.localPlayerMode == GameType.SPECTATOR) {
            return InteractionResult.PASS;
        }
        this.ensureHasSentCarriedItem();
        this.connection.send((Packet<?>)new ServerboundMovePlayerPacket.PosRot(p_233722_.getX(), p_233722_.getY(), p_233722_.getZ(), p_233722_.getYRot(), p_233722_.getXRot(), p_233722_.onGround()));
        MutableObject mutableobject = new MutableObject();
        this.startPrediction(this.minecraft.level, p_233720_ -> {
            ServerboundUseItemPacket serverbounduseitempacket = new ServerboundUseItemPacket(p_233723_, p_233720_);
            ItemStack itemstack = p_233722_.getItemInHand(p_233723_);
            if (p_233722_.getCooldowns().isOnCooldown(itemstack.getItem())) {
                mutableobject.setValue((Object)InteractionResult.PASS);
                return serverbounduseitempacket;
            }
            InteractionResult cancelResult = CommonHooks.onItemRightClick((Player)p_233722_, (InteractionHand)p_233723_);
            if (cancelResult != null) {
                mutableobject.setValue((Object)cancelResult);
                return serverbounduseitempacket;
            }
            InteractionResultHolder<ItemStack> interactionresultholder = itemstack.use(this.minecraft.level, p_233722_, p_233723_);
            ItemStack itemstack1 = (ItemStack)interactionresultholder.getObject();
            if (itemstack1 != itemstack) {
                p_233722_.setItemInHand(p_233723_, itemstack1);
                if (itemstack1.isEmpty()) {
                    EventHooks.onPlayerDestroyItem((Player)p_233722_, (ItemStack)itemstack, (InteractionHand)p_233723_);
                }
            }
            mutableobject.setValue((Object)interactionresultholder.getResult());
            return serverbounduseitempacket;
        });
        return (InteractionResult)mutableobject.getValue();
    }

    public LocalPlayer createPlayer(ClientLevel p_105247_, StatsCounter p_105248_, ClientRecipeBook p_105249_) {
        return this.createPlayer(p_105247_, p_105248_, p_105249_, false, false);
    }

    public LocalPlayer createPlayer(ClientLevel p_105251_, StatsCounter p_105252_, ClientRecipeBook p_105253_, boolean p_105254_, boolean p_105255_) {
        return new LocalPlayer(this.minecraft, p_105251_, this.connection, p_105252_, p_105253_, p_105254_, p_105255_);
    }

    public void attack(Player p_105224_, Entity p_105225_) {
        this.ensureHasSentCarriedItem();
        this.connection.send((Packet<?>)ServerboundInteractPacket.createAttackPacket((Entity)p_105225_, (boolean)p_105224_.isShiftKeyDown()));
        if (this.localPlayerMode != GameType.SPECTATOR) {
            p_105224_.attack(p_105225_);
            p_105224_.resetAttackStrengthTicker();
        }
    }

    public InteractionResult interact(Player p_105227_, Entity p_105228_, InteractionHand p_105229_) {
        this.ensureHasSentCarriedItem();
        this.connection.send((Packet<?>)ServerboundInteractPacket.createInteractionPacket((Entity)p_105228_, (boolean)p_105227_.isShiftKeyDown(), (InteractionHand)p_105229_));
        return this.localPlayerMode == GameType.SPECTATOR ? InteractionResult.PASS : p_105227_.interactOn(p_105228_, p_105229_);
    }

    public InteractionResult interactAt(Player p_105231_, Entity p_105232_, EntityHitResult p_105233_, InteractionHand p_105234_) {
        this.ensureHasSentCarriedItem();
        Vec3 vec3 = p_105233_.getLocation().subtract(p_105232_.getX(), p_105232_.getY(), p_105232_.getZ());
        this.connection.send((Packet<?>)ServerboundInteractPacket.createInteractionPacket((Entity)p_105232_, (boolean)p_105231_.isShiftKeyDown(), (InteractionHand)p_105234_, (Vec3)vec3));
        if (this.localPlayerMode == GameType.SPECTATOR) {
            return InteractionResult.PASS;
        }
        InteractionResult cancelResult = CommonHooks.onInteractEntityAt((Player)p_105231_, (Entity)p_105232_, (HitResult)p_105233_, (InteractionHand)p_105234_);
        if (cancelResult != null) {
            return cancelResult;
        }
        return this.localPlayerMode == GameType.SPECTATOR ? InteractionResult.PASS : p_105232_.interactAt(p_105231_, vec3, p_105234_);
    }

    public void handleInventoryMouseClick(int p_171800_, int p_171801_, int p_171802_, ClickType p_171803_, Player p_171804_) {
        AbstractContainerMenu abstractcontainermenu = p_171804_.containerMenu;
        if (p_171800_ != abstractcontainermenu.containerId) {
            LOGGER.warn("Ignoring click in mismatching container. Click in {}, player has {}.", (Object)p_171800_, (Object)abstractcontainermenu.containerId);
        } else {
            NonNullList<Slot> nonnulllist = abstractcontainermenu.slots;
            int i = nonnulllist.size();
            ArrayList list = Lists.newArrayListWithCapacity((int)i);
            for (Slot slot : nonnulllist) {
                list.add(slot.getItem().copy());
            }
            abstractcontainermenu.clicked(p_171801_, p_171802_, p_171803_, p_171804_);
            Int2ObjectOpenHashMap int2objectmap = new Int2ObjectOpenHashMap();
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack1;
                ItemStack itemstack = (ItemStack)list.get(j);
                if (ItemStack.matches(itemstack, itemstack1 = nonnulllist.get(j).getItem())) continue;
                int2objectmap.put(j, (Object)itemstack1.copy());
            }
            this.connection.send((Packet<?>)new ServerboundContainerClickPacket(p_171800_, abstractcontainermenu.getStateId(), p_171801_, p_171802_, p_171803_, abstractcontainermenu.getCarried().copy(), (Int2ObjectMap)int2objectmap));
        }
    }

    public void handlePlaceRecipe(int p_105218_, RecipeHolder<?> p_301105_, boolean p_105220_) {
        this.connection.send((Packet<?>)new ServerboundPlaceRecipePacket(p_105218_, p_301105_, p_105220_));
    }

    public void handleInventoryButtonClick(int p_105209_, int p_105210_) {
        this.connection.send((Packet<?>)new ServerboundContainerButtonClickPacket(p_105209_, p_105210_));
    }

    public void handleCreativeModeItemAdd(ItemStack p_105242_, int p_105243_) {
        if (this.localPlayerMode.isCreative() && this.connection.isFeatureEnabled(p_105242_.getItem().requiredFeatures())) {
            this.connection.send((Packet<?>)new ServerboundSetCreativeModeSlotPacket(p_105243_, p_105242_));
        }
    }

    public void handleCreativeModeItemDrop(ItemStack p_105240_) {
        if (this.localPlayerMode.isCreative() && !p_105240_.isEmpty() && this.connection.isFeatureEnabled(p_105240_.getItem().requiredFeatures())) {
            this.connection.send((Packet<?>)new ServerboundSetCreativeModeSlotPacket(-1, p_105240_));
        }
    }

    public void releaseUsingItem(Player p_105278_) {
        this.ensureHasSentCarriedItem();
        this.connection.send((Packet<?>)new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.RELEASE_USE_ITEM, BlockPos.ZERO, Direction.DOWN));
        p_105278_.releaseUsingItem();
    }

    public boolean hasExperience() {
        return this.localPlayerMode.isSurvival();
    }

    public boolean hasMissTime() {
        return !this.localPlayerMode.isCreative();
    }

    public boolean hasInfiniteItems() {
        return this.localPlayerMode.isCreative();
    }

    public boolean isServerControlledInventory() {
        return this.minecraft.player.isPassenger() && this.minecraft.player.getVehicle() instanceof HasCustomInventoryScreen;
    }

    public boolean isAlwaysFlying() {
        return this.localPlayerMode == GameType.SPECTATOR;
    }

    @Nullable
    public GameType getPreviousPlayerMode() {
        return this.previousLocalPlayerMode;
    }

    public GameType getPlayerMode() {
        return this.localPlayerMode;
    }

    public boolean isDestroying() {
        return this.isDestroying;
    }

    public int getDestroyStage() {
        return this.destroyProgress > 0.0f ? (int)(this.destroyProgress * 10.0f) : -1;
    }

    public void handlePickItem(int p_105207_) {
        this.connection.send((Packet<?>)new ServerboundPickItemPacket(p_105207_));
    }

    public void handleSlotStateChanged(int p_307527_, int p_307194_, boolean p_307559_) {
        this.connection.send((Packet<?>)new ServerboundContainerSlotStateChangedPacket(p_307527_, p_307194_, p_307559_));
    }
}

