/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.player;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.client.gui.screens.ReceivingLevelScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.BookEditScreen;
import net.minecraft.client.gui.screens.inventory.CommandBlockEditScreen;
import net.minecraft.client.gui.screens.inventory.HangingSignEditScreen;
import net.minecraft.client.gui.screens.inventory.JigsawBlockEditScreen;
import net.minecraft.client.gui.screens.inventory.MinecartCommandBlockEditScreen;
import net.minecraft.client.gui.screens.inventory.SignEditScreen;
import net.minecraft.client.gui.screens.inventory.StructureBlockEditScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.Input;
import net.minecraft.client.resources.sounds.AmbientSoundHandler;
import net.minecraft.client.resources.sounds.BiomeAmbientSoundsHandler;
import net.minecraft.client.resources.sounds.BubbleColumnAmbientSoundHandler;
import net.minecraft.client.resources.sounds.ElytraOnPlayerSoundInstance;
import net.minecraft.client.resources.sounds.RidingMinecartSoundInstance;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.UnderwaterAmbientSoundHandler;
import net.minecraft.client.resources.sounds.UnderwaterAmbientSoundInstances;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundClientCommandPacket;
import net.minecraft.network.protocol.game.ServerboundContainerClosePacket;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.network.protocol.game.ServerboundMoveVehiclePacket;
import net.minecraft.network.protocol.game.ServerboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerCommandPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerInputPacket;
import net.minecraft.network.protocol.game.ServerboundRecipeBookSeenRecipePacket;
import net.minecraft.network.protocol.game.ServerboundSwingPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.StatsCounter;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BaseCommandBlock;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.entity.HangingSignBlockEntity;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.PlayLevelSoundEvent;
import net.neoforged.neoforge.fluids.FluidType;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class LocalPlayer
extends AbstractClientPlayer {
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final int POSITION_REMINDER_INTERVAL = 20;
    private static final int WATER_VISION_MAX_TIME = 600;
    private static final int WATER_VISION_QUICK_TIME = 100;
    private static final float WATER_VISION_QUICK_PERCENT = 0.6f;
    private static final double SUFFOCATING_COLLISION_CHECK_SCALE = 0.35;
    private static final double MINOR_COLLISION_ANGLE_THRESHOLD_RADIAN = 0.13962633907794952;
    private static final float DEFAULT_SNEAKING_MOVEMENT_FACTOR = 0.3f;
    public final ClientPacketListener connection;
    private final StatsCounter stats;
    private final ClientRecipeBook recipeBook;
    private final List<AmbientSoundHandler> ambientSoundHandlers = Lists.newArrayList();
    private int permissionLevel = 0;
    private double xLast;
    private double yLast1;
    private double zLast;
    private float yRotLast;
    private float xRotLast;
    private boolean lastOnGround;
    private boolean crouching;
    private boolean wasShiftKeyDown;
    private boolean wasSprinting;
    private int positionReminder;
    private boolean flashOnSetHealth;
    public Input input;
    protected final Minecraft minecraft;
    protected int sprintTriggerTime;
    public float yBob;
    public float xBob;
    public float yBobO;
    public float xBobO;
    private int jumpRidingTicks;
    private float jumpRidingScale;
    public float spinningEffectIntensity;
    public float oSpinningEffectIntensity;
    private boolean startedUsingItem;
    @Nullable
    private InteractionHand usingItemHand;
    private boolean handsBusy;
    private boolean autoJumpEnabled = true;
    private int autoJumpTime;
    private boolean wasFallFlying;
    private int waterVisionTime;
    private boolean showDeathScreen = true;
    private boolean doLimitedCrafting = false;

    public LocalPlayer(Minecraft p_108621_, ClientLevel p_108622_, ClientPacketListener p_108623_, StatsCounter p_108624_, ClientRecipeBook p_108625_, boolean p_108626_, boolean p_108627_) {
        super(p_108622_, p_108623_.getLocalGameProfile());
        this.minecraft = p_108621_;
        this.connection = p_108623_;
        this.stats = p_108624_;
        this.recipeBook = p_108625_;
        this.wasShiftKeyDown = p_108626_;
        this.wasSprinting = p_108627_;
        this.ambientSoundHandlers.add((AmbientSoundHandler)new UnderwaterAmbientSoundHandler(this, p_108621_.getSoundManager()));
        this.ambientSoundHandlers.add((AmbientSoundHandler)new BubbleColumnAmbientSoundHandler(this));
        this.ambientSoundHandlers.add((AmbientSoundHandler)new BiomeAmbientSoundsHandler(this, p_108621_.getSoundManager(), p_108622_.getBiomeManager()));
    }

    @Override
    public boolean hurt(DamageSource p_108662_, float p_108663_) {
        CommonHooks.onPlayerAttack((LivingEntity)this, (DamageSource)p_108662_, (float)p_108663_);
        return false;
    }

    @Override
    public void heal(float p_108708_) {
    }

    @Override
    public boolean startRiding(Entity p_108667_, boolean p_108668_) {
        if (!super.startRiding(p_108667_, p_108668_)) {
            return false;
        }
        if (p_108667_ instanceof AbstractMinecart) {
            this.minecraft.getSoundManager().play((SoundInstance)new RidingMinecartSoundInstance((Player)this, (AbstractMinecart)((Object)p_108667_), true));
            this.minecraft.getSoundManager().play((SoundInstance)new RidingMinecartSoundInstance((Player)this, (AbstractMinecart)((Object)p_108667_), false));
        }
        return true;
    }

    @Override
    public void removeVehicle() {
        super.removeVehicle();
        this.handsBusy = false;
    }

    @Override
    public float getViewXRot(float p_108742_) {
        return this.getXRot();
    }

    @Override
    public float getViewYRot(float p_108753_) {
        return this.isPassenger() ? super.getViewYRot(p_108753_) : this.getYRot();
    }

    @Override
    public void tick() {
        if (this.level().hasChunkAt(this.getBlockX(), this.getBlockZ())) {
            super.tick();
            if (this.isPassenger()) {
                this.connection.send((Packet<?>)new ServerboundMovePlayerPacket.Rot(this.getYRot(), this.getXRot(), this.onGround()));
                this.connection.send((Packet<?>)new ServerboundPlayerInputPacket(this.xxa, this.zza, this.input.jumping, this.input.shiftKeyDown));
                Entity entity = this.getRootVehicle();
                if (entity != this && entity.isControlledByLocalInstance()) {
                    this.connection.send((Packet<?>)new ServerboundMoveVehiclePacket(entity));
                    this.sendIsSprintingIfNeeded();
                }
            } else {
                this.sendPosition();
            }
            for (AmbientSoundHandler ambientsoundhandler : this.ambientSoundHandlers) {
                ambientsoundhandler.tick();
            }
        }
    }

    public float getCurrentMood() {
        for (AmbientSoundHandler ambientsoundhandler : this.ambientSoundHandlers) {
            if (!(ambientsoundhandler instanceof BiomeAmbientSoundsHandler)) continue;
            return ((BiomeAmbientSoundsHandler)ambientsoundhandler).getMoodiness();
        }
        return 0.0f;
    }

    private void sendPosition() {
        this.sendIsSprintingIfNeeded();
        boolean flag = this.isShiftKeyDown();
        if (flag != this.wasShiftKeyDown) {
            ServerboundPlayerCommandPacket.Action serverboundplayercommandpacket$action = flag ? ServerboundPlayerCommandPacket.Action.PRESS_SHIFT_KEY : ServerboundPlayerCommandPacket.Action.RELEASE_SHIFT_KEY;
            this.connection.send((Packet<?>)new ServerboundPlayerCommandPacket((Entity)this, serverboundplayercommandpacket$action));
            this.wasShiftKeyDown = flag;
        }
        if (this.isControlledCamera()) {
            boolean flag2;
            double d4 = this.getX() - this.xLast;
            double d0 = this.getY() - this.yLast1;
            double d1 = this.getZ() - this.zLast;
            double d2 = this.getYRot() - this.yRotLast;
            double d3 = this.getXRot() - this.xRotLast;
            ++this.positionReminder;
            boolean flag1 = Mth.lengthSquared((double)d4, (double)d0, (double)d1) > Mth.square((double)2.0E-4) || this.positionReminder >= 20;
            boolean bl = flag2 = d2 != 0.0 || d3 != 0.0;
            if (this.isPassenger()) {
                Vec3 vec3 = this.getDeltaMovement();
                this.connection.send((Packet<?>)new ServerboundMovePlayerPacket.PosRot(vec3.x, -999.0, vec3.z, this.getYRot(), this.getXRot(), this.onGround()));
                flag1 = false;
            } else if (flag1 && flag2) {
                this.connection.send((Packet<?>)new ServerboundMovePlayerPacket.PosRot(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot(), this.onGround()));
            } else if (flag1) {
                this.connection.send((Packet<?>)new ServerboundMovePlayerPacket.Pos(this.getX(), this.getY(), this.getZ(), this.onGround()));
            } else if (flag2) {
                this.connection.send((Packet<?>)new ServerboundMovePlayerPacket.Rot(this.getYRot(), this.getXRot(), this.onGround()));
            } else if (this.lastOnGround != this.onGround()) {
                this.connection.send((Packet<?>)new ServerboundMovePlayerPacket.StatusOnly(this.onGround()));
            }
            if (flag1) {
                this.xLast = this.getX();
                this.yLast1 = this.getY();
                this.zLast = this.getZ();
                this.positionReminder = 0;
            }
            if (flag2) {
                this.yRotLast = this.getYRot();
                this.xRotLast = this.getXRot();
            }
            this.lastOnGround = this.onGround();
            this.autoJumpEnabled = (Boolean)this.minecraft.options.autoJump().get();
        }
    }

    private void sendIsSprintingIfNeeded() {
        boolean flag = this.isSprinting();
        if (flag != this.wasSprinting) {
            ServerboundPlayerCommandPacket.Action serverboundplayercommandpacket$action = flag ? ServerboundPlayerCommandPacket.Action.START_SPRINTING : ServerboundPlayerCommandPacket.Action.STOP_SPRINTING;
            this.connection.send((Packet<?>)new ServerboundPlayerCommandPacket((Entity)this, serverboundplayercommandpacket$action));
            this.wasSprinting = flag;
        }
    }

    public boolean drop(boolean p_108701_) {
        ServerboundPlayerActionPacket.Action serverboundplayeractionpacket$action;
        ServerboundPlayerActionPacket.Action action = serverboundplayeractionpacket$action = p_108701_ ? ServerboundPlayerActionPacket.Action.DROP_ALL_ITEMS : ServerboundPlayerActionPacket.Action.DROP_ITEM;
        if (this.isUsingItem() && this.getUsedItemHand() == InteractionHand.MAIN_HAND && (p_108701_ || this.getUseItem().getCount() == 1)) {
            this.stopUsingItem();
        }
        ItemStack itemstack = this.getInventory().removeFromSelected(p_108701_);
        this.connection.send((Packet<?>)new ServerboundPlayerActionPacket(serverboundplayeractionpacket$action, BlockPos.ZERO, Direction.DOWN));
        return !itemstack.isEmpty();
    }

    @Override
    public void swing(InteractionHand p_108660_) {
        super.swing(p_108660_);
        this.connection.send((Packet<?>)new ServerboundSwingPacket(p_108660_));
    }

    @Override
    public void respawn() {
        this.connection.send((Packet<?>)new ServerboundClientCommandPacket(ServerboundClientCommandPacket.Action.PERFORM_RESPAWN));
        KeyMapping.resetToggleKeys();
    }

    @Override
    protected void actuallyHurt(DamageSource p_108729_, float p_108730_) {
        if (!this.isInvulnerableTo(p_108729_)) {
            this.setHealth(this.getHealth() - p_108730_);
        }
    }

    @Override
    public void closeContainer() {
        this.connection.send((Packet<?>)new ServerboundContainerClosePacket(this.containerMenu.containerId));
        this.clientSideCloseContainer();
    }

    public void clientSideCloseContainer() {
        super.closeContainer();
        this.minecraft.setScreen(null);
    }

    public void hurtTo(float p_108761_) {
        if (this.flashOnSetHealth) {
            float f = this.getHealth() - p_108761_;
            if (f <= 0.0f) {
                this.setHealth(p_108761_);
                if (f < 0.0f) {
                    this.invulnerableTime = 10;
                }
            } else {
                this.lastHurt = f;
                this.invulnerableTime = 20;
                this.setHealth(p_108761_);
                this.hurtTime = this.hurtDuration = 10;
            }
        } else {
            this.setHealth(p_108761_);
            this.flashOnSetHealth = true;
        }
    }

    @Override
    public void onUpdateAbilities() {
        this.connection.send((Packet<?>)new ServerboundPlayerAbilitiesPacket(this.getAbilities()));
    }

    @Override
    public boolean isLocalPlayer() {
        return true;
    }

    @Override
    public boolean isSuppressingSlidingDownLadder() {
        return !this.getAbilities().flying && super.isSuppressingSlidingDownLadder();
    }

    @Override
    public boolean canSpawnSprintParticle() {
        return !this.getAbilities().flying && super.canSpawnSprintParticle();
    }

    @Override
    public boolean canSpawnSoulSpeedParticle() {
        return !this.getAbilities().flying && super.canSpawnSoulSpeedParticle();
    }

    protected void sendRidingJump() {
        this.connection.send((Packet<?>)new ServerboundPlayerCommandPacket((Entity)this, ServerboundPlayerCommandPacket.Action.START_RIDING_JUMP, Mth.floor((float)(this.getJumpRidingScale() * 100.0f))));
    }

    public void sendOpenInventory() {
        this.connection.send((Packet<?>)new ServerboundPlayerCommandPacket((Entity)this, ServerboundPlayerCommandPacket.Action.OPEN_INVENTORY));
    }

    public StatsCounter getStats() {
        return this.stats;
    }

    public ClientRecipeBook getRecipeBook() {
        return this.recipeBook;
    }

    public void removeRecipeHighlight(RecipeHolder<?> p_300983_) {
        if (this.recipeBook.willHighlight(p_300983_)) {
            this.recipeBook.removeHighlight(p_300983_);
            this.connection.send((Packet<?>)new ServerboundRecipeBookSeenRecipePacket(p_300983_));
        }
    }

    @Override
    public int getPermissionLevel() {
        return this.permissionLevel;
    }

    public void setPermissionLevel(int p_108649_) {
        this.permissionLevel = p_108649_;
    }

    @Override
    public void displayClientMessage(Component p_108696_, boolean p_108697_) {
        this.minecraft.getChatListener().handleSystemMessage(p_108696_, p_108697_);
    }

    private void moveTowardsClosestSpace(double p_108705_, double p_108706_) {
        BlockPos blockpos = BlockPos.containing((double)p_108705_, (double)this.getY(), (double)p_108706_);
        if (this.suffocatesAt(blockpos)) {
            Direction[] adirection;
            double d0 = p_108705_ - (double)blockpos.getX();
            double d1 = p_108706_ - (double)blockpos.getZ();
            Direction direction = null;
            double d2 = Double.MAX_VALUE;
            for (Direction direction1 : adirection = new Direction[]{Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH}) {
                double d4;
                double d3 = direction1.getAxis().choose(d0, 0.0, d1);
                double d = d4 = direction1.getAxisDirection() == Direction.AxisDirection.POSITIVE ? 1.0 - d3 : d3;
                if (!(d4 < d2) || this.suffocatesAt(blockpos.relative(direction1))) continue;
                d2 = d4;
                direction = direction1;
            }
            if (direction != null) {
                Vec3 vec3 = this.getDeltaMovement();
                if (direction.getAxis() == Direction.Axis.X) {
                    this.setDeltaMovement(0.1 * (double)direction.getStepX(), vec3.y, vec3.z);
                } else {
                    this.setDeltaMovement(vec3.x, vec3.y, 0.1 * (double)direction.getStepZ());
                }
            }
        }
    }

    private boolean suffocatesAt(BlockPos p_108747_) {
        AABB aabb = this.getBoundingBox();
        AABB aabb1 = new AABB(p_108747_.getX(), aabb.minY, p_108747_.getZ(), (double)p_108747_.getX() + 1.0, aabb.maxY, (double)p_108747_.getZ() + 1.0).deflate(1.0E-7);
        return this.level().collidesWithSuffocatingBlock(this, aabb1);
    }

    public void setExperienceValues(float p_108645_, int p_108646_, int p_108647_) {
        this.experienceProgress = p_108645_;
        this.totalExperience = p_108646_;
        this.experienceLevel = p_108647_;
    }

    @Override
    public void sendSystemMessage(Component p_234129_) {
        this.minecraft.gui.getChat().addMessage(p_234129_);
    }

    @Override
    public void handleEntityEvent(byte p_108643_) {
        if (p_108643_ >= 24 && p_108643_ <= 28) {
            this.setPermissionLevel(p_108643_ - 24);
        } else {
            super.handleEntityEvent(p_108643_);
        }
    }

    public void setShowDeathScreen(boolean p_108712_) {
        this.showDeathScreen = p_108712_;
    }

    public boolean shouldShowDeathScreen() {
        return this.showDeathScreen;
    }

    public void setDoLimitedCrafting(boolean p_302021_) {
        this.doLimitedCrafting = p_302021_;
    }

    public boolean getDoLimitedCrafting() {
        return this.doLimitedCrafting;
    }

    @Override
    public void playSound(SoundEvent p_108651_, float p_108652_, float p_108653_) {
        Holder<SoundEvent> holder = BuiltInRegistries.SOUND_EVENT.wrapAsHolder(p_108651_);
        PlayLevelSoundEvent.AtEntity event = EventHooks.onPlaySoundAtEntity((Entity)this, holder, (SoundSource)this.getSoundSource(), (float)p_108652_, (float)p_108653_);
        if (event.isCanceled() || event.getSound() == null) {
            return;
        }
        p_108651_ = (SoundEvent)event.getSound().value();
        SoundSource source = event.getSource();
        p_108652_ = event.getNewVolume();
        p_108653_ = event.getNewPitch();
        this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), p_108651_, source, p_108652_, p_108653_, false);
    }

    @Override
    public void playNotifySound(SoundEvent p_108655_, SoundSource p_108656_, float p_108657_, float p_108658_) {
        this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), p_108655_, p_108656_, p_108657_, p_108658_, false);
    }

    @Override
    public boolean isEffectiveAi() {
        return true;
    }

    @Override
    public void startUsingItem(InteractionHand p_108718_) {
        ItemStack itemstack = this.getItemInHand(p_108718_);
        if (!itemstack.isEmpty() && !this.isUsingItem()) {
            super.startUsingItem(p_108718_);
            this.startedUsingItem = true;
            this.usingItemHand = p_108718_;
        }
    }

    @Override
    public boolean isUsingItem() {
        return this.startedUsingItem;
    }

    @Override
    public void stopUsingItem() {
        super.stopUsingItem();
        this.startedUsingItem = false;
    }

    @Override
    public InteractionHand getUsedItemHand() {
        return Objects.requireNonNullElse(this.usingItemHand, InteractionHand.MAIN_HAND);
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> p_108699_) {
        super.onSyncedDataUpdated(p_108699_);
        if (DATA_LIVING_ENTITY_FLAGS.equals(p_108699_)) {
            InteractionHand interactionhand;
            boolean flag = ((Byte)this.entityData.get(DATA_LIVING_ENTITY_FLAGS) & 1) > 0;
            InteractionHand interactionHand = interactionhand = ((Byte)this.entityData.get(DATA_LIVING_ENTITY_FLAGS) & 2) > 0 ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
            if (flag && !this.startedUsingItem) {
                this.startUsingItem(interactionhand);
            } else if (!flag && this.startedUsingItem) {
                this.stopUsingItem();
            }
        }
        if (DATA_SHARED_FLAGS_ID.equals(p_108699_) && this.isFallFlying() && !this.wasFallFlying) {
            this.minecraft.getSoundManager().play((SoundInstance)new ElytraOnPlayerSoundInstance(this));
        }
    }

    @Nullable
    public PlayerRideableJumping jumpableVehicle() {
        PlayerRideableJumping playerrideablejumping;
        Entity entity = this.getControlledVehicle();
        if (entity instanceof PlayerRideableJumping && (playerrideablejumping = (PlayerRideableJumping)entity).canJump()) {
            return playerrideablejumping;
        }
        return null;
    }

    public float getJumpRidingScale() {
        return this.jumpRidingScale;
    }

    @Override
    public boolean isTextFilteringEnabled() {
        return this.minecraft.isTextFilteringEnabled();
    }

    @Override
    public void openTextEdit(SignBlockEntity p_277970_, boolean p_277980_) {
        if (p_277970_ instanceof HangingSignBlockEntity) {
            HangingSignBlockEntity hangingsignblockentity = (HangingSignBlockEntity)p_277970_;
            this.minecraft.setScreen((Screen)((Object)new HangingSignEditScreen((SignBlockEntity)hangingsignblockentity, p_277980_, this.minecraft.isTextFilteringEnabled())));
        } else {
            this.minecraft.setScreen((Screen)new SignEditScreen(p_277970_, p_277980_, this.minecraft.isTextFilteringEnabled()));
        }
    }

    @Override
    public void openMinecartCommandBlock(BaseCommandBlock p_108678_) {
        this.minecraft.setScreen((Screen)new MinecartCommandBlockEditScreen(p_108678_));
    }

    @Override
    public void openCommandBlock(CommandBlockEntity p_108680_) {
        this.minecraft.setScreen((Screen)new CommandBlockEditScreen(p_108680_));
    }

    @Override
    public void openStructureBlock(StructureBlockEntity p_108686_) {
        this.minecraft.setScreen((Screen)new StructureBlockEditScreen(p_108686_));
    }

    @Override
    public void openJigsawBlock(JigsawBlockEntity p_108682_) {
        this.minecraft.setScreen((Screen)new JigsawBlockEditScreen(p_108682_));
    }

    @Override
    public void openItemGui(ItemStack p_108673_, InteractionHand p_108674_) {
        if (p_108673_.is(Items.WRITABLE_BOOK)) {
            this.minecraft.setScreen((Screen)new BookEditScreen((Player)this, p_108673_, p_108674_));
        }
    }

    @Override
    public void crit(Entity p_108665_) {
        this.minecraft.particleEngine.createTrackingEmitter(p_108665_, (ParticleOptions)ParticleTypes.CRIT);
    }

    @Override
    public void magicCrit(Entity p_108710_) {
        this.minecraft.particleEngine.createTrackingEmitter(p_108710_, (ParticleOptions)ParticleTypes.ENCHANTED_HIT);
    }

    @Override
    public boolean isShiftKeyDown() {
        return this.input != null && this.input.shiftKeyDown;
    }

    @Override
    public boolean isCrouching() {
        return this.crouching;
    }

    public boolean isMovingSlowly() {
        return this.isCrouching() || this.isVisuallyCrawling();
    }

    @Override
    public void serverAiStep() {
        super.serverAiStep();
        if (this.isControlledCamera()) {
            this.xxa = this.input.leftImpulse;
            this.zza = this.input.forwardImpulse;
            this.jumping = this.input.jumping;
            this.yBobO = this.yBob;
            this.xBobO = this.xBob;
            this.xBob += (this.getXRot() - this.xBob) * 0.5f;
            this.yBob += (this.getYRot() - this.yBob) * 0.5f;
        }
    }

    protected boolean isControlledCamera() {
        return this.minecraft.getCameraEntity() == this;
    }

    public void resetPos() {
        this.setPose(Pose.STANDING);
        if (this.level() != null) {
            for (double d0 = this.getY(); d0 > (double)this.level().getMinBuildHeight() && d0 < (double)this.level().getMaxBuildHeight(); d0 += 1.0) {
                this.setPos(this.getX(), d0, this.getZ());
                if (this.level().noCollision(this)) break;
            }
            this.setDeltaMovement(Vec3.ZERO);
            this.setXRot(0.0f);
        }
        this.setHealth(this.getMaxHealth());
        this.deathTime = 0;
    }

    @Override
    public void aiStep() {
        PlayerRideableJumping playerrideablejumping;
        ItemStack itemstack;
        boolean flag6;
        if (this.sprintTriggerTime > 0) {
            --this.sprintTriggerTime;
        }
        if (!(this.minecraft.screen instanceof ReceivingLevelScreen)) {
            this.handleNetherPortalClient();
        }
        boolean flag = this.input.jumping;
        boolean flag1 = this.input.shiftKeyDown;
        boolean flag2 = this.hasEnoughImpulseToStartSprinting();
        Abilities abilities = this.getAbilities();
        this.crouching = !abilities.flying && !this.isSwimming() && !this.isPassenger() && this.canPlayerFitWithinBlocksAndEntitiesWhen(Pose.CROUCHING) && (this.isShiftKeyDown() || !this.isSleeping() && !this.canPlayerFitWithinBlocksAndEntitiesWhen(Pose.STANDING));
        float f = Mth.clamp((float)(0.3f + EnchantmentHelper.getSneakingSpeedBonus(this)), (float)0.0f, (float)1.0f);
        this.input.tick(this.isMovingSlowly(), f);
        ClientHooks.onMovementInputUpdate((Player)this, (Input)this.input);
        this.minecraft.getTutorial().onInput(this.input);
        if (this.isUsingItem() && !this.isPassenger()) {
            this.input.leftImpulse *= 0.2f;
            this.input.forwardImpulse *= 0.2f;
            this.sprintTriggerTime = 0;
        }
        boolean flag3 = false;
        if (this.autoJumpTime > 0) {
            --this.autoJumpTime;
            flag3 = true;
            this.input.jumping = true;
        }
        if (!this.noPhysics) {
            this.moveTowardsClosestSpace(this.getX() - (double)this.getBbWidth() * 0.35, this.getZ() + (double)this.getBbWidth() * 0.35);
            this.moveTowardsClosestSpace(this.getX() - (double)this.getBbWidth() * 0.35, this.getZ() - (double)this.getBbWidth() * 0.35);
            this.moveTowardsClosestSpace(this.getX() + (double)this.getBbWidth() * 0.35, this.getZ() - (double)this.getBbWidth() * 0.35);
            this.moveTowardsClosestSpace(this.getX() + (double)this.getBbWidth() * 0.35, this.getZ() + (double)this.getBbWidth() * 0.35);
        }
        if (flag1) {
            this.sprintTriggerTime = 0;
        }
        boolean flag4 = this.canStartSprinting();
        boolean flag5 = this.isPassenger() ? this.getVehicle().onGround() : this.onGround();
        boolean bl = flag6 = !flag1 && !flag2;
        if ((flag5 || this.isUnderWater() || this.canStartSwimming()) && flag6 && flag4) {
            if (this.sprintTriggerTime <= 0 && !this.minecraft.options.keySprint.isDown()) {
                this.sprintTriggerTime = 7;
            } else {
                this.setSprinting(true);
            }
        }
        if (!this.isSprinting() && (!this.isInWater() && !this.isInFluidType((fluidType, height) -> this.canSwimInFluidType((FluidType)fluidType)) || this.isUnderWater() || this.canStartSwimming()) && this.hasEnoughImpulseToStartSprinting() && flag4 && !this.isUsingItem() && !this.hasEffect(MobEffects.BLINDNESS) && this.minecraft.options.keySprint.isDown()) {
            this.setSprinting(true);
        }
        if (this.isSprinting()) {
            boolean flag8;
            boolean flag7 = !this.input.hasForwardImpulse() || !this.hasEnoughFoodToStartSprinting();
            boolean bl2 = flag8 = flag7 || this.horizontalCollision && !this.minorHorizontalCollision || this.isInWater() && !this.isUnderWater() || this.isInFluidType((fluidType, height) -> this.canSwimInFluidType((FluidType)fluidType)) && !this.canStartSwimming();
            if (this.isSwimming()) {
                if (!this.onGround() && !this.input.shiftKeyDown && flag7 || !this.isInWater() && !this.isInFluidType((fluidType, height) -> this.canSwimInFluidType((FluidType)fluidType))) {
                    this.setSprinting(false);
                }
            } else if (flag8) {
                this.setSprinting(false);
            }
        }
        boolean flag9 = false;
        if (this.mayFly()) {
            if (this.minecraft.gameMode.isAlwaysFlying()) {
                if (!abilities.flying) {
                    abilities.flying = true;
                    flag9 = true;
                    this.onUpdateAbilities();
                }
            } else if (!flag && this.input.jumping && !flag3) {
                if (this.jumpTriggerTime == 0) {
                    this.jumpTriggerTime = 7;
                } else if (!this.isSwimming()) {
                    boolean bl3 = abilities.flying = !abilities.flying;
                    if (abilities.flying && this.onGround()) {
                        this.jumpFromGround();
                    }
                    flag9 = true;
                    this.onUpdateAbilities();
                    this.jumpTriggerTime = 0;
                }
            }
        }
        if (this.input.jumping && !flag9 && !flag && !abilities.flying && !this.isPassenger() && !this.onClimbable() && (itemstack = this.getItemBySlot(EquipmentSlot.CHEST)).canElytraFly(this) && this.tryToStartFallFlying()) {
            this.connection.send((Packet<?>)new ServerboundPlayerCommandPacket((Entity)this, ServerboundPlayerCommandPacket.Action.START_FALL_FLYING));
        }
        this.wasFallFlying = this.isFallFlying();
        FluidType fluidType2 = this.getMaxHeightFluidType();
        if ((this.isInWater() || !fluidType2.isAir() && this.canSwimInFluidType(fluidType2)) && this.input.shiftKeyDown && this.isAffectedByFluids()) {
            this.sinkInFluid(this.isInWater() ? (FluidType)NeoForgeMod.WATER_TYPE.value() : fluidType2);
        }
        if (this.isEyeInFluid(FluidTags.WATER)) {
            int i = this.isSpectator() ? 10 : 1;
            this.waterVisionTime = Mth.clamp((int)(this.waterVisionTime + i), (int)0, (int)600);
        } else if (this.waterVisionTime > 0) {
            this.isEyeInFluid(FluidTags.WATER);
            this.waterVisionTime = Mth.clamp((int)(this.waterVisionTime - 10), (int)0, (int)600);
        }
        if (abilities.flying && this.isControlledCamera()) {
            int j = 0;
            if (this.input.shiftKeyDown) {
                --j;
            }
            if (this.input.jumping) {
                ++j;
            }
            if (j != 0) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)((float)j * abilities.getFlyingSpeed() * 3.0f), 0.0));
            }
        }
        if ((playerrideablejumping = this.jumpableVehicle()) != null && playerrideablejumping.getJumpCooldown() == 0) {
            if (this.jumpRidingTicks < 0) {
                ++this.jumpRidingTicks;
                if (this.jumpRidingTicks == 0) {
                    this.jumpRidingScale = 0.0f;
                }
            }
            if (flag && !this.input.jumping) {
                this.jumpRidingTicks = -10;
                playerrideablejumping.onPlayerJump(Mth.floor((float)(this.getJumpRidingScale() * 100.0f)));
                this.sendRidingJump();
            } else if (!flag && this.input.jumping) {
                this.jumpRidingTicks = 0;
                this.jumpRidingScale = 0.0f;
            } else if (flag) {
                ++this.jumpRidingTicks;
                this.jumpRidingScale = this.jumpRidingTicks < 10 ? (float)this.jumpRidingTicks * 0.1f : 0.8f + 2.0f / (float)(this.jumpRidingTicks - 9) * 0.1f;
            }
        } else {
            this.jumpRidingScale = 0.0f;
        }
        super.aiStep();
        if (this.onGround() && abilities.flying && !this.minecraft.gameMode.isAlwaysFlying()) {
            abilities.flying = false;
            this.onUpdateAbilities();
        }
    }

    @Override
    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime == 20) {
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    private void handleNetherPortalClient() {
        this.oSpinningEffectIntensity = this.spinningEffectIntensity;
        float f = 0.0f;
        if (this.isInsidePortal) {
            if (this.minecraft.screen != null && !this.minecraft.screen.isPauseScreen() && !(this.minecraft.screen instanceof DeathScreen)) {
                if (this.minecraft.screen instanceof AbstractContainerScreen) {
                    this.closeContainer();
                }
                this.minecraft.setScreen(null);
            }
            if (this.spinningEffectIntensity == 0.0f) {
                this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forLocalAmbience((SoundEvent)SoundEvents.PORTAL_TRIGGER, (float)(this.random.nextFloat() * 0.4f + 0.8f), (float)0.25f));
            }
            f = 0.0125f;
            this.isInsidePortal = false;
        } else if (this.hasEffect(MobEffects.CONFUSION) && !this.getEffect(MobEffects.CONFUSION).endsWithin(60)) {
            f = 0.006666667f;
        } else if (this.spinningEffectIntensity > 0.0f) {
            f = -0.05f;
        }
        this.spinningEffectIntensity = Mth.clamp((float)(this.spinningEffectIntensity + f), (float)0.0f, (float)1.0f);
        this.processPortalCooldown();
    }

    @Override
    public void rideTick() {
        super.rideTick();
        if (this.wantsToStopRiding() && this.isPassenger()) {
            this.input.shiftKeyDown = false;
        }
        this.handsBusy = false;
        Entity entity = this.getControlledVehicle();
        if (entity instanceof Boat) {
            Boat boat = (Boat)((Object)entity);
            boat.setInput(this.input.left, this.input.right, this.input.up, this.input.down);
            this.handsBusy |= this.input.left || this.input.right || this.input.up || this.input.down;
        }
    }

    public boolean isHandsBusy() {
        return this.handsBusy;
    }

    @Override
    @Nullable
    public MobEffectInstance removeEffectNoUpdate(Holder<MobEffect> p_316634_) {
        if (p_316634_.is(MobEffects.CONFUSION)) {
            this.oSpinningEffectIntensity = 0.0f;
            this.spinningEffectIntensity = 0.0f;
        }
        return super.removeEffectNoUpdate(p_316634_);
    }

    @Override
    public void move(MoverType p_108670_, Vec3 p_108671_) {
        double d0 = this.getX();
        double d1 = this.getZ();
        super.move(p_108670_, p_108671_);
        this.updateAutoJump((float)(this.getX() - d0), (float)(this.getZ() - d1));
    }

    public boolean isAutoJumpEnabled() {
        return this.autoJumpEnabled;
    }

    protected void updateAutoJump(float p_108744_, float p_108745_) {
        if (this.canAutoJump()) {
            Vec3 vec3 = this.position();
            Vec3 vec31 = vec3.add((double)p_108744_, 0.0, (double)p_108745_);
            Vec3 vec32 = new Vec3((double)p_108744_, 0.0, (double)p_108745_);
            float f = this.getSpeed();
            float f1 = (float)vec32.lengthSqr();
            if (f1 <= 0.001f) {
                Vec2 vec2 = this.input.getMoveVector();
                float f2 = f * vec2.x;
                float f3 = f * vec2.y;
                float f4 = Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180)));
                float f5 = Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180)));
                vec32 = new Vec3((double)(f2 * f5 - f3 * f4), vec32.y, (double)(f3 * f5 + f2 * f4));
                f1 = (float)vec32.lengthSqr();
                if (f1 <= 0.001f) {
                    return;
                }
            }
            float f12 = Mth.invSqrt((float)f1);
            Vec3 vec312 = vec32.scale((double)f12);
            Vec3 vec313 = this.getForward();
            float f13 = (float)(vec313.x * vec312.x + vec313.z * vec312.z);
            if (!(f13 < -0.15f)) {
                CollisionContext collisioncontext = CollisionContext.of((Entity)this);
                BlockPos blockpos = BlockPos.containing((double)this.getX(), (double)this.getBoundingBox().maxY, (double)this.getZ());
                BlockState blockstate = this.level().getBlockState(blockpos);
                if (blockstate.getCollisionShape((BlockGetter)((Object)this.level()), blockpos, collisioncontext).isEmpty()) {
                    blockpos = blockpos.above();
                    BlockState blockstate1 = this.level().getBlockState(blockpos);
                    if (blockstate1.getCollisionShape((BlockGetter)((Object)this.level()), blockpos, collisioncontext).isEmpty()) {
                        float f14;
                        float f6 = 7.0f;
                        float f7 = 1.2f;
                        if (this.hasEffect(MobEffects.JUMP)) {
                            f7 += (float)(this.getEffect(MobEffects.JUMP).getAmplifier() + 1) * 0.75f;
                        }
                        float f8 = Math.max(f * 7.0f, 1.0f / f12);
                        Vec3 vec34 = vec31.add(vec312.scale((double)f8));
                        float f9 = this.getBbWidth();
                        float f10 = this.getBbHeight();
                        AABB aabb = new AABB(vec3, vec34.add(0.0, (double)f10, 0.0)).inflate(f9, 0.0, f9);
                        Vec3 $$23 = vec3.add(0.0, (double)0.51f, 0.0);
                        vec34 = vec34.add(0.0, (double)0.51f, 0.0);
                        Vec3 vec35 = vec312.cross(new Vec3(0.0, 1.0, 0.0));
                        Vec3 vec36 = vec35.scale((double)(f9 * 0.5f));
                        Vec3 vec37 = $$23.subtract(vec36);
                        Vec3 vec38 = vec34.subtract(vec36);
                        Vec3 vec39 = $$23.add(vec36);
                        Vec3 vec310 = vec34.add(vec36);
                        Iterable iterable = this.level().getCollisions(this, aabb);
                        Iterator iterator = StreamSupport.stream(iterable.spliterator(), false).flatMap(p_234124_ -> p_234124_.toAabbs().stream()).iterator();
                        float f11 = Float.MIN_VALUE;
                        while (iterator.hasNext()) {
                            AABB aabb1 = (AABB)iterator.next();
                            if (!aabb1.intersects(vec37, vec38) && !aabb1.intersects(vec39, vec310)) continue;
                            f11 = (float)aabb1.maxY;
                            Vec3 vec311 = aabb1.getCenter();
                            BlockPos blockpos1 = BlockPos.containing((Position)vec311);
                            int i = 1;
                            while ((float)i < f7) {
                                BlockPos blockpos2 = blockpos1.above(i);
                                BlockState blockstate2 = this.level().getBlockState(blockpos2);
                                VoxelShape voxelshape = blockstate2.getCollisionShape((BlockGetter)((Object)this.level()), blockpos2, collisioncontext);
                                if (!voxelshape.isEmpty() && (double)(f11 = (float)voxelshape.max(Direction.Axis.Y) + (float)blockpos2.getY()) - this.getY() > (double)f7) {
                                    return;
                                }
                                if (i > 1) {
                                    blockpos = blockpos.above();
                                    BlockState blockstate3 = this.level().getBlockState(blockpos);
                                    if (!blockstate3.getCollisionShape((BlockGetter)((Object)this.level()), blockpos, collisioncontext).isEmpty()) {
                                        return;
                                    }
                                }
                                ++i;
                            }
                            break block0;
                        }
                        if (f11 != Float.MIN_VALUE && !((f14 = (float)((double)f11 - this.getY())) <= 0.5f) && !(f14 > f7)) {
                            this.autoJumpTime = 1;
                        }
                    }
                }
            }
        }
    }

    @Override
    protected boolean isHorizontalCollisionMinor(Vec3 p_197411_) {
        float f = this.getYRot() * ((float)Math.PI / 180);
        double d0 = Mth.sin((float)f);
        double d1 = Mth.cos((float)f);
        double d2 = (double)this.xxa * d1 - (double)this.zza * d0;
        double d3 = (double)this.zza * d1 + (double)this.xxa * d0;
        double d4 = Mth.square((double)d2) + Mth.square((double)d3);
        double d5 = Mth.square((double)p_197411_.x) + Mth.square((double)p_197411_.z);
        if (!(d4 < (double)1.0E-5f) && !(d5 < (double)1.0E-5f)) {
            double d6 = d2 * p_197411_.x + d3 * p_197411_.z;
            double d7 = Math.acos(d6 / Math.sqrt(d4 * d5));
            return d7 < 0.13962633907794952;
        }
        return false;
    }

    private boolean canAutoJump() {
        return this.isAutoJumpEnabled() && this.autoJumpTime <= 0 && this.onGround() && !this.isStayingOnGroundSurface() && !this.isPassenger() && this.isMoving() && (double)this.getBlockJumpFactor() >= 1.0;
    }

    private boolean isMoving() {
        Vec2 vec2 = this.input.getMoveVector();
        return vec2.x != 0.0f || vec2.y != 0.0f;
    }

    private boolean canStartSprinting() {
        return !this.isSprinting() && this.hasEnoughImpulseToStartSprinting() && this.hasEnoughFoodToStartSprinting() && !this.isUsingItem() && !this.hasEffect(MobEffects.BLINDNESS) && (!this.isPassenger() || this.vehicleCanSprint(this.getVehicle())) && !this.isFallFlying();
    }

    private boolean vehicleCanSprint(Entity p_265184_) {
        return p_265184_.canSprint() && p_265184_.isControlledByLocalInstance();
    }

    private boolean hasEnoughImpulseToStartSprinting() {
        double d0 = 0.8;
        return this.isUnderWater() ? this.input.hasForwardImpulse() : (double)this.input.forwardImpulse >= 0.8;
    }

    private boolean hasEnoughFoodToStartSprinting() {
        return this.isPassenger() || (float)this.getFoodData().getFoodLevel() > 6.0f || this.mayFly();
    }

    public float getWaterVision() {
        if (!this.isEyeInFluid(FluidTags.WATER)) {
            return 0.0f;
        }
        float f = 600.0f;
        float f1 = 100.0f;
        if ((float)this.waterVisionTime >= 600.0f) {
            return 1.0f;
        }
        float f2 = Mth.clamp((float)((float)this.waterVisionTime / 100.0f), (float)0.0f, (float)1.0f);
        float f3 = (float)this.waterVisionTime < 100.0f ? 0.0f : Mth.clamp((float)(((float)this.waterVisionTime - 100.0f) / 500.0f), (float)0.0f, (float)1.0f);
        return f2 * 0.6f + f3 * 0.39999998f;
    }

    public void onGameModeChanged(GameType p_287675_) {
        if (p_287675_ == GameType.SPECTATOR) {
            this.setDeltaMovement(this.getDeltaMovement().with(Direction.Axis.Y, 0.0));
        }
    }

    @Override
    public boolean isUnderWater() {
        return this.wasUnderwater;
    }

    @Override
    protected boolean updateIsUnderwater() {
        boolean flag = this.wasUnderwater;
        boolean flag1 = super.updateIsUnderwater();
        if (this.isSpectator()) {
            return this.wasUnderwater;
        }
        if (!flag && flag1) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.AMBIENT_UNDERWATER_ENTER, SoundSource.AMBIENT, 1.0f, 1.0f, false);
            this.minecraft.getSoundManager().play((SoundInstance)new UnderwaterAmbientSoundInstances.UnderwaterAmbientSoundInstance(this));
        }
        if (flag && !flag1) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.AMBIENT_UNDERWATER_EXIT, SoundSource.AMBIENT, 1.0f, 1.0f, false);
        }
        return this.wasUnderwater;
    }

    @Override
    public Vec3 getRopeHoldPosition(float p_108758_) {
        if (this.minecraft.options.getCameraType().isFirstPerson()) {
            float f = Mth.lerp((float)(p_108758_ * 0.5f), (float)this.getYRot(), (float)this.yRotO) * ((float)Math.PI / 180);
            float f1 = Mth.lerp((float)(p_108758_ * 0.5f), (float)this.getXRot(), (float)this.xRotO) * ((float)Math.PI / 180);
            double d0 = this.getMainArm() == HumanoidArm.RIGHT ? -1.0 : 1.0;
            Vec3 vec3 = new Vec3(0.39 * d0, -0.6, 0.3);
            return vec3.xRot(-f1).yRot(-f).add(this.getEyePosition(p_108758_));
        }
        return super.getRopeHoldPosition(p_108758_);
    }

    @Override
    public void updateTutorialInventoryAction(ItemStack p_172532_, ItemStack p_172533_, ClickAction p_172534_) {
        this.minecraft.getTutorial().onInventoryAction(p_172532_, p_172533_, p_172534_);
    }

    @Override
    public float getVisualRotationYInDegrees() {
        return this.getYRot();
    }
}

