/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.vertex.BufferBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Map;
import java.util.SortedMap;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.OutlineBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SectionBufferBuilderPack;
import net.minecraft.client.renderer.SectionBufferBuilderPool;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.resources.model.ModelBakery;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import net.neoforged.neoforge.client.event.RegisterRenderBuffersEvent;

@OnlyIn(value=Dist.CLIENT)
public class RenderBuffers {
    private final SectionBufferBuilderPack fixedBufferPack = new SectionBufferBuilderPack();
    private final SectionBufferBuilderPool sectionBufferPool;
    private final MultiBufferSource.BufferSource bufferSource;
    private final MultiBufferSource.BufferSource crumblingBufferSource;
    private final OutlineBufferSource outlineBufferSource;

    public RenderBuffers(int p_307464_) {
        this.sectionBufferPool = SectionBufferBuilderPool.allocate((int)p_307464_);
        SortedMap sortedmap = (SortedMap)Util.make(new Object2ObjectLinkedOpenHashMap(), p_307112_ -> {
            p_307112_.put((Object)Sheets.solidBlockSheet(), (Object)this.fixedBufferPack.builder(RenderType.solid()));
            p_307112_.put((Object)Sheets.cutoutBlockSheet(), (Object)this.fixedBufferPack.builder(RenderType.cutout()));
            p_307112_.put((Object)Sheets.bannerSheet(), (Object)this.fixedBufferPack.builder(RenderType.cutoutMipped()));
            p_307112_.put((Object)Sheets.translucentCullBlockSheet(), (Object)this.fixedBufferPack.builder(RenderType.translucent()));
            RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_307112_, Sheets.shieldSheet());
            RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_307112_, Sheets.bedSheet());
            RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_307112_, Sheets.shulkerBoxSheet());
            RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_307112_, Sheets.signSheet());
            RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_307112_, Sheets.hangingSignSheet());
            p_307112_.put((Object)Sheets.chestSheet(), (Object)new BufferBuilder(786432));
            RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_307112_, RenderType.armorGlint());
            RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_307112_, RenderType.armorEntityGlint());
            RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_307112_, RenderType.glint());
            RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_307112_, RenderType.glintDirect());
            RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_307112_, RenderType.glintTranslucent());
            RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_307112_, RenderType.entityGlint());
            RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_307112_, RenderType.entityGlintDirect());
            RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_307112_, RenderType.waterMask());
            ModelBakery.DESTROY_TYPES.forEach(p_173062_ -> RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_307112_, p_173062_));
        });
        ModLoader.postEvent((Event)new RegisterRenderBuffersEvent(sortedmap));
        this.crumblingBufferSource = MultiBufferSource.immediate((BufferBuilder)new BufferBuilder(1536));
        this.bufferSource = MultiBufferSource.immediateWithBuffers((Map)sortedmap, (BufferBuilder)new BufferBuilder(786432));
        this.outlineBufferSource = new OutlineBufferSource(this.bufferSource);
    }

    private static void put(Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder> p_110102_, RenderType p_110103_) {
        p_110102_.put((Object)p_110103_, (Object)new BufferBuilder(p_110103_.bufferSize()));
    }

    public SectionBufferBuilderPack fixedBufferPack() {
        return this.fixedBufferPack;
    }

    public SectionBufferBuilderPool sectionBufferPool() {
        return this.sectionBufferPool;
    }

    public MultiBufferSource.BufferSource bufferSource() {
        return this.bufferSource;
    }

    public MultiBufferSource.BufferSource crumblingBufferSource() {
        return this.crumblingBufferSource;
    }

    public OutlineBufferSource outlineBufferSource() {
        return this.outlineBufferSource;
    }
}

