/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BuiltInModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemDisplayContext;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.ExtendedBlockModelDeserializer;
import net.neoforged.neoforge.client.model.geometry.BlockGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.UnbakedGeometryHelper;
import org.joml.Matrix4f;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class BlockModel
implements UnbakedModel {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final FaceBakery FACE_BAKERY = new FaceBakery();
    @VisibleForTesting
    static final Gson GSON = new GsonBuilder().registerTypeAdapter(BlockModel.class, (Object)new Deserializer()).registerTypeAdapter(BlockElement.class, (Object)new BlockElement.Deserializer()).registerTypeAdapter(BlockElementFace.class, (Object)new BlockElementFace.Deserializer()).registerTypeAdapter(BlockFaceUV.class, (Object)new BlockFaceUV.Deserializer()).registerTypeAdapter(ItemTransform.class, (Object)new ItemTransform.Deserializer()).registerTypeAdapter(ItemTransforms.class, (Object)new ItemTransforms.Deserializer()).registerTypeAdapter(ItemOverride.class, (Object)new ItemOverride.Deserializer()).create();
    private static final char REFERENCE_CHAR = '#';
    public static final String PARTICLE_TEXTURE_REFERENCE = "particle";
    private static final boolean DEFAULT_AMBIENT_OCCLUSION = true;
    private final List<BlockElement> elements;
    @Nullable
    private final GuiLight guiLight;
    @Nullable
    public final Boolean hasAmbientOcclusion;
    private final ItemTransforms transforms;
    private final List<ItemOverride> overrides;
    public String name = "";
    @VisibleForTesting
    public final Map<String, Either<Material, String>> textureMap;
    @Nullable
    public BlockModel parent;
    @Nullable
    protected ResourceLocation parentLocation;
    public final BlockGeometryBakingContext customData = new BlockGeometryBakingContext(this);

    public static BlockModel fromStream(Reader p_111462_) {
        return (BlockModel)GsonHelper.fromJson((Gson)ExtendedBlockModelDeserializer.INSTANCE, (Reader)p_111462_, BlockModel.class);
    }

    public static BlockModel fromString(String p_111464_) {
        return BlockModel.fromStream(new StringReader(p_111464_));
    }

    public BlockModel(@Nullable ResourceLocation p_273263_, List<BlockElement> p_272668_, Map<String, Either<Material, String>> p_272821_, @Nullable Boolean p_272676_, @Nullable GuiLight p_273072_, ItemTransforms p_273480_, List<ItemOverride> p_273099_) {
        this.elements = p_272668_;
        this.hasAmbientOcclusion = p_272676_;
        this.guiLight = p_273072_;
        this.textureMap = p_272821_;
        this.parentLocation = p_273263_;
        this.transforms = p_273480_;
        this.overrides = p_273099_;
    }

    @Deprecated
    public List<BlockElement> getElements() {
        if (this.customData.hasCustomGeometry()) {
            return Collections.emptyList();
        }
        return this.elements.isEmpty() && this.parent != null ? this.parent.getElements() : this.elements;
    }

    @Nullable
    public ResourceLocation getParentLocation() {
        return this.parentLocation;
    }

    public boolean hasAmbientOcclusion() {
        if (this.hasAmbientOcclusion != null) {
            return this.hasAmbientOcclusion;
        }
        return this.parent != null ? this.parent.hasAmbientOcclusion() : true;
    }

    public GuiLight getGuiLight() {
        if (this.guiLight != null) {
            return this.guiLight;
        }
        return this.parent != null ? this.parent.getGuiLight() : GuiLight.SIDE;
    }

    public boolean isResolved() {
        return this.parentLocation == null || this.parent != null && this.parent.isResolved();
    }

    public List<ItemOverride> getOverrides() {
        return this.overrides;
    }

    private ItemOverrides getItemOverrides(ModelBaker p_250138_, BlockModel p_251800_) {
        return this.overrides.isEmpty() ? ItemOverrides.EMPTY : new ItemOverrides(p_250138_, p_251800_, this.overrides);
    }

    public ItemOverrides getOverrides(ModelBaker p_250138_, BlockModel p_251800_, Function<Material, TextureAtlasSprite> spriteGetter) {
        return this.overrides.isEmpty() ? ItemOverrides.EMPTY : new ItemOverrides(p_250138_, p_251800_, this.overrides, spriteGetter);
    }

    public Collection<ResourceLocation> getDependencies() {
        HashSet set = Sets.newHashSet();
        for (ItemOverride itemoverride : this.overrides) {
            set.add(itemoverride.getModel());
        }
        if (this.parentLocation != null) {
            set.add(this.parentLocation);
        }
        return set;
    }

    public void resolveParents(Function<ResourceLocation, UnbakedModel> p_249059_) {
        LinkedHashSet set = Sets.newLinkedHashSet();
        BlockModel blockmodel = this;
        while (blockmodel.parentLocation != null && blockmodel.parent == null) {
            set.add(blockmodel);
            UnbakedModel unbakedmodel = p_249059_.apply(blockmodel.parentLocation);
            if (unbakedmodel == null) {
                LOGGER.warn("No parent '{}' while loading model '{}'", (Object)this.parentLocation, (Object)blockmodel);
            }
            if (set.contains(unbakedmodel)) {
                LOGGER.warn("Found 'parent' loop while loading model '{}' in chain: {} -> {}", new Object[]{blockmodel, set.stream().map(Object::toString).collect(Collectors.joining(" -> ")), this.parentLocation});
                unbakedmodel = null;
            }
            if (unbakedmodel == null) {
                blockmodel.parentLocation = ModelBakery.MISSING_MODEL_LOCATION;
                unbakedmodel = p_249059_.apply(blockmodel.parentLocation);
            }
            if (!(unbakedmodel instanceof BlockModel)) {
                throw new IllegalStateException("BlockModel parent has to be a block model.");
            }
            blockmodel = blockmodel.parent = (BlockModel)unbakedmodel;
        }
        if (this.customData.hasCustomGeometry()) {
            this.customData.getCustomGeometry().resolveParents(p_249059_, (IGeometryBakingContext)this.customData);
        }
        this.overrides.forEach(p_247932_ -> {
            UnbakedModel unbakedmodel1 = (UnbakedModel)p_249059_.apply(p_247932_.getModel());
            if (!Objects.equals(unbakedmodel1, this)) {
                unbakedmodel1.resolveParents(p_249059_);
            }
        });
    }

    @Deprecated
    public BakedModel bake(ModelBaker p_252120_, Function<Material, TextureAtlasSprite> p_250023_, ModelState p_251130_, ResourceLocation p_252208_) {
        return this.bake(p_252120_, this, p_250023_, p_251130_, p_252208_, true);
    }

    public BakedModel bake(ModelBaker p_249720_, BlockModel p_111451_, Function<Material, TextureAtlasSprite> p_111452_, ModelState p_111453_, ResourceLocation p_111454_, boolean p_111455_) {
        return UnbakedGeometryHelper.bake((BlockModel)this, (ModelBaker)p_249720_, (BlockModel)p_111451_, p_111452_, (ModelState)p_111453_, (ResourceLocation)p_111454_, (boolean)p_111455_);
    }

    public BakedModel bakeVanilla(ModelBaker p_249720_, BlockModel p_111451_, Function<Material, TextureAtlasSprite> p_111452_, ModelState p_111453_, ResourceLocation p_111454_, boolean p_111455_) {
        TextureAtlasSprite textureatlassprite = p_111452_.apply(this.getMaterial(PARTICLE_TEXTURE_REFERENCE));
        if (this.getRootModel() == ModelBakery.BLOCK_ENTITY_MARKER) {
            return new BuiltInModel(this.getTransforms(), this.getItemOverrides(p_249720_, p_111451_), textureatlassprite, this.getGuiLight().lightLikeBlock());
        }
        SimpleBakedModel.Builder simplebakedmodel$builder = new SimpleBakedModel.Builder(this, this.getItemOverrides(p_249720_, p_111451_), p_111455_).particle(textureatlassprite);
        for (BlockElement blockelement : this.getElements()) {
            for (Direction direction : blockelement.faces.keySet()) {
                BlockElementFace blockelementface = blockelement.faces.get(direction);
                TextureAtlasSprite textureatlassprite1 = p_111452_.apply(this.getMaterial(blockelementface.texture));
                if (blockelementface.cullForDirection == null) {
                    simplebakedmodel$builder.addUnculledFace(BlockModel.bakeFace(blockelement, blockelementface, textureatlassprite1, direction, p_111453_, p_111454_));
                    continue;
                }
                simplebakedmodel$builder.addCulledFace(Direction.rotate((Matrix4f)p_111453_.getRotation().getMatrix(), (Direction)blockelementface.cullForDirection), BlockModel.bakeFace(blockelement, blockelementface, textureatlassprite1, direction, p_111453_, p_111454_));
            }
        }
        return simplebakedmodel$builder.build();
    }

    public static BakedQuad bakeFace(BlockElement p_111438_, BlockElementFace p_111439_, TextureAtlasSprite p_111440_, Direction p_111441_, ModelState p_111442_, ResourceLocation p_111443_) {
        return FACE_BAKERY.bakeQuad(p_111438_.from, p_111438_.to, p_111439_, p_111440_, p_111441_, p_111442_, p_111438_.rotation, p_111438_.shade, p_111443_);
    }

    public boolean hasTexture(String p_111478_) {
        return !MissingTextureAtlasSprite.getLocation().equals(this.getMaterial(p_111478_).texture());
    }

    public Material getMaterial(String p_111481_) {
        if (BlockModel.isTextureReference(p_111481_)) {
            p_111481_ = p_111481_.substring(1);
        }
        ArrayList list = Lists.newArrayList();
        Either<Material, String> either;
        Optional optional;
        while (!(optional = (either = this.findTextureEntry(p_111481_)).left()).isPresent()) {
            p_111481_ = (String)either.right().get();
            if (list.contains(p_111481_)) {
                LOGGER.warn("Unable to resolve texture due to reference chain {}->{} in {}", new Object[]{Joiner.on((String)"->").join((Iterable)list), p_111481_, this.name});
                return new Material(TextureAtlas.LOCATION_BLOCKS, MissingTextureAtlasSprite.getLocation());
            }
            list.add(p_111481_);
        }
        return (Material)optional.get();
    }

    private Either<Material, String> findTextureEntry(String p_111486_) {
        BlockModel blockmodel = this;
        while (blockmodel != null) {
            Either<Material, String> either = blockmodel.textureMap.get(p_111486_);
            if (either != null) {
                return either;
            }
            blockmodel = blockmodel.parent;
        }
        return Either.left((Object)new Material(TextureAtlas.LOCATION_BLOCKS, MissingTextureAtlasSprite.getLocation()));
    }

    static boolean isTextureReference(String p_111489_) {
        return p_111489_.charAt(0) == '#';
    }

    public BlockModel getRootModel() {
        return this.parent == null ? this : this.parent.getRootModel();
    }

    public ItemTransforms getTransforms() {
        ItemTransform itemtransform = this.getTransform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND);
        ItemTransform itemtransform1 = this.getTransform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND);
        ItemTransform itemtransform2 = this.getTransform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND);
        ItemTransform itemtransform3 = this.getTransform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND);
        ItemTransform itemtransform4 = this.getTransform(ItemDisplayContext.HEAD);
        ItemTransform itemtransform5 = this.getTransform(ItemDisplayContext.GUI);
        ItemTransform itemtransform6 = this.getTransform(ItemDisplayContext.GROUND);
        ItemTransform itemtransform7 = this.getTransform(ItemDisplayContext.FIXED);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ItemDisplayContext type : ItemDisplayContext.values()) {
            ItemTransform transform;
            if (!type.isModded() || (transform = this.getTransform(type)) == ItemTransform.NO_TRANSFORM) continue;
            builder.put((Object)type, (Object)transform);
        }
        return new ItemTransforms(itemtransform, itemtransform1, itemtransform2, itemtransform3, itemtransform4, itemtransform5, itemtransform6, itemtransform7, (ImmutableMap<ItemDisplayContext, ItemTransform>)builder.build());
    }

    private ItemTransform getTransform(ItemDisplayContext p_270662_) {
        return this.parent != null && !this.transforms.hasTransform(p_270662_) ? this.parent.getTransform(p_270662_) : this.transforms.getTransform(p_270662_);
    }

    public String toString() {
        return this.name;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum GuiLight {
        FRONT("front"),
        SIDE("side");

        private final String name;

        private GuiLight(String p_111525_) {
            this.name = p_111525_;
        }

        public static GuiLight getByName(String p_111528_) {
            for (GuiLight blockmodel$guilight : GuiLight.values()) {
                if (!blockmodel$guilight.name.equals(p_111528_)) continue;
                return blockmodel$guilight;
            }
            throw new IllegalArgumentException("Invalid gui light: " + p_111528_);
        }

        public boolean lightLikeBlock() {
            return this == SIDE;
        }

        public String getSerializedName() {
            return this.name;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Deserializer
    implements JsonDeserializer<BlockModel> {
        public BlockModel deserialize(JsonElement p_111498_, Type p_111499_, JsonDeserializationContext p_111500_) throws JsonParseException {
            JsonObject jsonobject = p_111498_.getAsJsonObject();
            List<BlockElement> list = this.getElements(p_111500_, jsonobject);
            String s = this.getParentName(jsonobject);
            Map<String, Either<Material, String>> map = this.getTextureMap(jsonobject);
            Boolean obool = this.getAmbientOcclusion(jsonobject);
            ItemTransforms itemtransforms = ItemTransforms.NO_TRANSFORMS;
            if (jsonobject.has("display")) {
                JsonObject jsonobject1 = GsonHelper.getAsJsonObject((JsonObject)jsonobject, (String)"display");
                itemtransforms = (ItemTransforms)p_111500_.deserialize((JsonElement)jsonobject1, ItemTransforms.class);
            }
            List<ItemOverride> list1 = this.getOverrides(p_111500_, jsonobject);
            GuiLight blockmodel$guilight = null;
            if (jsonobject.has("gui_light")) {
                blockmodel$guilight = GuiLight.getByName(GsonHelper.getAsString((JsonObject)jsonobject, (String)"gui_light"));
            }
            ResourceLocation resourcelocation = s.isEmpty() ? null : new ResourceLocation(s);
            return new BlockModel(resourcelocation, list, map, obool, blockmodel$guilight, itemtransforms, list1);
        }

        protected List<ItemOverride> getOverrides(JsonDeserializationContext p_111495_, JsonObject p_111496_) {
            ArrayList list = Lists.newArrayList();
            if (p_111496_.has("overrides")) {
                for (JsonElement jsonelement : GsonHelper.getAsJsonArray((JsonObject)p_111496_, (String)"overrides")) {
                    list.add((ItemOverride)p_111495_.deserialize(jsonelement, ItemOverride.class));
                }
            }
            return list;
        }

        private Map<String, Either<Material, String>> getTextureMap(JsonObject p_111510_) {
            ResourceLocation resourcelocation = TextureAtlas.LOCATION_BLOCKS;
            HashMap map = Maps.newHashMap();
            if (p_111510_.has("textures")) {
                JsonObject jsonobject = GsonHelper.getAsJsonObject((JsonObject)p_111510_, (String)"textures");
                for (Map.Entry entry : jsonobject.entrySet()) {
                    map.put((String)entry.getKey(), Deserializer.parseTextureLocationOrReference(resourcelocation, ((JsonElement)entry.getValue()).getAsString()));
                }
            }
            return map;
        }

        private static Either<Material, String> parseTextureLocationOrReference(ResourceLocation p_111504_, String p_111505_) {
            if (BlockModel.isTextureReference(p_111505_)) {
                return Either.right((Object)p_111505_.substring(1));
            }
            ResourceLocation resourcelocation = ResourceLocation.tryParse(p_111505_);
            if (resourcelocation == null) {
                throw new JsonParseException(p_111505_ + " is not valid resource location");
            }
            return Either.left((Object)new Material(p_111504_, resourcelocation));
        }

        private String getParentName(JsonObject p_111512_) {
            return GsonHelper.getAsString((JsonObject)p_111512_, (String)"parent", (String)"");
        }

        @Nullable
        protected Boolean getAmbientOcclusion(JsonObject p_273052_) {
            return p_273052_.has("ambientocclusion") ? Boolean.valueOf(GsonHelper.getAsBoolean((JsonObject)p_273052_, (String)"ambientocclusion")) : null;
        }

        protected List<BlockElement> getElements(JsonDeserializationContext p_111507_, JsonObject p_111508_) {
            ArrayList list = Lists.newArrayList();
            if (p_111508_.has("elements")) {
                for (JsonElement jsonelement : GsonHelper.getAsJsonArray((JsonObject)p_111508_, (String)"elements")) {
                    list.add((BlockElement)p_111507_.deserialize(jsonelement, BlockElement.class));
                }
            }
            return list;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LoopException
    extends RuntimeException {
        public LoopException(String p_173424_) {
            super(p_173424_);
        }
    }
}

