/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ShulkerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ShulkerBoxRenderer
implements BlockEntityRenderer<ShulkerBoxBlockEntity> {
    private final ShulkerModel<?> model;

    public ShulkerBoxRenderer(BlockEntityRendererProvider.Context p_173626_) {
        this.model = new ShulkerModel(p_173626_.bakeLayer(ModelLayers.SHULKER));
    }

    @Override
    public void render(ShulkerBoxBlockEntity p_112478_, float p_112479_, PoseStack p_112480_, MultiBufferSource p_112481_, int p_112482_, int p_112483_) {
        DyeColor dyecolor;
        BlockState blockstate;
        Direction direction = Direction.UP;
        if (p_112478_.hasLevel() && (blockstate = p_112478_.getLevel().getBlockState(p_112478_.getBlockPos())).getBlock() instanceof ShulkerBoxBlock) {
            direction = (Direction)blockstate.getValue((Property)ShulkerBoxBlock.FACING);
        }
        Material material = (dyecolor = p_112478_.getColor()) == null ? Sheets.DEFAULT_SHULKER_TEXTURE_LOCATION : Sheets.SHULKER_TEXTURE_LOCATION.get(dyecolor.getId());
        p_112480_.pushPose();
        p_112480_.translate(0.5f, 0.5f, 0.5f);
        float f = 0.9995f;
        p_112480_.scale(0.9995f, 0.9995f, 0.9995f);
        p_112480_.mulPose(direction.getRotation());
        p_112480_.scale(1.0f, -1.0f, -1.0f);
        p_112480_.translate(0.0f, -1.0f, 0.0f);
        ModelPart modelpart = this.model.getLid();
        modelpart.setPos(0.0f, 24.0f - p_112478_.getProgress(p_112479_) * 0.5f * 16.0f, 0.0f);
        modelpart.yRot = 270.0f * p_112478_.getProgress(p_112479_) * ((float)Math.PI / 180);
        VertexConsumer vertexconsumer = material.buffer(p_112481_, RenderType::entityCutoutNoCull);
        this.model.renderToBuffer(p_112480_, vertexconsumer, p_112482_, p_112483_, 1.0f, 1.0f, 1.0f, 1.0f);
        p_112480_.popPose();
    }

    public AABB getRenderBoundingBox(ShulkerBoxBlockEntity blockEntity) {
        BlockPos pos = blockEntity.getBlockPos();
        return new AABB((double)pos.getX() - 0.5, (double)pos.getY() - 0.5, (double)pos.getZ() - 0.5, (double)pos.getX() + 1.5, (double)pos.getY() + 1.5, (double)pos.getZ() + 1.5);
    }
}

