/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import it.unimi.dsi.fastutil.longs.Long2ObjectFunction;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelDataManager;
import net.neoforged.neoforge.common.world.AuxiliaryLightManager;

@OnlyIn(value=Dist.CLIENT)
public class RenderChunkRegion
implements BlockAndTintGetter {
    private final int centerX;
    private final int centerZ;
    protected final RenderChunk[][] chunks;
    protected final Level level;
    private final Long2ObjectFunction<ModelData> modelDataSnapshot;

    @Deprecated
    RenderChunkRegion(Level p_200456_, int p_200457_, int p_200458_, RenderChunk[][] p_200459_) {
        this(p_200456_, p_200457_, p_200458_, p_200459_, (Long2ObjectFunction<ModelData>)ModelDataManager.EMPTY_SNAPSHOT);
    }

    RenderChunkRegion(Level p_200456_, int p_200457_, int p_200458_, RenderChunk[][] p_200459_, Long2ObjectFunction<ModelData> modelDataSnapshot) {
        this.level = p_200456_;
        this.centerX = p_200457_;
        this.centerZ = p_200458_;
        this.chunks = p_200459_;
        this.modelDataSnapshot = modelDataSnapshot;
    }

    @Override
    public BlockState getBlockState(BlockPos p_112947_) {
        int i = SectionPos.blockToSectionCoord((int)p_112947_.getX()) - this.centerX;
        int j = SectionPos.blockToSectionCoord((int)p_112947_.getZ()) - this.centerZ;
        return this.chunks[i][j].getBlockState(p_112947_);
    }

    @Override
    public FluidState getFluidState(BlockPos p_112943_) {
        int i = SectionPos.blockToSectionCoord((int)p_112943_.getX()) - this.centerX;
        int j = SectionPos.blockToSectionCoord((int)p_112943_.getZ()) - this.centerZ;
        return this.chunks[i][j].getBlockState(p_112943_).getFluidState();
    }

    @Override
    public float getShade(Direction p_112940_, boolean p_112941_) {
        return this.level.getShade(p_112940_, p_112941_);
    }

    @Override
    public LevelLightEngine getLightEngine() {
        return this.level.getLightEngine();
    }

    @Override
    @Nullable
    public BlockEntity getBlockEntity(BlockPos p_112945_) {
        int i = SectionPos.blockToSectionCoord((int)p_112945_.getX()) - this.centerX;
        int j = SectionPos.blockToSectionCoord((int)p_112945_.getZ()) - this.centerZ;
        return this.chunks[i][j].getBlockEntity(p_112945_);
    }

    @Override
    public int getBlockTint(BlockPos p_112937_, ColorResolver p_112938_) {
        return this.level.getBlockTint(p_112937_, p_112938_);
    }

    public int getMinBuildHeight() {
        return this.level.getMinBuildHeight();
    }

    public int getHeight() {
        return this.level.getHeight();
    }

    public float getShade(float normalX, float normalY, float normalZ, boolean shade) {
        return this.level.getShade(normalX, normalY, normalZ, shade);
    }

    public ModelData getModelData(BlockPos pos) {
        return (ModelData)this.modelDataSnapshot.get(pos.asLong());
    }

    public AuxiliaryLightManager getAuxLightManager(ChunkPos pos) {
        int relX = pos.x - this.centerX;
        int relZ = pos.z - this.centerZ;
        return this.chunks[relX][relZ].wrapped.getAuxLightManager(pos);
    }
}

