/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.google.common.primitives.Doubles;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SectionBufferBuilderPack;
import net.minecraft.client.renderer.SectionBufferBuilderPool;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.chunk.RenderChunkRegion;
import net.minecraft.client.renderer.chunk.RenderRegionCache;
import net.minecraft.client.renderer.chunk.VisGraph;
import net.minecraft.client.renderer.chunk.VisibilitySet;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.thread.ProcessorMailbox;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.event.AddSectionGeometryEvent;
import net.neoforged.neoforge.client.model.data.ModelData;

@OnlyIn(value=Dist.CLIENT)
public class SectionRenderDispatcher {
    private static final int MAX_HIGH_PRIORITY_QUOTA = 2;
    private final PriorityBlockingQueue<RenderSection.CompileTask> toBatchHighPriority = Queues.newPriorityBlockingQueue();
    private final Queue<RenderSection.CompileTask> toBatchLowPriority = Queues.newLinkedBlockingDeque();
    private int highPriorityQuota = 2;
    private final Queue<Runnable> toUpload = Queues.newConcurrentLinkedQueue();
    final SectionBufferBuilderPack fixedBuffers;
    private final SectionBufferBuilderPool bufferPool;
    private volatile int toBatchCount;
    private volatile boolean closed;
    private final ProcessorMailbox<Runnable> mailbox;
    private final Executor executor;
    ClientLevel level;
    final LevelRenderer renderer;
    private Vec3 camera = Vec3.ZERO;

    public SectionRenderDispatcher(ClientLevel p_295274_, LevelRenderer p_295323_, Executor p_295234_, RenderBuffers p_307511_) {
        this.level = p_295274_;
        this.renderer = p_295323_;
        this.fixedBuffers = p_307511_.fixedBufferPack();
        this.bufferPool = p_307511_.sectionBufferPool();
        this.executor = p_295234_;
        this.mailbox = ProcessorMailbox.create((Executor)p_295234_, (String)"Section Renderer");
        this.mailbox.tell(this::runTask);
    }

    public void setLevel(ClientLevel p_295112_) {
        this.level = p_295112_;
    }

    private void runTask() {
        RenderSection.CompileTask sectionrenderdispatcher$rendersection$compiletask;
        if (!this.closed && !this.bufferPool.isEmpty() && (sectionrenderdispatcher$rendersection$compiletask = this.pollTask()) != null) {
            SectionBufferBuilderPack sectionbufferbuilderpack = Objects.requireNonNull(this.bufferPool.acquire());
            this.toBatchCount = this.toBatchHighPriority.size() + this.toBatchLowPriority.size();
            ((CompletableFuture)CompletableFuture.supplyAsync(Util.wrapThreadWithTaskName(sectionrenderdispatcher$rendersection$compiletask.name(), () -> sectionrenderdispatcher$rendersection$compiletask.doTask(sectionbufferbuilderpack)), this.executor).thenCompose(p_296185_ -> p_296185_)).whenComplete((p_296170_, p_294818_) -> {
                if (p_294818_ != null) {
                    Minecraft.getInstance().delayCrash(CrashReport.forThrowable(p_294818_, "Batching sections"));
                } else {
                    this.mailbox.tell(() -> {
                        if (p_296170_ == SectionTaskResult.SUCCESSFUL) {
                            sectionbufferbuilderpack.clearAll();
                        } else {
                            sectionbufferbuilderpack.discardAll();
                        }
                        this.bufferPool.release(sectionbufferbuilderpack);
                        this.runTask();
                    });
                }
            });
        }
    }

    @Nullable
    private RenderSection.CompileTask pollTask() {
        RenderSection.CompileTask sectionrenderdispatcher$rendersection$compiletask;
        if (this.highPriorityQuota <= 0 && (sectionrenderdispatcher$rendersection$compiletask = this.toBatchLowPriority.poll()) != null) {
            this.highPriorityQuota = 2;
            return sectionrenderdispatcher$rendersection$compiletask;
        }
        RenderSection.CompileTask sectionrenderdispatcher$rendersection$compiletask1 = this.toBatchHighPriority.poll();
        if (sectionrenderdispatcher$rendersection$compiletask1 != null) {
            --this.highPriorityQuota;
            return sectionrenderdispatcher$rendersection$compiletask1;
        }
        this.highPriorityQuota = 2;
        return this.toBatchLowPriority.poll();
    }

    public String getStats() {
        return String.format(Locale.ROOT, "pC: %03d, pU: %02d, aB: %02d", this.toBatchCount, this.toUpload.size(), this.bufferPool.getFreeBufferCount());
    }

    public int getToBatchCount() {
        return this.toBatchCount;
    }

    public int getToUpload() {
        return this.toUpload.size();
    }

    public int getFreeBufferCount() {
        return this.bufferPool.getFreeBufferCount();
    }

    public void setCamera(Vec3 p_296331_) {
        this.camera = p_296331_;
    }

    public Vec3 getCameraPosition() {
        return this.camera;
    }

    public void uploadAllPendingUploads() {
        Runnable runnable;
        while ((runnable = this.toUpload.poll()) != null) {
            runnable.run();
        }
    }

    public void rebuildSectionSync(RenderSection p_296309_, RenderRegionCache p_294139_) {
        p_296309_.compileSync(p_294139_);
    }

    public void blockUntilClear() {
        this.clearBatchQueue();
    }

    public void schedule(RenderSection.CompileTask p_295825_) {
        if (!this.closed) {
            this.mailbox.tell(() -> {
                if (!this.closed) {
                    if (p_295825_.isHighPriority) {
                        this.toBatchHighPriority.offer(p_295825_);
                    } else {
                        this.toBatchLowPriority.offer(p_295825_);
                    }
                    this.toBatchCount = this.toBatchHighPriority.size() + this.toBatchLowPriority.size();
                    this.runTask();
                }
            });
        }
    }

    public CompletableFuture<Void> uploadSectionLayer(BufferBuilder.RenderedBuffer p_295447_, VertexBuffer p_294163_) {
        return this.closed ? CompletableFuture.completedFuture(null) : CompletableFuture.runAsync(() -> {
            if (p_294163_.isInvalid()) {
                p_295447_.release();
            } else {
                p_294163_.bind();
                p_294163_.upload(p_295447_);
                VertexBuffer.unbind();
            }
        }, this.toUpload::add);
    }

    private void clearBatchQueue() {
        while (!this.toBatchHighPriority.isEmpty()) {
            RenderSection.CompileTask sectionrenderdispatcher$rendersection$compiletask = this.toBatchHighPriority.poll();
            if (sectionrenderdispatcher$rendersection$compiletask == null) continue;
            sectionrenderdispatcher$rendersection$compiletask.cancel();
        }
        while (!this.toBatchLowPriority.isEmpty()) {
            RenderSection.CompileTask sectionrenderdispatcher$rendersection$compiletask1 = this.toBatchLowPriority.poll();
            if (sectionrenderdispatcher$rendersection$compiletask1 == null) continue;
            sectionrenderdispatcher$rendersection$compiletask1.cancel();
        }
        this.toBatchCount = 0;
    }

    public boolean isQueueEmpty() {
        return this.toBatchCount == 0 && this.toUpload.isEmpty();
    }

    public void dispose() {
        this.closed = true;
        this.clearBatchQueue();
        this.uploadAllPendingUploads();
    }

    @OnlyIn(value=Dist.CLIENT)
    public class RenderSection {
        public static final int SIZE = 16;
        public final int index;
        public final AtomicReference<CompiledSection> compiled = new AtomicReference<CompiledSection>(CompiledSection.UNCOMPILED);
        final AtomicInteger initialCompilationCancelCount = new AtomicInteger(0);
        @Nullable
        private RebuildTask lastRebuildTask;
        @Nullable
        private ResortTransparencyTask lastResortTransparencyTask;
        private final Set<BlockEntity> globalBlockEntities = Sets.newHashSet();
        private final Map<RenderType, VertexBuffer> buffers = RenderType.chunkBufferLayers().stream().collect(Collectors.toMap(p_295245_ -> p_295245_, p_295640_ -> new VertexBuffer(VertexBuffer.Usage.STATIC)));
        private AABB bb;
        private boolean dirty = true;
        final BlockPos.MutableBlockPos origin = new BlockPos.MutableBlockPos(-1, -1, -1);
        private final BlockPos.MutableBlockPos[] relativeOrigins = Util.make(new BlockPos.MutableBlockPos[6], p_294717_ -> {
            for (int i = 0; i < ((BlockPos.MutableBlockPos[])p_294717_).length; ++i) {
                p_294717_[i] = new BlockPos.MutableBlockPos();
            }
        });
        private boolean playerChanged;

        public RenderSection(int p_295197_, int p_295159_, int p_294506_, int p_294392_) {
            this.index = p_295197_;
            this.setOrigin(p_295159_, p_294506_, p_294392_);
        }

        private boolean doesChunkExistAt(BlockPos p_295253_) {
            return SectionRenderDispatcher.this.level.getChunk(SectionPos.blockToSectionCoord((int)p_295253_.getX()), SectionPos.blockToSectionCoord((int)p_295253_.getZ()), ChunkStatus.FULL, false) != null;
        }

        public boolean hasAllNeighbors() {
            int i = 24;
            return !(this.getDistToPlayerSqr() > 576.0) ? true : this.doesChunkExistAt((BlockPos)this.relativeOrigins[Direction.WEST.ordinal()]) && this.doesChunkExistAt((BlockPos)this.relativeOrigins[Direction.NORTH.ordinal()]) && this.doesChunkExistAt((BlockPos)this.relativeOrigins[Direction.EAST.ordinal()]) && this.doesChunkExistAt((BlockPos)this.relativeOrigins[Direction.SOUTH.ordinal()]);
        }

        public AABB getBoundingBox() {
            return this.bb;
        }

        public VertexBuffer getBuffer(RenderType p_294497_) {
            return this.buffers.get((Object)p_294497_);
        }

        public void setOrigin(int p_294148_, int p_295137_, int p_295706_) {
            this.reset();
            this.origin.set(p_294148_, p_295137_, p_295706_);
            this.bb = new AABB(p_294148_, p_295137_, p_295706_, p_294148_ + 16, p_295137_ + 16, p_295706_ + 16);
            for (Direction direction : Direction.values()) {
                this.relativeOrigins[direction.ordinal()].set((Vec3i)this.origin).move(direction, 16);
            }
        }

        protected double getDistToPlayerSqr() {
            Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
            double d0 = this.bb.minX + 8.0 - camera.getPosition().x;
            double d1 = this.bb.minY + 8.0 - camera.getPosition().y;
            double d2 = this.bb.minZ + 8.0 - camera.getPosition().z;
            return d0 * d0 + d1 * d1 + d2 * d2;
        }

        void beginLayer(BufferBuilder p_294230_) {
            p_294230_.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.BLOCK);
        }

        public CompiledSection getCompiled() {
            return this.compiled.get();
        }

        private void reset() {
            this.cancelTasks();
            this.compiled.set(CompiledSection.UNCOMPILED);
            this.dirty = true;
        }

        public void releaseBuffers() {
            this.reset();
            this.buffers.values().forEach(VertexBuffer::close);
        }

        public BlockPos getOrigin() {
            return this.origin;
        }

        public void setDirty(boolean p_295417_) {
            boolean flag = this.dirty;
            this.dirty = true;
            this.playerChanged = p_295417_ | (flag && this.playerChanged);
        }

        public void setNotDirty() {
            this.dirty = false;
            this.playerChanged = false;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public boolean isDirtyFromPlayer() {
            return this.dirty && this.playerChanged;
        }

        public BlockPos getRelativeOrigin(Direction p_296100_) {
            return this.relativeOrigins[p_296100_.ordinal()];
        }

        public boolean resortTransparency(RenderType p_295679_, SectionRenderDispatcher p_294363_) {
            CompiledSection sectionrenderdispatcher$compiledsection = this.getCompiled();
            if (this.lastResortTransparencyTask != null) {
                this.lastResortTransparencyTask.cancel();
            }
            if (!sectionrenderdispatcher$compiledsection.hasBlocks.contains((Object)p_295679_)) {
                return false;
            }
            this.lastResortTransparencyTask = new ResortTransparencyTask(this.getDistToPlayerSqr(), sectionrenderdispatcher$compiledsection);
            p_294363_.schedule(this.lastResortTransparencyTask);
            return true;
        }

        protected boolean cancelTasks() {
            boolean flag = false;
            if (this.lastRebuildTask != null) {
                this.lastRebuildTask.cancel();
                this.lastRebuildTask = null;
                flag = true;
            }
            if (this.lastResortTransparencyTask != null) {
                this.lastResortTransparencyTask.cancel();
                this.lastResortTransparencyTask = null;
            }
            return flag;
        }

        public CompileTask createCompileTask(RenderRegionCache p_295324_) {
            boolean flag1;
            boolean flag = this.cancelTasks();
            BlockPos blockpos = this.origin.immutable();
            boolean i = true;
            List additionalRenderers = ClientHooks.gatherAdditionalRenderers((BlockPos)blockpos, (Level)SectionRenderDispatcher.this.level);
            RenderChunkRegion renderchunkregion = p_295324_.createRegion(SectionRenderDispatcher.this.level, blockpos.offset(-1, -1, -1), blockpos.offset(16, 16, 16), 1, additionalRenderers.isEmpty());
            boolean bl = flag1 = this.compiled.get() == CompiledSection.UNCOMPILED;
            if (flag1 && flag) {
                this.initialCompilationCancelCount.incrementAndGet();
            }
            this.lastRebuildTask = new RebuildTask(this.getDistToPlayerSqr(), renderchunkregion, !flag1 || this.initialCompilationCancelCount.get() > 2, additionalRenderers);
            return this.lastRebuildTask;
        }

        public void rebuildSectionAsync(SectionRenderDispatcher p_295901_, RenderRegionCache p_294660_) {
            CompileTask sectionrenderdispatcher$rendersection$compiletask = this.createCompileTask(p_294660_);
            p_295901_.schedule(sectionrenderdispatcher$rendersection$compiletask);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateGlobalBlockEntities(Collection<BlockEntity> p_296155_) {
            HashSet set1;
            HashSet set = Sets.newHashSet(p_296155_);
            Set<BlockEntity> set2 = this.globalBlockEntities;
            synchronized (set2) {
                set1 = Sets.newHashSet(this.globalBlockEntities);
                set.removeAll(this.globalBlockEntities);
                set1.removeAll(p_296155_);
                this.globalBlockEntities.clear();
                this.globalBlockEntities.addAll(p_296155_);
            }
            SectionRenderDispatcher.this.renderer.updateGlobalBlockEntities(set1, set);
        }

        public void compileSync(RenderRegionCache p_296018_) {
            CompileTask sectionrenderdispatcher$rendersection$compiletask = this.createCompileTask(p_296018_);
            sectionrenderdispatcher$rendersection$compiletask.doTask(SectionRenderDispatcher.this.fixedBuffers);
        }

        public boolean isAxisAlignedWith(int p_295743_, int p_295344_, int p_295518_) {
            BlockPos blockpos = this.getOrigin();
            return p_295743_ == SectionPos.blockToSectionCoord((int)blockpos.getX()) || p_295518_ == SectionPos.blockToSectionCoord((int)blockpos.getZ()) || p_295344_ == SectionPos.blockToSectionCoord((int)blockpos.getY());
        }

        @OnlyIn(value=Dist.CLIENT)
        class ResortTransparencyTask
        extends CompileTask {
            private final CompiledSection compiledSection;

            public ResortTransparencyTask(double p_294102_, CompiledSection p_294601_) {
                super(RenderSection.this, p_294102_, true);
                this.compiledSection = p_294601_;
            }

            @Override
            protected String name() {
                return "rend_chk_sort";
            }

            @Override
            public CompletableFuture<SectionTaskResult> doTask(SectionBufferBuilderPack p_295160_) {
                if (this.isCancelled.get()) {
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                if (!RenderSection.this.hasAllNeighbors()) {
                    this.isCancelled.set(true);
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                if (this.isCancelled.get()) {
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                Vec3 vec3 = SectionRenderDispatcher.this.getCameraPosition();
                float f = (float)vec3.x;
                float f1 = (float)vec3.y;
                float f2 = (float)vec3.z;
                BufferBuilder.SortState bufferbuilder$sortstate = this.compiledSection.transparencyState;
                if (bufferbuilder$sortstate != null && !this.compiledSection.isEmpty(RenderType.translucent())) {
                    BufferBuilder bufferbuilder = p_295160_.builder(RenderType.translucent());
                    RenderSection.this.beginLayer(bufferbuilder);
                    bufferbuilder.restoreSortState(bufferbuilder$sortstate);
                    bufferbuilder.setQuadSorting(VertexSorting.byDistance((float)(f - (float)RenderSection.this.origin.getX()), (float)(f1 - (float)RenderSection.this.origin.getY()), (float)(f2 - (float)RenderSection.this.origin.getZ())));
                    this.compiledSection.transparencyState = bufferbuilder.getSortState();
                    BufferBuilder.RenderedBuffer bufferbuilder$renderedbuffer = bufferbuilder.end();
                    if (this.isCancelled.get()) {
                        bufferbuilder$renderedbuffer.release();
                        return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                    }
                    CompletionStage completablefuture = SectionRenderDispatcher.this.uploadSectionLayer(bufferbuilder$renderedbuffer, RenderSection.this.getBuffer(RenderType.translucent())).thenApply(p_294714_ -> SectionTaskResult.CANCELLED);
                    return ((CompletableFuture)completablefuture).handle((p_295896_, p_295826_) -> {
                        if (p_295826_ != null && !(p_295826_ instanceof CancellationException) && !(p_295826_ instanceof InterruptedException)) {
                            Minecraft.getInstance().delayCrash(CrashReport.forThrowable(p_295826_, "Rendering section"));
                        }
                        return this.isCancelled.get() ? SectionTaskResult.CANCELLED : SectionTaskResult.SUCCESSFUL;
                    });
                }
                return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
            }

            @Override
            public void cancel() {
                this.isCancelled.set(true);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        abstract class CompileTask
        implements Comparable<CompileTask> {
            protected final double distAtCreation;
            protected final AtomicBoolean isCancelled = new AtomicBoolean(false);
            protected final boolean isHighPriority;

            public CompileTask(RenderSection this$1, double p_294428_, boolean p_295051_) {
                this.distAtCreation = p_294428_;
                this.isHighPriority = p_295051_;
            }

            public abstract CompletableFuture<SectionTaskResult> doTask(SectionBufferBuilderPack var1);

            public abstract void cancel();

            protected abstract String name();

            @Override
            public int compareTo(CompileTask p_296186_) {
                return Doubles.compare((double)this.distAtCreation, (double)p_296186_.distAtCreation);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        class RebuildTask
        extends CompileTask {
            @Nullable
            protected RenderChunkRegion region;
            private final List<AddSectionGeometryEvent.AdditionalSectionRenderer> additionalRenderers;

            @Deprecated
            public RebuildTask(@Nullable double p_294400_, RenderChunkRegion p_294382_, boolean p_295207_) {
                this(p_294400_, p_294382_, p_295207_, List.of());
            }

            public RebuildTask(@Nullable double p_294400_, RenderChunkRegion p_294382_, boolean p_295207_, List<AddSectionGeometryEvent.AdditionalSectionRenderer> additionalRenderers) {
                super(RenderSection.this, p_294400_, p_295207_);
                this.region = p_294382_;
                this.additionalRenderers = additionalRenderers;
            }

            @Override
            protected String name() {
                return "rend_chk_rebuild";
            }

            @Override
            public CompletableFuture<SectionTaskResult> doTask(SectionBufferBuilderPack p_296138_) {
                if (this.isCancelled.get()) {
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                if (!RenderSection.this.hasAllNeighbors()) {
                    this.region = null;
                    RenderSection.this.setDirty(false);
                    this.isCancelled.set(true);
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                if (this.isCancelled.get()) {
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                Vec3 vec3 = SectionRenderDispatcher.this.getCameraPosition();
                float f = (float)vec3.x;
                float f1 = (float)vec3.y;
                float f2 = (float)vec3.z;
                CompileResults sectionrenderdispatcher$rendersection$rebuildtask$compileresults = this.compile(f, f1, f2, p_296138_);
                RenderSection.this.updateGlobalBlockEntities(sectionrenderdispatcher$rendersection$rebuildtask$compileresults.globalBlockEntities);
                if (this.isCancelled.get()) {
                    sectionrenderdispatcher$rendersection$rebuildtask$compileresults.renderedLayers.values().forEach(BufferBuilder.RenderedBuffer::release);
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                CompiledSection sectionrenderdispatcher$compiledsection = new CompiledSection();
                sectionrenderdispatcher$compiledsection.visibilitySet = sectionrenderdispatcher$rendersection$rebuildtask$compileresults.visibilitySet;
                sectionrenderdispatcher$compiledsection.renderableBlockEntities.addAll(sectionrenderdispatcher$rendersection$rebuildtask$compileresults.blockEntities);
                sectionrenderdispatcher$compiledsection.transparencyState = sectionrenderdispatcher$rendersection$rebuildtask$compileresults.transparencyState;
                ArrayList list = Lists.newArrayList();
                sectionrenderdispatcher$rendersection$rebuildtask$compileresults.renderedLayers.forEach((p_295005_, p_295071_) -> {
                    list.add(SectionRenderDispatcher.this.uploadSectionLayer((BufferBuilder.RenderedBuffer)p_295071_, RenderSection.this.getBuffer((RenderType)((Object)p_295005_))));
                    sectionrenderdispatcher$compiledsection.hasBlocks.add((RenderType)((Object)p_295005_));
                });
                return Util.sequenceFailFast(list).handle((p_295515_, p_295905_) -> {
                    if (p_295905_ != null && !(p_295905_ instanceof CancellationException) && !(p_295905_ instanceof InterruptedException)) {
                        Minecraft.getInstance().delayCrash(CrashReport.forThrowable(p_295905_, "Rendering section"));
                    }
                    if (this.isCancelled.get()) {
                        return SectionTaskResult.CANCELLED;
                    }
                    RenderSection.this.compiled.set(sectionrenderdispatcher$compiledsection);
                    RenderSection.this.initialCompilationCancelCount.set(0);
                    SectionRenderDispatcher.this.renderer.addRecentlyCompiledSection(RenderSection.this);
                    return SectionTaskResult.SUCCESSFUL;
                });
            }

            private CompileResults compile(float p_294894_, float p_295437_, float p_294465_, SectionBufferBuilderPack p_294319_) {
                CompileResults sectionrenderdispatcher$rendersection$rebuildtask$compileresults = new CompileResults();
                boolean i = true;
                BlockPos blockpos = RenderSection.this.origin.immutable();
                BlockPos blockpos1 = blockpos.offset(15, 15, 15);
                VisGraph visgraph = new VisGraph();
                RenderChunkRegion renderchunkregion = this.region;
                this.region = null;
                PoseStack posestack = new PoseStack();
                if (renderchunkregion != null) {
                    BufferBuilder bufferbuilder1;
                    ModelBlockRenderer.enableCaching();
                    ReferenceArraySet set = new ReferenceArraySet(RenderType.chunkBufferLayers().size());
                    RandomSource randomsource = RandomSource.create();
                    BlockRenderDispatcher blockrenderdispatcher = Minecraft.getInstance().getBlockRenderer();
                    for (BlockPos blockpos2 : BlockPos.betweenClosed((BlockPos)blockpos, (BlockPos)blockpos1)) {
                        FluidState fluidstate;
                        BlockEntity blockentity;
                        BlockState blockstate = renderchunkregion.getBlockState(blockpos2);
                        if (blockstate.isSolidRender(renderchunkregion, blockpos2)) {
                            visgraph.setOpaque(blockpos2);
                        }
                        if (blockstate.hasBlockEntity() && (blockentity = renderchunkregion.getBlockEntity(blockpos2)) != null) {
                            this.handleBlockEntity(sectionrenderdispatcher$rendersection$rebuildtask$compileresults, blockentity);
                        }
                        if (!(fluidstate = blockstate.getFluidState()).isEmpty()) {
                            RenderType rendertype = ItemBlockRenderTypes.getRenderLayer(fluidstate);
                            BufferBuilder bufferbuilder = p_294319_.builder(rendertype);
                            if (set.add(rendertype)) {
                                RenderSection.this.beginLayer(bufferbuilder);
                            }
                            blockrenderdispatcher.renderLiquid(blockpos2, renderchunkregion, (VertexConsumer)((Object)bufferbuilder), blockstate, fluidstate);
                        }
                        if (blockstate.getRenderShape() == RenderShape.INVISIBLE) continue;
                        BakedModel model = blockrenderdispatcher.getBlockModel(blockstate);
                        ModelData modelData = renderchunkregion.getModelData(blockpos2);
                        modelData = model.getModelData(renderchunkregion, blockpos2, blockstate, modelData);
                        randomsource.setSeed(blockstate.getSeed(blockpos2));
                        for (RenderType rendertype2 : model.getRenderTypes(blockstate, randomsource, modelData)) {
                            BufferBuilder bufferbuilder2 = p_294319_.builder(rendertype2);
                            if (set.add(rendertype2)) {
                                RenderSection.this.beginLayer(bufferbuilder2);
                            }
                            posestack.pushPose();
                            posestack.translate(blockpos2.getX() & 0xF, blockpos2.getY() & 0xF, blockpos2.getZ() & 0xF);
                            blockrenderdispatcher.renderBatched(blockstate, blockpos2, renderchunkregion, posestack, (VertexConsumer)((Object)bufferbuilder2), true, randomsource, modelData, rendertype2);
                            posestack.popPose();
                        }
                    }
                    ClientHooks.addAdditionalGeometry(this.additionalRenderers, arg_0 -> this.lambda$compile$2(p_294319_, (Set)set, arg_0), (RenderChunkRegion)renderchunkregion, (PoseStack)posestack);
                    if (set.contains((Object)RenderType.translucent()) && !(bufferbuilder1 = p_294319_.builder(RenderType.translucent())).isCurrentBatchEmpty()) {
                        bufferbuilder1.setQuadSorting(VertexSorting.byDistance((float)(p_294894_ - (float)blockpos.getX()), (float)(p_295437_ - (float)blockpos.getY()), (float)(p_294465_ - (float)blockpos.getZ())));
                        sectionrenderdispatcher$rendersection$rebuildtask$compileresults.transparencyState = bufferbuilder1.getSortState();
                    }
                    for (RenderType rendertype1 : set) {
                        BufferBuilder.RenderedBuffer bufferbuilder$renderedbuffer = p_294319_.builder(rendertype1).endOrDiscardIfEmpty();
                        if (bufferbuilder$renderedbuffer == null) continue;
                        sectionrenderdispatcher$rendersection$rebuildtask$compileresults.renderedLayers.put(rendertype1, bufferbuilder$renderedbuffer);
                    }
                    ModelBlockRenderer.clearCache();
                }
                sectionrenderdispatcher$rendersection$rebuildtask$compileresults.visibilitySet = visgraph.resolve();
                return sectionrenderdispatcher$rendersection$rebuildtask$compileresults;
            }

            private <E extends BlockEntity> void handleBlockEntity(CompileResults p_294198_, E p_296214_) {
                BlockEntityRenderer blockentityrenderer = Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer(p_296214_);
                if (blockentityrenderer != null) {
                    if (blockentityrenderer.shouldRenderOffScreen(p_296214_)) {
                        p_294198_.globalBlockEntities.add(p_296214_);
                    } else {
                        p_294198_.blockEntities.add(p_296214_);
                    }
                }
            }

            @Override
            public void cancel() {
                this.region = null;
                if (this.isCancelled.compareAndSet(false, true)) {
                    RenderSection.this.setDirty(false);
                }
            }

            private /* synthetic */ VertexConsumer lambda$compile$2(SectionBufferBuilderPack p_294319_, Set set, RenderType type) {
                BufferBuilder builder = p_294319_.builder(type);
                if (set.add(type)) {
                    RenderSection.this.beginLayer(builder);
                }
                return builder;
            }

            @OnlyIn(value=Dist.CLIENT)
            static final class CompileResults {
                public final List<BlockEntity> globalBlockEntities = new ArrayList<BlockEntity>();
                public final List<BlockEntity> blockEntities = new ArrayList<BlockEntity>();
                public final Map<RenderType, BufferBuilder.RenderedBuffer> renderedLayers = new Reference2ObjectArrayMap();
                public VisibilitySet visibilitySet = new VisibilitySet();
                @Nullable
                public BufferBuilder.SortState transparencyState;

                CompileResults() {
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static enum SectionTaskResult {
        SUCCESSFUL,
        CANCELLED;

    }

    @OnlyIn(value=Dist.CLIENT)
    public static class CompiledSection {
        public static final CompiledSection UNCOMPILED = new CompiledSection(){

            @Override
            public boolean facesCanSeeEachother(Direction p_296238_, Direction p_294727_) {
                return false;
            }
        };
        final Set<RenderType> hasBlocks = new ObjectArraySet(RenderType.chunkBufferLayers().size());
        final List<BlockEntity> renderableBlockEntities = Lists.newArrayList();
        VisibilitySet visibilitySet = new VisibilitySet();
        @Nullable
        BufferBuilder.SortState transparencyState;

        public boolean hasNoRenderableLayers() {
            return this.hasBlocks.isEmpty();
        }

        public boolean isEmpty(RenderType p_296192_) {
            return !this.hasBlocks.contains((Object)p_296192_);
        }

        public List<BlockEntity> getRenderableBlockEntities() {
            return this.renderableBlockEntities;
        }

        public boolean facesCanSeeEachother(Direction p_295753_, Direction p_294424_) {
            return this.visibilitySet.visibilityBetween(p_295753_, p_294424_);
        }
    }
}

