/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.logging.LogUtils;
import com.mojang.math.Axis;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.client.event.RenderLivingEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public abstract class LivingEntityRenderer<T extends LivingEntity, M extends EntityModel<T>>
extends EntityRenderer<T>
implements RenderLayerParent<T, M> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final float EYE_BED_OFFSET = 0.1f;
    protected M model;
    protected final List<RenderLayer<T, M>> layers = Lists.newArrayList();

    public LivingEntityRenderer(EntityRendererProvider.Context p_174289_, M p_174290_, float p_174291_) {
        super(p_174289_);
        this.model = p_174290_;
        this.shadowRadius = p_174291_;
    }

    public final boolean addLayer(RenderLayer<T, M> p_115327_) {
        return this.layers.add(p_115327_);
    }

    public M getModel() {
        return this.model;
    }

    @Override
    public void render(T p_115308_, float p_115309_, float p_115310_, PoseStack p_115311_, MultiBufferSource p_115312_, int p_115313_) {
        Direction direction;
        Entity entity;
        boolean shouldSit;
        if (((RenderLivingEvent.Pre)NeoForge.EVENT_BUS.post((Event)new RenderLivingEvent.Pre(p_115308_, this, p_115310_, p_115311_, p_115312_, p_115313_))).isCanceled()) {
            return;
        }
        p_115311_.pushPose();
        ((EntityModel)this.model).attackTime = this.getAttackAnim(p_115308_, p_115310_);
        ((EntityModel)this.model).riding = shouldSit = ((Entity)((Object)p_115308_)).isPassenger() && ((Entity)((Object)p_115308_)).getVehicle() != null && ((Entity)((Object)p_115308_)).getVehicle().shouldRiderSit();
        ((EntityModel)this.model).young = ((LivingEntity)((Object)p_115308_)).isBaby();
        float f = Mth.rotLerp((float)p_115310_, (float)((LivingEntity)((Object)p_115308_)).yBodyRotO, (float)((LivingEntity)((Object)p_115308_)).yBodyRot);
        float f1 = Mth.rotLerp((float)p_115310_, (float)((LivingEntity)((Object)p_115308_)).yHeadRotO, (float)((LivingEntity)((Object)p_115308_)).yHeadRot);
        float f2 = f1 - f;
        if (shouldSit && (entity = ((Entity)((Object)p_115308_)).getVehicle()) instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            f = Mth.rotLerp((float)p_115310_, (float)livingentity.yBodyRotO, (float)livingentity.yBodyRot);
            f2 = f1 - f;
            float f7 = Mth.wrapDegrees((float)f2);
            if (f7 < -85.0f) {
                f7 = -85.0f;
            }
            if (f7 >= 85.0f) {
                f7 = 85.0f;
            }
            f = f1 - f7;
            if (f7 * f7 > 2500.0f) {
                f += f7 * 0.2f;
            }
            f2 = f1 - f;
        }
        float f6 = Mth.lerp((float)p_115310_, (float)((LivingEntity)((Object)p_115308_)).xRotO, (float)((Entity)((Object)p_115308_)).getXRot());
        if (LivingEntityRenderer.isEntityUpsideDown(p_115308_)) {
            f6 *= -1.0f;
            f2 *= -1.0f;
        }
        f2 = Mth.wrapDegrees((float)f2);
        if (((Entity)((Object)p_115308_)).hasPose(Pose.SLEEPING) && (direction = ((LivingEntity)((Object)p_115308_)).getBedOrientation()) != null) {
            float f3 = ((Entity)((Object)p_115308_)).getEyeHeight(Pose.STANDING) - 0.1f;
            p_115311_.translate((float)(-direction.getStepX()) * f3, 0.0f, (float)(-direction.getStepZ()) * f3);
        }
        float f8 = ((LivingEntity)((Object)p_115308_)).getScale();
        p_115311_.scale(f8, f8, f8);
        float f9 = this.getBob(p_115308_, p_115310_);
        this.setupRotations(p_115308_, p_115311_, f9, f, p_115310_, f8);
        p_115311_.scale(-1.0f, -1.0f, 1.0f);
        this.scale(p_115308_, p_115311_, p_115310_);
        p_115311_.translate(0.0f, -1.501f, 0.0f);
        float f4 = 0.0f;
        float f5 = 0.0f;
        if (!shouldSit && ((LivingEntity)((Object)p_115308_)).isAlive()) {
            f4 = ((LivingEntity)((Object)p_115308_)).walkAnimation.speed(p_115310_);
            f5 = ((LivingEntity)((Object)p_115308_)).walkAnimation.position(p_115310_);
            if (((LivingEntity)((Object)p_115308_)).isBaby()) {
                f5 *= 3.0f;
            }
            if (f4 > 1.0f) {
                f4 = 1.0f;
            }
        }
        this.model.prepareMobModel(p_115308_, f5, f4, p_115310_);
        this.model.setupAnim(p_115308_, f5, f4, f9, f2, f6);
        Minecraft minecraft = Minecraft.getInstance();
        boolean flag = this.isBodyVisible(p_115308_);
        boolean flag1 = !flag && !((Entity)((Object)p_115308_)).isInvisibleTo(minecraft.player);
        boolean flag2 = minecraft.shouldEntityAppearGlowing((Entity)((Object)p_115308_));
        RenderType rendertype = this.getRenderType(p_115308_, flag, flag1, flag2);
        if (rendertype != null) {
            VertexConsumer vertexconsumer = p_115312_.getBuffer(rendertype);
            int i = LivingEntityRenderer.getOverlayCoords(p_115308_, this.getWhiteOverlayProgress(p_115308_, p_115310_));
            this.model.renderToBuffer(p_115311_, vertexconsumer, p_115313_, i, 1.0f, 1.0f, 1.0f, flag1 ? 0.15f : 1.0f);
        }
        if (!((Entity)((Object)p_115308_)).isSpectator()) {
            for (RenderLayer<T, M> renderlayer : this.layers) {
                renderlayer.render(p_115311_, p_115312_, p_115313_, p_115308_, f5, f4, p_115310_, f9, f2, f6);
            }
        }
        p_115311_.popPose();
        super.render(p_115308_, p_115309_, p_115310_, p_115311_, p_115312_, p_115313_);
        NeoForge.EVENT_BUS.post((Event)new RenderLivingEvent.Post(p_115308_, this, p_115310_, p_115311_, p_115312_, p_115313_));
    }

    @Nullable
    protected RenderType getRenderType(T p_115322_, boolean p_115323_, boolean p_115324_, boolean p_115325_) {
        ResourceLocation resourcelocation = this.getTextureLocation(p_115322_);
        if (p_115324_) {
            return RenderType.itemEntityTranslucentCull(resourcelocation);
        }
        if (p_115323_) {
            return this.model.renderType(resourcelocation);
        }
        return p_115325_ ? RenderType.outline(resourcelocation) : null;
    }

    public static int getOverlayCoords(LivingEntity p_115339_, float p_115340_) {
        return OverlayTexture.pack((int)OverlayTexture.u((float)p_115340_), (int)OverlayTexture.v((p_115339_.hurtTime > 0 || p_115339_.deathTime > 0 ? 1 : 0) != 0));
    }

    protected boolean isBodyVisible(T p_115341_) {
        return !((Entity)((Object)p_115341_)).isInvisible();
    }

    private static float sleepDirectionToRotation(Direction p_115329_) {
        switch (p_115329_) {
            case SOUTH: {
                return 90.0f;
            }
            case WEST: {
                return 0.0f;
            }
            case NORTH: {
                return 270.0f;
            }
            case EAST: {
                return 180.0f;
            }
        }
        return 0.0f;
    }

    protected boolean isShaking(T p_115304_) {
        return ((Entity)((Object)p_115304_)).isFullyFrozen();
    }

    protected void setupRotations(T p_115317_, PoseStack p_115318_, float p_115319_, float p_115320_, float p_115321_, float p_320045_) {
        if (this.isShaking(p_115317_)) {
            p_115320_ += (float)(Math.cos((double)((LivingEntity)((Object)p_115317_)).tickCount * 3.25) * Math.PI * (double)0.4f);
        }
        if (!((Entity)((Object)p_115317_)).hasPose(Pose.SLEEPING)) {
            p_115318_.mulPose(Axis.YP.rotationDegrees(180.0f - p_115320_));
        }
        if (((LivingEntity)((Object)p_115317_)).deathTime > 0) {
            float f = ((float)((LivingEntity)((Object)p_115317_)).deathTime + p_115321_ - 1.0f) / 20.0f * 1.6f;
            if ((f = Mth.sqrt((float)f)) > 1.0f) {
                f = 1.0f;
            }
            p_115318_.mulPose(Axis.ZP.rotationDegrees(f * this.getFlipDegrees(p_115317_)));
        } else if (((LivingEntity)((Object)p_115317_)).isAutoSpinAttack()) {
            p_115318_.mulPose(Axis.XP.rotationDegrees(-90.0f - ((Entity)((Object)p_115317_)).getXRot()));
            p_115318_.mulPose(Axis.YP.rotationDegrees(((float)((LivingEntity)((Object)p_115317_)).tickCount + p_115321_) * -75.0f));
        } else if (((Entity)((Object)p_115317_)).hasPose(Pose.SLEEPING)) {
            Direction direction = ((LivingEntity)((Object)p_115317_)).getBedOrientation();
            float f1 = direction != null ? LivingEntityRenderer.sleepDirectionToRotation(direction) : p_115320_;
            p_115318_.mulPose(Axis.YP.rotationDegrees(f1));
            p_115318_.mulPose(Axis.ZP.rotationDegrees(this.getFlipDegrees(p_115317_)));
            p_115318_.mulPose(Axis.YP.rotationDegrees(270.0f));
        } else if (LivingEntityRenderer.isEntityUpsideDown(p_115317_)) {
            p_115318_.translate(0.0f, (((Entity)((Object)p_115317_)).getBbHeight() + 0.1f) / p_320045_, 0.0f);
            p_115318_.mulPose(Axis.ZP.rotationDegrees(180.0f));
        }
    }

    protected float getAttackAnim(T p_115343_, float p_115344_) {
        return ((LivingEntity)((Object)p_115343_)).getAttackAnim(p_115344_);
    }

    protected float getBob(T p_115305_, float p_115306_) {
        return (float)((LivingEntity)((Object)p_115305_)).tickCount + p_115306_;
    }

    protected float getFlipDegrees(T p_115337_) {
        return 90.0f;
    }

    protected float getWhiteOverlayProgress(T p_115334_, float p_115335_) {
        return 0.0f;
    }

    protected void scale(T p_115314_, PoseStack p_115315_, float p_115316_) {
    }

    @Override
    protected boolean shouldShowName(T p_115333_) {
        boolean flag;
        float f;
        double d0 = this.entityRenderDispatcher.distanceToSqr((Entity)((Object)p_115333_));
        float f2 = f = ((Entity)((Object)p_115333_)).isDiscrete() ? 32.0f : 64.0f;
        if (d0 >= (double)(f * f)) {
            return false;
        }
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer localplayer = minecraft.player;
        boolean bl = flag = !((Entity)((Object)p_115333_)).isInvisibleTo(localplayer);
        if (p_115333_ != localplayer) {
            PlayerTeam team = ((Entity)((Object)p_115333_)).getTeam();
            PlayerTeam team1 = localplayer.getTeam();
            if (team != null) {
                Team.Visibility team$visibility = team.getNameTagVisibility();
                switch (team$visibility) {
                    case ALWAYS: {
                        return flag;
                    }
                    case NEVER: {
                        return false;
                    }
                    case HIDE_FOR_OTHER_TEAMS: {
                        return team1 == null ? flag : team.isAlliedTo((Team)team1) && (team.canSeeFriendlyInvisibles() || flag);
                    }
                    case HIDE_FOR_OWN_TEAM: {
                        return team1 == null ? flag : !team.isAlliedTo((Team)team1) && flag;
                    }
                }
                return true;
            }
        }
        return Minecraft.renderNames() && p_115333_ != minecraft.getCameraEntity() && flag && !((Entity)((Object)p_115333_)).isVehicle();
    }

    public static boolean isEntityUpsideDown(LivingEntity p_194454_) {
        String s;
        if ((p_194454_ instanceof Player || p_194454_.hasCustomName()) && ("Dinnerbone".equals(s = ChatFormatting.stripFormatting((String)p_194454_.getName().getString())) || "Grumm".equals(s))) {
            return !(p_194454_ instanceof Player) || ((Player)p_194454_).isModelPartShown(PlayerModelPart.CAPE);
        }
        return false;
    }

    @Override
    protected float getShadowRadius(T p_316722_) {
        return super.getShadowRadius(p_316722_) * ((LivingEntity)((Object)p_316722_)).getScale();
    }
}

