/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture.atlas;

import com.google.common.collect.BiMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.SpriteSourceType;
import net.minecraft.client.renderer.texture.atlas.sources.DirectoryLister;
import net.minecraft.client.renderer.texture.atlas.sources.PalettedPermutations;
import net.minecraft.client.renderer.texture.atlas.sources.SingleFile;
import net.minecraft.client.renderer.texture.atlas.sources.SourceFilter;
import net.minecraft.client.renderer.texture.atlas.sources.Unstitcher;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ClientHooks;

@OnlyIn(value=Dist.CLIENT)
public class SpriteSources {
    private static final BiMap<ResourceLocation, SpriteSourceType> TYPES = ClientHooks.makeSpriteSourceTypesMap();
    public static final SpriteSourceType SINGLE_FILE = SpriteSources.register("single", (MapCodec<? extends SpriteSource>)SingleFile.CODEC);
    public static final SpriteSourceType DIRECTORY = SpriteSources.register("directory", (MapCodec<? extends SpriteSource>)DirectoryLister.CODEC);
    public static final SpriteSourceType FILTER = SpriteSources.register("filter", (MapCodec<? extends SpriteSource>)SourceFilter.CODEC);
    public static final SpriteSourceType UNSTITCHER = SpriteSources.register("unstitch", (MapCodec<? extends SpriteSource>)Unstitcher.CODEC);
    public static final SpriteSourceType PALETTED_PERMUTATIONS = SpriteSources.register("paletted_permutations", (MapCodec<? extends SpriteSource>)PalettedPermutations.CODEC);
    public static Codec<SpriteSourceType> TYPE_CODEC = ResourceLocation.CODEC.flatXmap(p_274717_ -> {
        SpriteSourceType spritesourcetype = (SpriteSourceType)TYPES.get(p_274717_);
        return spritesourcetype != null ? DataResult.success((Object)spritesourcetype) : DataResult.error(() -> "Unknown type " + String.valueOf(p_274717_));
    }, p_274716_ -> {
        ResourceLocation resourcelocation = (ResourceLocation)TYPES.inverse().get(p_274716_);
        return p_274716_ != null ? DataResult.success((Object)resourcelocation) : DataResult.error(() -> "Unknown type " + String.valueOf(resourcelocation));
    });
    public static Codec<SpriteSource> CODEC = TYPE_CODEC.dispatch(SpriteSource::type, SpriteSourceType::codec);
    public static Codec<List<SpriteSource>> FILE_CODEC = CODEC.listOf().fieldOf("sources").codec();

    private static SpriteSourceType register(String p_262175_, MapCodec<? extends SpriteSource> p_338536_) {
        ResourceLocation resourcelocation = new ResourceLocation(p_262175_);
        SpriteSourceType spritesourcetype = new SpriteSourceType(p_338536_);
        SpriteSourceType spritesourcetype1 = (SpriteSourceType)TYPES.putIfAbsent((Object)resourcelocation, (Object)spritesourcetype);
        if (spritesourcetype1 != null) {
            throw new IllegalStateException("Duplicate registration " + String.valueOf(resourcelocation));
        }
        return spritesourcetype;
    }
}

