/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.util.TriState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class WeightedBakedModel
implements BakedModel,
IDynamicBakedModel {
    private final int totalWeight;
    private final List<WeightedEntry.Wrapper<BakedModel>> list;
    private final BakedModel wrapped;

    public WeightedBakedModel(List<WeightedEntry.Wrapper<BakedModel>> p_119544_) {
        this.list = p_119544_;
        this.totalWeight = WeightedRandom.getTotalWeight(p_119544_);
        this.wrapped = (BakedModel)p_119544_.get(0).data();
    }

    public List<BakedQuad> getQuads(@javax.annotation.Nullable BlockState p_235058_, @javax.annotation.Nullable Direction p_235059_, RandomSource p_235060_, ModelData modelData, @Nullable RenderType renderType) {
        return WeightedRandom.getWeightedItem(this.list, (int)(Math.abs((int)p_235060_.nextLong()) % this.totalWeight)).map(p_235065_ -> ((BakedModel)p_235065_.data()).getQuads(p_235058_, p_235059_, p_235060_, modelData, renderType)).orElse(Collections.emptyList());
    }

    @Override
    public boolean useAmbientOcclusion() {
        return this.wrapped.useAmbientOcclusion();
    }

    public TriState useAmbientOcclusion(BlockState state, ModelData modelData, RenderType renderType) {
        return this.wrapped.useAmbientOcclusion(state, modelData, renderType);
    }

    @Override
    public boolean isGui3d() {
        return this.wrapped.isGui3d();
    }

    @Override
    public boolean usesBlockLight() {
        return this.wrapped.usesBlockLight();
    }

    @Override
    public boolean isCustomRenderer() {
        return this.wrapped.isCustomRenderer();
    }

    @Override
    public TextureAtlasSprite getParticleIcon() {
        return this.wrapped.getParticleIcon();
    }

    public TextureAtlasSprite getParticleIcon(ModelData modelData) {
        return this.wrapped.getParticleIcon(modelData);
    }

    @Override
    public ItemTransforms getTransforms() {
        return this.wrapped.getTransforms();
    }

    public BakedModel applyTransform(ItemDisplayContext transformType, PoseStack poseStack, boolean applyLeftHandTransform) {
        return this.wrapped.applyTransform(transformType, poseStack, applyLeftHandTransform);
    }

    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return WeightedRandom.getWeightedItem(this.list, (int)(Math.abs((int)rand.nextLong()) % this.totalWeight)).map(p_235065_ -> ((BakedModel)p_235065_.data()).getRenderTypes(state, rand, data)).orElse(ChunkRenderTypeSet.none());
    }

    @Override
    public ItemOverrides getOverrides() {
        return this.wrapped.getOverrides();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Builder {
        private final List<WeightedEntry.Wrapper<BakedModel>> list = Lists.newArrayList();

        public Builder add(@javax.annotation.Nullable BakedModel p_119560_, int p_119561_) {
            if (p_119560_ != null) {
                this.list.add((WeightedEntry.Wrapper<BakedModel>)WeightedEntry.wrap((Object)p_119560_, (int)p_119561_));
            }
            return this;
        }

        @javax.annotation.Nullable
        public BakedModel build() {
            if (this.list.isEmpty()) {
                return null;
            }
            return this.list.size() == 1 ? (BakedModel)this.list.get(0).data() : new WeightedBakedModel(this.list);
        }
    }
}

