/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.neoforged.neoforge.registries.BaseMappedRegistry;
import net.neoforged.neoforge.registries.datamaps.DataMapType;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class MappedRegistry<T>
extends BaseMappedRegistry<T>
implements WritableRegistry<T> {
    private static final Logger LOGGER = LogUtils.getLogger();
    final ResourceKey<? extends Registry<T>> key;
    private final ObjectList<Holder.Reference<T>> byId = new ObjectArrayList(256);
    private final Reference2IntMap<T> toId = (Reference2IntMap)Util.make(new Reference2IntOpenHashMap(), p_304142_ -> p_304142_.defaultReturnValue(-1));
    private final Map<ResourceLocation, Holder.Reference<T>> byLocation = new HashMap<ResourceLocation, Holder.Reference<T>>();
    private final Map<ResourceKey<T>, Holder.Reference<T>> byKey = new HashMap<ResourceKey<T>, Holder.Reference<T>>();
    private final Map<T, Holder.Reference<T>> byValue = new IdentityHashMap<T, Holder.Reference<T>>();
    private final Map<ResourceKey<T>, RegistrationInfo> registrationInfos = new IdentityHashMap<ResourceKey<T>, RegistrationInfo>();
    private Lifecycle registryLifecycle;
    private volatile Map<TagKey<T>, HolderSet.Named<T>> tags = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>();
    private boolean frozen;
    @javax.annotation.Nullable
    protected Map<T, Holder.Reference<T>> unregisteredIntrusiveHolders;
    private final HolderLookup.RegistryLookup<T> lookup = new HolderLookup.RegistryLookup<T>(){

        @Override
        public ResourceKey<? extends Registry<? extends T>> key() {
            return MappedRegistry.this.key;
        }

        @Override
        public Lifecycle registryLifecycle() {
            return MappedRegistry.this.registryLifecycle();
        }

        public Optional<Holder.Reference<T>> get(ResourceKey<T> p_255624_) {
            return MappedRegistry.this.getHolder(p_255624_);
        }

        @Override
        public Stream<Holder.Reference<T>> listElements() {
            return MappedRegistry.this.holders();
        }

        public Optional<HolderSet.Named<T>> get(TagKey<T> p_256277_) {
            return MappedRegistry.this.getTag(p_256277_);
        }

        @Override
        public Stream<HolderSet.Named<T>> listTags() {
            return MappedRegistry.this.getTags().map(Pair::getSecond);
        }

        @Override
        @Nullable
        public <A> A getData(DataMapType<T, A> type, ResourceKey<T> key) {
            return (A)MappedRegistry.this.getData(type, key);
        }
    };
    private final Object tagAdditionLock = new Object();

    public MappedRegistry(ResourceKey<? extends Registry<T>> p_249899_, Lifecycle p_252249_) {
        this(p_249899_, p_252249_, false);
    }

    public MappedRegistry(ResourceKey<? extends Registry<T>> p_252132_, Lifecycle p_249215_, boolean p_251014_) {
        this.key = p_252132_;
        this.registryLifecycle = p_249215_;
        if (p_251014_) {
            this.unregisteredIntrusiveHolders = new IdentityHashMap<T, Holder.Reference<T>>();
        }
    }

    public ResourceKey<? extends Registry<T>> key() {
        return this.key;
    }

    public String toString() {
        return "Registry[" + String.valueOf(this.key) + " (" + String.valueOf(this.registryLifecycle) + ")]";
    }

    private void validateWrite() {
        if (this.frozen) {
            throw new IllegalStateException("Registry is already frozen");
        }
    }

    private void validateWrite(ResourceKey<T> p_205922_) {
        if (this.frozen) {
            throw new IllegalStateException("Registry is already frozen (trying to add key " + String.valueOf(p_205922_) + ")");
        }
    }

    public Holder.Reference<T> register(ResourceKey<T> p_256252_, T p_256591_, RegistrationInfo p_326235_) {
        return this.register(this.byId.size(), p_256252_, p_256591_, p_326235_);
    }

    public Holder.Reference<T> register(int id, ResourceKey<T> p_256252_, T p_256591_, RegistrationInfo p_326235_) {
        Holder.Reference reference;
        this.validateWrite(p_256252_);
        Objects.requireNonNull(p_256252_);
        Objects.requireNonNull(p_256591_);
        int i = id;
        if (i > this.getMaxId()) {
            throw new IllegalStateException(String.format(Locale.ENGLISH, "Invalid id %d - maximum id range of %d exceeded.", i, this.getMaxId()));
        }
        if (this.byLocation.containsKey(p_256252_.location())) {
            Util.pauseInIde(new IllegalStateException("Adding duplicate key '" + String.valueOf(p_256252_) + "' to registry"));
        }
        if (this.byValue.containsKey(p_256591_)) {
            Util.pauseInIde(new IllegalStateException("Adding duplicate value '" + String.valueOf(p_256591_) + "' to registry"));
        }
        if (this.unregisteredIntrusiveHolders != null) {
            reference = this.unregisteredIntrusiveHolders.remove(p_256591_);
            if (reference == null) {
                throw new AssertionError((Object)("Missing intrusive holder for " + String.valueOf(p_256252_) + ":" + String.valueOf(p_256591_)));
            }
            reference.bindKey(p_256252_);
        } else {
            reference = this.byKey.computeIfAbsent(p_256252_, p_258168_ -> Holder.Reference.createStandAlone(this.holderOwner(), p_258168_));
            reference.bindValue(p_256591_);
        }
        this.byKey.put(p_256252_, reference);
        this.byLocation.put(p_256252_.location(), reference);
        this.byValue.put(p_256591_, reference);
        this.byId.add((Object)reference);
        this.toId.put(p_256591_, i);
        this.registrationInfos.put(p_256252_, p_326235_);
        this.registryLifecycle = this.registryLifecycle.add(p_326235_.lifecycle());
        this.addCallbacks.forEach(addCallback -> addCallback.onAdd((Registry)((Object)this), i, p_256252_, p_256591_));
        return reference;
    }

    @javax.annotation.Nullable
    public ResourceLocation getKey(T p_122746_) {
        Holder.Reference<T> reference = this.byValue.get(p_122746_);
        return reference != null ? reference.key().location() : null;
    }

    public Optional<ResourceKey<T>> getResourceKey(T p_122755_) {
        return Optional.ofNullable(this.byValue.get(p_122755_)).map(Holder.Reference::key);
    }

    public int getId(@javax.annotation.Nullable T p_122706_) {
        return this.toId.getInt(p_122706_);
    }

    @javax.annotation.Nullable
    public T get(@javax.annotation.Nullable ResourceKey<T> p_122714_) {
        return MappedRegistry.getValueFromNullable(this.byKey.get(this.resolve(p_122714_)));
    }

    @javax.annotation.Nullable
    public T byId(int p_122684_) {
        return p_122684_ >= 0 && p_122684_ < this.byId.size() ? (T)((Holder.Reference)this.byId.get(p_122684_)).value() : null;
    }

    public Optional<Holder.Reference<T>> getHolder(int p_205907_) {
        return p_205907_ >= 0 && p_205907_ < this.byId.size() ? Optional.ofNullable((Holder.Reference)this.byId.get(p_205907_)) : Optional.empty();
    }

    public Optional<Holder.Reference<T>> getHolder(ResourceLocation p_316743_) {
        return Optional.ofNullable(this.byLocation.get(p_316743_));
    }

    public Optional<Holder.Reference<T>> getHolder(ResourceKey<T> p_205905_) {
        return Optional.ofNullable(this.byKey.get(this.resolve(p_205905_)));
    }

    public Holder<T> wrapAsHolder(T p_263356_) {
        Holder.Reference<T> reference = this.byValue.get(p_263356_);
        return reference != null ? reference : Holder.direct(p_263356_);
    }

    Holder.Reference<T> getOrCreateHolderOrThrow(ResourceKey<T> p_248831_) {
        return this.byKey.computeIfAbsent(this.resolve(p_248831_), p_258169_ -> {
            if (this.unregisteredIntrusiveHolders != null) {
                throw new IllegalStateException("This registry can't create new holders without value");
            }
            this.validateWrite((ResourceKey<T>)p_258169_);
            return Holder.Reference.createStandAlone(this.holderOwner(), p_258169_);
        });
    }

    public int size() {
        return this.byKey.size();
    }

    public Optional<RegistrationInfo> registrationInfo(ResourceKey<T> p_326067_) {
        return Optional.ofNullable(this.registrationInfos.get(p_326067_));
    }

    public Lifecycle registryLifecycle() {
        return this.registryLifecycle;
    }

    public Iterator<T> iterator() {
        return Iterators.transform((Iterator)this.byId.iterator(), Holder::value);
    }

    @javax.annotation.Nullable
    public T get(@javax.annotation.Nullable ResourceLocation p_122739_) {
        Holder.Reference<T> reference = this.byLocation.get(this.resolve(p_122739_));
        return MappedRegistry.getValueFromNullable(reference);
    }

    @javax.annotation.Nullable
    private static <T> T getValueFromNullable(@javax.annotation.Nullable Holder.Reference<T> p_205866_) {
        return p_205866_ != null ? (T)p_205866_.value() : null;
    }

    public Set<ResourceLocation> keySet() {
        return Collections.unmodifiableSet(this.byLocation.keySet());
    }

    public Set<ResourceKey<T>> registryKeySet() {
        return Collections.unmodifiableSet(this.byKey.keySet());
    }

    public Set<Map.Entry<ResourceKey<T>, T>> entrySet() {
        return Collections.unmodifiableSet(Maps.transformValues(this.byKey, Holder::value).entrySet());
    }

    public Stream<Holder.Reference<T>> holders() {
        return this.byId.stream();
    }

    public Stream<Pair<TagKey<T>, HolderSet.Named<T>>> getTags() {
        return this.tags.entrySet().stream().map(p_211060_ -> Pair.of((Object)((TagKey)p_211060_.getKey()), (Object)((HolderSet.Named)p_211060_.getValue())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HolderSet.Named<T> getOrCreateTag(TagKey<T> p_205895_) {
        HolderSet.Named<T> named = this.tags.get(p_205895_);
        if (named != null) {
            return named;
        }
        Object object = this.tagAdditionLock;
        synchronized (object) {
            named = this.tags.get(p_205895_);
            if (named != null) {
                return named;
            }
            named = this.createTag(p_205895_);
            IdentityHashMap<TagKey<T>, HolderSet.Named<T>> map = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>(this.tags);
            map.put(p_205895_, named);
            this.tags = map;
            return named;
        }
    }

    private HolderSet.Named<T> createTag(TagKey<T> p_211068_) {
        return new HolderSet.Named<T>(this.holderOwner(), p_211068_);
    }

    public Stream<TagKey<T>> getTagNames() {
        return this.tags.keySet().stream();
    }

    public boolean isEmpty() {
        return this.byKey.isEmpty();
    }

    public Optional<Holder.Reference<T>> getRandom(RandomSource p_235716_) {
        return Util.getRandomSafe(this.byId, p_235716_);
    }

    public boolean containsKey(ResourceLocation p_122761_) {
        return this.byLocation.containsKey(p_122761_);
    }

    public boolean containsKey(ResourceKey<T> p_175392_) {
        return this.byKey.containsKey(p_175392_);
    }

    @Deprecated
    public void unfreeze() {
        this.frozen = false;
    }

    public Registry<T> freeze() {
        if (this.frozen) {
            return this;
        }
        this.frozen = true;
        List<ResourceLocation> list = this.byKey.entrySet().stream().filter(p_211055_ -> !((Holder.Reference)p_211055_.getValue()).isBound()).map(p_211794_ -> ((ResourceKey)p_211794_.getKey()).location()).sorted().toList();
        if (!list.isEmpty()) {
            throw new IllegalStateException("Unbound values in registry " + String.valueOf(this.key()) + ": " + String.valueOf(list));
        }
        if (this.unregisteredIntrusiveHolders != null && !this.unregisteredIntrusiveHolders.isEmpty()) {
            throw new IllegalStateException("Some intrusive holders were not registered: " + String.valueOf(this.unregisteredIntrusiveHolders.values()));
        }
        this.bakeCallbacks.forEach(bakeCallback -> bakeCallback.onBake((Registry)((Object)this)));
        return this;
    }

    public Holder.Reference<T> createIntrusiveHolder(T p_205915_) {
        if (this.unregisteredIntrusiveHolders == null) {
            throw new IllegalStateException("This registry can't create intrusive holders");
        }
        this.validateWrite();
        return this.unregisteredIntrusiveHolders.computeIfAbsent(p_205915_, p_258166_ -> Holder.Reference.createIntrusive(this.asLookup(), p_258166_));
    }

    public Optional<HolderSet.Named<T>> getTag(TagKey<T> p_205909_) {
        return Optional.ofNullable(this.tags.get(p_205909_));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindTags(Map<TagKey<T>, List<Holder<T>>> p_205875_) {
        IdentityHashMap<Holder.Reference, List> map = new IdentityHashMap<Holder.Reference, List>();
        this.byKey.values().forEach(p_211801_ -> map.put((Holder.Reference)p_211801_, new ArrayList()));
        p_205875_.forEach((p_339332_, p_339333_) -> {
            for (Holder holder : p_339333_) {
                if (!holder.canSerializeIn(this.asLookup())) {
                    throw new IllegalStateException("Can't create named set " + String.valueOf(p_339332_) + " containing value " + String.valueOf(holder) + " from outside registry " + String.valueOf((Object)this));
                }
                if (!(holder instanceof Holder.Reference)) {
                    throw new IllegalStateException("Found direct holder " + String.valueOf(holder) + " value in tag " + String.valueOf(p_339332_));
                }
                Holder.Reference reference = (Holder.Reference)holder;
                ((List)map.get(reference)).add(p_339332_);
            }
        });
        Sets.SetView set = Sets.difference(this.tags.keySet(), p_205875_.keySet());
        if (!set.isEmpty()) {
            LOGGER.warn("Not all defined tags for registry {} are present in data pack: {}", this.key(), (Object)set.stream().map(p_211811_ -> p_211811_.location().toString()).sorted().collect(Collectors.joining(", ")));
        }
        Object object = this.tagAdditionLock;
        synchronized (object) {
            IdentityHashMap<TagKey<T>, HolderSet.Named<T>> map1 = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>(this.tags);
            p_205875_.forEach((p_211797_, p_211798_) -> map1.computeIfAbsent((TagKey<T>)p_211797_, this::createTag).bind(p_211798_));
            map.forEach(Holder.Reference::bindTags);
            this.tags = map1;
        }
    }

    public void resetTags() {
        this.tags.values().forEach(p_211792_ -> p_211792_.bind(List.of()));
        this.byKey.values().forEach(p_211803_ -> p_211803_.bindTags(Set.of()));
    }

    public HolderGetter<T> createRegistrationLookup() {
        this.validateWrite();
        return new HolderGetter<T>(){

            public Optional<Holder.Reference<T>> get(ResourceKey<T> p_259097_) {
                return Optional.of(this.getOrThrow(p_259097_));
            }

            public Holder.Reference<T> getOrThrow(ResourceKey<T> p_259750_) {
                return MappedRegistry.this.getOrCreateHolderOrThrow(p_259750_);
            }

            public Optional<HolderSet.Named<T>> get(TagKey<T> p_259486_) {
                return Optional.of(this.getOrThrow(p_259486_));
            }

            public HolderSet.Named<T> getOrThrow(TagKey<T> p_260298_) {
                return MappedRegistry.this.getOrCreateTag(p_260298_);
            }
        };
    }

    public HolderOwner<T> holderOwner() {
        return this.lookup;
    }

    public HolderLookup.RegistryLookup<T> asLookup() {
        return this.lookup;
    }

    protected void clear(boolean full) {
        this.validateWrite();
        this.clearCallbacks.forEach(clearCallback -> clearCallback.onClear((Registry)((Object)this), full));
        super.clear(full);
        this.byId.clear();
        this.toId.clear();
        if (full) {
            this.byLocation.clear();
            this.byKey.clear();
            this.byValue.clear();
            this.tags.clear();
            if (this.unregisteredIntrusiveHolders != null) {
                this.unregisteredIntrusiveHolders.clear();
                this.unregisteredIntrusiveHolders = null;
            }
        }
    }

    protected void registerIdMapping(ResourceKey<T> key, int id) {
        this.validateWrite(key);
        if (id > this.getMaxId()) {
            throw new IllegalStateException(String.format(Locale.ENGLISH, "Invalid id %d - maximum id range of %d exceeded.", id, this.getMaxId()));
        }
        if (0 <= id && id < this.byId.size() && this.byId.get(id) != null) {
            throw new IllegalStateException("Duplicate id " + id + " for " + String.valueOf(key) + " and " + String.valueOf(this.getKey(((Holder.Reference)this.byId.get(id)).value())));
        }
        Holder.Reference<T> holder = this.byKey.get(key);
        while (this.byId.size() < id + 1) {
            this.byId.add(null);
        }
        this.byId.set(id, holder);
        this.toId.put(holder.value(), id);
    }

    public int getId(ResourceLocation name) {
        return this.getId(this.get(name));
    }

    public int getId(ResourceKey<T> key) {
        return this.getId(this.get(key));
    }

    public boolean containsValue(T value) {
        return this.byValue.containsKey(value);
    }
}

