/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.loot;

import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.RandomSequence;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.slf4j.Logger;

public class LootTableProvider
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final PackOutput.PathProvider pathProvider;
    private final Set<ResourceKey<LootTable>> requiredTables;
    private final List<SubProviderEntry> subProviders;
    private final CompletableFuture<HolderLookup.Provider> registries;

    public LootTableProvider(PackOutput p_254123_, Set<ResourceKey<LootTable>> p_254481_, List<SubProviderEntry> p_253798_, CompletableFuture<HolderLookup.Provider> p_323798_) {
        this.pathProvider = p_254123_.createPathProvider(PackOutput.Target.DATA_PACK, "loot_tables");
        this.subProviders = p_253798_;
        this.requiredTables = p_254481_;
        this.registries = p_323798_;
    }

    @Override
    public CompletableFuture<?> run(CachedOutput p_254060_) {
        return this.registries.thenCompose(p_323117_ -> this.run(p_254060_, (HolderLookup.Provider)p_323117_));
    }

    private CompletableFuture<?> run(CachedOutput p_324447_, HolderLookup.Provider p_323978_) {
        MappedRegistry<LootTable> writableregistry = new MappedRegistry<LootTable>(Registries.LOOT_TABLE, Lifecycle.experimental());
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        this.getTables().forEach(arg_0 -> LootTableProvider.lambda$run$2(p_323978_, (Map)map, writableregistry, arg_0));
        writableregistry.freeze();
        ProblemReporter.Collector problemreporter$collector = new ProblemReporter.Collector();
        HolderGetter.Provider holdergetter$provider = new RegistryAccess.ImmutableRegistryAccess(List.of(writableregistry)).freeze().asGetterLookup();
        ValidationContext validationcontext = new ValidationContext((ProblemReporter)problemreporter$collector, LootContextParamSets.ALL_PARAMS, holdergetter$provider);
        this.validate(writableregistry, validationcontext, problemreporter$collector);
        Multimap multimap = problemreporter$collector.get();
        if (!multimap.isEmpty()) {
            multimap.forEach((p_124446_, p_124447_) -> LOGGER.warn("Found validation problem in {}: {}", p_124446_, p_124447_));
            throw new IllegalStateException("Failed to validate loot tables, see logs");
        }
        return CompletableFuture.allOf((CompletableFuture[])writableregistry.entrySet().stream().map(p_335193_ -> {
            ResourceKey resourcekey1 = (ResourceKey)p_335193_.getKey();
            LootTable loottable = (LootTable)p_335193_.getValue();
            Path path = this.pathProvider.json(resourcekey1.location());
            return DataProvider.saveStable(p_324447_, p_323978_, LootTable.DIRECT_CODEC, loottable, path);
        }).toArray(CompletableFuture[]::new));
    }

    public List<SubProviderEntry> getTables() {
        return this.subProviders;
    }

    protected void validate(WritableRegistry<LootTable> writableregistry, ValidationContext validationcontext, ProblemReporter.Collector problemreporter$collector) {
        for (ResourceKey resourcekey : Sets.difference(this.requiredTables, (Set)writableregistry.registryKeySet())) {
            problemreporter$collector.report("Missing built-in table: " + String.valueOf(resourcekey.location()));
        }
        writableregistry.holders().forEach(p_335195_ -> ((LootTable)p_335195_.value()).validate(validationcontext.setParams(((LootTable)p_335195_.value()).getParamSet()).enterElement("{" + String.valueOf(p_335195_.key().location()) + "}", p_335195_.key())));
    }

    private static ResourceLocation sequenceIdForLootTable(ResourceKey<LootTable> p_336172_) {
        return p_336172_.location();
    }

    @Override
    public final String getName() {
        return "Loot Tables";
    }

    private static /* synthetic */ void lambda$run$2(HolderLookup.Provider p_323978_, Map map, WritableRegistry writableregistry, SubProviderEntry p_329847_) {
        p_329847_.provider().get().generate(p_323978_, (p_335199_, p_335200_) -> {
            ResourceLocation resourcelocation = LootTableProvider.sequenceIdForLootTable(p_335199_);
            ResourceLocation resourcelocation1 = map.put(RandomSequence.seedForKey((ResourceLocation)resourcelocation), resourcelocation);
            if (resourcelocation1 != null) {
                Util.logAndPauseIfInIde("Loot table random sequence seed collision on " + String.valueOf(resourcelocation1) + " and " + String.valueOf(p_335199_.location()));
            }
            p_335200_.setRandomSequence(resourcelocation);
            LootTable loottable = p_335200_.setParamSet(p_329847_.paramSet).build();
            writableregistry.register(p_335199_, (Object)loottable, RegistrationInfo.BUILT_IN);
        });
    }

    public record SubProviderEntry(Supplier<LootTableSubProvider> provider, LootContextParamSet paramSet) {
    }
}

