/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen.biome;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.Carvers;
import net.minecraft.data.worldgen.placement.AquaticPlacements;
import net.minecraft.data.worldgen.placement.MiscOverworldPlacements;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class OverworldBiomes {
    protected static final int NORMAL_WATER_COLOR = 4159204;
    protected static final int NORMAL_WATER_FOG_COLOR = 329011;
    private static final int OVERWORLD_FOG_COLOR = 12638463;
    @Nullable
    private static final Music NORMAL_MUSIC = null;

    protected static int calculateSkyColor(float p_194844_) {
        float $$1 = p_194844_ / 3.0f;
        $$1 = Mth.clamp((float)$$1, (float)-1.0f, (float)1.0f);
        return Mth.hsvToRgb((float)(0.62222224f - $$1 * 0.05f), (float)(0.5f + $$1 * 0.1f), (float)1.0f);
    }

    private static Biome biome(boolean p_265746_, float p_265800_, float p_265276_, MobSpawnSettings.Builder p_265425_, BiomeGenerationSettings.Builder p_265371_, @Nullable Music p_265636_) {
        return OverworldBiomes.biome(p_265746_, p_265800_, p_265276_, 4159204, 329011, null, null, p_265425_, p_265371_, p_265636_);
    }

    private static Biome biome(boolean p_273483_, float p_272621_, float p_273588_, int p_273605_, int p_272756_, @Nullable Integer p_272889_, @Nullable Integer p_272657_, MobSpawnSettings.Builder p_273300_, BiomeGenerationSettings.Builder p_272700_, @Nullable Music p_272996_) {
        BiomeSpecialEffects.Builder biomespecialeffects$builder = new BiomeSpecialEffects.Builder().waterColor(p_273605_).waterFogColor(p_272756_).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor(p_272621_)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(p_272996_);
        if (p_272889_ != null) {
            biomespecialeffects$builder.grassColorOverride(p_272889_);
        }
        if (p_272657_ != null) {
            biomespecialeffects$builder.foliageColorOverride(p_272657_);
        }
        return new Biome.BiomeBuilder().hasPrecipitation(p_273483_).temperature(p_272621_).downfall(p_273588_).specialEffects(biomespecialeffects$builder.build()).mobSpawnSettings(p_273300_.build()).generationSettings(p_272700_.build()).build();
    }

    private static void globalOverworldGeneration(BiomeGenerationSettings.Builder p_194870_) {
        BiomeDefaultFeatures.addDefaultCarversAndLakes((BiomeGenerationSettings.Builder)p_194870_);
        BiomeDefaultFeatures.addDefaultCrystalFormations((BiomeGenerationSettings.Builder)p_194870_);
        BiomeDefaultFeatures.addDefaultMonsterRoom((BiomeGenerationSettings.Builder)p_194870_);
        BiomeDefaultFeatures.addDefaultUndergroundVariety((BiomeGenerationSettings.Builder)p_194870_);
        BiomeDefaultFeatures.addDefaultSprings((BiomeGenerationSettings.Builder)p_194870_);
        BiomeDefaultFeatures.addSurfaceFreezing((BiomeGenerationSettings.Builder)p_194870_);
    }

    public static Biome oldGrowthTaiga(HolderGetter<PlacedFeature> p_255849_, HolderGetter<ConfiguredWorldCarver<?>> p_256578_, boolean p_194877_) {
        MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)mobspawnsettings$builder);
        mobspawnsettings$builder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.WOLF, 8, 4, 4));
        mobspawnsettings$builder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 4, 2, 3));
        mobspawnsettings$builder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.FOX, 8, 2, 4));
        if (p_194877_) {
            BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)mobspawnsettings$builder);
        } else {
            BiomeDefaultFeatures.caveSpawns((MobSpawnSettings.Builder)mobspawnsettings$builder);
            BiomeDefaultFeatures.monsters((MobSpawnSettings.Builder)mobspawnsettings$builder, (int)100, (int)25, (int)100, (boolean)false);
        }
        BiomeGenerationSettings.Builder biomegenerationsettings$builder = new BiomeGenerationSettings.Builder(p_255849_, p_256578_);
        OverworldBiomes.globalOverworldGeneration(biomegenerationsettings$builder);
        BiomeDefaultFeatures.addMossyStoneBlock((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addFerns((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        biomegenerationsettings$builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, p_194877_ ? VegetationPlacements.TREES_OLD_GROWTH_SPRUCE_TAIGA : VegetationPlacements.TREES_OLD_GROWTH_PINE_TAIGA);
        BiomeDefaultFeatures.addDefaultFlowers((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addGiantTaigaVegetation((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addCommonBerryBushes((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        Music music = Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_OLD_GROWTH_TAIGA);
        return OverworldBiomes.biome(true, p_194877_ ? 0.25f : 0.3f, 0.8f, mobspawnsettings$builder, biomegenerationsettings$builder, music);
    }

    public static Biome sparseJungle(HolderGetter<PlacedFeature> p_255977_, HolderGetter<ConfiguredWorldCarver<?>> p_256531_) {
        MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.baseJungleSpawns((MobSpawnSettings.Builder)mobspawnsettings$builder);
        mobspawnsettings$builder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.WOLF, 8, 2, 4));
        return OverworldBiomes.baseJungle(p_255977_, p_256531_, 0.8f, false, true, false, mobspawnsettings$builder, Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_SPARSE_JUNGLE));
    }

    public static Biome jungle(HolderGetter<PlacedFeature> p_256033_, HolderGetter<ConfiguredWorldCarver<?>> p_255651_) {
        MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.baseJungleSpawns((MobSpawnSettings.Builder)mobspawnsettings$builder);
        mobspawnsettings$builder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.PARROT, 40, 1, 2)).addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.OCELOT, 2, 1, 3)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.PANDA, 1, 1, 2));
        return OverworldBiomes.baseJungle(p_256033_, p_255651_, 0.9f, false, false, true, mobspawnsettings$builder, Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_JUNGLE));
    }

    public static Biome bambooJungle(HolderGetter<PlacedFeature> p_255817_, HolderGetter<ConfiguredWorldCarver<?>> p_256096_) {
        MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.baseJungleSpawns((MobSpawnSettings.Builder)mobspawnsettings$builder);
        mobspawnsettings$builder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.PARROT, 40, 1, 2)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.PANDA, 80, 1, 2)).addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.OCELOT, 2, 1, 1));
        return OverworldBiomes.baseJungle(p_255817_, p_256096_, 0.9f, true, false, true, mobspawnsettings$builder, Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_BAMBOO_JUNGLE));
    }

    private static Biome baseJungle(HolderGetter<PlacedFeature> p_285208_, HolderGetter<ConfiguredWorldCarver<?>> p_285276_, float p_285079_, boolean p_285393_, boolean p_285109_, boolean p_285122_, MobSpawnSettings.Builder p_285449_, Music p_285440_) {
        BiomeGenerationSettings.Builder biomegenerationsettings$builder = new BiomeGenerationSettings.Builder(p_285208_, p_285276_);
        OverworldBiomes.globalOverworldGeneration(biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        if (p_285393_) {
            BiomeDefaultFeatures.addBambooVegetation((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        } else {
            if (p_285122_) {
                BiomeDefaultFeatures.addLightBambooVegetation((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
            }
            if (p_285109_) {
                BiomeDefaultFeatures.addSparseJungleTrees((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
            } else {
                BiomeDefaultFeatures.addJungleTrees((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
            }
        }
        BiomeDefaultFeatures.addWarmFlowers((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addJungleGrass((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addJungleVines((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        if (p_285109_) {
            BiomeDefaultFeatures.addSparseJungleMelons((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        } else {
            BiomeDefaultFeatures.addJungleMelons((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        }
        return OverworldBiomes.biome(true, 0.95f, p_285079_, p_285449_, biomegenerationsettings$builder, p_285440_);
    }

    public static Biome windsweptHills(HolderGetter<PlacedFeature> p_255703_, HolderGetter<ConfiguredWorldCarver<?>> p_256239_, boolean p_194887_) {
        MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)mobspawnsettings$builder);
        mobspawnsettings$builder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.LLAMA, 5, 4, 6));
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)mobspawnsettings$builder);
        BiomeGenerationSettings.Builder biomegenerationsettings$builder = new BiomeGenerationSettings.Builder(p_255703_, p_256239_);
        OverworldBiomes.globalOverworldGeneration(biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        if (p_194887_) {
            BiomeDefaultFeatures.addMountainForestTrees((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        } else {
            BiomeDefaultFeatures.addMountainTrees((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        }
        BiomeDefaultFeatures.addDefaultFlowers((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultGrass((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addExtraEmeralds((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addInfestedStone((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        return OverworldBiomes.biome(true, 0.2f, 0.3f, mobspawnsettings$builder, biomegenerationsettings$builder, NORMAL_MUSIC);
    }

    public static Biome desert(HolderGetter<PlacedFeature> p_256064_, HolderGetter<ConfiguredWorldCarver<?>> p_255852_) {
        MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.desertSpawns((MobSpawnSettings.Builder)mobspawnsettings$builder);
        BiomeGenerationSettings.Builder biomegenerationsettings$builder = new BiomeGenerationSettings.Builder(p_256064_, p_255852_);
        BiomeDefaultFeatures.addFossilDecoration((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        OverworldBiomes.globalOverworldGeneration(biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultFlowers((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultGrass((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDesertVegetation((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDesertExtraVegetation((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDesertExtraDecoration((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        return OverworldBiomes.biome(false, 2.0f, 0.0f, mobspawnsettings$builder, biomegenerationsettings$builder, Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_DESERT));
    }

    public static Biome plains(HolderGetter<PlacedFeature> p_256382_, HolderGetter<ConfiguredWorldCarver<?>> p_256173_, boolean p_194882_, boolean p_194883_, boolean p_194884_) {
        MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder biomegenerationsettings$builder = new BiomeGenerationSettings.Builder(p_256382_, p_256173_);
        OverworldBiomes.globalOverworldGeneration(biomegenerationsettings$builder);
        if (p_194883_) {
            mobspawnsettings$builder.creatureGenerationProbability(0.07f);
            BiomeDefaultFeatures.snowySpawns((MobSpawnSettings.Builder)mobspawnsettings$builder);
            if (p_194884_) {
                biomegenerationsettings$builder.addFeature(GenerationStep.Decoration.SURFACE_STRUCTURES, MiscOverworldPlacements.ICE_SPIKE);
                biomegenerationsettings$builder.addFeature(GenerationStep.Decoration.SURFACE_STRUCTURES, MiscOverworldPlacements.ICE_PATCH);
            }
        } else {
            BiomeDefaultFeatures.plainsSpawns((MobSpawnSettings.Builder)mobspawnsettings$builder);
            BiomeDefaultFeatures.addPlainGrass((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
            if (p_194882_) {
                biomegenerationsettings$builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.PATCH_SUNFLOWER);
            }
        }
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        if (p_194883_) {
            BiomeDefaultFeatures.addSnowyTrees((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
            BiomeDefaultFeatures.addDefaultFlowers((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
            BiomeDefaultFeatures.addDefaultGrass((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        } else {
            BiomeDefaultFeatures.addPlainVegetation((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        }
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        if (p_194882_) {
            biomegenerationsettings$builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.PATCH_SUGAR_CANE);
            biomegenerationsettings$builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.PATCH_PUMPKIN);
        } else {
            BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        }
        float f = p_194883_ ? 0.0f : 0.8f;
        return OverworldBiomes.biome(true, f, p_194883_ ? 0.5f : 0.4f, mobspawnsettings$builder, biomegenerationsettings$builder, NORMAL_MUSIC);
    }

    public static Biome mushroomFields(HolderGetter<PlacedFeature> p_255775_, HolderGetter<ConfiguredWorldCarver<?>> p_256480_) {
        MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.mooshroomSpawns((MobSpawnSettings.Builder)mobspawnsettings$builder);
        BiomeGenerationSettings.Builder biomegenerationsettings$builder = new BiomeGenerationSettings.Builder(p_255775_, p_256480_);
        OverworldBiomes.globalOverworldGeneration(biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addMushroomFieldVegetation((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        return OverworldBiomes.biome(true, 0.9f, 1.0f, mobspawnsettings$builder, biomegenerationsettings$builder, NORMAL_MUSIC);
    }

    public static Biome savanna(HolderGetter<PlacedFeature> p_256294_, HolderGetter<ConfiguredWorldCarver<?>> p_256583_, boolean p_194879_, boolean p_194880_) {
        BiomeGenerationSettings.Builder biomegenerationsettings$builder = new BiomeGenerationSettings.Builder(p_256294_, p_256583_);
        OverworldBiomes.globalOverworldGeneration(biomegenerationsettings$builder);
        if (!p_194879_) {
            BiomeDefaultFeatures.addSavannaGrass((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        }
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        if (p_194879_) {
            BiomeDefaultFeatures.addShatteredSavannaTrees((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
            BiomeDefaultFeatures.addDefaultFlowers((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
            BiomeDefaultFeatures.addShatteredSavannaGrass((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        } else {
            BiomeDefaultFeatures.addSavannaTrees((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
            BiomeDefaultFeatures.addWarmFlowers((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
            BiomeDefaultFeatures.addSavannaExtraGrass((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        }
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)mobspawnsettings$builder);
        mobspawnsettings$builder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.HORSE, 1, 2, 6)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.DONKEY, 1, 1, 1)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.ARMADILLO, 10, 2, 3));
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)mobspawnsettings$builder);
        if (p_194880_) {
            mobspawnsettings$builder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.LLAMA, 8, 4, 4));
            mobspawnsettings$builder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.WOLF, 8, 4, 8));
        }
        return OverworldBiomes.biome(false, 2.0f, 0.0f, mobspawnsettings$builder, biomegenerationsettings$builder, NORMAL_MUSIC);
    }

    public static Biome badlands(HolderGetter<PlacedFeature> p_256309_, HolderGetter<ConfiguredWorldCarver<?>> p_256430_, boolean p_194897_) {
        MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)mobspawnsettings$builder);
        mobspawnsettings$builder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.ARMADILLO, 6, 1, 2));
        mobspawnsettings$builder.creatureGenerationProbability(0.03f);
        if (p_194897_) {
            mobspawnsettings$builder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.WOLF, 2, 4, 8));
            mobspawnsettings$builder.creatureGenerationProbability(0.04f);
        }
        BiomeGenerationSettings.Builder biomegenerationsettings$builder = new BiomeGenerationSettings.Builder(p_256309_, p_256430_);
        OverworldBiomes.globalOverworldGeneration(biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addExtraGold((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        if (p_194897_) {
            BiomeDefaultFeatures.addBadlandsTrees((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        }
        BiomeDefaultFeatures.addBadlandGrass((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addBadlandExtraVegetation((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(2.0f).downfall(0.0f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor(2.0f)).foliageColorOverride(10387789).grassColorOverride(9470285).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_BADLANDS)).build()).mobSpawnSettings(mobspawnsettings$builder.build()).generationSettings(biomegenerationsettings$builder.build()).build();
    }

    private static Biome baseOcean(MobSpawnSettings.Builder p_194872_, int p_194873_, int p_194874_, BiomeGenerationSettings.Builder p_194875_) {
        return OverworldBiomes.biome(true, 0.5f, 0.5f, p_194873_, p_194874_, null, null, p_194872_, p_194875_, NORMAL_MUSIC);
    }

    private static BiomeGenerationSettings.Builder baseOceanGeneration(HolderGetter<PlacedFeature> p_256289_, HolderGetter<ConfiguredWorldCarver<?>> p_256514_) {
        BiomeGenerationSettings.Builder biomegenerationsettings$builder = new BiomeGenerationSettings.Builder(p_256289_, p_256514_);
        OverworldBiomes.globalOverworldGeneration(biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addWaterTrees((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultFlowers((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultGrass((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        return biomegenerationsettings$builder;
    }

    public static Biome coldOcean(HolderGetter<PlacedFeature> p_256141_, HolderGetter<ConfiguredWorldCarver<?>> p_255841_, boolean p_194900_) {
        MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.oceanSpawns((MobSpawnSettings.Builder)mobspawnsettings$builder, (int)3, (int)4, (int)15);
        mobspawnsettings$builder.addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.SALMON, 15, 1, 5));
        BiomeGenerationSettings.Builder biomegenerationsettings$builder = OverworldBiomes.baseOceanGeneration(p_256141_, p_255841_);
        biomegenerationsettings$builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, p_194900_ ? AquaticPlacements.SEAGRASS_DEEP_COLD : AquaticPlacements.SEAGRASS_COLD);
        BiomeDefaultFeatures.addDefaultSeagrass((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addColdOceanExtraVegetation((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        return OverworldBiomes.baseOcean(mobspawnsettings$builder, 4020182, 329011, biomegenerationsettings$builder);
    }

    public static Biome ocean(HolderGetter<PlacedFeature> p_256265_, HolderGetter<ConfiguredWorldCarver<?>> p_256537_, boolean p_255752_) {
        MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.oceanSpawns((MobSpawnSettings.Builder)mobspawnsettings$builder, (int)1, (int)4, (int)10);
        mobspawnsettings$builder.addSpawn(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData(EntityType.DOLPHIN, 1, 1, 2));
        BiomeGenerationSettings.Builder biomegenerationsettings$builder = OverworldBiomes.baseOceanGeneration(p_256265_, p_256537_);
        biomegenerationsettings$builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, p_255752_ ? AquaticPlacements.SEAGRASS_DEEP : AquaticPlacements.SEAGRASS_NORMAL);
        BiomeDefaultFeatures.addDefaultSeagrass((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addColdOceanExtraVegetation((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        return OverworldBiomes.baseOcean(mobspawnsettings$builder, 4159204, 329011, biomegenerationsettings$builder);
    }

    public static Biome lukeWarmOcean(HolderGetter<PlacedFeature> p_255660_, HolderGetter<ConfiguredWorldCarver<?>> p_256231_, boolean p_194906_) {
        MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder();
        if (p_194906_) {
            BiomeDefaultFeatures.oceanSpawns((MobSpawnSettings.Builder)mobspawnsettings$builder, (int)8, (int)4, (int)8);
        } else {
            BiomeDefaultFeatures.oceanSpawns((MobSpawnSettings.Builder)mobspawnsettings$builder, (int)10, (int)2, (int)15);
        }
        mobspawnsettings$builder.addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.PUFFERFISH, 5, 1, 3)).addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.TROPICAL_FISH, 25, 8, 8)).addSpawn(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData(EntityType.DOLPHIN, 2, 1, 2));
        BiomeGenerationSettings.Builder biomegenerationsettings$builder = OverworldBiomes.baseOceanGeneration(p_255660_, p_256231_);
        biomegenerationsettings$builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, p_194906_ ? AquaticPlacements.SEAGRASS_DEEP_WARM : AquaticPlacements.SEAGRASS_WARM);
        if (p_194906_) {
            BiomeDefaultFeatures.addDefaultSeagrass((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        }
        BiomeDefaultFeatures.addLukeWarmKelp((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        return OverworldBiomes.baseOcean(mobspawnsettings$builder, 4566514, 267827, biomegenerationsettings$builder);
    }

    public static Biome warmOcean(HolderGetter<PlacedFeature> p_256477_, HolderGetter<ConfiguredWorldCarver<?>> p_256024_) {
        MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder().addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.PUFFERFISH, 15, 1, 3));
        BiomeDefaultFeatures.warmOceanSpawns((MobSpawnSettings.Builder)mobspawnsettings$builder, (int)10, (int)4);
        BiomeGenerationSettings.Builder biomegenerationsettings$builder = OverworldBiomes.baseOceanGeneration(p_256477_, p_256024_).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.WARM_OCEAN_VEGETATION).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEAGRASS_WARM).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEA_PICKLE);
        return OverworldBiomes.baseOcean(mobspawnsettings$builder, 4445678, 270131, biomegenerationsettings$builder);
    }

    public static Biome frozenOcean(HolderGetter<PlacedFeature> p_256482_, HolderGetter<ConfiguredWorldCarver<?>> p_256660_, boolean p_194909_) {
        MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder().addSpawn(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData(EntityType.SQUID, 1, 1, 4)).addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.SALMON, 15, 1, 5)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.POLAR_BEAR, 1, 1, 2));
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)mobspawnsettings$builder);
        mobspawnsettings$builder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.DROWNED, 5, 1, 1));
        float f = p_194909_ ? 0.5f : 0.0f;
        BiomeGenerationSettings.Builder biomegenerationsettings$builder = new BiomeGenerationSettings.Builder(p_256482_, p_256660_);
        BiomeDefaultFeatures.addIcebergs((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        OverworldBiomes.globalOverworldGeneration(biomegenerationsettings$builder);
        BiomeDefaultFeatures.addBlueIce((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addWaterTrees((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultFlowers((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultGrass((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(f).temperatureAdjustment(Biome.TemperatureModifier.FROZEN).downfall(0.5f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(3750089).waterFogColor(329011).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor(f)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(mobspawnsettings$builder.build()).generationSettings(biomegenerationsettings$builder.build()).build();
    }

    public static Biome forest(HolderGetter<PlacedFeature> p_255788_, HolderGetter<ConfiguredWorldCarver<?>> p_256461_, boolean p_194892_, boolean p_194893_, boolean p_194894_) {
        Music music;
        BiomeGenerationSettings.Builder biomegenerationsettings$builder = new BiomeGenerationSettings.Builder(p_255788_, p_256461_);
        OverworldBiomes.globalOverworldGeneration(biomegenerationsettings$builder);
        if (p_194894_) {
            music = Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_FLOWER_FOREST);
            biomegenerationsettings$builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.FLOWER_FOREST_FLOWERS);
        } else {
            music = Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_FOREST);
            BiomeDefaultFeatures.addForestFlowers((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        }
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        if (p_194894_) {
            biomegenerationsettings$builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.TREES_FLOWER_FOREST);
            biomegenerationsettings$builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.FLOWER_FLOWER_FOREST);
            BiomeDefaultFeatures.addDefaultGrass((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        } else {
            if (p_194892_) {
                if (p_194893_) {
                    BiomeDefaultFeatures.addTallBirchTrees((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
                } else {
                    BiomeDefaultFeatures.addBirchTrees((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
                }
            } else {
                BiomeDefaultFeatures.addOtherBirchTrees((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
            }
            BiomeDefaultFeatures.addDefaultFlowers((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
            BiomeDefaultFeatures.addForestGrass((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        }
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)mobspawnsettings$builder);
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)mobspawnsettings$builder);
        if (p_194894_) {
            mobspawnsettings$builder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 4, 2, 3));
        } else if (!p_194892_) {
            mobspawnsettings$builder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.WOLF, 5, 4, 4));
        }
        float f = p_194892_ ? 0.6f : 0.7f;
        return OverworldBiomes.biome(true, f, p_194892_ ? 0.6f : 0.8f, mobspawnsettings$builder, biomegenerationsettings$builder, music);
    }

    public static Biome taiga(HolderGetter<PlacedFeature> p_256177_, HolderGetter<ConfiguredWorldCarver<?>> p_255727_, boolean p_194912_) {
        MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)mobspawnsettings$builder);
        mobspawnsettings$builder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.WOLF, 8, 4, 4)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 4, 2, 3)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.FOX, 8, 2, 4));
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)mobspawnsettings$builder);
        float f = p_194912_ ? -0.5f : 0.25f;
        BiomeGenerationSettings.Builder biomegenerationsettings$builder = new BiomeGenerationSettings.Builder(p_256177_, p_255727_);
        OverworldBiomes.globalOverworldGeneration(biomegenerationsettings$builder);
        BiomeDefaultFeatures.addFerns((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addTaigaTrees((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultFlowers((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addTaigaGrass((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        if (p_194912_) {
            BiomeDefaultFeatures.addRareBerryBushes((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        } else {
            BiomeDefaultFeatures.addCommonBerryBushes((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        }
        return OverworldBiomes.biome(true, f, p_194912_ ? 0.4f : 0.8f, p_194912_ ? 4020182 : 4159204, 329011, null, null, mobspawnsettings$builder, biomegenerationsettings$builder, NORMAL_MUSIC);
    }

    public static Biome darkForest(HolderGetter<PlacedFeature> p_256140_, HolderGetter<ConfiguredWorldCarver<?>> p_256223_) {
        MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)mobspawnsettings$builder);
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)mobspawnsettings$builder);
        BiomeGenerationSettings.Builder biomegenerationsettings$builder = new BiomeGenerationSettings.Builder(p_256140_, p_256223_);
        OverworldBiomes.globalOverworldGeneration(biomegenerationsettings$builder);
        biomegenerationsettings$builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.DARK_FOREST_VEGETATION);
        BiomeDefaultFeatures.addForestFlowers((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultFlowers((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addForestGrass((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        Music music = Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_FOREST);
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.7f).downfall(0.8f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor(0.7f)).grassColorModifier(BiomeSpecialEffects.GrassColorModifier.DARK_FOREST).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(music).build()).mobSpawnSettings(mobspawnsettings$builder.build()).generationSettings(biomegenerationsettings$builder.build()).build();
    }

    public static Biome swamp(HolderGetter<PlacedFeature> p_256058_, HolderGetter<ConfiguredWorldCarver<?>> p_256016_, Consumer<MobSpawnSettings.Builder> p_341985_) {
        MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)mobspawnsettings$builder);
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)mobspawnsettings$builder);
        mobspawnsettings$builder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.SLIME, 1, 1, 1));
        mobspawnsettings$builder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.FROG, 10, 2, 5));
        p_341985_.accept(mobspawnsettings$builder);
        BiomeGenerationSettings.Builder biomegenerationsettings$builder = new BiomeGenerationSettings.Builder(p_256058_, p_256016_);
        BiomeDefaultFeatures.addFossilDecoration((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        OverworldBiomes.globalOverworldGeneration(biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addSwampClayDisk((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addSwampVegetation((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addSwampExtraVegetation((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        biomegenerationsettings$builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEAGRASS_SWAMP);
        Music music = Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_SWAMP);
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.8f).downfall(0.9f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(6388580).waterFogColor(2302743).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor(0.8f)).foliageColorOverride(6975545).grassColorModifier(BiomeSpecialEffects.GrassColorModifier.SWAMP).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(music).build()).mobSpawnSettings(mobspawnsettings$builder.build()).generationSettings(biomegenerationsettings$builder.build()).build();
    }

    public static Biome mangroveSwamp(HolderGetter<PlacedFeature> p_256353_, HolderGetter<ConfiguredWorldCarver<?>> p_256103_, Consumer<MobSpawnSettings.Builder> p_341983_) {
        MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)mobspawnsettings$builder);
        mobspawnsettings$builder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.SLIME, 1, 1, 1));
        mobspawnsettings$builder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.FROG, 10, 2, 5));
        mobspawnsettings$builder.addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.TROPICAL_FISH, 25, 8, 8));
        p_341983_.accept(mobspawnsettings$builder);
        BiomeGenerationSettings.Builder biomegenerationsettings$builder = new BiomeGenerationSettings.Builder(p_256353_, p_256103_);
        BiomeDefaultFeatures.addFossilDecoration((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        OverworldBiomes.globalOverworldGeneration(biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addMangroveSwampDisks((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addMangroveSwampVegetation((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        biomegenerationsettings$builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEAGRASS_SWAMP);
        Music music = Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_SWAMP);
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.8f).downfall(0.9f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(3832426).waterFogColor(5077600).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor(0.8f)).foliageColorOverride(9285927).grassColorModifier(BiomeSpecialEffects.GrassColorModifier.SWAMP).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(music).build()).mobSpawnSettings(mobspawnsettings$builder.build()).generationSettings(biomegenerationsettings$builder.build()).build();
    }

    public static Biome river(HolderGetter<PlacedFeature> p_256613_, HolderGetter<ConfiguredWorldCarver<?>> p_256581_, boolean p_194915_) {
        MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder().addSpawn(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData(EntityType.SQUID, 2, 1, 4)).addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.SALMON, 5, 1, 5));
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)mobspawnsettings$builder);
        mobspawnsettings$builder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.DROWNED, p_194915_ ? 1 : 100, 1, 1));
        BiomeGenerationSettings.Builder biomegenerationsettings$builder = new BiomeGenerationSettings.Builder(p_256613_, p_256581_);
        OverworldBiomes.globalOverworldGeneration(biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addWaterTrees((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultFlowers((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultGrass((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        if (!p_194915_) {
            biomegenerationsettings$builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEAGRASS_RIVER);
        }
        float f = p_194915_ ? 0.0f : 0.5f;
        return OverworldBiomes.biome(true, f, 0.5f, p_194915_ ? 3750089 : 4159204, 329011, null, null, mobspawnsettings$builder, biomegenerationsettings$builder, NORMAL_MUSIC);
    }

    public static Biome beach(HolderGetter<PlacedFeature> p_256157_, HolderGetter<ConfiguredWorldCarver<?>> p_255712_, boolean p_194889_, boolean p_194890_) {
        boolean flag;
        MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder();
        boolean bl = flag = !p_194890_ && !p_194889_;
        if (flag) {
            mobspawnsettings$builder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.TURTLE, 5, 2, 5));
        }
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)mobspawnsettings$builder);
        BiomeGenerationSettings.Builder biomegenerationsettings$builder = new BiomeGenerationSettings.Builder(p_256157_, p_255712_);
        OverworldBiomes.globalOverworldGeneration(biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultFlowers((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultGrass((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        float f = p_194889_ ? 0.05f : (p_194890_ ? 0.2f : 0.8f);
        return OverworldBiomes.biome(true, f, flag ? 0.4f : 0.3f, p_194889_ ? 4020182 : 4159204, 329011, null, null, mobspawnsettings$builder, biomegenerationsettings$builder, NORMAL_MUSIC);
    }

    public static Biome theVoid(HolderGetter<PlacedFeature> p_256509_, HolderGetter<ConfiguredWorldCarver<?>> p_256544_) {
        BiomeGenerationSettings.Builder biomegenerationsettings$builder = new BiomeGenerationSettings.Builder(p_256509_, p_256544_);
        biomegenerationsettings$builder.addFeature(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, MiscOverworldPlacements.VOID_START_PLATFORM);
        return OverworldBiomes.biome(false, 0.5f, 0.5f, new MobSpawnSettings.Builder(), biomegenerationsettings$builder, NORMAL_MUSIC);
    }

    public static Biome meadowOrCherryGrove(HolderGetter<PlacedFeature> p_273564_, HolderGetter<ConfiguredWorldCarver<?>> p_273374_, boolean p_273710_) {
        BiomeGenerationSettings.Builder biomegenerationsettings$builder = new BiomeGenerationSettings.Builder(p_273564_, p_273374_);
        MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder();
        mobspawnsettings$builder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(p_273710_ ? EntityType.PIG : EntityType.DONKEY, 1, 1, 2)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 2, 2, 6)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.SHEEP, 2, 2, 4));
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)mobspawnsettings$builder);
        OverworldBiomes.globalOverworldGeneration(biomegenerationsettings$builder);
        BiomeDefaultFeatures.addPlainGrass((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        if (p_273710_) {
            BiomeDefaultFeatures.addCherryGroveVegetation((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        } else {
            BiomeDefaultFeatures.addMeadowVegetation((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        }
        BiomeDefaultFeatures.addExtraEmeralds((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addInfestedStone((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        Music music = Musics.createGameMusic((Holder)(p_273710_ ? SoundEvents.MUSIC_BIOME_CHERRY_GROVE : SoundEvents.MUSIC_BIOME_MEADOW));
        return p_273710_ ? OverworldBiomes.biome(true, 0.5f, 0.8f, 6141935, 6141935, 11983713, 11983713, mobspawnsettings$builder, biomegenerationsettings$builder, music) : OverworldBiomes.biome(true, 0.5f, 0.8f, 937679, 329011, null, null, mobspawnsettings$builder, biomegenerationsettings$builder, music);
    }

    public static Biome frozenPeaks(HolderGetter<PlacedFeature> p_255713_, HolderGetter<ConfiguredWorldCarver<?>> p_256092_) {
        BiomeGenerationSettings.Builder biomegenerationsettings$builder = new BiomeGenerationSettings.Builder(p_255713_, p_256092_);
        MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder();
        mobspawnsettings$builder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.GOAT, 5, 1, 3));
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)mobspawnsettings$builder);
        OverworldBiomes.globalOverworldGeneration(biomegenerationsettings$builder);
        BiomeDefaultFeatures.addFrozenSprings((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addExtraEmeralds((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addInfestedStone((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        Music music = Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_FROZEN_PEAKS);
        return OverworldBiomes.biome(true, -0.7f, 0.9f, mobspawnsettings$builder, biomegenerationsettings$builder, music);
    }

    public static Biome jaggedPeaks(HolderGetter<PlacedFeature> p_256512_, HolderGetter<ConfiguredWorldCarver<?>> p_255908_) {
        BiomeGenerationSettings.Builder biomegenerationsettings$builder = new BiomeGenerationSettings.Builder(p_256512_, p_255908_);
        MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder();
        mobspawnsettings$builder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.GOAT, 5, 1, 3));
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)mobspawnsettings$builder);
        OverworldBiomes.globalOverworldGeneration(biomegenerationsettings$builder);
        BiomeDefaultFeatures.addFrozenSprings((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addExtraEmeralds((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addInfestedStone((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        Music music = Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_JAGGED_PEAKS);
        return OverworldBiomes.biome(true, -0.7f, 0.9f, mobspawnsettings$builder, biomegenerationsettings$builder, music);
    }

    public static Biome stonyPeaks(HolderGetter<PlacedFeature> p_256490_, HolderGetter<ConfiguredWorldCarver<?>> p_255694_) {
        BiomeGenerationSettings.Builder biomegenerationsettings$builder = new BiomeGenerationSettings.Builder(p_256490_, p_255694_);
        MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)mobspawnsettings$builder);
        OverworldBiomes.globalOverworldGeneration(biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addExtraEmeralds((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addInfestedStone((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        Music music = Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_STONY_PEAKS);
        return OverworldBiomes.biome(true, 1.0f, 0.3f, mobspawnsettings$builder, biomegenerationsettings$builder, music);
    }

    public static Biome snowySlopes(HolderGetter<PlacedFeature> p_255927_, HolderGetter<ConfiguredWorldCarver<?>> p_255982_) {
        BiomeGenerationSettings.Builder biomegenerationsettings$builder = new BiomeGenerationSettings.Builder(p_255927_, p_255982_);
        MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder();
        mobspawnsettings$builder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 4, 2, 3)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.GOAT, 5, 1, 3));
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)mobspawnsettings$builder);
        OverworldBiomes.globalOverworldGeneration(biomegenerationsettings$builder);
        BiomeDefaultFeatures.addFrozenSprings((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addExtraEmeralds((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addInfestedStone((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        Music music = Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_SNOWY_SLOPES);
        return OverworldBiomes.biome(true, -0.3f, 0.9f, mobspawnsettings$builder, biomegenerationsettings$builder, music);
    }

    public static Biome grove(HolderGetter<PlacedFeature> p_256094_, HolderGetter<ConfiguredWorldCarver<?>> p_256431_) {
        BiomeGenerationSettings.Builder biomegenerationsettings$builder = new BiomeGenerationSettings.Builder(p_256094_, p_256431_);
        MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder();
        mobspawnsettings$builder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.WOLF, 1, 1, 1)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 8, 2, 3)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.FOX, 4, 2, 4));
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)mobspawnsettings$builder);
        OverworldBiomes.globalOverworldGeneration(biomegenerationsettings$builder);
        BiomeDefaultFeatures.addFrozenSprings((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addGroveTrees((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addExtraEmeralds((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addInfestedStone((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        Music music = Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_GROVE);
        return OverworldBiomes.biome(true, -0.2f, 0.8f, mobspawnsettings$builder, biomegenerationsettings$builder, music);
    }

    public static Biome lushCaves(HolderGetter<PlacedFeature> p_255944_, HolderGetter<ConfiguredWorldCarver<?>> p_255654_) {
        MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder();
        mobspawnsettings$builder.addSpawn(MobCategory.AXOLOTLS, new MobSpawnSettings.SpawnerData(EntityType.AXOLOTL, 10, 4, 6));
        mobspawnsettings$builder.addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.TROPICAL_FISH, 25, 8, 8));
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)mobspawnsettings$builder);
        BiomeGenerationSettings.Builder biomegenerationsettings$builder = new BiomeGenerationSettings.Builder(p_255944_, p_255654_);
        OverworldBiomes.globalOverworldGeneration(biomegenerationsettings$builder);
        BiomeDefaultFeatures.addPlainGrass((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addLushCavesSpecialOres((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addLushCavesVegetationFeatures((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        Music music = Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_LUSH_CAVES);
        return OverworldBiomes.biome(true, 0.5f, 0.5f, mobspawnsettings$builder, biomegenerationsettings$builder, music);
    }

    public static Biome dripstoneCaves(HolderGetter<PlacedFeature> p_256253_, HolderGetter<ConfiguredWorldCarver<?>> p_255644_) {
        MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.dripstoneCavesSpawns((MobSpawnSettings.Builder)mobspawnsettings$builder);
        BiomeGenerationSettings.Builder biomegenerationsettings$builder = new BiomeGenerationSettings.Builder(p_256253_, p_255644_);
        OverworldBiomes.globalOverworldGeneration(biomegenerationsettings$builder);
        BiomeDefaultFeatures.addPlainGrass((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomegenerationsettings$builder, (boolean)true);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addPlainVegetation((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDripstone((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        Music music = Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_DRIPSTONE_CAVES);
        return OverworldBiomes.biome(true, 0.8f, 0.4f, mobspawnsettings$builder, biomegenerationsettings$builder, music);
    }

    public static Biome deepDark(HolderGetter<PlacedFeature> p_256073_, HolderGetter<ConfiguredWorldCarver<?>> p_256212_) {
        MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder biomegenerationsettings$builder = new BiomeGenerationSettings.Builder(p_256073_, p_256212_);
        biomegenerationsettings$builder.addCarver(GenerationStep.Carving.AIR, Carvers.CAVE);
        biomegenerationsettings$builder.addCarver(GenerationStep.Carving.AIR, Carvers.CAVE_EXTRA_UNDERGROUND);
        biomegenerationsettings$builder.addCarver(GenerationStep.Carving.AIR, Carvers.CANYON);
        BiomeDefaultFeatures.addDefaultCrystalFormations((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultMonsterRoom((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultUndergroundVariety((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addSurfaceFreezing((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addPlainGrass((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addPlainVegetation((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addSculk((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        Music music = Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_DEEP_DARK);
        return OverworldBiomes.biome(true, 0.8f, 0.4f, mobspawnsettings$builder, biomegenerationsettings$builder, music);
    }
}

