/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.codec;

import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.Utf8String;
import net.minecraft.network.VarInt;
import net.minecraft.network.VarLong;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.neoforged.neoforge.registries.RegistryManager;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public interface ByteBufCodecs {
    public static final int MAX_INITIAL_COLLECTION_SIZE = 65536;
    public static final StreamCodec<ByteBuf, Boolean> BOOL = new StreamCodec<ByteBuf, Boolean>(){

        public Boolean decode(ByteBuf p_320813_) {
            return p_320813_.readBoolean();
        }

        public void encode(ByteBuf p_319896_, Boolean p_320251_) {
            p_319896_.writeBoolean(p_320251_.booleanValue());
        }
    };
    public static final StreamCodec<ByteBuf, Byte> BYTE = new StreamCodec<ByteBuf, Byte>(){

        public Byte decode(ByteBuf p_320628_) {
            return p_320628_.readByte();
        }

        public void encode(ByteBuf p_320364_, Byte p_320618_) {
            p_320364_.writeByte((int)p_320618_.byteValue());
        }
    };
    public static final StreamCodec<ByteBuf, Short> SHORT = new StreamCodec<ByteBuf, Short>(){

        public Short decode(ByteBuf p_320513_) {
            return p_320513_.readShort();
        }

        public void encode(ByteBuf p_320028_, Short p_320388_) {
            p_320028_.writeShort((int)p_320388_.shortValue());
        }
    };
    public static final StreamCodec<ByteBuf, Integer> UNSIGNED_SHORT = new StreamCodec<ByteBuf, Integer>(){

        public Integer decode(ByteBuf p_320319_) {
            return p_320319_.readUnsignedShort();
        }

        public void encode(ByteBuf p_320669_, Integer p_320205_) {
            p_320669_.writeShort(p_320205_.intValue());
        }
    };
    public static final StreamCodec<ByteBuf, Integer> INT = new StreamCodec<ByteBuf, Integer>(){

        public Integer decode(ByteBuf p_320253_) {
            return p_320253_.readInt();
        }

        public void encode(ByteBuf p_320753_, Integer p_330380_) {
            p_320753_.writeInt(p_330380_.intValue());
        }
    };
    public static final StreamCodec<ByteBuf, Integer> VAR_INT = new StreamCodec<ByteBuf, Integer>(){

        public Integer decode(ByteBuf p_320759_) {
            return VarInt.read((ByteBuf)p_320759_);
        }

        public void encode(ByteBuf p_320314_, Integer p_341414_) {
            VarInt.write((ByteBuf)p_320314_, (int)p_341414_);
        }
    };
    public static final StreamCodec<ByteBuf, Long> VAR_LONG = new StreamCodec<ByteBuf, Long>(){

        public Long decode(ByteBuf p_320635_) {
            return VarLong.read((ByteBuf)p_320635_);
        }

        public void encode(ByteBuf p_320545_, Long p_341419_) {
            VarLong.write((ByteBuf)p_320545_, (long)p_341419_);
        }
    };
    public static final StreamCodec<ByteBuf, Float> FLOAT = new StreamCodec<ByteBuf, Float>(){

        public Float decode(ByteBuf p_320259_) {
            return Float.valueOf(p_320259_.readFloat());
        }

        public void encode(ByteBuf p_320199_, Float p_341020_) {
            p_320199_.writeFloat(p_341020_.floatValue());
        }
    };
    public static final StreamCodec<ByteBuf, Double> DOUBLE = new StreamCodec<ByteBuf, Double>(){

        public Double decode(ByteBuf p_320599_) {
            return p_320599_.readDouble();
        }

        public void encode(ByteBuf p_320880_, Double p_340812_) {
            p_320880_.writeDouble(p_340812_.doubleValue());
        }
    };
    public static final StreamCodec<ByteBuf, byte[]> BYTE_ARRAY = new StreamCodec<ByteBuf, byte[]>(){

        public byte[] decode(ByteBuf p_320167_) {
            return FriendlyByteBuf.readByteArray(p_320167_);
        }

        public void encode(ByteBuf p_320240_, byte[] p_341316_) {
            FriendlyByteBuf.writeByteArray(p_320240_, p_341316_);
        }
    };
    public static final StreamCodec<ByteBuf, String> STRING_UTF8 = ByteBufCodecs.stringUtf8(Short.MAX_VALUE);
    public static final StreamCodec<ByteBuf, Tag> TAG = ByteBufCodecs.tagCodec(() -> NbtAccounter.create(0x200000L));
    public static final StreamCodec<ByteBuf, Tag> TRUSTED_TAG = ByteBufCodecs.tagCodec(NbtAccounter::unlimitedHeap);
    public static final StreamCodec<ByteBuf, CompoundTag> COMPOUND_TAG = ByteBufCodecs.compoundTagCodec(() -> NbtAccounter.create(0x200000L));
    public static final StreamCodec<ByteBuf, CompoundTag> TRUSTED_COMPOUND_TAG = ByteBufCodecs.compoundTagCodec(NbtAccounter::unlimitedHeap);
    public static final StreamCodec<ByteBuf, Optional<CompoundTag>> OPTIONAL_COMPOUND_TAG = new StreamCodec<ByteBuf, Optional<CompoundTag>>(){

        public Optional<CompoundTag> decode(ByteBuf p_320103_) {
            return Optional.ofNullable(FriendlyByteBuf.readNbt(p_320103_));
        }

        public void encode(ByteBuf p_320012_, Optional<CompoundTag> p_341059_) {
            FriendlyByteBuf.writeNbt(p_320012_, p_341059_.orElse(null));
        }
    };
    public static final StreamCodec<ByteBuf, Vector3f> VECTOR3F = new StreamCodec<ByteBuf, Vector3f>(){

        public Vector3f decode(ByteBuf p_319897_) {
            return FriendlyByteBuf.readVector3f(p_319897_);
        }

        public void encode(ByteBuf p_320441_, Vector3f p_340932_) {
            FriendlyByteBuf.writeVector3f(p_320441_, p_340932_);
        }
    };
    public static final StreamCodec<ByteBuf, Quaternionf> QUATERNIONF = new StreamCodec<ByteBuf, Quaternionf>(){

        public Quaternionf decode(ByteBuf p_324083_) {
            return FriendlyByteBuf.readQuaternion(p_324083_);
        }

        public void encode(ByteBuf p_324192_, Quaternionf p_341304_) {
            FriendlyByteBuf.writeQuaternion(p_324192_, p_341304_);
        }
    };
    public static final StreamCodec<ByteBuf, PropertyMap> GAME_PROFILE_PROPERTIES = new StreamCodec<ByteBuf, PropertyMap>(){
        private static final int MAX_PROPERTY_NAME_LENGTH = 64;
        private static final int MAX_PROPERTY_VALUE_LENGTH = Short.MAX_VALUE;
        private static final int MAX_PROPERTY_SIGNATURE_LENGTH = 1024;
        private static final int MAX_PROPERTIES = 16;

        public PropertyMap decode(ByteBuf p_331129_) {
            int i = ByteBufCodecs.readCount(p_331129_, 16);
            PropertyMap propertymap = new PropertyMap();
            for (int j = 0; j < i; ++j) {
                String s = Utf8String.read((ByteBuf)p_331129_, (int)64);
                String s1 = Utf8String.read((ByteBuf)p_331129_, (int)Short.MAX_VALUE);
                String s2 = (String)FriendlyByteBuf.readNullable(p_331129_, p_341239_ -> Utf8String.read((ByteBuf)p_341239_, (int)1024));
                Property property = new Property(s, s1, s2);
                propertymap.put((Object)property.name(), (Object)property);
            }
            return propertymap;
        }

        public void encode(ByteBuf p_331394_, PropertyMap p_341001_) {
            ByteBufCodecs.writeCount(p_331394_, p_341001_.size(), 16);
            for (Property property : p_341001_.values()) {
                Utf8String.write((ByteBuf)p_331394_, (CharSequence)property.name(), (int)64);
                Utf8String.write((ByteBuf)p_331394_, (CharSequence)property.value(), (int)Short.MAX_VALUE);
                FriendlyByteBuf.writeNullable(p_331394_, property.signature(), (p_340917_, p_341030_) -> Utf8String.write((ByteBuf)p_340917_, (CharSequence)p_341030_, (int)1024));
            }
        }
    };
    public static final StreamCodec<ByteBuf, GameProfile> GAME_PROFILE = new StreamCodec<ByteBuf, GameProfile>(){

        public GameProfile decode(ByteBuf p_341302_) {
            UUID uuid = (UUID)UUIDUtil.STREAM_CODEC.decode((Object)p_341302_);
            String s = Utf8String.read((ByteBuf)p_341302_, (int)16);
            GameProfile gameprofile = new GameProfile(uuid, s);
            gameprofile.getProperties().putAll((Multimap)GAME_PROFILE_PROPERTIES.decode((Object)p_341302_));
            return gameprofile;
        }

        public void encode(ByteBuf p_340881_, GameProfile p_341071_) {
            UUIDUtil.STREAM_CODEC.encode((Object)p_340881_, (Object)p_341071_.getId());
            Utf8String.write((ByteBuf)p_340881_, (CharSequence)p_341071_.getName(), (int)16);
            GAME_PROFILE_PROPERTIES.encode((Object)p_340881_, (Object)p_341071_.getProperties());
        }
    };

    public static StreamCodec<ByteBuf, byte[]> byteArray(final int p_324182_) {
        return new StreamCodec<ByteBuf, byte[]>(){

            public byte[] decode(ByteBuf p_319947_) {
                return FriendlyByteBuf.readByteArray(p_319947_, p_324182_);
            }

            public void encode(ByteBuf p_320370_, byte[] p_331189_) {
                if (p_331189_.length > p_324182_) {
                    throw new EncoderException("ByteArray with size " + p_331189_.length + " is bigger than allowed " + p_324182_);
                }
                FriendlyByteBuf.writeByteArray(p_320370_, p_331189_);
            }
        };
    }

    public static StreamCodec<ByteBuf, String> stringUtf8(final int p_320693_) {
        return new StreamCodec<ByteBuf, String>(){

            public String decode(ByteBuf p_332176_) {
                return Utf8String.read((ByteBuf)p_332176_, (int)p_320693_);
            }

            public void encode(ByteBuf p_331068_, String p_341104_) {
                Utf8String.write((ByteBuf)p_331068_, (CharSequence)p_341104_, (int)p_320693_);
            }
        };
    }

    public static StreamCodec<ByteBuf, Tag> tagCodec(final Supplier<NbtAccounter> p_320506_) {
        return new StreamCodec<ByteBuf, Tag>(){

            public Tag decode(ByteBuf p_341393_) {
                Tag tag = FriendlyByteBuf.readNbt(p_341393_, (NbtAccounter)p_320506_.get());
                if (tag == null) {
                    throw new DecoderException("Expected non-null compound tag");
                }
                return tag;
            }

            public void encode(ByteBuf p_340857_, Tag p_341321_) {
                if (p_341321_ == EndTag.INSTANCE) {
                    throw new EncoderException("Expected non-null compound tag");
                }
                FriendlyByteBuf.writeNbt(p_340857_, p_341321_);
            }
        };
    }

    public static StreamCodec<ByteBuf, CompoundTag> compoundTagCodec(Supplier<NbtAccounter> p_331128_) {
        return ByteBufCodecs.tagCodec(p_331128_).map(p_339405_ -> {
            if (p_339405_ instanceof CompoundTag) {
                return (CompoundTag)p_339405_;
            }
            throw new DecoderException("Not a compound tag: " + String.valueOf(p_339405_));
        }, p_330975_ -> p_330975_);
    }

    public static <T> StreamCodec<ByteBuf, T> fromCodecTrusted(Codec<T> p_331105_) {
        return ByteBufCodecs.fromCodec(p_331105_, NbtAccounter::unlimitedHeap);
    }

    public static <T> StreamCodec<ByteBuf, T> fromCodec(Codec<T> p_320615_) {
        return ByteBufCodecs.fromCodec(p_320615_, () -> NbtAccounter.create(0x200000L));
    }

    public static <T> StreamCodec<ByteBuf, T> fromCodec(Codec<T> p_330943_, Supplier<NbtAccounter> p_330382_) {
        return ByteBufCodecs.tagCodec(p_330382_).map(p_337514_ -> p_330943_.parse((DynamicOps)NbtOps.INSTANCE, p_337514_).getOrThrow(p_339407_ -> new DecoderException("Failed to decode: " + p_339407_ + " " + String.valueOf(p_337514_))), p_337516_ -> (Tag)p_330943_.encodeStart((DynamicOps)NbtOps.INSTANCE, p_337516_).getOrThrow(p_339409_ -> new EncoderException("Failed to encode: " + p_339409_ + " " + String.valueOf(p_337516_))));
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, T> fromCodecWithRegistriesTrusted(Codec<T> p_331713_) {
        return ByteBufCodecs.fromCodecWithRegistries(p_331713_, NbtAccounter::unlimitedHeap);
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, T> fromCodecWithRegistries(Codec<T> p_323797_) {
        return ByteBufCodecs.fromCodecWithRegistries(p_323797_, () -> NbtAccounter.create(0x200000L));
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, T> fromCodecWithRegistries(final Codec<T> p_331571_, Supplier<NbtAccounter> p_331922_) {
        final StreamCodec<ByteBuf, Tag> streamcodec = ByteBufCodecs.tagCodec(p_331922_);
        return new StreamCodec<RegistryFriendlyByteBuf, T>(){

            public T decode(RegistryFriendlyByteBuf p_340878_) {
                Tag tag = (Tag)streamcodec.decode((Object)p_340878_);
                RegistryOps registryops = p_340878_.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
                return p_331571_.parse((DynamicOps)registryops, (Object)tag).getOrThrow(p_340924_ -> new DecoderException("Failed to decode: " + p_340924_ + " " + String.valueOf(tag)));
            }

            public void encode(RegistryFriendlyByteBuf p_341221_, T p_341320_) {
                RegistryOps registryops = p_341221_.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
                Tag tag = (Tag)p_331571_.encodeStart((DynamicOps)registryops, p_341320_).getOrThrow(p_341126_ -> new EncoderException("Failed to encode: " + p_341126_ + " " + String.valueOf(p_341320_)));
                streamcodec.encode((Object)p_341221_, (Object)tag);
            }
        };
    }

    public static <B extends ByteBuf, V> StreamCodec<B, Optional<V>> optional(final StreamCodec<B, V> p_320522_) {
        return new StreamCodec<B, Optional<V>>(){

            public Optional<V> decode(B p_324595_) {
                return p_324595_.readBoolean() ? Optional.of(p_320522_.decode(p_324595_)) : Optional.empty();
            }

            public void encode(B p_324147_, Optional<V> p_340875_) {
                if (p_340875_.isPresent()) {
                    p_324147_.writeBoolean(true);
                    p_320522_.encode(p_324147_, p_340875_.get());
                } else {
                    p_324147_.writeBoolean(false);
                }
            }
        };
    }

    public static int readCount(ByteBuf p_331813_, int p_331668_) {
        int i = VarInt.read((ByteBuf)p_331813_);
        if (i > p_331668_) {
            throw new DecoderException(i + " elements exceeded max size of: " + p_331668_);
        }
        return i;
    }

    public static void writeCount(ByteBuf p_330907_, int p_330535_, int p_331447_) {
        if (p_330535_ > p_331447_) {
            throw new EncoderException(p_330535_ + " elements exceeded max size of: " + p_331447_);
        }
        VarInt.write((ByteBuf)p_330907_, (int)p_330535_);
    }

    public static <B extends ByteBuf, V, C extends Collection<V>> StreamCodec<B, C> collection(IntFunction<C> p_320579_, StreamCodec<? super B, V> p_319970_) {
        return ByteBufCodecs.collection(p_320579_, p_319970_, Integer.MAX_VALUE);
    }

    public static <B extends ByteBuf, V, C extends Collection<V>> StreamCodec<B, C> collection(final IntFunction<C> p_332198_, final StreamCodec<? super B, V> p_332183_, final int p_332173_) {
        return new StreamCodec<B, C>(){

            public C decode(B p_324220_) {
                int i = ByteBufCodecs.readCount(p_324220_, p_332173_);
                Collection c = (Collection)p_332198_.apply(Math.min(i, 65536));
                for (int j = 0; j < i; ++j) {
                    c.add(p_332183_.decode(p_324220_));
                }
                return c;
            }

            public void encode(B p_323874_, C p_340813_) {
                ByteBufCodecs.writeCount(p_323874_, p_340813_.size(), p_332173_);
                for (Object v : p_340813_) {
                    p_332183_.encode(p_323874_, v);
                }
            }
        };
    }

    public static <B extends ByteBuf, V, C extends Collection<V>> StreamCodec.CodecOperation<B, V, C> collection(IntFunction<C> p_319808_) {
        return p_319785_ -> ByteBufCodecs.collection(p_319808_, p_319785_);
    }

    public static <B extends ByteBuf, V> StreamCodec.CodecOperation<B, V, List<V>> list() {
        return p_320272_ -> ByteBufCodecs.collection(ArrayList::new, p_320272_);
    }

    public static <B extends ByteBuf, V> StreamCodec.CodecOperation<B, V, List<V>> list(int p_330434_) {
        return p_329871_ -> ByteBufCodecs.collection(ArrayList::new, p_329871_, p_330434_);
    }

    public static <B extends ByteBuf, K, V, M extends Map<K, V>> StreamCodec<B, M> map(IntFunction<? extends M> p_320265_, StreamCodec<? super B, K> p_320113_, StreamCodec<? super B, V> p_320275_) {
        return ByteBufCodecs.map(p_320265_, p_320113_, p_320275_, Integer.MAX_VALUE);
    }

    public static <B extends ByteBuf, K, V, M extends Map<K, V>> StreamCodec<B, M> map(final IntFunction<? extends M> p_331325_, final StreamCodec<? super B, K> p_331975_, final StreamCodec<? super B, V> p_331254_, final int p_330938_) {
        return new StreamCodec<B, M>(){

            public void encode(B p_331539_, M p_341314_) {
                ByteBufCodecs.writeCount(p_331539_, p_341314_.size(), p_330938_);
                p_341314_.forEach((p_340647_, p_340648_) -> {
                    p_331975_.encode(p_331539_, p_340647_);
                    p_331254_.encode(p_331539_, p_340648_);
                });
            }

            public M decode(B p_331901_) {
                int i = ByteBufCodecs.readCount(p_331901_, p_330938_);
                Map m = (Map)p_331325_.apply(Math.min(i, 65536));
                for (int j = 0; j < i; ++j) {
                    Object k = p_331975_.decode(p_331901_);
                    Object v = p_331254_.decode(p_331901_);
                    m.put(k, v);
                }
                return m;
            }
        };
    }

    public static <B extends ByteBuf, L, R> StreamCodec<B, Either<L, R>> either(final StreamCodec<? super B, L> p_331983_, final StreamCodec<? super B, R> p_332156_) {
        return new StreamCodec<B, Either<L, R>>(){

            public Either<L, R> decode(B p_332082_) {
                return p_332082_.readBoolean() ? Either.left((Object)p_331983_.decode(p_332082_)) : Either.right((Object)p_332156_.decode(p_332082_));
            }

            public void encode(B p_331172_, Either<L, R> p_340944_) {
                p_340944_.ifLeft(p_341317_ -> {
                    p_331172_.writeBoolean(true);
                    p_331983_.encode(p_331172_, p_341317_);
                }).ifRight(p_341155_ -> {
                    p_331172_.writeBoolean(false);
                    p_332156_.encode(p_331172_, p_341155_);
                });
            }
        };
    }

    public static <T> StreamCodec<ByteBuf, T> idMapper(final IntFunction<T> p_320877_, final ToIntFunction<T> p_319985_) {
        return new StreamCodec<ByteBuf, T>(){

            public T decode(ByteBuf p_340809_) {
                int i = VarInt.read((ByteBuf)p_340809_);
                return p_320877_.apply(i);
            }

            public void encode(ByteBuf p_341417_, T p_330257_) {
                int i = p_319985_.applyAsInt(p_330257_);
                VarInt.write((ByteBuf)p_341417_, (int)i);
            }
        };
    }

    public static <T> StreamCodec<ByteBuf, T> idMapper(IdMap<T> p_319822_) {
        return ByteBufCodecs.idMapper(arg_0 -> p_319822_.byIdOrThrow(arg_0), arg_0 -> p_319822_.getIdOrThrow(arg_0));
    }

    private static <T, R> StreamCodec<RegistryFriendlyByteBuf, R> registry(final ResourceKey<? extends Registry<T>> p_319942_, final Function<Registry<T>, IdMap<R>> p_320353_) {
        return new StreamCodec<RegistryFriendlyByteBuf, R>(){

            private IdMap<R> getRegistryOrThrow(RegistryFriendlyByteBuf p_330361_) {
                Registry registry = p_330361_.registryAccess().registryOrThrow(p_319942_);
                if (RegistryManager.isNonSyncedBuiltInRegistry((Registry)registry)) {
                    throw new IllegalStateException("Cannot use ID syncing for non-synced built-in registry: " + String.valueOf(registry.key()));
                }
                return (IdMap)p_320353_.apply(registry);
            }

            public R decode(RegistryFriendlyByteBuf p_331253_) {
                int i = VarInt.read((ByteBuf)p_331253_);
                return this.getRegistryOrThrow(p_331253_).byIdOrThrow(i);
            }

            public void encode(RegistryFriendlyByteBuf p_331775_, R p_341178_) {
                int i = this.getRegistryOrThrow(p_331775_).getIdOrThrow(p_341178_);
                VarInt.write((ByteBuf)p_331775_, (int)i);
            }
        };
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, T> registry(ResourceKey<? extends Registry<T>> p_320404_) {
        return ByteBufCodecs.registry(p_320404_, p_332056_ -> p_332056_);
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, Holder<T>> holderRegistry(ResourceKey<? extends Registry<T>> p_320387_) {
        return ByteBufCodecs.registry(p_320387_, Registry::asHolderIdMap);
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, Holder<T>> holder(final ResourceKey<? extends Registry<T>> p_320391_, final StreamCodec<? super RegistryFriendlyByteBuf, T> p_320595_) {
        return new StreamCodec<RegistryFriendlyByteBuf, Holder<T>>(){
            private static final int DIRECT_HOLDER_ID = 0;

            private IdMap<Holder<T>> getRegistryOrThrow(RegistryFriendlyByteBuf p_341377_) {
                return p_341377_.registryAccess().registryOrThrow(p_320391_).asHolderIdMap();
            }

            public Holder<T> decode(RegistryFriendlyByteBuf p_330998_) {
                int i = VarInt.read((ByteBuf)p_330998_);
                return i == 0 ? Holder.direct(p_320595_.decode((Object)p_330998_)) : (Holder)this.getRegistryOrThrow(p_330998_).byIdOrThrow(i - 1);
            }

            public void encode(RegistryFriendlyByteBuf p_330557_, Holder<T> p_341109_) {
                switch (p_341109_.kind()) {
                    case REFERENCE: {
                        int i = this.getRegistryOrThrow(p_330557_).getIdOrThrow(p_341109_);
                        VarInt.write((ByteBuf)p_330557_, (int)(i + 1));
                        break;
                    }
                    case DIRECT: {
                        VarInt.write((ByteBuf)p_330557_, (int)0);
                        p_320595_.encode((Object)p_330557_, p_341109_.value());
                    }
                }
            }
        };
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, HolderSet<T>> holderSet(final ResourceKey<? extends Registry<T>> p_332137_) {
        return new StreamCodec<RegistryFriendlyByteBuf, HolderSet<T>>(){
            private static final int NAMED_SET = -1;
            private final StreamCodec<RegistryFriendlyByteBuf, Holder<T>> holderCodec;
            {
                this.holderCodec = ByteBufCodecs.holderRegistry(p_332137_);
            }

            public HolderSet<T> decode(RegistryFriendlyByteBuf p_340887_) {
                int i = VarInt.read((ByteBuf)p_340887_) - 1;
                if (i == -1) {
                    Registry registry = p_340887_.registryAccess().registryOrThrow(p_332137_);
                    return registry.getTag(TagKey.create((ResourceKey)p_332137_, (ResourceLocation)((ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)p_340887_)))).orElseThrow();
                }
                ArrayList<Holder> list = new ArrayList<Holder>(Math.min(i, 65536));
                for (int j = 0; j < i; ++j) {
                    list.add((Holder)this.holderCodec.decode((Object)p_340887_));
                }
                return HolderSet.direct(list);
            }

            public void encode(RegistryFriendlyByteBuf p_341009_, HolderSet<T> p_340834_) {
                Optional optional = p_340834_.unwrapKey();
                if (optional.isPresent()) {
                    VarInt.write((ByteBuf)p_341009_, (int)0);
                    ResourceLocation.STREAM_CODEC.encode((Object)p_341009_, (Object)optional.get().location());
                } else {
                    VarInt.write((ByteBuf)p_341009_, (int)(p_340834_.size() + 1));
                    for (Holder holder : p_340834_) {
                        this.holderCodec.encode((Object)p_341009_, (Object)holder);
                    }
                }
            }
        };
    }
}

