/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.EvokerFangs;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.scores.PlayerTeam;
import net.neoforged.neoforge.event.EventHooks;

public class Evoker
extends SpellcasterIllager {
    @Nullable
    private Sheep wololoTarget;

    public Evoker(EntityType<? extends Evoker> p_32627_, Level p_32628_) {
        super(p_32627_, p_32628_);
        this.xpReward = 10;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)((Object)this)));
        this.goalSelector.addGoal(1, (Goal)new EvokerCastingSpellGoal());
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.6, 1.0));
        this.goalSelector.addGoal(4, (Goal)new EvokerSummonSpellGoal());
        this.goalSelector.addGoal(5, (Goal)new EvokerAttackSpellGoal());
        this.goalSelector.addGoal(6, (Goal)new EvokerWololoSpellGoal());
        this.goalSelector.addGoal(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)((Object)this), Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)((Object)this), Mob.class, 8.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)((Object)this), Player.class, true).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)((Object)this), AbstractVillager.class, false).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)((Object)this), IronGolem.class, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MOVEMENT_SPEED, 0.5).add(Attributes.FOLLOW_RANGE, 12.0).add(Attributes.MAX_HEALTH, 24.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326426_) {
        super.defineSynchedData(p_326426_);
    }

    public void readAdditionalSaveData(CompoundTag p_32642_) {
        super.readAdditionalSaveData(p_32642_);
    }

    public SoundEvent getCelebrateSound() {
        return SoundEvents.EVOKER_CELEBRATE;
    }

    public void addAdditionalSaveData(CompoundTag p_32646_) {
        super.addAdditionalSaveData(p_32646_);
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
    }

    public boolean isAlliedTo(Entity p_32665_) {
        boolean bl;
        if (p_32665_ == null) {
            return false;
        }
        if (p_32665_ == this) {
            return true;
        }
        if (super.isAlliedTo(p_32665_)) {
            return true;
        }
        if (p_32665_ instanceof Vex) {
            Vex vex = (Vex)p_32665_;
            bl = this.isAlliedTo(vex.getOwner());
        } else {
            bl = false;
        }
        return bl;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.EVOKER_AMBIENT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.EVOKER_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource p_32654_) {
        return SoundEvents.EVOKER_HURT;
    }

    void setWololoTarget(@Nullable Sheep p_32635_) {
        this.wololoTarget = p_32635_;
    }

    @Nullable
    Sheep getWololoTarget() {
        return this.wololoTarget;
    }

    protected SoundEvent getCastingSoundEvent() {
        return SoundEvents.EVOKER_CAST_SPELL;
    }

    public void applyRaidBuffs(int p_32632_, boolean p_32633_) {
    }

    class EvokerCastingSpellGoal
    extends SpellcasterIllager.SpellcasterCastingSpellGoal {
        EvokerCastingSpellGoal() {
            super((SpellcasterIllager)Evoker.this);
        }

        public void tick() {
            if (Evoker.this.getTarget() != null) {
                Evoker.this.getLookControl().setLookAt((Entity)Evoker.this.getTarget(), (float)Evoker.this.getMaxHeadYRot(), (float)Evoker.this.getMaxHeadXRot());
            } else if (Evoker.this.getWololoTarget() != null) {
                Evoker.this.getLookControl().setLookAt((Entity)((Object)Evoker.this.getWololoTarget()), (float)Evoker.this.getMaxHeadYRot(), (float)Evoker.this.getMaxHeadXRot());
            }
        }
    }

    class EvokerSummonSpellGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        private final TargetingConditions vexCountTargeting;

        EvokerSummonSpellGoal() {
            super((SpellcasterIllager)Evoker.this);
            this.vexCountTargeting = TargetingConditions.forNonCombat().range(16.0).ignoreLineOfSight().ignoreInvisibilityTesting();
        }

        public boolean canUse() {
            if (!super.canUse()) {
                return false;
            }
            int i = Evoker.this.level().getNearbyEntities(Vex.class, this.vexCountTargeting, (LivingEntity)((Object)Evoker.this), Evoker.this.getBoundingBox().inflate(16.0)).size();
            return Evoker.this.random.nextInt(8) + 1 > i;
        }

        protected int getCastingTime() {
            return 100;
        }

        protected int getCastingInterval() {
            return 340;
        }

        protected void performSpellCasting() {
            ServerLevel serverlevel = (ServerLevel)Evoker.this.level();
            PlayerTeam playerteam = Evoker.this.getTeam();
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos = Evoker.this.blockPosition().offset(-2 + Evoker.this.random.nextInt(5), 1, -2 + Evoker.this.random.nextInt(5));
                Vex vex = EntityType.VEX.create(Evoker.this.level());
                if (vex == null) continue;
                vex.moveTo(blockpos, 0.0f, 0.0f);
                vex.finalizeSpawn((ServerLevelAccessor)serverlevel, Evoker.this.level().getCurrentDifficultyAt(blockpos), MobSpawnType.MOB_SUMMONED, null);
                vex.setOwner((Mob)((Object)Evoker.this));
                vex.setBoundOrigin(blockpos);
                vex.setLimitedLife(20 * (30 + Evoker.this.random.nextInt(90)));
                if (playerteam != null) {
                    serverlevel.getScoreboard().addPlayerToTeam(vex.getScoreboardName(), playerteam);
                }
                serverlevel.addFreshEntityWithPassengers((Entity)vex);
                serverlevel.gameEvent(GameEvent.ENTITY_PLACE, blockpos, GameEvent.Context.of((Entity)((Object)Evoker.this)));
            }
        }

        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.EVOKER_PREPARE_SUMMON;
        }

        protected SpellcasterIllager.IllagerSpell getSpell() {
            return SpellcasterIllager.IllagerSpell.SUMMON_VEX;
        }
    }

    class EvokerAttackSpellGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        EvokerAttackSpellGoal() {
            super((SpellcasterIllager)Evoker.this);
        }

        protected int getCastingTime() {
            return 40;
        }

        protected int getCastingInterval() {
            return 100;
        }

        protected void performSpellCasting() {
            LivingEntity livingentity = Evoker.this.getTarget();
            double d0 = Math.min(livingentity.getY(), Evoker.this.getY());
            double d1 = Math.max(livingentity.getY(), Evoker.this.getY()) + 1.0;
            float f = (float)Mth.atan2((double)(livingentity.getZ() - Evoker.this.getZ()), (double)(livingentity.getX() - Evoker.this.getX()));
            if (Evoker.this.distanceToSqr(livingentity) < 9.0) {
                for (int i = 0; i < 5; ++i) {
                    float f1 = f + (float)i * (float)Math.PI * 0.4f;
                    this.createSpellEntity(Evoker.this.getX() + (double)Mth.cos((float)f1) * 1.5, Evoker.this.getZ() + (double)Mth.sin((float)f1) * 1.5, d0, d1, f1, 0);
                }
                for (int k = 0; k < 8; ++k) {
                    float f2 = f + (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    this.createSpellEntity(Evoker.this.getX() + (double)Mth.cos((float)f2) * 2.5, Evoker.this.getZ() + (double)Mth.sin((float)f2) * 2.5, d0, d1, f2, 3);
                }
            } else {
                for (int l = 0; l < 16; ++l) {
                    double d2 = 1.25 * (double)(l + 1);
                    int j = 1 * l;
                    this.createSpellEntity(Evoker.this.getX() + (double)Mth.cos((float)f) * d2, Evoker.this.getZ() + (double)Mth.sin((float)f) * d2, d0, d1, f, j);
                }
            }
        }

        private void createSpellEntity(double p_32673_, double p_32674_, double p_32675_, double p_32676_, float p_32677_, int p_32678_) {
            BlockPos blockpos = BlockPos.containing((double)p_32673_, (double)p_32676_, (double)p_32674_);
            boolean flag = false;
            double d0 = 0.0;
            do {
                BlockState blockstate1;
                VoxelShape voxelshape;
                BlockPos blockpos1 = blockpos.below();
                BlockState blockstate = Evoker.this.level().getBlockState(blockpos1);
                if (!blockstate.isFaceSturdy((BlockGetter)((Object)Evoker.this.level()), blockpos1, Direction.UP)) continue;
                if (!Evoker.this.level().isEmptyBlock(blockpos) && !(voxelshape = (blockstate1 = Evoker.this.level().getBlockState(blockpos)).getCollisionShape((BlockGetter)((Object)Evoker.this.level()), blockpos)).isEmpty()) {
                    d0 = voxelshape.max(Direction.Axis.Y);
                }
                flag = true;
                break;
            } while ((blockpos = blockpos.below()).getY() >= Mth.floor((double)p_32675_) - 1);
            if (flag) {
                Evoker.this.level().addFreshEntity((Entity)new EvokerFangs(Evoker.this.level(), p_32673_, (double)blockpos.getY() + d0, p_32674_, p_32677_, p_32678_, (LivingEntity)((Object)Evoker.this)));
                Evoker.this.level().gameEvent(GameEvent.ENTITY_PLACE, new Vec3(p_32673_, (double)blockpos.getY() + d0, p_32674_), GameEvent.Context.of((Entity)((Object)Evoker.this)));
            }
        }

        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.EVOKER_PREPARE_ATTACK;
        }

        protected SpellcasterIllager.IllagerSpell getSpell() {
            return SpellcasterIllager.IllagerSpell.FANGS;
        }
    }

    public class EvokerWololoSpellGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        private final TargetingConditions wololoTargeting;

        public EvokerWololoSpellGoal() {
            super((SpellcasterIllager)Evoker.this);
            this.wololoTargeting = TargetingConditions.forNonCombat().range(16.0).selector(p_32710_ -> ((Sheep)((Object)p_32710_)).getColor() == DyeColor.BLUE);
        }

        public boolean canUse() {
            if (Evoker.this.getTarget() != null) {
                return false;
            }
            if (Evoker.this.isCastingSpell()) {
                return false;
            }
            if (Evoker.this.tickCount < this.nextAttackTickCount) {
                return false;
            }
            if (!EventHooks.canEntityGrief((Level)Evoker.this.level(), (Entity)((Object)Evoker.this))) {
                return false;
            }
            List list = Evoker.this.level().getNearbyEntities(Sheep.class, this.wololoTargeting, (LivingEntity)((Object)Evoker.this), Evoker.this.getBoundingBox().inflate(16.0, 4.0, 16.0));
            if (list.isEmpty()) {
                return false;
            }
            Evoker.this.setWololoTarget((Sheep)list.get(Evoker.this.random.nextInt(list.size())));
            return true;
        }

        public boolean canContinueToUse() {
            return Evoker.this.getWololoTarget() != null && this.attackWarmupDelay > 0;
        }

        public void stop() {
            super.stop();
            Evoker.this.setWololoTarget(null);
        }

        protected void performSpellCasting() {
            Sheep sheep = Evoker.this.getWololoTarget();
            if (sheep != null && sheep.isAlive()) {
                sheep.setColor(DyeColor.RED);
            }
        }

        protected int getCastWarmupTime() {
            return 40;
        }

        protected int getCastingTime() {
            return 60;
        }

        protected int getCastingInterval() {
            return 140;
        }

        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.EVOKER_PREPARE_WOLOLO;
        }

        protected SpellcasterIllager.IllagerSpell getSpell() {
            return SpellcasterIllager.IllagerSpell.WOLOLO;
        }
    }
}

