/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntFunction;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.neoforged.neoforge.common.IExtensibleEnum;

public enum Rarity implements StringRepresentable,
IExtensibleEnum
{
    COMMON(0, "common", ChatFormatting.WHITE),
    UNCOMMON(1, "uncommon", ChatFormatting.YELLOW),
    RARE(2, "rare", ChatFormatting.AQUA),
    EPIC(3, "epic", ChatFormatting.LIGHT_PURPLE);

    private static final Map<String, Rarity> BY_NAME;
    public static final Codec<Rarity> CODEC;
    public static final IntFunction<Rarity> BY_ID;
    public static final StreamCodec<ByteBuf, Rarity> STREAM_CODEC;
    private final int id;
    private final String name;
    private final ChatFormatting color;
    private final UnaryOperator<Style> styleModifier;

    private Rarity(int p_336096_, String p_335642_, ChatFormatting p_43028_) {
        this.id = p_336096_;
        this.name = p_335642_;
        this.color = p_43028_;
        this.styleModifier = style -> style.withColor(p_43028_);
    }

    private Rarity(ResourceLocation serializedName, UnaryOperator<Style> styleModifier) {
        this.id = 0;
        this.name = Objects.requireNonNull(serializedName, "Modded Rarities must have a non-null serializedName").toString();
        this.color = ChatFormatting.BLACK;
        this.styleModifier = styleModifier;
    }

    private Rarity(ResourceLocation serializedName, ChatFormatting color) {
        this(0, Objects.requireNonNull(serializedName, "Modded Rarities must have a non-null serializedName").toString(), color);
    }

    @Deprecated
    public ChatFormatting color() {
        return this.color;
    }

    public UnaryOperator<Style> getStyleModifier() {
        return this.styleModifier;
    }

    public String getSerializedName() {
        return this.name;
    }

    @Deprecated
    public void init() {
        BY_NAME.put(this.name, this);
    }

    public static Rarity byName(String name) {
        return BY_NAME.get(name);
    }

    public static Rarity create(String name, ResourceLocation serializedName, ChatFormatting color) {
        throw new IllegalStateException("Enum not extended");
    }

    public static Rarity create(String name, ResourceLocation serializedName, UnaryOperator<Style> styleModifier) {
        throw new IllegalStateException("Enum not extended");
    }

    static {
        BY_NAME = Arrays.stream(Rarity.values()).collect(Collectors.toMap(rarity -> rarity.name, rarity -> rarity));
        CODEC = IExtensibleEnum.createCodecForExtensibleEnum(Rarity::values, Rarity::byName);
        BY_ID = ByIdMap.continuous(p_335877_ -> p_335877_.id, (Object[])Rarity.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        STREAM_CODEC = IExtensibleEnum.createStreamCodecForExtensibleEnum(Rarity::values);
    }
}

