/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FrostedIceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.neoforge.common.util.BlockSnapshot;
import net.neoforged.neoforge.event.EventHooks;

public class FrostWalkerEnchantment
extends Enchantment {
    public FrostWalkerEnchantment(Enchantment.EnchantmentDefinition p_335719_) {
        super(p_335719_);
    }

    @Override
    public boolean isTreasureOnly() {
        return true;
    }

    public static void onEntityMoved(LivingEntity p_45019_, Level p_45020_, BlockPos p_45021_, int p_45022_) {
        if (p_45019_.onGround()) {
            BlockState blockstate = Blocks.FROSTED_ICE.defaultBlockState();
            int i = Math.min(16, 2 + p_45022_);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)p_45021_.offset(-i, -1, -i), (BlockPos)p_45021_.offset(i, -1, i))) {
                BlockState blockstate2;
                if (!blockpos.closerToCenterThan((Position)p_45019_.position(), (double)i)) continue;
                blockpos$mutableblockpos.set(blockpos.getX(), blockpos.getY() + 1, blockpos.getZ());
                BlockState blockstate1 = p_45020_.getBlockState((BlockPos)blockpos$mutableblockpos);
                if (!blockstate1.isAir() || (blockstate2 = p_45020_.getBlockState(blockpos)) != FrostedIceBlock.meltsInto() || !blockstate.canSurvive((LevelReader)((Object)p_45020_), blockpos) || !p_45020_.isUnobstructed(blockstate, blockpos, CollisionContext.empty()) || EventHooks.onBlockPlace((Entity)p_45019_, (BlockSnapshot)BlockSnapshot.create(p_45020_.dimension(), (LevelAccessor)p_45020_, (BlockPos)blockpos), (Direction)Direction.UP)) continue;
                p_45020_.setBlockAndUpdate(blockpos, blockstate);
                p_45020_.scheduleTick(blockpos, Blocks.FROSTED_ICE, Mth.nextInt((RandomSource)p_45019_.getRandom(), (int)60, (int)120));
            }
        }
    }

    @Override
    public boolean checkCompatibility(Enchantment p_45024_) {
        return super.checkCompatibility(p_45024_) && p_45024_ != Enchantments.DEPTH_STRIDER;
    }
}

